/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtEditedEvent;
import com.sun.symon.base.console.tools.editor.CtEditedListener;
import com.sun.symon.base.console.tools.editor.CtEditorDataSource;
import com.sun.symon.base.console.tools.editor.CtEditorISDException;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CtEditorLauncher
extends JDialog
implements CtEditedListener {
    private CtAttributeEditor _editor = null;
    private CtEditorDataSource _handle1 = null;
    private SMRawDataRequest _handle = null;
    private JButton _okButton;
    private JButton _resetButton;
    private JButton _applyButton;
    private JLabel _statusLabel;
    private String _origUrl = null;
    private String _descrip = "";
    private String _pathInfo = "";
    private String _title = "";
    private String _initialShadowGroup = "";

    public CtEditorLauncher(CtEditorDataSource ctEditorDataSource, String string, String string2, String string3) {
        this.CtEditorLauncher(ctEditorDataSource, string);
        this._title = UcInternationalizer.translateKey((String)string2);
        this._initialShadowGroup = string3;
        this.init();
    }

    public CtEditorLauncher(SMRawDataRequest sMRawDataRequest, String string, String string2, String string3) {
        this.CtEditorLauncher(sMRawDataRequest, string);
        this._title = UcInternationalizer.translateKey((String)string2);
        this._initialShadowGroup = string3;
        this.init();
    }

    public void CtEditorLauncher(CtEditorDataSource ctEditorDataSource, String string) {
        this.setModal(true);
        this._handle1 = ctEditorDataSource;
        this._origUrl = string;
    }

    public void CtEditorLauncher(SMRawDataRequest sMRawDataRequest, String string) {
        this.setModal(true);
        this._handle = sMRawDataRequest == null ? SMConsoleContext.getInstance().getAPIHandle() : sMRawDataRequest;
        this._origUrl = string;
    }

    private void init() {
        boolean bl = false;
        this._editor = new CtAttributeEditor();
        this._editor.setInitShadowGroup(this._initialShadowGroup);
        this._editor.setLoadAsRequired(true);
        if (this._handle1 == null) {
            this._editor.setDataSource(this._handle);
        } else {
            this._editor.setDataSource(this._handle1);
        }
        this._editor.setEditObject(this._origUrl);
        this._editor.addCtEditedListener(this);
        UcAgentURL ucAgentURL = new UcAgentURL(this._origUrl);
        bl = ucAgentURL.isModuleBaseURL();
        if (bl) {
            this._descrip = "   " + ucAgentURL.getModuleSpec();
            this._pathInfo = "   " + ucAgentURL.getModuleSpec();
        } else {
            this._descrip = "   " + ucAgentURL.getProperty();
            this._pathInfo = "   " + ucAgentURL.getModuleId() + "/" + ucAgentURL.getManagedObject();
        }
        this.createUI();
    }

    public Dimension getPreferredSize() {
        return new Dimension(570, 480);
    }

    private void createUI() {
        this.setTitle(this._title);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 3, 10, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JLabel jLabel = new JLabel(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:editor.label"));
        jLabel.setAlignmentX(1.0f);
        jPanel3.add(jLabel);
        jLabel = new JLabel(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:editor.location"));
        jLabel.setAlignmentX(1.0f);
        jPanel3.add(jLabel);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jLabel = new JLabel(this._descrip);
        jLabel.setForeground(Color.black);
        jPanel4.add(jLabel);
        jLabel = new JLabel(this._pathInfo);
        jLabel.setForeground(Color.black);
        jPanel4.add(jLabel);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)this._editor, "Center");
        this._editor.setPreferredSize(new Dimension(450, 500));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.setBorder(new EmptyBorder(8, 0, 5, 0));
        this._okButton = new JButton(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:message.ok"));
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CtEditorLauncher.this._editor == null) {
                    return;
                }
                CtEditorLauncher.this.performOkAction(actionEvent);
            }
        });
        this._applyButton = new JButton(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.apply"));
        this._applyButton.setEnabled(false);
        this._applyButton.setMnemonic(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.apply.mnemonic").charAt(0));
        this._applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CtEditorLauncher.this.performApplyAction(actionEvent);
            }
        });
        this._resetButton = new JButton(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.reset"));
        this._resetButton.setMnemonic(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.reset.mnemonic").charAt(0));
        this._resetButton.setEnabled(false);
        this._resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CtEditorLauncher.this.performResetAction(actionEvent);
            }
        });
        JButton jButton = new JButton(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:message.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CtEditorLauncher.this.performCancelAction(actionEvent);
            }
        });
        JButton jButton2 = new JButton(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.help"));
        jButton2.setMnemonic(UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:standard.help.mnemonic").charAt(0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "attribute-editor-help";
                CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
                cmConsoleSession.launchHelp(string);
            }
        });
        jPanel5.setMaximumSize(new Dimension(600, 40));
        jPanel5.setMinimumSize(new Dimension(600, 40));
        jPanel5.setPreferredSize(new Dimension(600, 40));
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(this._okButton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(this._applyButton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(this._resetButton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jButton);
        jPanel5.add(Box.createHorizontalGlue());
        jPanel5.add(jButton2);
        jPanel5.add(Box.createHorizontalGlue());
        this._statusLabel = new JLabel("     ");
        this._statusLabel.setForeground(Color.black);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel5, "Center");
        this.getRootPane().setDefaultButton(this._okButton);
        jPanel6.add((Component)this._statusLabel, "South");
        jPanel.add((Component)jPanel6, "South");
        ((Component)this).setSize(600, 600);
    }

    public void performOkAction(ActionEvent actionEvent) {
        if (this._editor == null) {
            return;
        }
        if (this.performApplyAction(actionEvent)) {
            this.performCancelAction(actionEvent);
        }
    }

    public boolean performApplyAction(ActionEvent actionEvent) {
        boolean bl = this.saveData();
        if (bl) {
            this.performResetAction(actionEvent);
        }
        return bl;
    }

    public void performCancelAction(ActionEvent actionEvent) {
        this.dispose();
    }

    public void performResetAction(ActionEvent actionEvent) {
        if (this._editor == null) {
            return;
        }
        this._editor.resetAttributes();
        this.triggerState("reset");
        this.setMessage(" ");
    }

    private void setMessage(String string) {
        if (string == null || string.trim().equals("")) {
            string = "            ";
        }
        this._statusLabel.setText(string);
    }

    public void triggerState(String string) {
        if (string.equals("edited")) {
            this._okButton.setEnabled(true);
            this._applyButton.setEnabled(true);
            this._resetButton.setEnabled(true);
        } else if (string.equals("reset")) {
            this._resetButton.setEnabled(false);
            this._applyButton.setEnabled(false);
            this._okButton.setEnabled(false);
        }
    }

    public void attributeEdited(CtEditedEvent ctEditedEvent) {
        this.triggerState("edited");
        String string = "";
        this.setMessage(string);
    }

    private boolean saveData() {
        if (this._editor == null) {
            return false;
        }
        try {
            this._editor.saveAttributes();
        }
        catch (CtEditorISDException ctEditorISDException) {
            String string = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.invalid");
            String string2 = string + ctEditorISDException.getMessage();
            this.setMessage(string2);
            return false;
        }
        catch (SMAPIException sMAPIException) {
            this.setMessage("Unexpected error occur when saving attributes " + sMAPIException.getMessage());
            return false;
        }
        return true;
    }
}

