/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.buffer;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.topology.SMTopologyEntityData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.tools.buffer.CtTransferChangeEvent;
import com.sun.symon.base.console.tools.buffer.CtTransferChangeListener;
import com.sun.symon.base.console.tools.buffer.CtTransferCopyRunnable;
import com.sun.symon.base.console.tools.buffer.CtTransferCutRunnable;
import com.sun.symon.base.console.tools.buffer.CtTransferPasteRunnable;
import com.sun.symon.base.utility.UcInternationalizer;
import java.util.Vector;

public class CtTransferBuffer
implements AwxServiceManager {
    private AwxServiceProvider SvcProvider = null;
    private SMTopologyRequest RequestHandle = null;
    private SMTopologyEntityData[] EntityBuffer = null;
    private Vector ChangeListeners = new Vector();
    private String CutSourceUrl = null;
    private String CopySourceUrl = null;
    private String MarkPhilUrl = null;

    public void addCtTransferChangeListener(CtTransferChangeListener ctTransferChangeListener) {
        Vector vector = this.ChangeListeners;
        synchronized (vector) {
            this.ChangeListeners.addElement(ctTransferChangeListener);
        }
    }

    public void clearPendingCut() {
        this.CutSourceUrl = null;
        this.EntityBuffer = null;
        this.fireTransferChangeEvents(new CtTransferChangeEvent(this, 3));
    }

    public void copyFromContext(String string, String string2) {
        String string3 = null;
        String[] stringArray = null;
        int n = string2.indexOf(35);
        if (n < 0) {
            string3 = string2;
        } else {
            string3 = string2.substring(0, n);
            stringArray = new String[]{string2.substring(n + 1)};
        }
        this.SvcProvider.triggerServiceOnTarget(string, "busyStart");
        CtTransferCopyRunnable ctTransferCopyRunnable = new CtTransferCopyRunnable(this, this.RequestHandle, this.SvcProvider, string, string3, stringArray);
        Thread thread = new Thread(ctTransferCopyRunnable);
        thread.start();
    }

    public void copyFromView(String string, String string2, String[] stringArray) {
        this.SvcProvider.triggerServiceOnTarget(string, "busyStart");
        CtTransferCopyRunnable ctTransferCopyRunnable = new CtTransferCopyRunnable(this, this.RequestHandle, this.SvcProvider, string, string2, stringArray);
        Thread thread = new Thread(ctTransferCopyRunnable);
        thread.start();
    }

    public void cutFromContext(String string, String string2) {
        String string3 = null;
        String[] stringArray = null;
        int n = string2.indexOf(35);
        if (n < 0) {
            string3 = string2;
        } else {
            string3 = string2.substring(0, n);
            stringArray = new String[]{string2.substring(n + 1)};
        }
        this.SvcProvider.triggerServiceOnTarget(string, "busyStart");
        CtTransferCutRunnable ctTransferCutRunnable = new CtTransferCutRunnable(this, this.RequestHandle, this.SvcProvider, string, string3, stringArray);
        Thread thread = new Thread(ctTransferCutRunnable);
        thread.start();
    }

    public void cutFromView(String string, String string2, String[] stringArray) {
        this.SvcProvider.triggerServiceOnTarget(string, "busyStart");
        CtTransferCutRunnable ctTransferCutRunnable = new CtTransferCutRunnable(this, this.RequestHandle, this.SvcProvider, string, string2, stringArray);
        Thread thread = new Thread(ctTransferCutRunnable);
        thread.start();
    }

    public void fireTransferChangeEvents(CtTransferChangeEvent ctTransferChangeEvent) {
        Vector vector;
        Vector vector2 = this.ChangeListeners;
        synchronized (vector2) {
            vector = (Vector)this.ChangeListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtTransferChangeListener ctTransferChangeListener = (CtTransferChangeListener)this.ChangeListeners.elementAt(n);
            ctTransferChangeListener.txfrChangeOccurred(ctTransferChangeEvent);
            ++n;
        }
    }

    public String getCutSourceUrl() {
        return this.CutSourceUrl;
    }

    public String[] getBufferEntityIds() {
        if (this.EntityBuffer == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.EntityBuffer.length];
        int n = 0;
        while (n < this.EntityBuffer.length) {
            stringArray[n] = this.EntityBuffer[n].getEntityId();
            ++n;
        }
        return stringArray;
    }

    public String getUrlMarkedForPhil() {
        return this.MarkPhilUrl;
    }

    public void markUrlForPhil(String string, String string2) {
        this.MarkPhilUrl = string2;
        String[] stringArray = new String[]{"base.console.ConsoleMessages:ccp.markok"};
        this.SvcProvider.triggerServiceOnTarget(string, "message", stringArray);
        this.fireTransferChangeEvents(new CtTransferChangeEvent(this, 2));
    }

    public void pasteInto(String string, String string2) {
        if (this.EntityBuffer == null) {
            return;
        }
        this.SvcProvider.triggerServiceOnTarget(string, "busyStart");
        CtTransferPasteRunnable ctTransferPasteRunnable = this.CutSourceUrl == null ? new CtTransferPasteRunnable(this, this.RequestHandle, this.SvcProvider, string, string2, this.CopySourceUrl, this.translateDesc(this.EntityBuffer), true) : new CtTransferPasteRunnable(this, this.RequestHandle, this.SvcProvider, string, string2, this.CutSourceUrl, this.translateDesc(this.EntityBuffer), false);
        Thread thread = new Thread(ctTransferPasteRunnable);
        thread.start();
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void removeCtTransferChangeListener(CtTransferChangeListener ctTransferChangeListener) {
        Vector vector = this.ChangeListeners;
        synchronized (vector) {
            this.ChangeListeners.removeElement(ctTransferChangeListener);
        }
    }

    public synchronized void setBufferData(String string, SMTopologyEntityData[] sMTopologyEntityDataArray) {
        this.CutSourceUrl = string;
        this.EntityBuffer = sMTopologyEntityDataArray;
    }

    synchronized void setCopyBufferData(String string, SMTopologyEntityData[] sMTopologyEntityDataArray) {
        this.CutSourceUrl = null;
        this.CopySourceUrl = string;
        this.EntityBuffer = sMTopologyEntityDataArray;
    }

    public void setCutComplete() {
        this.CopySourceUrl = this.CutSourceUrl;
        this.CutSourceUrl = null;
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.RequestHandle = new SMTopologyRequest(sMRawDataRequest);
    }

    public SMTopologyEntityData[] translateDesc(SMTopologyEntityData[] sMTopologyEntityDataArray) {
        if (sMTopologyEntityDataArray == null) {
            return sMTopologyEntityDataArray;
        }
        int n = 0;
        while (n < sMTopologyEntityDataArray.length) {
            String string = UcInternationalizer.translateKey((String)sMTopologyEntityDataArray[n].getDesc());
            if (string.compareTo(sMTopologyEntityDataArray[n].getDesc()) != 0) {
                sMTopologyEntityDataArray[n] = new SMTopologyEntityData(sMTopologyEntityDataArray[n].getEntityId(), sMTopologyEntityDataArray[n].getXCoord(), sMTopologyEntityDataArray[n].getYCoord(), string, sMTopologyEntityDataArray[n].getFullDesc(), sMTopologyEntityDataArray[n].getHostName(), sMTopologyEntityDataArray[n].getIpAddr(), sMTopologyEntityDataArray[n].getNetmask(), sMTopologyEntityDataArray[n].getArch(), sMTopologyEntityDataArray[n].getFamily(), sMTopologyEntityDataArray[n].getType(), sMTopologyEntityDataArray[n].getConfig(), sMTopologyEntityDataArray[n].getIsPoll(), sMTopologyEntityDataArray[n].getPollType(), sMTopologyEntityDataArray[n].getIsSoftGroupLink(), sMTopologyEntityDataArray[n].getReadInfo(), sMTopologyEntityDataArray[n].getWriteInfo(), sMTopologyEntityDataArray[n].getTargetHost(), sMTopologyEntityDataArray[n].getTargetIP(), sMTopologyEntityDataArray[n].getTargetUrl());
            }
            ++n;
        }
        return sMTopologyEntityDataArray;
    }
}

