/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.modules;

import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class CmLoadNowDialog
extends JDialog
implements ActionListener {
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton helpBtn;
    private ButtonGroup group;
    public static int OK = 0;
    public static int CANCEL = 1;
    public static int HELP = 2;
    private int clicked = OK;
    private String command = "preserve";
    private static final String OK_BTN = "ok";
    private static final String CANCEL_BTN = "cancel";
    private static final String HELP_BTN = "help";
    private static final String LOAD_SELECT = "loadSel";
    private static final String PRESERVE_EXP = "preserveExp";
    private static final String CLEAR_EXP = "clearExp";
    private static final String PRESERVE_BTN = "preserveBtn";
    private static final String CLEAR_BTN = "clearBtn";
    private static final String LOADNOW = "runNow";
    public static final String PRESERVE_ACT_CMD = "preserve";
    public static final String CLEAR_ACT_CMD = "clear";

    public CmLoadNowDialog(JFrame jFrame) {
        super(jFrame);
        this.setModal(true);
        this.setTitle(this.translate(LOADNOW));
        this.createGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CmLoadNowDialog.this.cancel();
            }
        });
        this.pack();
        ((Component)this).setVisible(true);
    }

    public int getClicked() {
        return this.clicked;
    }

    public String getCommand() {
        return this.command;
    }

    void createGUI() {
        JPanel jPanel = new JPanel();
        this.setContentPane(jPanel);
        jPanel.setBorder(new EmptyBorder(20, 20, 10, 20));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        JLabel jLabel = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jLabel = new JLabel(this.translate(LOAD_SELECT));
        jLabel.setForeground(Color.black);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jLabel = new JLabel(this.translate(PRESERVE_EXP));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jLabel = new JLabel(this.translate(CLEAR_EXP));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 0);
        this.group = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(this.translate(PRESERVE_BTN));
        jRadioButton.setActionCommand(PRESERVE_ACT_CMD);
        jRadioButton.setMnemonic(this.translate("preserveBtn.mnemonic").charAt(0));
        jPanel2.add(jRadioButton);
        this.group.add(jRadioButton);
        JRadioButton jRadioButton2 = new JRadioButton(this.translate(CLEAR_BTN));
        jRadioButton2.setActionCommand(CLEAR_ACT_CMD);
        jRadioButton2.setMnemonic(this.translate("clearBtn.mnemonic").charAt(0));
        jRadioButton.setSelected(true);
        jPanel2.add(jRadioButton2);
        this.group.add(jRadioButton2);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 3, 5, 0));
        BoxLayout boxLayout2 = new BoxLayout(jPanel, 0);
        this.okBtn = new JButton(this.translate(OK_BTN));
        this.okBtn.addActionListener(this);
        jPanel3.add(this.okBtn);
        this.cancelBtn = new JButton(this.translate(CANCEL_BTN));
        this.cancelBtn.addActionListener(this);
        this.cancelBtn.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
        jPanel3.add(this.cancelBtn);
        this.helpBtn = new JButton(this.translate(HELP_BTN));
        this.helpBtn.setMnemonic(this.translate("help.mnemonic").charAt(0));
        this.helpBtn.addActionListener(this);
        jPanel3.add(this.helpBtn);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        this.getRootPane().setDefaultButton(this.okBtn);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.command = this.group.getSelection().getActionCommand();
        Object object = actionEvent.getSource();
        if (object == this.helpBtn) {
            String string = "details-module-loadnow-help";
            CmConsoleSession cmConsoleSession = CmConsoleSession.getInstance();
            cmConsoleSession.launchHelp(string);
        } else if (object == this.okBtn) {
            this.clicked = OK;
            ((Component)this).setVisible(false);
            this.dispose();
        } else if (object == this.cancelBtn) {
            this.cancel();
        }
    }

    void cancel() {
        this.clicked = CANCEL;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.modules.ModuleBundle:" + string));
    }
}

