/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CmProbeSelect
implements AwxServiceManager,
ListSelectionListener,
MouseListener {
    private AwxServiceProvider SvcProvider = null;
    private JList DisplayList = null;
    private String[] Labels;
    private String[] Commands;

    public void init(String string) {
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)string, vector)) {
            UcDDL.logErrorMessage((String)"Invalid probe select information");
            return;
        }
        this.Labels = new String[vector.size()];
        this.Commands = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = new Vector();
            UcListUtil.decomposeList((String)((String)vector.elementAt(n)), vector2);
            if (vector2.size() != 2) {
                this.Labels[n] = "***";
                this.Commands[n] = "";
            } else {
                this.Labels[n] = (String)vector2.elementAt(0);
                this.Labels[n] = UcListUtil.AsciiToUnicode((String)this.Labels[n]);
                this.Commands[n] = (String)vector2.elementAt(1);
            }
            ++n;
        }
        if (this.DisplayList != null) {
            this.DisplayList.setListData(this.Labels);
            this.DisplayList.revalidate();
            this.DisplayList.repaint();
        }
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void setListObject(Object object) {
        this.DisplayList = (JList)object;
        this.DisplayList.addListSelectionListener(this);
        this.DisplayList.addMouseListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
        int n = this.DisplayList.getSelectedIndex();
        if (n < 0) {
            this.SvcProvider.triggerService("deselect");
        } else {
            this.DisplayList.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        CmProbeSelect.this.SvcProvider.triggerService("enterKey");
                    }
                }
            });
            this.SvcProvider.triggerService("select");
            String[] stringArray2 = new String[]{this.Commands[n]};
            this.SvcProvider.triggerService("setProbeCmd", stringArray2);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            int n = this.DisplayList.getSelectedIndex();
            if (n < 0) {
                return;
            }
            String[] stringArray = new String[]{this.Commands[n]};
            this.SvcProvider.triggerService("setProbeCmd", stringArray);
            this.SvcProvider.triggerService("doubleSelect");
        }
    }
}

