/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMConfigFileLoader;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.attribute.SMAttributeDataException;
import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeGroupData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtEditedEvent;
import com.sun.symon.base.console.tools.editor.CtEditedListener;
import com.sun.symon.base.console.tools.editor.CtEditorDataSource;
import com.sun.symon.base.console.tools.editor.CtEditorISDException;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.xobject.XLoaderInterface;
import com.sun.symon.base.xobject.XObjectBase;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;

public class CmModuleEditor
implements AwxServiceManager,
CtEditorDataSource,
CtEditedListener,
Runnable {
    private AwxServiceProvider SvcProvider = null;
    private SMRawDataRequest RawHandle = null;
    private CtAttributeEditor Editor = null;
    private String ModuleId = null;
    private String AgentHost = null;
    private String EditModSpec = null;
    private int AgentPort = 0;
    private XObjectBase EditObject = null;
    private boolean SendInProgress = false;
    private boolean OkSelected = false;
    private boolean DefaultsSelected = false;
    private boolean scheduled = false;
    private Vector taskOperListeners = new Vector();

    public void attributeEdited(CtEditedEvent ctEditedEvent) {
        this.SvcProvider.triggerService("edited");
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
    }

    public synchronized void editApplyPressed() {
        if (this.Editor == null || this.SendInProgress) {
            return;
        }
        this.SendInProgress = true;
        this.OkSelected = false;
        Thread thread = new Thread((Runnable)this, "module-apply");
        thread.start();
    }

    public void editCancelPressed() {
        this.SvcProvider.triggerService("destroyWindow");
    }

    public synchronized void editOkPressed() {
        if (this.Editor == null || this.SendInProgress) {
            return;
        }
        this.SendInProgress = true;
        this.OkSelected = true;
        Thread thread = new Thread((Runnable)this, "module-ok");
        thread.start();
    }

    public synchronized void editDefaultsPressed() {
        if (this.Editor == null || this.SendInProgress) {
            return;
        }
        this.SendInProgress = true;
        this.DefaultsSelected = true;
        Thread thread = new Thread((Runnable)this, "module-defaults");
        thread.start();
    }

    public void editResetPressed() {
        if (this.Editor == null) {
            return;
        }
        this.Editor.resetAttributes();
        this.SvcProvider.triggerService("reset");
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
    }

    public SMAttributeEntryData[] getAttributeEntries(String string, String string2) throws SMAttributeDataException {
        SMAttributeEntryData[] sMAttributeEntryDataArray;
        if (this.EditObject == null) {
            return null;
        }
        Vector vector = this.EditObject.keys("param");
        String string3 = this.EditObject.lookup("consoleHint", "moduleParams(" + string2 + ")", null);
        if (string3 != null) {
            vector.removeAllElements();
            sMAttributeEntryDataArray = new StringTokenizer(string3);
            while (sMAttributeEntryDataArray.hasMoreTokens()) {
                vector.addElement(sMAttributeEntryDataArray.nextToken());
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        sMAttributeEntryDataArray = new SMAttributeEntryData[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            String string4;
            String string5 = (String)vector.elementAt(n);
            String string6 = this.EditObject.lookup("param", string5, "");
            String string7 = this.EditObject.lookup("?param", string5 + "?description", string5);
            char c = UcInternationalizer.translateKey((String)(string7 + ".mnemonic")).charAt(0);
            string7 = UcInternationalizer.translateKey((String)string7);
            String string8 = this.EditObject.lookup("?param", string5 + "?access", "rw");
            if (this.EditModSpec != null) {
                string8 = this.EditObject.lookup("?param", string5 + "?editaccess", string8);
            }
            String string9 = this.EditObject.lookup("?param", string5 + "?reqd", "");
            String string10 = this.EditObject.lookup("?param", string5 + "?type", "");
            String string11 = this.EditObject.lookup("?param", string5 + "?format", "");
            boolean bl = false;
            if (string9.compareTo("yes") == 0) {
                bl = true;
            }
            boolean bl2 = false;
            if (string8.compareTo("rw") == 0) {
                bl2 = true;
            }
            string6 = (string4 = this.EditObject.lookup("?param", string5 + "?i18n", "no")).equals("yes") ? UcInternationalizer.translateKey((String)string6) : UcListUtil.AsciiToUnicode((String)string6);
            sMAttributeEntryDataArray[n] = new SMAttributeEntryData(string5, string7, bl2, bl, string10, string11, string6, string6);
            sMAttributeEntryDataArray[n].setMnemonic(c);
            ++n;
        }
        return sMAttributeEntryDataArray;
    }

    public SMAttributeGroupData[] getAttributeGroups(String string) throws SMAttributeDataException {
        if (this.EditObject == null) {
            return null;
        }
        String string2 = this.EditObject.lookup("consoleHint", "moduleParamGroups", "param");
        boolean bl = string2.indexOf("schedule") > 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        int n = stringTokenizer.countTokens();
        SMAttributeGroupData[] sMAttributeGroupDataArray = new SMAttributeGroupData[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String string4 = this.EditObject.lookup("?" + string3, "?description", string3);
            char c = UcInternationalizer.translateKey((String)(string4 + ".mnemonic")).charAt(0);
            string4 = UcInternationalizer.translateKey((String)string4);
            sMAttributeGroupDataArray[n2] = new SMAttributeGroupData(string3, string4);
            sMAttributeGroupDataArray[n2++].setMnemonic(c);
        }
        return sMAttributeGroupDataArray;
    }

    public Image getImage(String string) {
        if (this.RawHandle == null) {
            return null;
        }
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.RawHandle);
        return sMResourceAccess.getImage(string);
    }

    public String[] getTimezoneInfo() {
        String[] stringArray;
        Vector vector;
        block6: {
            String string = "snmp://" + this.AgentHost + ":" + this.AgentPort + "/sym/base/info/system/localtime#0";
            vector = new Vector();
            try {
                stringArray = new String[]{string};
                StObject[][] stObjectArray = this.RawHandle.getURLValue(stringArray);
                if (stObjectArray == null || stObjectArray[0] == null || stObjectArray[0][0] == null) {
                    return null;
                }
                boolean bl = UcListUtil.decomposeList((String)stObjectArray[0][0].toString(), vector);
                if (!bl) {
                    return null;
                }
            }
            catch (SMAPIException sMAPIException) {
                vector = null;
                if (sMAPIException.getReasonCode() != 7) break block6;
                UcDDL.logDebugMessage((String)"CmModuleLoader:: you are running an old agent");
            }
        }
        if (vector != null) {
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
            stringArray[0] = UcInternationalizer.translateKey((String)stringArray[0], (String)stringArray[1]);
            return stringArray;
        }
        return null;
    }

    public void init() {
        Object object;
        Object object2;
        SMModuleRequest sMModuleRequest;
        this.Editor.addCtEditedListener(this);
        this.EditObject = XObjectBase.createRoot();
        try {
            sMModuleRequest = new SMModuleRequest(this.RawHandle);
            try {
                object2 = sMModuleRequest.getModuleXfile(this.AgentHost, this.AgentPort, this.ModuleId);
                this.EditObject.importData(true, "value", (String)object2);
            }
            catch (SMAPIException sMAPIException) {
                object = new SMConfigFileLoader(this.RawHandle);
                this.EditObject = XObjectBase.createRoot((XLoaderInterface)object);
                this.EditObject.importData(false, "value", this.ModuleId + "-m.x");
            }
        }
        catch (Exception exception) {
            object2 = new String[]{"base.console.ConsoleMessages:modload.nodef"};
            this.SvcProvider.triggerService("messageBell", (String[])object2);
        }
        if (this.EditModSpec != null) {
            sMModuleRequest = new SMModuleRequest(this.RawHandle);
            try {
                object2 = sMModuleRequest.getModuleFromSpec(this.EditModSpec);
                if (object2 == null || ((String[])object2).length != 2) {
                    object = new String[]{"base.console.ConsoleMessages:modload.noparam"};
                    this.SvcProvider.triggerService("messageBell", (String[])object);
                } else {
                    object = sMModuleRequest.getModuleParams(this.AgentHost, this.AgentPort, object2[0], object2[1]);
                    this.EditObject.importData(true, "param", (String)object);
                }
            }
            catch (Exception exception) {
                object = new String[]{"base.console.ConsoleMessages:modload.noparam"};
                this.SvcProvider.triggerService("messageBell", (String[])object);
            }
        }
        this.Editor.setDataSource(this);
        this.Editor.setEditObject("module");
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void run() {
        this.SvcProvider.triggerService("busyStart");
        boolean bl = this.saveData();
        this.SvcProvider.triggerService("busyEnd");
        CmModuleEditor cmModuleEditor = this;
        synchronized (cmModuleEditor) {
            this.SendInProgress = false;
        }
        if (!bl) {
            this.DefaultsSelected = false;
            return;
        }
        if (this.OkSelected || this.DefaultsSelected) {
            this.SvcProvider.triggerService("destroyWindow");
        } else {
            if (this.EditModSpec != null) {
                String[] stringArray = new String[]{"base.console.ConsoleMessages:modload.editsuccess"};
                this.SvcProvider.triggerService("message", stringArray);
            } else {
                String[] stringArray = new String[]{"base.console.ConsoleMessages:modload.loadsuccess"};
                this.SvcProvider.triggerService("message", stringArray);
            }
            this.SvcProvider.triggerService("reset");
        }
    }

    private boolean saveData() {
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
        try {
            this.Editor.saveAttributes();
        }
        catch (CtEditorISDException ctEditorISDException) {
            String string = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.invalid");
            String[] stringArray2 = new String[]{string + ctEditorISDException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return false;
        }
        catch (SMAttributeDataException sMAttributeDataException) {
            String[] stringArray3 = new String[]{sMAttributeDataException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray3);
            return false;
        }
        return true;
    }

    public void setAgentHost(String string) {
        this.AgentHost = string;
    }

    public void setAgentPort(int n) {
        this.AgentPort = n;
    }

    public void setDataSource(SMRawDataRequest sMRawDataRequest) {
        this.RawHandle = sMRawDataRequest;
    }

    public void setEditModSpec(String string) {
        this.EditModSpec = string;
    }

    public void setEditorBean(Object object) {
        try {
            this.Editor = (CtAttributeEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"Invalid editor object specified");
        }
    }

    public void setModuleId(String string) {
        this.ModuleId = string;
    }

    public void updateAttributes(String string, SMAttributeUpdateData[] sMAttributeUpdateDataArray) throws SMAttributeDataException {
        boolean bl;
        Object object;
        String string2;
        StringBuffer stringBuffer;
        if (this.EditObject == null) {
            return;
        }
        int n = 0;
        while (n < sMAttributeUpdateDataArray.length) {
            stringBuffer = sMAttributeUpdateDataArray[n];
            this.EditObject.define("param", stringBuffer.getKey(), stringBuffer.getValue());
            ++n;
        }
        stringBuffer = new StringBuffer();
        Vector vector = this.EditObject.keys("param");
        String string3 = "";
        String string4 = "";
        this.scheduled = false;
        int n2 = 0;
        while (n2 < vector.size()) {
            string2 = (String)vector.elementAt(n2);
            String string5 = this.EditObject.lookup("param", string2, "");
            if (string2.equals("module")) {
                string3 = string5;
            } else if (string2.equals("instance")) {
                string4 = string5;
            } else {
                stringBuffer.append(string2).append(" = \"").append(string5).append("\"; ");
            }
            if (string2.equals("loadtimewindow")) {
                this.scheduled = !string5.equals("");
            }
            ++n2;
        }
        string2 = stringBuffer.toString();
        if (this.EditModSpec != null) {
            string2 = string2 + "_RELOAD = \"true\";";
        }
        try {
            if (this.scheduled) {
                object = new SMModuleRequest(this.RawHandle);
                bl = this.EditModSpec != null ? !object.scheduleModuleAnyway(this.AgentHost, this.AgentPort, string3, string4, string2, null, this.DefaultsSelected) : !object.loadModuleBySchedule(this.AgentHost, this.AgentPort, string3, string4, string2, null, this.DefaultsSelected);
            } else {
                object = new SMModuleRequest(this.RawHandle);
                if (this.EditModSpec != null) {
                    object.removeModuleSchedule(this.AgentHost, this.AgentPort, string3, string4);
                    bl = !object.loadModuleAnyway(this.AgentHost, this.AgentPort, string3, string4, string2, this.DefaultsSelected);
                } else {
                    bl = !object.loadModule(this.AgentHost, this.AgentPort, string3, string4, string2, this.DefaultsSelected);
                }
            }
        }
        catch (SMAPIException sMAPIException) {
            String string6 = "";
            string6 = sMAPIException.getReasonCode() == 1 ? (this.EditModSpec != null ? (CmConsoleSession.isInRemoteServerContext(this.AgentHost, Integer.toString(this.AgentPort)) ? UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.editnoaccess") + UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.remoteServer") : UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.editnoaccess")) : (CmConsoleSession.isInRemoteServerContext(this.AgentHost, Integer.toString(this.AgentPort)) ? UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.noaccess") + UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.remoteServer") : UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.noaccess"))) : (this.EditModSpec != null ? UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.editfail") : UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.fail"));
            throw new SMAttributeDataException(string6);
        }
        if (bl) {
            object = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:modload.already");
            throw new SMAttributeDataException((String)object);
        }
    }
}

