/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMInvalidNameException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.topology.SMTopologyException;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.didgets.CdDomainTable;
import com.sun.symon.base.utility.UcDDL;
import javax.swing.AbstractButton;
import javax.swing.JTextField;

public class CmDomainCreate
implements AwxServiceManager,
Runnable {
    private AwxServiceProvider SvcProvider = null;
    private SMUserDomainRequest RequestHandle = null;
    private JTextField TextArea = null;
    private AbstractButton DiscoveryIndr = null;
    private CdDomainTable DomainTable = null;

    public void createDomain() {
        String string = this.TextArea.getText().trim();
        if (string.length() == 0) {
            String[] stringArray = new String[]{"base.console.ConsoleMessages:domaincreate.needname"};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return;
        }
        Thread thread = new Thread((Runnable)this, "domainCreate");
        thread.start();
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void run() {
        String[] stringArray;
        String[] stringArray2 = new String[]{"base.console.ConsoleMessages:domaincreate.work"};
        this.SvcProvider.triggerService("message", stringArray2);
        this.SvcProvider.triggerService("busyStart");
        SMUserDomainData sMUserDomainData = null;
        try {
            sMUserDomainData = this.RequestHandle.createDomain(this.TextArea.getText().trim());
        }
        catch (SMInvalidNameException sMInvalidNameException) {
            stringArray2 = new String[]{"base.console.ConsoleMessages:domaincreate.invalidname"};
            this.SvcProvider.triggerService("busyEnd");
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logErrorMessage((String)("createDomain: " + sMAPIException.getMessage()));
            stringArray2 = new String[]{sMAPIException.getReasonCode() == 1 ? "base.console.ConsoleMessages:domaincreate.noaccess" : "base.console.ConsoleMessages:domaincreate.fail"};
            this.SvcProvider.triggerService("busyEnd");
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        catch (SMTopologyException sMTopologyException) {
            stringArray2 = new String[]{sMTopologyException.getReasonCode() == 5 ? "base.console.ConsoleMessages:domaincreate.maxexceeded" : (sMTopologyException.getReasonCode() == 6 ? "base.console.ConsoleMessages:domaincreate.licenseexceeded" : "base.console.ConsoleMessages:domaincreate.fail")};
            this.SvcProvider.triggerService("busyEnd");
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        if (sMUserDomainData == null) {
            stringArray2 = new String[]{"base.console.ConsoleMessages:domaincreate.already"};
            this.SvcProvider.triggerService("busyEnd");
            this.SvcProvider.triggerService("messageBell", stringArray2);
            return;
        }
        if (this.DiscoveryIndr != null && this.DiscoveryIndr.isSelected()) {
            stringArray = new String[]{"domainName=" + sMUserDomainData.getDomainName(), "domainUrl=" + sMUserDomainData.getDomainRootUrl()};
            this.SvcProvider.triggerService("discovery", stringArray);
        }
        stringArray = new String[]{sMUserDomainData.getDomainName(), sMUserDomainData.getDomainRootUrl()};
        this.SvcProvider.triggerService("switchDomain", stringArray);
        this.SvcProvider.triggerService("destroyWindow");
    }

    public void setDiscoveryButton(Object object) {
        try {
            this.DiscoveryIndr = (AbstractButton)object;
        }
        catch (ClassCastException classCastException) {
            UcDDL.logErrorMessage((String)"Discovery button must be an AbstractButton");
        }
    }

    public void setDomainTable(Object object) {
        this.DomainTable = (CdDomainTable)object;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.RequestHandle = new SMUserDomainRequest(sMRawDataRequest);
    }

    public void setTextArea(Object object) {
        try {
            this.TextArea = (JTextField)object;
        }
        catch (ClassCastException classCastException) {
            UcDDL.logErrorMessage((String)"Text area must be a JTextField");
        }
    }
}

