/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.filter;

import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CgFilterSubPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JCheckBox titleCheckBox;
    private JRadioButton include;
    private JRadioButton exclude;
    private JComboBox type;
    private JButton delete;
    private JList list = new JList(new DefaultListModel());
    private String title;

    public CgFilterSubPanel(String string, boolean bl) {
        this.title = string;
        this.include = new JRadioButton(this.translate("include"), true);
        this.exclude = new JRadioButton(this.translate("exclude"), false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.include);
        buttonGroup.add(this.exclude);
        this.delete = new JButton(this.translate("delete"));
        this.titleCheckBox = new JCheckBox(string);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 12, 0));
        jPanel2.add(this.titleCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.include);
        jPanel3.add(Box.createHorizontalStrut(12));
        jPanel3.add(this.exclude);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel(new GridLayout(1, 2, 12, 0));
        this.type = new JComboBox();
        this.type.setMaximumRowCount(4);
        jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(0, 18, 0, 0));
        jPanel3.add((Component)this.type, "North");
        jPanel2.add(jPanel3);
        this.list.setBackground(UcCommon.getLightGrayColor());
        this.list.setFixedCellHeight(15);
        this.list.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.list, 22, 30);
        jPanel2.add(jScrollPane);
        jPanel.add(jPanel2);
        this.setLayout(new BorderLayout());
        this.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        this.delete = new JButton(this.translate("delete"));
        jPanel.add((Component)this.delete, "North");
        jPanel.setBorder(new EmptyBorder(25, 12, 0, 0));
        this.add((Component)jPanel, "East");
        this.titleCheckBox.addActionListener(this);
        this.delete.addActionListener(this);
        this.list.addListSelectionListener(this);
        this.type.addActionListener(this);
        this.setStatus(bl);
    }

    public void setStatus(boolean bl) {
        this.titleCheckBox.setSelected(bl);
        this.include.setEnabled(bl);
        this.exclude.setEnabled(bl);
        this.type.setEnabled(bl);
        if (!bl) {
            this.delete.setEnabled(bl);
        }
        this.list.setEnabled(bl);
        this.setIncludeSelected();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        defaultListModel.clear();
    }

    public boolean getCheckBoxSelected() {
        return this.titleCheckBox.isSelected();
    }

    public void setCheckBoxSelected(boolean bl) {
        this.titleCheckBox.setSelected(bl);
    }

    public boolean getIncludeSelected() {
        return this.include.isSelected();
    }

    public void setIncludeSelected() {
        this.include.doClick();
    }

    public boolean getExcludeSelected() {
        return this.exclude.isSelected();
    }

    public void setExcludeSelected() {
        this.exclude.doClick();
    }

    public void setTypeList(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.type.addItem(objectArray[n]);
            ++n;
        }
    }

    public JList getList() {
        return this.list;
    }

    public void setList(Object[] objectArray) {
        this.list.setListData(objectArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.titleCheckBox) {
            this.checkBoxActivated();
        } else if (object == this.delete) {
            this.deleteActivated();
        } else if (object == this.type) {
            this.typeActivated();
        } else if (object == this.list) {
            this.listActivated();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (object == this.list) {
            this.listActivated();
        }
    }

    public void checkBoxActivated() {
        this.setStatus(this.titleCheckBox.isSelected());
    }

    public void typeActivated() {
        Object object = this.type.getSelectedItem();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        if (!defaultListModel.contains(object)) {
            defaultListModel.addElement(object);
            this.list.setModel(defaultListModel);
            if (this.list.isShowing()) {
                this.list.revalidate();
            }
        }
    }

    public void deleteActivated() {
        int[] nArray = this.list.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        int n = 0;
        while (n < nArray.length) {
            defaultListModel.removeElementAt(nArray[n]);
            ++n;
        }
        this.delete.setEnabled(false);
    }

    public void listActivated() {
        if (this.list.getSelectedIndex() != -1) {
            this.delete.setEnabled(true);
        } else {
            this.delete.setEnabled(false);
        }
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.grouping.filter.CgFilterBundle:" + string));
    }
}

