/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.group.SMObjectGroup;
import com.sun.symon.base.client.group.SMObjectGroupData;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgAggregateManager;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CgPreviewDialog
extends JDialog
implements ActionListener,
Runnable {
    private JTextArea textArea;
    private JButton saveBtn;
    private JButton closeBtn;
    private JButton helpBtn;
    private JLabel statusLbl;
    private JFileChooser chooser = new JFileChooser();
    private SMObjectGroup handle = null;
    private SMObjectGroupData objectGroup;

    public static void showPreviewDialog(CgAggregateManager cgAggregateManager, SMObjectGroupData sMObjectGroupData) {
        CgPreviewDialog cgPreviewDialog = new CgPreviewDialog(cgAggregateManager, sMObjectGroupData);
        cgPreviewDialog.pack();
        cgPreviewDialog.setLocationRelativeTo(cgAggregateManager);
        ((Component)cgPreviewDialog).setVisible(true);
        cgPreviewDialog.setObjectGroupData(sMObjectGroupData);
    }

    public CgPreviewDialog(CgAggregateManager cgAggregateManager, SMObjectGroupData sMObjectGroupData) {
        super((Frame)cgAggregateManager, true);
        this.handle = cgAggregateManager.getObjectGroupHandle();
        this.createGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgPreviewDialog.this.close();
            }
        });
        if (sMObjectGroupData != null) {
            this.setObjectGroupData(sMObjectGroupData);
        }
    }

    private void setObjectGroupData(SMObjectGroupData sMObjectGroupData) {
        this.objectGroup = sMObjectGroupData;
        this.statusLbl.setText(CgUtility.getI18nMsg("preview.resolving"));
        new Thread(this).start();
    }

    public void run() {
        String string = this.objectGroup.getName();
        String[] stringArray = this.objectGroup.getObjects();
        try {
            stringArray = this.handle.resolve(this.objectGroup);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showError((Component)this, (Object)UcInternationalizer.translateKey((String)sMAPIException.getMessageI18nKey()));
            this.statusLbl.setText(CgUtility.getI18nMsg("preview.unableToResolve"));
            return;
        }
        final String[] stringArray2 = stringArray;
        Runnable runnable = new Runnable(){

            public void run() {
                if (stringArray2 != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        String string = stringArray2[n];
                        if (n != stringArray2.length - 1) {
                            string = string + "\n";
                        }
                        CgPreviewDialog.this.textArea.append(string);
                        ++n;
                    }
                    if (stringArray2.length > 0) {
                        CgPreviewDialog.this.saveBtn.setEnabled(true);
                    }
                }
                CgPreviewDialog.this.statusLbl.setText(" ");
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void createGUI() {
        this.setTitle(CgUtility.getI18nMsg("preview.title"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.textArea = new JTextArea(15, 40);
        this.textArea.setEditable(false);
        this.textArea.setBackground(jPanel.getBackground());
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.saveBtn = new JButton(CgUtility.getI18nMsg("standard.saveAs") + "...");
        this.saveBtn.setMnemonic(CgUtility.getMnemonic("standard.saveAs"));
        this.saveBtn.setEnabled(false);
        this.saveBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.saveBtn);
        this.closeBtn = new JButton(CgUtility.getI18nMsg("message.close"));
        this.getRootPane().setDefaultButton(this.closeBtn);
        this.closeBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.closeBtn);
        this.helpBtn = new JButton(CgUtility.getI18nMsg("standard.help"));
        this.helpBtn.setMnemonic(CgUtility.getMnemonic("standard.help"));
        this.helpBtn.addActionListener(this);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(this.helpBtn);
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add(jPanel);
        this.statusLbl = new JLabel(" ");
        this.statusLbl.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.statusLbl.setForeground(Color.black);
        jPanel3.add((Component)this.statusLbl, "South");
        this.setContentPane(jPanel3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.saveBtn) {
            this.save();
        } else if (object == this.closeBtn) {
            this.close();
        } else if (object == this.helpBtn) {
            CmConsoleSession.getInstance().launchHelp("grouping-og-previewer-help");
        }
    }

    public void close() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void save() {
        int n = this.chooser.showSaveDialog(this);
        if (n == 0) {
            File file = this.chooser.getSelectedFile();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(this.textArea.getText().getBytes());
            }
            catch (IOException iOException) {
                UcDialog.showError((Component)this, (Object)iOException.getMessage());
                this.statusLbl.setText(CgUtility.getI18nMsg("standard.unableToSave"));
                return;
            }
            this.statusLbl.setText(CgUtility.getI18nMsg("standard.saved"));
        }
    }
}

