/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.module.SMModuleInfo;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskEditor;
import com.sun.symon.base.client.task.SMTaskEditorManager;
import com.sun.symon.base.client.task.SMTaskEditorManagerEx;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgAttributeModifier;
import com.sun.symon.base.console.grouping.aggregate.CgModuleScheduler;
import com.sun.symon.base.console.grouping.aggregate.CgTaskOperationEvent;
import com.sun.symon.base.console.grouping.aggregate.CgTaskOperationListener;
import com.sun.symon.base.console.grouping.table.CgComboBox;
import com.sun.symon.base.console.grouping.table.CgData;
import com.sun.symon.base.console.grouping.table.CgTblColumnFormat;
import com.sun.symon.base.console.grouping.table.CgTblPane;
import com.sun.symon.base.console.grouping.table.CgTblSelectEvent;
import com.sun.symon.base.console.grouping.table.CgTblSelectListener;
import com.sun.symon.base.utility.UcCommon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CgModuleTaskEditor
extends JPanel
implements SMTaskEditor {
    private static final String NONE = "none";
    public static final String LOAD = "load";
    public static final String SET = "set";
    public static final String ENABLE = "enable";
    public static final String UNLOAD = "unload";
    public static final String DISABLE = "disable";
    private static final int MODULE_COL = 0;
    private static final int ACTION_COL = 1;
    private static final int SCHEDULE_COL = 2;
    private static final int SECURITY_COL = 3;
    private static final Integer NO = new Integer(0);
    private static final Integer YES = new Integer(1);
    private static final int SCHEDULE_TAB = 0;
    private static final int SECURITY_TAB = 1;
    private static CgData NO_DATA = new CgData(CgUtility.getI18nMsg("standard.notSet"), null, NO);
    private static CgData YES_DATA = new CgData(CgUtility.getI18nMsg("standard.set"), null, YES);
    private static CgData SCHEDULED = new CgData(CgUtility.getI18nMsg("standard.scheduled"), null, YES);
    private static CgData NOTSCHEDULED = new CgData(CgUtility.getI18nMsg("standard.notscheduled"), null, NO);
    private static CgData NOTAPPLICABLE = new CgData(CgUtility.getI18nMsg("standard.notapplicable"), null, NO);
    private SMRawDataRequest handle_;
    private SMTaskEditorManagerEx taskManager_;
    private Frame parentFrame_;
    GridBagLayout mainGridBagLayout_ = new GridBagLayout();
    GridLayout gridLayout = new GridLayout();
    CgTblPane tablePanel_;
    JButton loadButton_ = new JButton();
    JButton scheduleButton_ = new JButton();
    JButton securityButton_ = new JButton();
    JButton deleteButton_ = new JButton();
    JComboBox selectModule_;
    JComboBox selectAction_;
    JLabel selectModuleLabel_ = new JLabel();
    JLabel selectActionLabel_ = new JLabel();
    boolean editing_ = true;

    public CgModuleTaskEditor() {
        this(null, null, null, false);
    }

    public CgModuleTaskEditor(SMTaskEditorManager sMTaskEditorManager, SMTask sMTask, SMRawDataRequest sMRawDataRequest, boolean bl) {
        this.taskManager_ = (SMTaskEditorManagerEx)sMTaskEditorManager;
        if (this.taskManager_ instanceof Frame) {
            this.parentFrame_ = (Frame)this.taskManager_;
        }
        this.handle_ = sMRawDataRequest;
        Object[] objectArray = this.getModuleNames();
        this.selectModule_ = new CgComboBox(objectArray);
        this.selectModule_.setSelectedIndex(-1);
        this.selectModule_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgModuleTaskEditor.this.moduleChanged(actionEvent);
            }
        });
        this.selectAction_ = new CgComboBox(new CgData[]{new CgData(CgUtility.getI18nMsg("module.none"), null, NONE), new CgData(CgUtility.getI18nMsg("module.load"), null, LOAD), new CgData(CgUtility.getI18nMsg("module.enable"), null, ENABLE), new CgData(CgUtility.getI18nMsg("module.disable"), null, DISABLE), new CgData(CgUtility.getI18nMsg("module.unload"), null, UNLOAD)});
        this.selectAction_.setSelectedIndex(-1);
        this.selectAction_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgModuleTaskEditor.this.actionChanged(actionEvent);
            }
        });
        CgTblColumnFormat[] cgTblColumnFormatArray = new CgTblColumnFormat[]{new CgTblColumnFormat(CgUtility.getI18nMsg("module.moduleName"), false, null), new CgTblColumnFormat(CgUtility.getI18nMsg("module.selectAction"), false, null), new CgTblColumnFormat(CgUtility.getI18nMsg("module.moduleSchedule"), false, null), new CgTblColumnFormat(CgUtility.getI18nMsg("module.moduleSecurity"), false, null)};
        this.tablePanel_ = new CgTblPane(cgTblColumnFormatArray, false);
        this.tablePanel_.setShowConfirmForRow(false);
        Vector<CgData> vector = new Vector<CgData>();
        vector.add(new CgData(""));
        vector.add(new CgData(""));
        vector.add(new CgData(""));
        vector.add(new CgData(""));
        this.tablePanel_.addRow(vector);
        ModuleRenderer moduleRenderer = new ModuleRenderer();
        this.tablePanel_.addCgTblSelectListener(new CgTblSelectListener(){

            public void selectionOccurred(CgTblSelectEvent cgTblSelectEvent) {
                CgModuleTaskEditor.this.tableRowSelected(cgTblSelectEvent);
            }
        });
        this.tablePanel_.getTable().setBackground(UcCommon.getLightGrayColor());
        this.tablePanel_.getTable().setColumnSelectionAllowed(false);
        this.tablePanel_.getTable().getColumnModel().getColumn(0).setCellRenderer(moduleRenderer);
        this.tablePanel_.getTable().getColumnModel().getColumn(1).setCellRenderer(moduleRenderer);
        this.tablePanel_.getTable().getColumnModel().getColumn(2).setCellRenderer(moduleRenderer);
        this.tablePanel_.getTable().getColumnModel().getColumn(3).setCellRenderer(moduleRenderer);
        this.tablePanel_.getTable().getColumnModel().getColumn(0).setPreferredWidth(300);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tablePanel_.getTable().getColumnModel().getColumn(0).setPreferredWidth(200);
        this.tablePanel_.getTable().getColumnModel().getColumn(1).setPreferredWidth(150);
        this.selectModule_.setEnabled(false);
        this.selectAction_.setEnabled(false);
        this.localize();
        this.tablePanel_.setRowSelectionInterval(0, 0);
        this.setVisible(true);
    }

    CgData[] getModuleNames() {
        CgData[] cgDataArray = null;
        try {
            SMModuleInfo[] sMModuleInfoArray = CgUtility.getMDRModules(this.handle_);
            cgDataArray = new CgData[sMModuleInfoArray.length];
            Arrays.sort((Object[])sMModuleInfoArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = ((SMModuleInfo)object).toString();
                    String string2 = ((SMModuleInfo)object2).toString();
                    return string.compareTo(string2);
                }

                public boolean equals(Object object, Object object2) {
                    String string = ((SMModuleInfo)object).toString();
                    String string2 = ((SMModuleInfo)object2).toString();
                    return string.equals(string2);
                }
            });
            int n = 0;
            while (n < sMModuleInfoArray.length) {
                Module module = new Module(sMModuleInfoArray[n]);
                cgDataArray[n] = new CgData(module.toString(), null, module);
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cgDataArray;
    }

    public void setOperationData(SMTaskOperationData[] sMTaskOperationDataArray) {
        CgData[] cgDataArray;
        Object object;
        Vector<CgData[]> vector = new Vector<CgData[]>();
        Module module = null;
        Object var4_4 = null;
        boolean bl = false;
        int n = 0;
        while (n < sMTaskOperationDataArray.length) {
            object = NOTSCHEDULED;
            CgData cgData = NO_DATA;
            cgDataArray = new CgData[4];
            SMTaskOperationData sMTaskOperationData = sMTaskOperationDataArray[n];
            String string = this.setToEnable(sMTaskOperationData).getOperation();
            String string2 = sMTaskOperationData.getOperand();
            String string3 = this.getModuleNameFromOperand(string2);
            String string4 = this.getInstanceFromOperand(string2);
            SMModuleInfo sMModuleInfo = this.getModuleInfo(string3);
            if (sMModuleInfo == null) {
                sMModuleInfo = new SMModuleInfo(string3, string3, "", "1.0", 1, string3, Locale.getDefault());
            }
            module = new Module(string4, sMModuleInfo);
            String string5 = module.getModuleName();
            if (module.getInstanceName() != null && !module.getInstanceName().equals("")) {
                string5 = string5 + " [" + module.getInstanceName() + "]";
            }
            CgData cgData2 = new CgData(string5);
            CgData cgData3 = null;
            if (string.equals(LOAD) || string.equals(SET)) {
                SMTaskOperationData sMTaskOperationData2;
                if (string.equals(LOAD)) {
                    module.setLoadOperationData(sMTaskOperationData);
                    cgData3 = new CgData(CgUtility.getI18nMsg("module.load"), null, string);
                    if (sMTaskOperationData.getValue() != null && !sMTaskOperationData.getValue().equals("") || sMTaskOperationData.getUserData() != null && sMTaskOperationData.getUserData().indexOf("enabletimewindow") >= 0) {
                        object = SCHEDULED;
                    }
                    ++n;
                } else {
                    sMTaskOperationData2 = new SMTaskOperationData();
                    try {
                        sMTaskOperationData2.setOperation(NONE);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    module.setOperation(sMTaskOperationData2);
                    string = NONE;
                    cgData3 = new CgData(CgUtility.getI18nMsg("standard.none"), null, NONE);
                }
                while (n < sMTaskOperationDataArray.length) {
                    sMTaskOperationData2 = sMTaskOperationDataArray[n];
                    String string6 = sMTaskOperationData2.getOperand();
                    String string7 = this.getModuleNameFromOperand(string6);
                    String string8 = this.getInstanceFromOperand(string6);
                    if (!(string3 == null || string4 == null || string3.equals(string7) && string4.equals(string8))) {
                        --n;
                        break;
                    }
                    if (sMTaskOperationData2.getOperation().equals(SET) && this.isSecurityOp(sMTaskOperationData2)) {
                        module.setSecurityOperationData(sMTaskOperationData2);
                        cgData = YES_DATA;
                        ++n;
                        continue;
                    }
                    --n;
                    break;
                }
            }
            if (string.equals(ENABLE)) {
                module.setEnableOperationData(sMTaskOperationData);
                cgData3 = new CgData(CgUtility.getI18nMsg("module.enable"), null, string);
                if (sMTaskOperationData.getValue() != null && !sMTaskOperationData.getValue().equals("") || sMTaskOperationData.getUserData() != null && sMTaskOperationData.getUserData().indexOf("enabletimewindow") >= 0) {
                    object = SCHEDULED;
                }
                cgData = NOTAPPLICABLE;
            }
            if (string.equals(DISABLE)) {
                module.setOperation(sMTaskOperationData);
                cgData3 = new CgData(CgUtility.getI18nMsg("module.disable"), null, string);
                object = NOTAPPLICABLE;
                cgData = NOTAPPLICABLE;
            }
            if (string.equals(UNLOAD)) {
                module.setOperation(sMTaskOperationData);
                cgData3 = new CgData(CgUtility.getI18nMsg("module.unload"), null, string);
                cgData = NOTAPPLICABLE;
                object = NOTAPPLICABLE;
            }
            if (string.equals(NONE)) {
                object = NOTAPPLICABLE;
            }
            cgData2.setUserData(module);
            cgDataArray[0] = cgData2;
            cgDataArray[1] = cgData3;
            cgDataArray[2] = object;
            cgDataArray[3] = cgData;
            vector.add(cgDataArray);
            ++n;
        }
        cgDataArray = new CgData[]{new CgData(""), new CgData(""), new CgData(""), new CgData("")};
        vector.add(cgDataArray);
        object = new CgData[vector.size()][];
        vector.copyInto((Object[])object);
        this.tablePanel_.setData((CgData[][])object);
        int n2 = this.tablePanel_.getRowCount() - 1;
        this.tablePanel_.setRowSelectionInterval(n2, n2);
    }

    private boolean isScheduleOp(SMTaskOperationData sMTaskOperationData) {
        String string = sMTaskOperationData.getUserData();
        return string.startsWith("Schedule");
    }

    private boolean isSecurityOp(SMTaskOperationData sMTaskOperationData) {
        String string = sMTaskOperationData.getUserData();
        return string.startsWith("Security");
    }

    private String getModuleNameFromOperand(String string) {
        String string2 = string;
        int n = string2.indexOf("/mod/");
        if (n >= 0) {
            string2 = string2.substring(n + 5);
        }
        if ((n = string2.indexOf("?getset")) >= 0) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf(":")) != -1) {
            string2 = string2.substring(0, n);
        }
        if ((n = string2.indexOf("+")) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private String getInstanceFromOperand(String string) {
        String string2 = string;
        int n = string2.indexOf("+");
        if (n != -1) {
            string2 = string2.substring(n + 1);
        }
        if ((n = string2.indexOf(":")) != -1) {
            string2 = string2.substring(n + 1);
        }
        if (string2.equals(string)) {
            return null;
        }
        n = string2.indexOf("?");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private SMModuleInfo getModuleInfo(String string) {
        SMModuleInfo[] sMModuleInfoArray = null;
        try {
            sMModuleInfoArray = CgUtility.getMDRModules(this.handle_);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sMModuleInfoArray == null) {
            return null;
        }
        int n = 0;
        while (n < sMModuleInfoArray.length) {
            if (string.equals(sMModuleInfoArray[n].getModule())) {
                return sMModuleInfoArray[n];
            }
            ++n;
        }
        return null;
    }

    public SMTaskOperationData[] getOperationData() {
        int n = this.tablePanel_.getRowCount() - 1;
        Vector<SMTaskOperationData> vector = new Vector<SMTaskOperationData>();
        int n2 = 0;
        while (n2 < n) {
            Module module;
            CgData cgData = (CgData)this.tablePanel_.getValueAt(n2, 0);
            if (cgData != null && (module = (Module)cgData.getUserData()) != null) {
                int n3;
                SMTaskOperationData[] sMTaskOperationDataArray;
                if (module.getLoadOperationData() != null) {
                    vector.addElement(module.getLoadOperationData());
                }
                if (module.getEnableOperationData() != null) {
                    vector.addElement(module.getEnableOperationData());
                }
                if ((sMTaskOperationDataArray = module.getOperations()) != null) {
                    n3 = 0;
                    while (n3 < sMTaskOperationDataArray.length) {
                        if (sMTaskOperationDataArray[n3] != null && !sMTaskOperationDataArray[n3].getOperation().equals(NONE)) {
                            vector.addElement(sMTaskOperationDataArray[n3]);
                        }
                        ++n3;
                    }
                }
                if ((sMTaskOperationDataArray = module.getSecurityOperationData()) != null) {
                    n3 = 0;
                    while (n3 < sMTaskOperationDataArray.length) {
                        if (sMTaskOperationDataArray[n3] != null) {
                            vector.addElement(sMTaskOperationDataArray[n3]);
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        Object[] objectArray = new SMTaskOperationData[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean validateData() {
        String string;
        Object object;
        int n = this.tablePanel_.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            Module module;
            object = (CgData)this.tablePanel_.getValueAt(n2, 0);
            if (object == null || (module = (Module)((CgData)object).getUserData()) == null) break;
            if (module.getLoadOperationData() == null && module.getEnableOperationData() == null && module.getSecurityOperationData() == null && module.getOperations() == null) {
                this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("task.incompleteData"));
                return false;
            }
            if (module.isMultiInstance() && (string = module.getLoadOperationData()) != null && (string.getUserData() == null || string.getUserData().indexOf("instanceName") < 0)) {
                this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("module.noDescription"));
                return false;
            }
            ++n2;
        }
        object = this.getOperationData();
        int n3 = 0;
        while (n3 < ((SMTaskOperationData[])object).length) {
            string = object[n3].getOperation();
            if (string == null || string.equals("")) {
                this.taskManager_.setStatusMessage(CgUtility.getI18nMsg("task.incompleteData"));
                return false;
            }
            ++n3;
        }
        return true;
    }

    private boolean isModuleAction(String string) {
        return string.equals(LOAD) || string.equals(ENABLE) || string.equals(UNLOAD) || string.equals(DISABLE) || string.equals(NONE);
    }

    public void cleanup() {
    }

    private void localize() {
        int n = this.taskManager_.getTaskNameLabelWidth();
        this.selectModuleLabel_.setLabelFor(this.selectModule_);
        this.selectModuleLabel_.setMinimumSize(new Dimension(n, 23));
        this.selectModuleLabel_.setPreferredSize(new Dimension(n, 23));
        this.selectModuleLabel_.setText(CgUtility.getI18nMsg("module.selectModule") + ":");
        this.selectActionLabel_.setMinimumSize(new Dimension(n, 23));
        this.selectActionLabel_.setPreferredSize(new Dimension(n, 23));
        this.selectActionLabel_.setText(CgUtility.getI18nMsg("module.selectAction") + ":");
        this.selectActionLabel_.setLabelFor(this.selectAction_);
        this.loadButton_.setText(CgUtility.getI18nMsg("module.loadParameters") + "...");
        this.scheduleButton_.setText(CgUtility.getI18nMsg("module.setSchedule") + "...");
        this.securityButton_.setText(CgUtility.getI18nMsg("module.setSecurity") + "...");
        this.deleteButton_.setText(CgUtility.getI18nMsg("standard.deleteEntry"));
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainGridBagLayout_);
        this.loadButton_.setEnabled(false);
        this.loadButton_.setText(LOAD);
        this.loadButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgModuleTaskEditor.this.loadButton__actionPerformed(actionEvent);
            }
        });
        this.scheduleButton_.setEnabled(false);
        this.scheduleButton_.setText("schedule");
        this.scheduleButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgModuleTaskEditor.this.scheduleButton__actionPerformed(actionEvent);
            }
        });
        this.securityButton_.setEnabled(false);
        this.securityButton_.setText("security");
        this.securityButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgModuleTaskEditor.this.securityButton__actionPerformed(actionEvent);
            }
        });
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.setText("delete");
        this.deleteButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgModuleTaskEditor.this.deleteButton__actionPerformed(actionEvent);
            }
        });
        this.setMinimumSize(new Dimension(10, 10));
        this.setPreferredSize(new Dimension(10, 10));
        this.selectModuleLabel_.setMaximumSize(new Dimension(130, 18));
        this.selectModuleLabel_.setMinimumSize(new Dimension(130, 18));
        this.selectModuleLabel_.setPreferredSize(new Dimension(130, 18));
        this.selectModuleLabel_.setText("selectModule");
        this.selectActionLabel_.setMaximumSize(new Dimension(130, 18));
        this.selectActionLabel_.setMinimumSize(new Dimension(130, 18));
        this.selectActionLabel_.setPreferredSize(new Dimension(130, 18));
        this.selectActionLabel_.setText("selectAction");
        this.add((Component)this.tablePanel_, new GridBagConstraints(0, 2, 3, 4, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.loadButton_, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.scheduleButton_, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.securityButton_, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.deleteButton_, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)this.selectModuleLabel_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectActionLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectModule_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectAction_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(7, 0, 3, 0), 0, 0));
    }

    void loadButton__actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.tablePanel_.getSelectedRow();
            SMTaskOperationData sMTaskOperationData = new SMTaskOperationData();
            sMTaskOperationData.setOperation(LOAD);
            CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 0);
            final Module module = (Module)cgData.getUserData();
            sMTaskOperationData.setOperand(module.getOperand());
            CgTaskOperationListener cgTaskOperationListener = new CgTaskOperationListener(){

                public void taskOperationChanged(CgTaskOperationEvent cgTaskOperationEvent) {
                    SMTaskOperationData[] sMTaskOperationDataArray = cgTaskOperationEvent.getTaskOpeations();
                    CgModuleTaskEditor.this.setActions(CgModuleTaskEditor.LOAD, sMTaskOperationDataArray);
                    module.setLoadOperationData(sMTaskOperationDataArray[0]);
                }
            };
            boolean bl = true;
            CgAttributeModifier cgAttributeModifier = null;
            SMTaskOperationData sMTaskOperationData2 = module.getLoadOperationData();
            this.taskManager_.setBusy(true);
            cgAttributeModifier = sMTaskOperationData2 == null || sMTaskOperationData2.getUserData() == null || sMTaskOperationData2.getUserData().equals("") ? new CgAttributeModifier(this.parentFrame_, module.getTargetUrl(), this.handle_, cgTaskOperationListener, 0, bl, true) : new CgAttributeModifier(this.parentFrame_, new SMTaskOperationData[]{sMTaskOperationData2}, this.handle_, cgTaskOperationListener, 0, bl, true);
            cgAttributeModifier.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    CgModuleTaskEditor.this.taskManager_.setBusy(false);
                }
            });
            cgAttributeModifier.setLocationRelativeTo(this.loadButton_);
            ((Component)cgAttributeModifier).setVisible(true);
            this.taskManager_.setModified(true);
        }
        catch (Exception exception) {
            this.taskManager_.setBusy(false);
            exception.printStackTrace();
        }
    }

    void scheduleButton__actionPerformed(ActionEvent actionEvent) {
        try {
            final int n = this.tablePanel_.getSelectedRow();
            CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 0);
            final Module module = (Module)cgData.getUserData();
            CgTaskOperationListener cgTaskOperationListener = new CgTaskOperationListener(){

                public void taskOperationChanged(CgTaskOperationEvent cgTaskOperationEvent) {
                    SMTaskOperationData[] sMTaskOperationDataArray = cgTaskOperationEvent.getTaskOpeations();
                    CgData cgData = (CgData)CgModuleTaskEditor.this.tablePanel_.getValueAt(n, 1);
                    String string = (String)cgData.getUserData();
                    if (string.equals(CgModuleTaskEditor.LOAD)) {
                        module.setLoadOperationData(sMTaskOperationDataArray[0]);
                        if (sMTaskOperationDataArray[0].getValue() != null && !sMTaskOperationDataArray[0].getValue().equals("") || sMTaskOperationDataArray[0].getUserData() != null && sMTaskOperationDataArray[0].getUserData().indexOf("enabletimewindow") >= 0) {
                            CgModuleTaskEditor.this.tablePanel_.setValueAt(SCHEDULED, n, 2);
                        } else {
                            CgModuleTaskEditor.this.tablePanel_.setValueAt(NOTSCHEDULED, n, 2);
                        }
                    } else if (sMTaskOperationDataArray[0].getValue() != null && sMTaskOperationDataArray[0].getValue().indexOf("activetimewindow") >= 0) {
                        module.setEnableOperationData(sMTaskOperationDataArray[0]);
                        CgModuleTaskEditor.this.tablePanel_.setValueAt(SCHEDULED, n, 2);
                    } else {
                        CgModuleTaskEditor.this.tablePanel_.setValueAt(NOTSCHEDULED, n, 2);
                    }
                }
            };
            Object var6_7 = null;
            CgData cgData2 = (CgData)this.tablePanel_.getValueAt(n, 1);
            String string = (String)cgData2.getUserData();
            SMTaskOperationData sMTaskOperationData = string.equals(LOAD) ? module.getLoadOperationData() : module.getEnableOperationData();
            this.getSchedule(sMTaskOperationData);
            this.taskManager_.setModified(true);
        }
        catch (Exception exception) {
            this.taskManager_.setBusy(false);
            exception.printStackTrace();
        }
    }

    private void getSchedule(SMTaskOperationData sMTaskOperationData) {
        if (sMTaskOperationData == null) {
            return;
        }
        String string = sMTaskOperationData.getOperation();
        String string2 = sMTaskOperationData.getValue();
        this.taskManager_.setBusy(true);
        CgModuleScheduler cgModuleScheduler = new CgModuleScheduler(this.parentFrame_, string2);
        cgModuleScheduler.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                CgModuleTaskEditor.this.taskManager_.setBusy(false);
            }
        });
        ((Component)cgModuleScheduler).setVisible(true);
        try {
            if (!cgModuleScheduler.isCancelled()) {
                this.tablePanel_.setValueAt(SCHEDULED, this.tablePanel_.getSelectedRow(), 2);
                string2 = cgModuleScheduler.getTimexString();
                sMTaskOperationData.setValue(string2);
                sMTaskOperationData.setValueType("java.lang.String");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void securityButton__actionPerformed(ActionEvent actionEvent) {
        try {
            final int n = this.tablePanel_.getSelectedRow();
            CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 0);
            final Module module = (Module)cgData.getUserData();
            CgTaskOperationListener cgTaskOperationListener = new CgTaskOperationListener(){

                public void taskOperationChanged(CgTaskOperationEvent cgTaskOperationEvent) {
                    SMTaskOperationData[] sMTaskOperationDataArray = cgTaskOperationEvent.getTaskOpeations();
                    CgModuleTaskEditor.this.setActions(CgModuleTaskEditor.SET, sMTaskOperationDataArray);
                    module.setSecurityOperationData(sMTaskOperationDataArray);
                    CgModuleTaskEditor.this.tablePanel_.setValueAt(YES_DATA, n, 3);
                }
            };
            this.taskManager_.setBusy(true);
            CgAttributeModifier cgAttributeModifier = null;
            if (((CgData)this.tablePanel_.getValueAt(n, 3)).equals(NO_DATA)) {
                cgAttributeModifier = new CgAttributeModifier(this.parentFrame_, module.getTargetUrl(), this.handle_, cgTaskOperationListener, 1);
            } else {
                SMTaskOperationData[] sMTaskOperationDataArray = module.getSecurityOperationData();
                cgAttributeModifier = new CgAttributeModifier(this.parentFrame_, sMTaskOperationDataArray, this.handle_, cgTaskOperationListener, 1);
            }
            cgAttributeModifier.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    CgModuleTaskEditor.this.taskManager_.setBusy(false);
                }
            });
            this.taskManager_.setModified(true);
            cgAttributeModifier.setLocationRelativeTo(this.securityButton_);
            ((Component)cgAttributeModifier).setVisible(true);
        }
        catch (Exception exception) {
            this.taskManager_.setBusy(false);
            exception.printStackTrace();
        }
    }

    void deleteButton__actionPerformed(ActionEvent actionEvent) {
        int n = this.tablePanel_.getSelectedRow();
        if (n < 0) {
            return;
        }
        if (n == this.tablePanel_.getRowCount() - 1) {
            this.tablePanel_.deleteRow(n);
            this.tablePanel_.getTable().newCreatingRow();
            if (this.tablePanel_.getRowCount() > 1) {
                this.tablePanel_.getTable().setRowSelectionInterval(n - 1, n - 1);
            }
        } else {
            if (!CgUtility.confirmDelete(this, CgUtility.getI18nMsg("standard.askDeleteEntry"))) {
                return;
            }
            this.tablePanel_.deleteRow(n);
            this.taskManager_.setModified(true);
        }
        this.tablePanel_.setRowSelectionInterval(n, n);
    }

    private void setActions(int n, SMTaskOperationData[] sMTaskOperationDataArray) {
        CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 1);
        String string = (String)cgData.getUserData();
        this.setActions(string, sMTaskOperationDataArray);
    }

    private void setActions(String string, SMTaskOperationData[] sMTaskOperationDataArray) {
        int n = 0;
        while (n < sMTaskOperationDataArray.length) {
            try {
                sMTaskOperationDataArray[n].setOperation(string);
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
            ++n;
        }
    }

    private void moduleChanged(ActionEvent actionEvent) {
        int n = this.tablePanel_.getSelectedRow();
        if (!this.editing_ || n < 0 || n > this.tablePanel_.getRowCount() - 1 || actionEvent == null) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        CgData cgData = (CgData)jComboBox.getSelectedItem();
        if (cgData == null) {
            return;
        }
        this.selectAction_.setEnabled(true);
        this.loadButton_.setEnabled(false);
        this.scheduleButton_.setEnabled(false);
        this.securityButton_.setEnabled(false);
        Module module = (Module)cgData.getUserData();
        if (module.isMultiInstance()) {
            String string = CgUtility.getInstanceName((JFrame)this.taskManager_);
            if (string == null) {
                this.tablePanel_.resetWorkingCell();
                return;
            }
            module = new Module(string, module.getModuleInfo());
        }
        this.tablePanel_.setValueAt(new CgData(module.toString(), null, module), n, 0);
        this.tablePanel_.setValueAt(new CgData(""), n, 1);
        this.tablePanel_.setValueAt(new CgData(""), n, 2);
        this.tablePanel_.setValueAt(new CgData(""), n, 3);
        this.taskManager_.setModified(true);
    }

    private void actionChanged(ActionEvent actionEvent) {
        Object object;
        int n = this.tablePanel_.getSelectedRow();
        if (!this.editing_ || n < 0 || n > this.tablePanel_.getRowCount() - 1 || actionEvent == null) {
            return;
        }
        CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 0);
        if (cgData == null) {
            this.tablePanel_.resetWorkingRow();
            return;
        }
        Module module = (Module)cgData.getUserData();
        if (module == null) {
            return;
        }
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        CgData cgData2 = (CgData)jComboBox.getSelectedItem();
        if (cgData2 == null) {
            return;
        }
        String string = (String)cgData2.getUserData();
        if (string == null) {
            return;
        }
        module.cleanup();
        if (this.isModuleAction(string)) {
            object = new SMTaskOperationData();
            try {
                if (string.equals(LOAD)) {
                    object.setOperation(LOAD);
                    object.setOperand(module.getOperand());
                    object.setUserData(null);
                    module.setLoadOperationData((SMTaskOperationData)object);
                    if (module.isMultiInstance()) {
                        this.loadButton__actionPerformed(null);
                    }
                } else if (string.equals(ENABLE)) {
                    object.setOperation(ENABLE);
                    object.setOperand(module.getOperand());
                    module.setEnableOperationData((SMTaskOperationData)object);
                } else {
                    object.setOperation(string);
                    object.setOperand(module.getOperand());
                    module.setOperation((SMTaskOperationData)object);
                }
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
        }
        this.tablePanel_.setValueAt(cgData2, n, 1);
        if (string.equals(NONE) || string.equals(DISABLE) || string.equals(UNLOAD)) {
            this.tablePanel_.setValueAt(NOTAPPLICABLE, n, 2);
        } else {
            this.tablePanel_.setValueAt(NOTSCHEDULED, n, 2);
        }
        if (string.equals(DISABLE) || string.equals(UNLOAD) || string.equals(ENABLE)) {
            this.tablePanel_.setValueAt(NOTAPPLICABLE, n, 3);
        } else {
            this.tablePanel_.setValueAt(NO_DATA, n, 3);
        }
        if (this.tablePanel_.getRowCount() == n + 1) {
            object = new Vector();
            ((Vector)object).add(new CgData(""));
            ((Vector)object).add(new CgData(""));
            ((Vector)object).add(new CgData(""));
            ((Vector)object).add(new CgData(""));
            this.tablePanel_.getTable().insertRow((Vector)object, this.tablePanel_.getRowCount());
            this.tablePanel_.setRowSelectionInterval(n, n);
        }
        this.taskManager_.setModified(true);
        this.enableButtons(n);
    }

    private void tableRowSelected(CgTblSelectEvent cgTblSelectEvent) {
        Object object;
        this.editing_ = false;
        int n = this.tablePanel_.getSelectedRow();
        int n2 = this.tablePanel_.getRowCount();
        this.selectModule_.setEnabled(true);
        this.enableButtons(n);
        if (n >= 0 && n == n2 - 1) {
            this.tablePanel_.setValueAt(new CgData(""), n, 0);
            this.selectModule_.setSelectedIndex(-1);
            this.selectAction_.setEnabled(false);
            this.editing_ = true;
            return;
        }
        CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 0);
        if (cgData == null) {
            this.editing_ = true;
            return;
        }
        Module module = (Module)cgData.getUserData();
        int n3 = 0;
        while (n3 < this.selectModule_.getItemCount()) {
            object = (Module)((CgData)this.selectModule_.getItemAt(n3)).getUserData();
            if (module.getModuleName().equals(((Module)object).getModuleName())) {
                this.selectModule_.setSelectedIndex(n3);
                break;
            }
            ++n3;
        }
        object = (String)((CgData)this.tablePanel_.getValueAt(n, 1)).getUserData();
        if (object == null) {
            this.selectAction_.setSelectedIndex(-1);
        } else if (((String)object).equals(NONE)) {
            this.selectAction_.setSelectedIndex(0);
        } else if (((String)object).equals(LOAD)) {
            this.selectAction_.setSelectedIndex(1);
        } else if (((String)object).equals(ENABLE)) {
            this.selectAction_.setSelectedIndex(2);
        } else if (((String)object).equals(DISABLE)) {
            this.selectAction_.setSelectedIndex(3);
        } else if (((String)object).equals(UNLOAD)) {
            this.selectAction_.setSelectedIndex(4);
        } else {
            this.selectAction_.setSelectedIndex(-1);
        }
        this.selectAction_.setEnabled(this.tablePanel_.getValueAt(n, 0) != null);
        this.tablePanel_.resetWorkingRow();
        this.editing_ = true;
    }

    private void enableButtons(int n) {
        if (n == this.tablePanel_.getRowCount() - 1) {
            this.loadButton_.setEnabled(false);
            this.scheduleButton_.setEnabled(false);
            this.securityButton_.setEnabled(false);
            this.deleteButton_.setEnabled(false);
            return;
        }
        CgData cgData = (CgData)this.tablePanel_.getValueAt(n, 1);
        if (cgData != null && cgData.getUserData() != null && cgData.getUserData().equals(LOAD)) {
            this.loadButton_.setEnabled(true);
            this.scheduleButton_.setEnabled(true);
            this.securityButton_.setEnabled(true);
        } else if (cgData != null && cgData.getUserData() != null && cgData.getUserData().equals(ENABLE)) {
            this.loadButton_.setEnabled(false);
            this.scheduleButton_.setEnabled(true);
            this.securityButton_.setEnabled(false);
        } else if (cgData != null && cgData.getUserData() != null && cgData.getUserData().equals(NONE)) {
            this.loadButton_.setEnabled(false);
            this.scheduleButton_.setEnabled(false);
            this.securityButton_.setEnabled(true);
        } else {
            this.loadButton_.setEnabled(false);
            this.scheduleButton_.setEnabled(false);
            this.securityButton_.setEnabled(false);
        }
        this.deleteButton_.setEnabled(true);
    }

    private void disableButtons() {
        this.loadButton_.setEnabled(false);
        this.scheduleButton_.setEnabled(false);
        this.securityButton_.setEnabled(false);
        this.deleteButton_.setEnabled(false);
    }

    private SMTaskOperationData setToEnable(SMTaskOperationData sMTaskOperationData) {
        SMTaskOperationData sMTaskOperationData2 = new SMTaskOperationData();
        if (!sMTaskOperationData.getUserData().equals("Schedule#$#activetimewindow")) {
            return sMTaskOperationData;
        }
        try {
            String string = sMTaskOperationData.getValue();
            if (string.indexOf("activetimewindow") < 0) {
                return sMTaskOperationData;
            }
            sMTaskOperationData2.setOperation(ENABLE);
            String string2 = sMTaskOperationData.getOperand();
            string2 = string2.substring(5);
            sMTaskOperationData2.setOperand(string2.substring(0, string2.indexOf("?getset")));
            string = string.substring(string.indexOf("{") + 1);
            string = string.substring(string.indexOf("{") + 1);
            string = string.substring(0, string.indexOf("}"));
            sMTaskOperationData2.setUserData("enabletimewindow = \"" + string + "\"");
            sMTaskOperationData2.setValueType("");
            sMTaskOperationData2.setValue("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sMTaskOperationData2;
    }

    class ModuleRenderer
    extends DefaultTableCellRenderer {
        ModuleRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            int n3 = CgModuleTaskEditor.this.tablePanel_.getSelectedRow();
            if (object instanceof CgData) {
                this.setText(((CgData)object).getLabel());
                if (this.getText().equals("")) {
                    this.setForeground(Color.blue);
                } else {
                    this.setForeground(Color.black);
                }
            }
            if (n == n3) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            return this;
        }
    }

    class Module {
        private SMModuleInfo minfo_;
        private String instance_;
        private SMTaskOperationData[] securityData_ = null;
        private SMTaskOperationData loadOperationData_ = null;
        private SMTaskOperationData enableOperationData_ = null;
        private SMTaskOperationData enableScheduleOperationData_ = null;
        private Vector otherOperationData_ = new Vector();

        public Module(SMModuleInfo sMModuleInfo) {
            this.minfo_ = sMModuleInfo;
        }

        public Module(SMModuleInfo sMModuleInfo, String string) {
            this.minfo_ = sMModuleInfo;
            int n = string.indexOf("+");
            if (n > 0) {
                this.instance_ = string.substring(n + 1);
            }
        }

        public Module(String string, SMModuleInfo sMModuleInfo) {
            this.instance_ = string;
            this.minfo_ = sMModuleInfo;
        }

        public String getModuleId() {
            return this.minfo_.getModuleId();
        }

        public SMModuleInfo getModuleInfo() {
            return this.minfo_;
        }

        public boolean isMultiInstance() {
            return this.minfo_.isMultiInstance();
        }

        public String getOperand() {
            if (this.instance_ == null) {
                return this.minfo_.getModule();
            }
            return this.minfo_.getModule() + ":" + this.instance_;
        }

        public String getTargetUrl() {
            if (this.instance_ == null) {
                return "mod/" + this.minfo_.getModule();
            }
            return "mod/" + this.minfo_.getModule() + "+" + this.instance_;
        }

        public String toString() {
            if (this.instance_ == null) {
                return this.minfo_.toString();
            }
            return this.minfo_.toString() + " [" + this.instance_ + "]";
        }

        public String getModuleName() {
            return this.minfo_.getModuleName();
        }

        public String getInstanceName() {
            return this.instance_;
        }

        public String getModule() {
            return this.minfo_.getModule();
        }

        public String getModuleVersion() {
            return this.minfo_.getModuleVersion();
        }

        public void setSecurityOperationData(SMTaskOperationData[] sMTaskOperationDataArray) {
            this.securityData_ = sMTaskOperationDataArray;
        }

        public void setSecurityOperationData(SMTaskOperationData sMTaskOperationData) {
            int n = 0;
            if (this.securityData_ != null) {
                n = this.securityData_.length;
            }
            SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[n + 1];
            int n2 = 0;
            while (n2 < n) {
                sMTaskOperationDataArray[n2] = this.securityData_[n2];
                ++n2;
            }
            sMTaskOperationDataArray[n] = sMTaskOperationData;
            this.securityData_ = sMTaskOperationDataArray;
        }

        public SMTaskOperationData[] getSecurityOperationData() {
            return this.securityData_;
        }

        public void setOperation(SMTaskOperationData sMTaskOperationData) {
            this.otherOperationData_.add(sMTaskOperationData);
        }

        public SMTaskOperationData[] getOperations() {
            if (this.otherOperationData_.size() == 0) {
                return null;
            }
            Object[] objectArray = new SMTaskOperationData[this.otherOperationData_.size()];
            this.otherOperationData_.copyInto(objectArray);
            return objectArray;
        }

        public SMTaskOperationData getLoadOperationData() {
            return this.loadOperationData_;
        }

        public void setLoadOperationData(SMTaskOperationData sMTaskOperationData) {
            this.loadOperationData_ = sMTaskOperationData;
        }

        public SMTaskOperationData getEnableOperationData() {
            if (this.enableOperationData_ != null) {
                return this.enableOperationData_;
            }
            return this.enableScheduleOperationData_;
        }

        public void setEnableOperationData(SMTaskOperationData sMTaskOperationData) {
            if (sMTaskOperationData.getOperation().equals(CgModuleTaskEditor.ENABLE)) {
                this.enableOperationData_ = sMTaskOperationData;
                this.enableScheduleOperationData_ = null;
            } else {
                this.enableScheduleOperationData_ = sMTaskOperationData;
                this.enableOperationData_ = null;
            }
        }

        public void cleanup() {
            this.securityData_ = null;
            this.loadOperationData_ = null;
            this.enableOperationData_ = null;
            this.enableScheduleOperationData_ = null;
            this.otherOperationData_ = new Vector();
        }
    }
}

