/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.bootstrap.BsRMIClassLoader;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.task.SMTaskRequestLog;
import com.sun.symon.base.client.task.SMTaskRequestLogData;
import com.sun.symon.base.client.task.SMTaskRequestLogDetail;
import com.sun.symon.base.client.task.SMTaskRequestLogEvent;
import com.sun.symon.base.client.task.SMTaskRequestLogFactory;
import com.sun.symon.base.client.task.SMTaskRequestLogInfo;
import com.sun.symon.base.client.task.SMTaskRequestLogListener;
import com.sun.symon.base.client.task.SMTaskRequestLogManager;
import com.sun.symon.base.client.task.SMTaskRequestLogOperation;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgGenericLogFactory;
import com.sun.symon.base.console.grouping.aggregate.CgLogManager;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class CgLogParser
implements SMTaskRequestLogListener {
    private int taskType = -1;
    private SMTaskRequestLogManager manager_;
    private SMTaskRequestLog handle_;
    private SMTaskRequestLogInfo info_;
    private SMTaskType taskTypeHandle_;
    private int focusRow_ = -1;
    private int focusColumn_ = -1;
    private SMDBObjectID taskRequestID_;
    private boolean createdHandle_ = false;
    private boolean registeredListeners_ = false;
    private boolean ignoreUpdates_ = false;
    private String taskRequestName_;
    private SMTaskRequestLogData data_;
    private SMTaskRequestLogFactory factory_;
    private Vector agents_;
    private Hashtable taskReqLogInfo_ = new Hashtable();
    private Hashtable groupInfo_ = new Hashtable();
    private Hashtable taskInfo_ = new Hashtable();

    public CgLogParser(SMTaskRequestLog sMTaskRequestLog, SMTaskRequestLogInfo sMTaskRequestLogInfo, SMTaskRequestLogManager sMTaskRequestLogManager) {
        this.handle_ = sMTaskRequestLog;
        this.manager_ = sMTaskRequestLogManager;
        this.info_ = sMTaskRequestLogInfo;
        this.loadData(this.info_);
    }

    public CgLogParser(String string) {
        this.taskRequestName_ = string;
        this.loadData(this.taskRequestName_);
    }

    private void loadData(final SMTaskRequestLogInfo sMTaskRequestLogInfo) {
        this.ignoreUpdates_ = true;
        if (CgLogManager.isTesting()) {
            this.makeDemoData(sMTaskRequestLogInfo);
            return;
        }
        try {
            if (this.handle_ == null) {
                this.handle_ = new SMTaskRequestLog(SMConsoleContext.getInstance().getAPIHandle());
                this.createdHandle_ = true;
            }
        }
        catch (SMAPIException sMAPIException) {
            CgLogManager.showError("log.unableToGetService");
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                try {
                    CgLogParser.this.data_ = CgLogParser.this.handle_.load(sMTaskRequestLogInfo.getObjectID());
                }
                catch (SMAPIException sMAPIException) {
                    CgLogManager.showError("log.unableToGetLog");
                    sMAPIException.printStackTrace();
                    return;
                }
                CgLogParser.this.parseXML(CgLogParser.this.data_.getXML());
            }
        };
        thread.start();
    }

    private void loadData(final String string) {
        if (CgLogManager.isTesting()) {
            this.makeDemoData(null);
            return;
        }
        try {
            if (this.handle_ == null) {
                this.handle_ = new SMTaskRequestLog(SMConsoleContext.getInstance().getAPIHandle());
                this.createdHandle_ = true;
            }
        }
        catch (SMAPIException sMAPIException) {
            CgLogManager.showError("log.unableToGetService");
            return;
        }
        final CgLogParser cgLogParser = this;
        Thread thread = new Thread(){

            public void run() {
                try {
                    CgLogParser.this.data_ = CgLogParser.this.handle_.load(string);
                    if (CgLogParser.this.data_.getStatus() == 4) {
                        CgLogParser.this.handle_.addLogChangeListener(cgLogParser);
                        CgLogParser.this.registeredListeners_ = true;
                    }
                }
                catch (SMAPIException sMAPIException) {
                    sMAPIException.printStackTrace();
                    CgLogManager.showError("log.unableToGetRetrieveLog");
                    return;
                }
                CgLogParser.this.parseXML(CgLogParser.this.data_.getXML());
            }
        };
        thread.start();
    }

    private void makeDemoData(SMTaskRequestLogInfo sMTaskRequestLogInfo) {
        SMTaskRequestLogDetail sMTaskRequestLogDetail;
        SMTaskRequestLogOperation sMTaskRequestLogOperation;
        this.taskReqLogInfo_.put("startTime", "991843421");
        this.taskReqLogInfo_.put("stopTime", "991843621");
        this.taskReqLogInfo_.put("timeZone", "PST");
        this.taskReqLogInfo_.put("user", "tony");
        this.taskReqLogInfo_.put("state", "OK");
        this.taskReqLogInfo_.put("name", "tester");
        this.taskReqLogInfo_.put("description", " This is a testing dummy data");
        this.taskReqLogInfo_.put("message", "message");
        this.taskReqLogInfo_.put("file", "/var/opt/SUNWsymon/log/taskreq");
        this.groupInfo_.put("name", "testing group");
        this.groupInfo_.put("description", "Testing Group");
        this.groupInfo_.put("domain", "Default Domain");
        this.taskInfo_.put("size", "2");
        this.taskInfo_.put("typeID", "0");
        this.taskInfo_.put("typeName", "com.sun.symon.base.console.grouping.GroupingMessages:TaskType.dataLabel:");
        this.taskInfo_.put("name", "My Test Task");
        this.taskInfo_.put("description", "This task is just to test the funciton");
        SMTaskRequestLogDetail sMTaskRequestLogDetail2 = new SMTaskRequestLogDetail("osftqas7", "1161");
        SMTaskRequestLogDetail sMTaskRequestLogDetail3 = new SMTaskRequestLogDetail("osftserv02", "1161");
        SMTaskRequestLogDetail sMTaskRequestLogDetail4 = new SMTaskRequestLogDetail("yang", "161");
        SMTaskRequestLogDetail[] sMTaskRequestLogDetailArray = new SMTaskRequestLogDetail[]{sMTaskRequestLogDetail2, sMTaskRequestLogDetail3, sMTaskRequestLogDetail4};
        int n = 0;
        while (n < sMTaskRequestLogDetailArray.length) {
            sMTaskRequestLogOperation = new SMTaskRequestLogOperation("0", "set", "/mod/kernel-reader-simple:load/avg_1min?getset#0", "{refreshinterval 222}", "StString", "userData", "true");
            sMTaskRequestLogDetail = sMTaskRequestLogDetailArray[n];
            sMTaskRequestLogDetail.addOperation(sMTaskRequestLogOperation);
            ++n;
        }
        sMTaskRequestLogOperation = new Hashtable();
        sMTaskRequestLogOperation.put("host", "osftqas7");
        sMTaskRequestLogOperation.put("port", "1161");
        sMTaskRequestLogOperation.put("index", "0");
        sMTaskRequestLogOperation.put("startTime", "99184321");
        sMTaskRequestLogOperation.put("stopTime", "99184331");
        sMTaskRequestLogOperation.put("status", "OK");
        sMTaskRequestLogDetail = (SMTaskRequestLogOperation)sMTaskRequestLogDetail2.getOperations().get(0);
        sMTaskRequestLogDetail.setResult((Hashtable)sMTaskRequestLogOperation);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("host", "osftserv02");
        hashtable.put("port", "1161");
        hashtable.put("index", "0");
        hashtable.put("startTime", "99184321");
        hashtable.put("stopTime", "99184331");
        hashtable.put("status", "failure");
        SMTaskRequestLogOperation sMTaskRequestLogOperation2 = (SMTaskRequestLogOperation)sMTaskRequestLogDetail3.getOperations().get(0);
        sMTaskRequestLogOperation2.setResult(hashtable);
        String string = (String)this.taskInfo_.get("typeID");
        this.factory_ = this.factory(string);
        if (this.factory_ == null) {
            this.factory_ = new CgGenericLogFactory();
            this.factory_.setManager(this.manager_);
        }
        this.factory_.setData(sMTaskRequestLogDetailArray);
        Runnable runnable = new Runnable(){

            public void run() {
                CgLogParser.this.manager_.showTaskInfo(CgLogParser.this.getTaskType(), CgLogParser.this.getTaskDescription());
                CgLogParser.this.manager_.showSummary(CgLogParser.this.getDuration(), CgLogParser.this.getUser(), CgLogParser.this.getLogFileName());
                CgLogParser.this.manager_.showStatusComponent(CgLogParser.this.factory_.getComponent());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void changed(SMTaskRequestLogEvent[] sMTaskRequestLogEventArray) {
        if (this.ignoreUpdates_) {
            return;
        }
        int n = 0;
        while (n < sMTaskRequestLogEventArray.length) {
            if (sMTaskRequestLogEventArray[n].getType() == 1 && sMTaskRequestLogEventArray[n].getStatus() != 4 && sMTaskRequestLogEventArray[n].getStatus() != 0 && sMTaskRequestLogEventArray[n].getTaskRequestName().equals(this.taskRequestName_)) {
                this.ignoreUpdates_ = true;
                this.loadData(this.taskRequestName_);
                return;
            }
            if (sMTaskRequestLogEventArray[n].getType() == 1 && sMTaskRequestLogEventArray[n].getTaskRequestName().equals(this.taskRequestName_)) {
                this.updateScreenByRequest(sMTaskRequestLogEventArray[n]);
            } else if (sMTaskRequestLogEventArray[n].getType() == 2 && sMTaskRequestLogEventArray[n].getTaskRequestName().equals(this.taskRequestName_)) {
                this.factory_.updateScreenByOperation(sMTaskRequestLogEventArray[n]);
                return;
            }
            ++n;
        }
    }

    private SMTaskRequestLogFactory factory(String string) {
        SMTaskRequestLogFactory sMTaskRequestLogFactory;
        SMTaskType[] sMTaskTypeArray = CgUtility.getTaskTypes(null);
        int n = 0;
        while (n < sMTaskTypeArray.length) {
            if (string.equals(sMTaskTypeArray[n].getTaskTypeString())) {
                this.taskTypeHandle_ = sMTaskTypeArray[n];
                break;
            }
            ++n;
        }
        if (this.taskTypeHandle_ == null) {
            return null;
        }
        String string2 = this.taskTypeHandle_.getConsoleLogClassName();
        try {
            BsRMIClassLoader bsRMIClassLoader = BsRMIClassLoader.getClassLoader((RMIClientLevel1)SMConsoleContext.getInstance().getAPIHandle().getHandle());
            Class clazz = bsRMIClassLoader.loadClass(string2, true);
            sMTaskRequestLogFactory = (SMTaskRequestLogFactory)clazz.newInstance();
            sMTaskRequestLogFactory.setManager(this.manager_);
        }
        catch (Exception exception) {
            return null;
        }
        return sMTaskRequestLogFactory;
    }

    private void parseXML(String string) {
        try {
            new GroupLogParser(string);
        }
        catch (SAXException sAXException) {
            CgLogManager.showError("log.invalidLogData");
            sAXException.printStackTrace();
            return;
        }
        catch (Exception exception) {
            CgLogManager.showError("log.logParseFailed");
            exception.printStackTrace();
            return;
        }
    }

    private String getDuration() {
        TimeZone timeZone = TimeZone.getTimeZone((String)this.taskReqLogInfo_.get("timeZone"));
        String string = (String)this.taskReqLogInfo_.get("startTime");
        String string2 = (String)this.taskReqLogInfo_.get("stopTime");
        float f = Long.valueOf(string2) - Long.valueOf(string);
        String string3 = CgUtility.formatDuration(f);
        return string3;
    }

    private String getUser() {
        return (String)this.taskReqLogInfo_.get("user");
    }

    private String getLogFileName() {
        return (String)this.taskReqLogInfo_.get("file");
    }

    private String getTaskType() {
        if (this.taskTypeHandle_ == null) {
            return "Unidentifiable task type";
        }
        return this.taskTypeHandle_.toString();
    }

    private String getTaskDescription() {
        return (String)this.taskInfo_.get("description");
    }

    private void updateScreenByRequest(SMTaskRequestLogEvent sMTaskRequestLogEvent) {
        String string = String.valueOf(sMTaskRequestLogEvent.getStartTime());
        String string2 = String.valueOf(sMTaskRequestLogEvent.getStopTime());
        String string3 = sMTaskRequestLogEvent.getTimeZone().getID();
        this.taskReqLogInfo_.put("startTime", string);
        this.taskReqLogInfo_.put("stopTime", string2);
        this.taskReqLogInfo_.put("timZone", string3);
        this.manager_.showSummary(this.getDuration(), this.getUser(), this.getLogFileName());
    }

    public void cleanup() {
        try {
            this.handle_.removeLogChangeListener((SMTaskRequestLogListener)this);
            if (this.factory_ != null) {
                this.factory_.cleanup();
            }
        }
        catch (SMAPIException sMAPIException) {
            System.err.println((Object)sMAPIException);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        MyErrorHandler(PrintStream printStream) {
            this.out = printStream;
        }

        private String getParseExceptionInfo(SAXParseException sAXParseException) {
            String string = sAXParseException.getSystemId();
            if (string == null) {
                string = "null";
            }
            String string2 = "URI=" + string + " Line=" + sAXParseException.getLineNumber() + ": " + sAXParseException.getMessage();
            return string2;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(sAXParseException));
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + this.getParseExceptionInfo(sAXParseException);
            throw new SAXException(string);
        }
    }

    private class GroupLogParser
    extends DefaultHandler {
        String xmlStr;
        InputSource xmlInputSource;
        XMLReader xmlReader = null;
        String dtd;

        public GroupLogParser(String string) throws SAXException, Exception {
            CgLogParser.this.agents_ = new Vector();
            if (string == null || string.equals("")) {
                return;
            }
            this.xmlStr = string.trim();
            StringReader stringReader = new StringReader(this.xmlStr);
            this.xmlInputSource = new InputSource(stringReader);
            try {
                this.dtd = CgLogParser.this.handle_.getDTD();
            }
            catch (SMAPIException sMAPIException) {
                sMAPIException.printStackTrace();
                return;
            }
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            this.xmlReader = sAXParser.getXMLReader();
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(new MyErrorHandler(System.err));
            this.xmlReader.setEntityResolver(new MyResolver(this.dtd));
            this.xmlReader.parse(this.xmlInputSource);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5;
            Object object;
            int n;
            int n2 = attributes.getLength();
            if (string3.equals("taskRequestLog")) {
                n = 0;
                while (n < n2) {
                    object = attributes.getQName(n);
                    String string6 = attributes.getValue(n);
                    CgLogParser.this.taskReqLogInfo_.put(object, string6);
                    ++n;
                }
            }
            if (string3.equals("group")) {
                n = 0;
                while (n < attributes.getLength()) {
                    CgLogParser.this.groupInfo_.put(attributes.getQName(n), attributes.getValue(n));
                    ++n;
                }
            }
            if (string3.equals("task")) {
                n = 0;
                while (n < attributes.getLength()) {
                    CgLogParser.this.taskInfo_.put(attributes.getQName(n), attributes.getValue(n));
                    ++n;
                }
            }
            if (string3.equals("agent")) {
                SMTaskRequestLogDetail sMTaskRequestLogDetail = new SMTaskRequestLogDetail(attributes.getValue(0), attributes.getValue(1));
                CgLogParser.this.agents_.add(sMTaskRequestLogDetail);
            }
            if (string3.equals("operation")) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                int n3 = 0;
                while (n3 < n2) {
                    hashtable.put(attributes.getQName(n3), attributes.getValue(n3));
                    ++n3;
                }
                int n4 = 0;
                while (n4 < CgLogParser.this.agents_.size()) {
                    string5 = new SMTaskRequestLogOperation((String)hashtable.get("index"), (String)hashtable.get("command"), (String)hashtable.get("operand"), (String)hashtable.get("value"), (String)hashtable.get("valueType"), (String)hashtable.get("userData"), (String)hashtable.get("async"));
                    string4 = (SMTaskRequestLogDetail)CgLogParser.this.agents_.get(n4);
                    string4.addOperation((SMTaskRequestLogOperation)string5);
                    ++n4;
                }
            }
            if (string3.equals("results")) {
                // empty if block
            }
            if (string3.equals("result")) {
                SMTaskRequestLogDetail sMTaskRequestLogDetail = null;
                object = new Hashtable();
                int n5 = 0;
                while (n5 < n2) {
                    ((Hashtable)object).put(attributes.getQName(n5), attributes.getValue(n5));
                    ++n5;
                }
                string5 = (String)((Hashtable)object).get("host");
                string4 = (String)((Hashtable)object).get("port");
                if (string5 == null || CgLogParser.this.agents_.isEmpty()) {
                    return;
                }
                int n6 = 0;
                while (n6 < CgLogParser.this.agents_.size()) {
                    sMTaskRequestLogDetail = (SMTaskRequestLogDetail)CgLogParser.this.agents_.get(n6);
                    if (string5.equals(sMTaskRequestLogDetail.getName()) && string4.equals(sMTaskRequestLogDetail.getPort())) break;
                    ++n6;
                }
                if (sMTaskRequestLogDetail == null) {
                    return;
                }
                String string7 = (String)((Hashtable)object).get("index");
                if (string7 == null) {
                    return;
                }
                Vector vector = sMTaskRequestLogDetail.getOperations();
                SMTaskRequestLogOperation sMTaskRequestLogOperation = null;
                int n7 = 0;
                while (n7 < vector.size()) {
                    sMTaskRequestLogOperation = (SMTaskRequestLogOperation)vector.get(n7);
                    if (sMTaskRequestLogOperation.getIndex().equals(string7)) break;
                    ++n7;
                }
                if (sMTaskRequestLogOperation == null) {
                    return;
                }
                sMTaskRequestLogOperation.setResult((Hashtable)object);
            }
        }

        public void endDocument() throws SAXException {
            String string = (String)CgLogParser.this.taskInfo_.get("typeID");
            CgLogParser.this.factory_ = CgLogParser.this.factory(string);
            if (CgLogParser.this.factory_ == null) {
                CgLogParser.this.factory_ = new CgGenericLogFactory();
                CgLogParser.this.factory_.setManager(CgLogParser.this.manager_);
            }
            SMTaskRequestLogDetail[] sMTaskRequestLogDetailArray = new SMTaskRequestLogDetail[CgLogParser.this.agents_.size()];
            int n = 0;
            while (n < CgLogParser.this.agents_.size()) {
                sMTaskRequestLogDetailArray[n] = (SMTaskRequestLogDetail)CgLogParser.this.agents_.get(n);
                ++n;
            }
            if (sMTaskRequestLogDetailArray.length > 0) {
                CgLogParser.this.factory_.setData(sMTaskRequestLogDetailArray);
            }
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ GroupLogParser this$1;
                {
                    this.this$1 = groupLogParser;
                }

                public void run() {
                    CgLogParser.access$600(GroupLogParser.access$1600(this.this$1)).showTaskInfo(CgLogParser.access$400(GroupLogParser.access$1600(this.this$1)), CgLogParser.access$500(GroupLogParser.access$1600(this.this$1)));
                    CgLogParser.access$600(GroupLogParser.access$1600(this.this$1)).showSummary(CgLogParser.access$700(GroupLogParser.access$1600(this.this$1)), CgLogParser.access$800(GroupLogParser.access$1600(this.this$1)), CgLogParser.access$900(GroupLogParser.access$1600(this.this$1)));
                    CgLogParser.access$600(GroupLogParser.access$1600(this.this$1)).showStatusComponent(CgLogParser.access$1000(GroupLogParser.access$1600(this.this$1)).getComponent());
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        static /* synthetic */ CgLogParser access$1600(GroupLogParser groupLogParser) {
            return groupLogParser.CgLogParser.this;
        }

        private class MyResolver
        implements EntityResolver {
            String dtdContent;

            public MyResolver(String string) {
                this.dtdContent = string;
            }

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                StringReader stringReader = new StringReader(this.dtdContent);
                InputSource inputSource = new InputSource(stringReader);
                return inputSource;
            }
        }
    }
}

