/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.table.SMTableColumnFormat;
import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.client.table.SMTableResponse;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.topology.SMHierarchyResponse;
import com.sun.symon.base.client.topology.SMHierarchyViewData;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.didgets.CdPropValueEditorPane;
import com.sun.symon.base.console.grouping.aggregate.CgHierarchyData;
import com.sun.symon.base.console.grouping.aggregate.CgHierarchyModel;
import com.sun.symon.base.console.grouping.aggregate.CgHierarchyRenderer;
import com.sun.symon.base.console.grouping.aggregate.CgHierarchyTree;
import com.sun.symon.base.console.grouping.aggregate.CgTableInfo;
import com.sun.symon.base.console.grouping.aggregate.CgTableRequest;
import com.sun.symon.base.console.grouping.aggregate.CgTaskUtility;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcURL;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class CgHierarchyController
extends JPanel
implements SMHierarchyResponse,
SMTableResponse {
    private CgHierarchyTree oTree_;
    private CgHierarchyModel oModel_;
    private SMRawDataRequest oRawReq_;
    private SMManagedEntityRequest oMgtReq_;
    private SMModuleRequest oModReq_;
    private SMTableRequest oTableReq_;
    private SMTopologyRequest oTopReq_;
    private Object oResponseHandle_ = null;
    private int iDepth_;
    private Vector vTreeSelectionListeners_ = new Vector();
    private CgHierarchyData oTableParent_;
    private CgHierarchyData oChildParent_;
    private CgTableRequest requester_;
    private boolean tableChooser_ = false;
    private boolean categoryComplete_ = false;
    private boolean moduleComplete_ = false;
    private boolean managedObjectComplete_ = false;
    private boolean managedTableComplete_ = false;
    private static String DUMMY_MODULE_INSTANCE = "dummy";
    private Vector tableInfoVector_ = new Vector();

    public CgHierarchyController(SMRawDataRequest sMRawDataRequest) {
        this(sMRawDataRequest, 5);
        this.oModReq_ = new SMModuleRequest(sMRawDataRequest);
        this.oMgtReq_ = new SMManagedEntityRequest(sMRawDataRequest);
        this.oTableReq_ = new SMTableRequest(sMRawDataRequest);
        this.oTopReq_ = new SMTopologyRequest(sMRawDataRequest);
    }

    public CgHierarchyController(SMRawDataRequest sMRawDataRequest, int n) {
        this.iDepth_ = n;
        this.oModel_ = new CgHierarchyModel();
        this.oRawReq_ = sMRawDataRequest;
        this.setPreferredSize(new Dimension(312, 516));
    }

    public void activateBean() {
        String string = this.oRawReq_.getMDRBaseURL() + "sym/base/mibman/modules";
        try {
            this.oResponseHandle_ = this.oTopReq_.getHierarchyRootRequest(string, "30", false, (SMHierarchyResponse)this, null);
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("Failed to request for hierarchy root node data: " + exception));
            return;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        if (treeSelectionListener != null) {
            this.vTreeSelectionListeners_.addElement(treeSelectionListener);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        if (treeSelectionListener != null) {
            this.vTreeSelectionListeners_.removeElement(treeSelectionListener);
        }
    }

    private void expandTree(CgHierarchyData cgHierarchyData) {
        block5: {
            if (cgHierarchyData.getType() >= this.iDepth_ || cgHierarchyData.isLeaf()) {
                return;
            }
            if (cgHierarchyData.hasExpandedData()) {
                this.oModel_.fireListeners(cgHierarchyData);
                return;
            }
            try {
                cgHierarchyData.addChild(new CgHierarchyData());
                if (cgHierarchyData.getType() <= 4 && cgHierarchyData.getNavigationUrl() != null) {
                    Object object = this.oTopReq_.getHierarchyChildRequest(cgHierarchyData.getNavigationUrl(), "0", false, (SMHierarchyResponse)this, (Object)cgHierarchyData);
                    cgHierarchyData.setDataRequestHandle(object);
                }
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("Failed to request for hierarchy children node data: " + exception));
                if (exception == null) break block5;
                exception.printStackTrace();
            }
        }
    }

    public synchronized void getHierarchyRootResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData sMHierarchyViewData, Object object) {
        if (this.oModel_.getRoot() != null) {
            return;
        }
        if (sMHierarchyViewData == null) {
            return;
        }
        if (sMRequestStatus.getReturnCode() != 0) {
            return;
        }
        if (this.oResponseHandle_ != null) {
            try {
                this.oRawReq_.removeURLRequest(this.oResponseHandle_);
                this.oResponseHandle_ = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = 0 == this.iDepth_;
        CgHierarchyData cgHierarchyData = new CgHierarchyData(sMHierarchyViewData, 0, bl, null);
        try {
            this.oModel_.addChild(cgHierarchyData, null);
            if (!bl) {
                this.expandTree(cgHierarchyData);
            }
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("getHierarchyRootResponse - Failed to properly display root node: " + exception));
            return;
        }
        this.oTree_ = new CgHierarchyTree(this.oModel_);
        this.oTree_.getSelectionModel().setSelectionMode(1);
        this.oTree_.putClientProperty("JTree.lineStyle", "Angled");
        this.oTree_.setShowsRootHandles(false);
        this.oTree_.setEditable(false);
        this.oTree_.setCellRenderer(new CgHierarchyRenderer());
        this.oTree_.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                CgHierarchyData cgHierarchyData = (CgHierarchyData)treeExpansionEvent.getPath().getLastPathComponent();
                CgHierarchyController.this.expandTree(cgHierarchyData);
                CgHierarchyController.this.oTree_.scrollPathToVisible(treeExpansionEvent.getPath());
            }
        });
        this.oTree_.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                int n = CgHierarchyController.this.vTreeSelectionListeners_.size();
                int n2 = 0;
                while (n2 < n) {
                    TreeSelectionListener treeSelectionListener = (TreeSelectionListener)CgHierarchyController.this.vTreeSelectionListeners_.elementAt(n2);
                    treeSelectionListener.valueChanged(treeSelectionEvent);
                    CgHierarchyController.this.oTree_.scrollPathToVisible(treeSelectionEvent.getPath());
                    ++n2;
                }
            }
        });
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.oTree_);
        this.add((Component)jScrollPane, "Center");
        this.oTree_.requestFocus();
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.validate();
        }
    }

    public synchronized void getHierarchyChildResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData[] sMHierarchyViewDataArray, Object object) {
        final SMRequestStatus sMRequestStatus2 = sMRequestStatus;
        final SMHierarchyViewData[] sMHierarchyViewDataArray2 = sMHierarchyViewDataArray;
        final Object object2 = object;
        Thread thread = new Thread(){

            public void run() {
                CgHierarchyController.this.doHierarchyChildResponse(sMRequestStatus2, sMHierarchyViewDataArray2, object2);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CgHierarchyData cgHierarchyData = CgHierarchyController.access$400(3.access$300(this.this$1));
                        CgHierarchyModel cgHierarchyModel = CgHierarchyController.access$500(3.access$300(this.this$1));
                        cgHierarchyModel.fireListeners(cgHierarchyData);
                    }
                });
            }

            static /* synthetic */ CgHierarchyController access$300(3 var0) {
                return var0.CgHierarchyController.this;
            }
        };
        thread.start();
    }

    public void doHierarchyChildResponse(SMRequestStatus sMRequestStatus, SMHierarchyViewData[] sMHierarchyViewDataArray, Object object) {
        CgHierarchyData cgHierarchyData = (CgHierarchyData)object;
        if (sMRequestStatus.getReturnCode() != 0) {
            return;
        }
        int n = -1;
        switch (cgHierarchyData.getType()) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = sMHierarchyViewDataArray.length > 0 ? 4 : 3;
            }
        }
        Object object2 = cgHierarchyData.getDataRequestHandle();
        if (object2 != null) {
            try {
                this.oRawReq_.removeURLRequest(object2);
                cgHierarchyData.setDataRequestHandle(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        cgHierarchyData.removeChildAt(0);
        int n2 = 0;
        int n3 = sMHierarchyViewDataArray.length;
        while (n2 < n3) {
            block17: {
                try {
                    boolean bl = n == this.iDepth_;
                    CgHierarchyData cgHierarchyData2 = new CgHierarchyData(sMHierarchyViewDataArray[n2], n, bl, cgHierarchyData);
                    this.oModel_.addChild(cgHierarchyData2, cgHierarchyData, false);
                }
                catch (Exception exception) {
                    this.categoryComplete_ = true;
                    this.moduleComplete_ = true;
                    this.managedObjectComplete_ = true;
                    UcDDL.logErrorMessage((String)("getHierarchyChildResponse - Failed to properly display child node: " + exception));
                    if (exception == null) break block17;
                    exception.printStackTrace();
                }
            }
            ++n2;
        }
        this.categoryComplete_ = true;
        this.moduleComplete_ = true;
        this.managedObjectComplete_ = true;
        if (sMHierarchyViewDataArray.length == 0 && n < this.iDepth_) {
            String string = cgHierarchyData.getNavigationUrl();
            try {
                this.oTableReq_.getTableLayoutRequest(string, (SMTableResponse)this, object);
            }
            catch (Exception exception) {
                UcDDL.logErrorMessage((String)("CgHierarchyController.getHierarchyChildResponse(): " + exception));
            }
        } else {
            cgHierarchyData.setHasExpandedData(true);
            this.managedTableComplete_ = true;
        }
        this.oChildParent_ = cgHierarchyData;
    }

    public synchronized void getTableLayoutResponse(SMRequestStatus sMRequestStatus, SMTableFormat[] sMTableFormatArray, Object object) {
        final SMRequestStatus sMRequestStatus2 = sMRequestStatus;
        final SMTableFormat[] sMTableFormatArray2 = sMTableFormatArray;
        final Object object2 = object;
        Thread thread = new Thread(){

            public void run() {
                CgHierarchyController.this.doTableLayoutResponse(sMRequestStatus2, sMTableFormatArray2, object2);
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CgHierarchyData cgHierarchyData = CgHierarchyController.access$700(5.access$600(this.this$1));
                        CgHierarchyModel cgHierarchyModel = CgHierarchyController.access$500(5.access$600(this.this$1));
                        cgHierarchyModel.fireListeners(cgHierarchyData);
                    }
                });
            }

            static /* synthetic */ CgHierarchyController access$600(5 var0) {
                return var0.CgHierarchyController.this;
            }
        };
        thread.start();
    }

    public void doTableLayoutResponse(SMRequestStatus sMRequestStatus, SMTableFormat[] sMTableFormatArray, Object object) {
        Object object2;
        if (sMRequestStatus.getReturnCode() != 0) {
            return;
        }
        if (sMTableFormatArray == null || sMTableFormatArray.length == 0) {
            return;
        }
        CgHierarchyData cgHierarchyData = (CgHierarchyData)object;
        String string = UcURL.standardizeURL((String)cgHierarchyData.getTargetUrl());
        boolean bl = false;
        try {
            object2 = new UcAgentURL(cgHierarchyData.getTargetUrl());
            bl = this.oModReq_.isModuleMultiInstances(object2.getHost(), object2.getAgentPort(), object2.getModuleId());
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("CgHierarchyController.getTableLayoutRequest: Failed to request module multi-instance info - " + exception));
        }
        cgHierarchyData.setIsMultiInstanceModule(bl);
        int n = 0;
        int n2 = sMTableFormatArray.length;
        while (n < n2) {
            try {
                String[] stringArray;
                SMTableColumnFormat[] sMTableColumnFormatArray = sMTableFormatArray[n].getColumns();
                boolean bl2 = sMTableFormatArray[n].getIsScalar();
                boolean bl3 = CgTaskUtility.hasRowAction(sMTableFormatArray[n]);
                if (bl2 && sMTableFormatArray.length == 1 && cgHierarchyData.getName().equals(sMTableFormatArray[0].getTitle())) {
                    object2 = cgHierarchyData;
                } else {
                    object2 = new CgHierarchyData(sMTableFormatArray[n].getTitle(), 4, false, cgHierarchyData, string, string, false);
                    this.oModel_.addChild((CgHierarchyData)object2, cgHierarchyData);
                    cgHierarchyData.setHasExpandedData(true);
                    if (!bl2 && (stringArray = sMTableFormatArray[n].getIndexURLs()) != null && stringArray.length >= 1) {
                        ((CgHierarchyData)object2).setProperty(false, stringArray, stringArray[0], bl3, false, false);
                    }
                }
                ((CgHierarchyData)object2).setTableChooserFlag(this.tableChooser_);
                this.addToTableVector((CgHierarchyData)object2, cgHierarchyData);
                stringArray = sMTableFormatArray[n].getIndexURLs();
                int n3 = 0;
                int n4 = sMTableColumnFormatArray.length;
                while (n3 < n4) {
                    try {
                        CgHierarchyData cgHierarchyData2 = new CgHierarchyData(sMTableColumnFormatArray[n3].getColumnHeading(), 5, true, (CgHierarchyData)object2, null, sMTableColumnFormatArray[n3].getDataURL(), false);
                        cgHierarchyData2.setProperty(bl2, stringArray, sMTableColumnFormatArray[n3].getDataURL(), false, sMTableColumnFormatArray[n3].isCellEditable(), this.isIndexURL(sMTableColumnFormatArray[n3].getDataURL(), stringArray));
                        cgHierarchyData2.setRawDataType(sMTableColumnFormatArray[n3].getRawDataType());
                        cgHierarchyData2.setTableChooserFlag(this.tableChooser_);
                        this.oModel_.addChild(cgHierarchyData2, (CgHierarchyData)object2, false);
                    }
                    catch (Exception exception) {
                        this.managedTableComplete_ = true;
                        UcDDL.logErrorMessage((String)("CgHierarchyController.getTableLayoutResponse: Failed to get a table column - " + exception));
                    }
                    ++n3;
                }
                ((CgHierarchyData)object2).setHasExpandedData(true);
            }
            catch (Exception exception) {
                this.managedTableComplete_ = true;
                UcDDL.logErrorMessage((String)("CgHierarchyController.getTableLayoutResponse()::: " + exception));
            }
            ++n;
        }
        cgHierarchyData.setHasExpandedData(true);
        this.oTableParent_ = cgHierarchyData;
        this.managedTableComplete_ = true;
    }

    private boolean isIndexURL(String string, String[] stringArray) {
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void getTableFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, Object object) {
    }

    public void getTableAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
    }

    public void getTableInfo(CgTableRequest cgTableRequest) {
        this.requester_ = cgTableRequest;
        this.tableInfoVector_ = new Vector();
        this.activateBean();
        Thread thread = new Thread(){

            public void run() {
                Object object;
                while (!CgHierarchyController.this.categoryComplete_) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        UcDDL.logErrorMessage((String)("CgHierarchyController.getTableInfo Failed to get categories:" + interruptedException));
                    }
                }
                int n = CgHierarchyController.this.oModel_.getChildCount(CgHierarchyController.this.oModel_.getRoot());
                int n2 = 0;
                while (n2 < n) {
                    object = CgHierarchyController.this.oModel_.getChild(CgHierarchyController.this.oModel_.getRoot(), n2);
                    CgHierarchyData cgHierarchyData = (CgHierarchyData)object;
                    CgHierarchyController.this.moduleComplete_ = false;
                    if (cgHierarchyData != null) {
                        CgHierarchyController.this.expandTree(cgHierarchyData);
                    }
                    while (!CgHierarchyController.this.moduleComplete_) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            UcDDL.logErrorMessage((String)("CgHierarchyController.getTableInfo Failed to get modules:" + interruptedException));
                        }
                    }
                    int n3 = CgHierarchyController.this.oModel_.getChildCount(object);
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object2 = CgHierarchyController.this.oModel_.getChild(object, n4);
                        CgHierarchyData cgHierarchyData2 = (CgHierarchyData)object2;
                        CgHierarchyController.this.managedObjectComplete_ = false;
                        if (cgHierarchyData2 != null) {
                            CgHierarchyController.this.expandTree(cgHierarchyData2);
                        }
                        while (!CgHierarchyController.this.managedObjectComplete_) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                UcDDL.logErrorMessage((String)("CgHierarchyController.getTableInfo Failed to get managed object:" + interruptedException));
                            }
                        }
                        int n5 = CgHierarchyController.this.oModel_.getChildCount(object2);
                        int n6 = 0;
                        while (n6 < n5) {
                            Object object3 = CgHierarchyController.this.oModel_.getChild(object2, n6);
                            CgHierarchyData cgHierarchyData3 = (CgHierarchyData)object3;
                            CgHierarchyController.this.managedTableComplete_ = false;
                            if (cgHierarchyData3 != null) {
                                CgHierarchyController.this.expandTree(cgHierarchyData3);
                            }
                            int n7 = 0;
                            int n8 = 1000;
                            while (!CgHierarchyController.this.managedTableComplete_) {
                                try {
                                    if ((n7 += 10) >= n8) break;
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    UcDDL.logErrorMessage((String)("CgHierarchyController.getTableInfo Failed to get managed tables:" + interruptedException));
                                }
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                object = new CgTableInfo[CgHierarchyController.this.tableInfoVector_.size()];
                CgHierarchyController.this.tableInfoVector_.copyInto((Object[])object);
                CgHierarchyController.this.requester_.returnTableInfo((CgTableInfo[])object);
            }
        };
        thread.start();
    }

    public SMTaskOperationData[] getTaskData(CgHierarchyData cgHierarchyData) {
        Vector<SMTaskOperationData> vector = new Vector<SMTaskOperationData>();
        SMTaskOperationData[] sMTaskOperationDataArray = this.getOperDataPerRow(cgHierarchyData);
        int n = 0;
        while (n < sMTaskOperationDataArray.length) {
            vector.add(sMTaskOperationDataArray[n]);
            ++n;
        }
        Object[] objectArray = new SMTaskOperationData[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private SMTaskOperationData[] getOperDataPerRow(CgHierarchyData cgHierarchyData) {
        Object object;
        String string = null;
        String string2 = null;
        Object var4_4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        SMTaskOperationData[] sMTaskOperationDataArray = new SMTaskOperationData[this.getEditableColumns(cgHierarchyData).size() + 2];
        String[] stringArray = cgHierarchyData.getIndexURLs();
        if (stringArray != null && stringArray.length >= 1) {
            string = stringArray[0].substring(0, stringArray[0].lastIndexOf(47));
            string = this.buildUrl(string, cgHierarchyData);
            object = new UcURL(string);
            stringBuffer.append("/");
            stringBuffer.append(object.getPath());
            string = stringBuffer.toString();
        }
        try {
            sMTaskOperationDataArray[0] = new SMTaskOperationData();
            sMTaskOperationDataArray[0].setOperation("add_row");
            sMTaskOperationDataArray[0].setOperand(string);
            sMTaskOperationDataArray[0].setUserData("");
            object = this.getEditableColumns(cgHierarchyData);
            int n = 1;
            while (n < ((Vector)object).size() + 1) {
                sMTaskOperationDataArray[n] = new SMTaskOperationData();
                string2 = ((CgHierarchyData)((Vector)object).elementAt(n - 1)).getDataURL();
                string2 = string2.substring(string2.lastIndexOf(47) + 1);
                sMTaskOperationDataArray[n].setOperand(string2);
                sMTaskOperationDataArray[n].setValue("");
                String string3 = cgHierarchyData.getRawDataType();
                if (string3 != null && !string3.equals("")) {
                    sMTaskOperationDataArray[n].setValueType(CdPropValueEditorPane.mapType(string3));
                } else {
                    sMTaskOperationDataArray[n].setValueType("");
                }
                ++n;
            }
            sMTaskOperationDataArray[this.getEditableColumns((CgHierarchyData)cgHierarchyData).size() + 1] = SMTaskOperationData.getEndOperation();
        }
        catch (SMLengthException sMLengthException) {
            UcDDL.logErrorMessage((String)("CgPropChooser.getOperDataPerRow Failed to create SMTaskOperationData:" + (Object)((Object)sMLengthException)));
        }
        return sMTaskOperationDataArray;
    }

    private Vector getEditableColumns(CgHierarchyData cgHierarchyData) {
        Vector<CgHierarchyData> vector = new Vector<CgHierarchyData>();
        Enumeration enumeration = cgHierarchyData.children();
        while (enumeration.hasMoreElements()) {
            CgHierarchyData cgHierarchyData2 = (CgHierarchyData)enumeration.nextElement();
            if (!cgHierarchyData2.isEditable()) continue;
            vector.addElement(cgHierarchyData2);
        }
        return vector;
    }

    public String buildUrl(String string, CgHierarchyData cgHierarchyData) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        UcAgentURL ucAgentURL = new UcAgentURL(string);
        String string2 = ucAgentURL.getModuleSpec();
        int n = string.indexOf(string2);
        String string3 = string.substring(n + string2.length());
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(ucAgentURL.getModuleId());
        if (cgHierarchyData.isMultiInstanceModule()) {
            stringBuffer.append("+");
            stringBuffer.append(DUMMY_MODULE_INSTANCE);
        }
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        return string4;
    }

    public void addToTableVector(CgHierarchyData cgHierarchyData, CgHierarchyData cgHierarchyData2) {
        if (cgHierarchyData != null && cgHierarchyData.getType() == 4 && cgHierarchyData.hasRowAction()) {
            String string = null;
            while (cgHierarchyData2 != null && cgHierarchyData2.getType() != 2) {
                cgHierarchyData2 = cgHierarchyData2.getParent();
            }
            if (cgHierarchyData2 == null) {
                return;
            }
            string = cgHierarchyData2.getName();
            SMTaskOperationData[] sMTaskOperationDataArray = this.getTaskData(cgHierarchyData);
            String string2 = sMTaskOperationDataArray[0].getOperand();
            CgTableInfo cgTableInfo = new CgTableInfo(string, cgHierarchyData.getName(), string2, cgHierarchyData.isMultiInstanceModule(), sMTaskOperationDataArray);
            this.tableInfoVector_.add(cgTableInfo);
        }
    }

    static /* synthetic */ CgHierarchyData access$400(CgHierarchyController cgHierarchyController) {
        return cgHierarchyController.oChildParent_;
    }

    static /* synthetic */ CgHierarchyData access$700(CgHierarchyController cgHierarchyController) {
        return cgHierarchyController.oTableParent_;
    }
}

