/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDatabaseException;
import com.sun.symon.base.client.service.SMDuplicateException;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMIntegrityException;
import com.sun.symon.base.client.service.SMNoSuchObjectException;
import com.sun.symon.base.client.service.SMSecurityException;
import com.sun.symon.base.client.service.SMStaleDataException;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcSaveDialog;
import java.awt.Component;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CgUtil {
    public static final String OBJECTGROUP_MANAGER = "og manger";
    public static final String REQUEST_MANAGER = "request manager";
    public static final String REQUEST_LOG = "request log";
    public static final String OBJECT_GROUP_PREVIEWER = "og previewer";
    private static Hashtable dlgHash = new Hashtable();
    private static JFrame groupMainFrame;

    public static void registerMainGroupWindow(JFrame jFrame) {
        groupMainFrame = jFrame;
    }

    public static void removeMainGroupWindow() {
        groupMainFrame = null;
    }

    public static JFrame getMainGroupWindow() {
        return groupMainFrame;
    }

    public static void addDialogToPool(String string, JDialog jDialog) {
        dlgHash.put(string, jDialog);
    }

    public static JDialog getDialogFromPool(String string) {
        return (JDialog)dlgHash.get(string);
    }

    public static void removeDialogFromPool(String string) {
        dlgHash.remove(string);
    }

    public static void handleAPIException(SMAPIException sMAPIException, Component component) {
        String string = "";
        string = sMAPIException instanceof SMSecurityException ? CgUtil.getI18nMsg("standard.noRight") + "\n" + sMAPIException.getMessage() : (sMAPIException instanceof SMIntegrityException ? CgUtil.getI18nMsg("standard.integrityErr") + "\n" + sMAPIException.getMessage() : (sMAPIException instanceof SMDatabaseException ? CgUtil.getI18nMsg("standard.dbError") + "\n" + sMAPIException.getMessage() : sMAPIException.getMessage()));
        UcDialog.showError((Component)component, (Object)string);
    }

    public static String getI18nMsg(String string) {
        return UcInternationalizer.translateKey((String)("base.console.grouping.Grouping:" + string));
    }

    public static Vector showSave(Component component, String string, String string2, int n, int n2, String string3, String string4) {
        Vector<String> vector = null;
        Frame frame = JOptionPane.getFrameForComponent(component);
        UcSaveDialog ucSaveDialog = new UcSaveDialog(frame, string, string2, n, n2, string3, string4);
        ucSaveDialog.pack();
        ucSaveDialog.setLocationRelativeTo(component);
        ucSaveDialog.setVisible(true);
        if (ucSaveDialog.isSaveButtonClicked()) {
            vector = new Vector<String>();
            vector.add(ucSaveDialog.getName());
            vector.add(ucSaveDialog.getDescription());
        }
        return vector;
    }

    public static boolean saveObj(SMHandle sMHandle, SMDBObject sMDBObject) {
        try {
            sMHandle.saveObj(sMDBObject);
        }
        catch (SMStaleDataException sMStaleDataException) {
            int n = UcDialog.showYesNo((String)CgUtil.getI18nMsg("continueSave"));
            if (n == 0) {
                try {
                    SMDBObject sMDBObject2 = sMHandle.loadObj(sMDBObject.getObjectID());
                    sMDBObject.setTimestamp(sMDBObject2.getTimestamp());
                    return CgUtil.saveObj(sMHandle, sMDBObject);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtil.handleAPIException(sMAPIException, null);
                    return false;
                }
            }
            return false;
        }
        catch (SMDuplicateException sMDuplicateException) {
            String string = sMDBObject.getName();
            int n = UcDialog.showYesNo((String)CgUtil.getI18nMsg("confirmOverwrite(" + string + ")"));
            if (n == 0) {
                try {
                    SMDBObject sMDBObject3 = sMHandle.loadObj(string);
                    sMHandle.deleteObj(sMDBObject3);
                    return CgUtil.saveObj(sMHandle, sMDBObject);
                }
                catch (SMAPIException sMAPIException) {
                    CgUtil.handleAPIException(sMAPIException, null);
                    return false;
                }
            }
            return false;
        }
        catch (SMNoSuchObjectException sMNoSuchObjectException) {
            sMDBObject.setObjectID(null);
            return CgUtil.saveObj(sMHandle, sMDBObject);
        }
        catch (SMAPIException sMAPIException) {
            CgUtil.handleAPIException(sMAPIException, null);
            return false;
        }
        return true;
    }
}

