/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.alarm.SMAlarmMessage;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.utility.UcListUtil;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

abstract class CaDataObject {
    protected AlarmData[] data;
    protected SMAlarmMessage[] message;
    protected AlarmPanel alarmPanel;
    protected SMAlarmPageAsyncRequest request;
    protected Vector date = new Vector();
    protected Vector user = new Vector();
    protected Vector text = new Vector();

    public CaDataObject(AlarmPanel alarmPanel) {
        this.alarmPanel = alarmPanel;
        this.request = this.alarmPanel.getRequestHandle();
        this.data = this.alarmPanel.getAlarmTable().getAlarmData();
    }

    protected void setDate() {
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        this.date.clear();
        int n = 0;
        while (n < this.message.length) {
            long l = Long.parseLong(this.message[n].getTime().trim()) * 1000L;
            this.date.add(dateFormat.format(new Date(l)));
            ++n;
        }
    }

    protected void setUser() {
        this.user.clear();
        int n = 0;
        while (n < this.message.length) {
            this.user.add(this.message[n].getUser());
            ++n;
        }
    }

    protected void setText() {
        this.text.clear();
        int n = 0;
        while (n < this.message.length) {
            this.text.add(UcListUtil.AsciiToUnicode((String)this.message[n].getMessage()));
            ++n;
        }
    }

    public String getDate(int n) {
        if (n < this.date.size()) {
            return (String)this.date.elementAt(n);
        }
        return null;
    }

    public String getUser(int n) {
        if (n < this.user.size()) {
            return (String)this.user.elementAt(n);
        }
        return null;
    }

    public String getText(int n) {
        if (n < this.text.size()) {
            return (String)this.text.elementAt(n);
        }
        return null;
    }

    public int getCount() {
        return this.message.length;
    }

    public String getId() {
        if (this.data.length > 0) {
            return this.data[0].getId();
        }
        return null;
    }

    public String getUrl() {
        if (this.data.length > 0) {
            return this.data[0].getUrl();
        }
        return null;
    }

    public String[] getRow(int n) {
        if (n >= this.getCount() || n < 0) {
            return null;
        }
        String[] stringArray = new String[]{this.getDate(n), this.getUser(n), this.getText(n)};
        return stringArray;
    }

    public abstract void fillInMessage() throws SMAPIException;

    public abstract boolean addMessage(String var1);

    public abstract boolean removeMessage(int var1);

    public abstract boolean changeMessage(int var1, String var2);

    public boolean isEditable(int n) {
        return true;
    }
}

