/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.pv.console.presentation;

import com.sun.symon.apps.pv.console.presentation.SMPvBean;
import com.sun.symon.apps.pv.console.presentation.SMPvData;
import com.sun.symon.apps.pv.console.presentation.SMPvException;
import com.sun.symon.apps.pv.console.presentation.SMPvGlobals;
import com.sun.symon.apps.pv.console.presentation.SMPvImagePanel;
import com.sun.symon.apps.pv.console.presentation.SMPvNode;
import com.sun.symon.apps.pv.console.presentation.SMPvViewPnt;
import com.sun.symon.apps.pv.console.presentation.SMPvViewPointListener;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SMPvImagePanelActive
extends SMPvImagePanel
implements Runnable {
    SMPvNode nodeP;
    boolean postNow;
    Thread post = null;

    public SMPvImagePanelActive(SMPvNode sMPvNode, Image image) {
        super(image);
        this.nodeP = sMPvNode;
    }

    public SMPvImagePanelActive(SMPvNode sMPvNode, String string) {
        super(string);
        this.nodeP = sMPvNode;
    }

    public SMPvImagePanelActive(SMPvNode sMPvNode, String string, int n) {
        super(string, n);
        this.nodeP = sMPvNode;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        this.postPath(this.nodeP.getPvDataRef().getPath());
        this.start();
        this.postNow = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        this.postNow = false;
        this.postPath("");
        this.stop();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        if (this.getDepth() != 3) {
            return;
        }
        this.buildSiblingMenu();
        if (this.nodeP.hasMenuAdded()) {
            this.nodeP.getSiblingMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.mouseExited(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.getDepth() != 2) {
            return;
        }
        this.mouseExited(mouseEvent);
        this.drillDown();
    }

    public void start() {
        if (this.post == null) {
            this.post = new Thread(this);
        }
        if (this.post != null && !this.post.isAlive()) {
            this.post.start();
        }
    }

    public void stop() {
        this.post = null;
    }

    public void run() {
        if (this.post != null && this.post.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                SMPvGlobals.debug("could not wait for two seconds");
            }
            if (this.postNow) {
                this.postDetails(this.nodeP.getPvDataRef());
            }
        }
    }

    public void drillDown() {
        if (this.nodeP.getPvDataRef().getPvViewPnt(0) == null) {
            return;
        }
        this.createPvPanel();
    }

    public void buildSiblingMenu() {
        if (this.nodeP.hasMenuAdded()) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = null;
        SMPvData sMPvData = this.nodeP.getPvDataRef();
        SMPvData sMPvData2 = sMPvData.getFirstChild();
        while (sMPvData2 != null) {
            if (sMPvData2.getLinks() == null) {
                SMPvGlobals.debug("no link_to for: " + sMPvData2.getNodeName());
            } else {
                String[] stringArray = sMPvData2.getLinks();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n];
                    SMPvData sMPvData3 = SMPvData.findAlarmNode(sMPvData.getRoot(), string);
                    if (sMPvData3 != null) {
                        jMenuItem = new JMenuItem(sMPvData3.getNodeName());
                        jPopupMenu.add(jMenuItem);
                        if (sMPvData3.getViewNum() != 0) {
                            SMPvBean sMPvBean = sMPvData3.getPvViewPnt(0).getBeanReference();
                            jMenuItem.addActionListener(new SMPvViewPointListener(sMPvBean, sMPvData3));
                        }
                    }
                    ++n;
                }
            }
            sMPvData2 = sMPvData2.getBrother();
        }
        if (jMenuItem != null) {
            this.nodeP.setSiblingMenu(jPopupMenu);
        }
    }

    public void createPvPanel() {
        SMPvData sMPvData = this.nodeP.getPvDataRef();
        SMPvViewPnt sMPvViewPnt = sMPvData.getPvViewPnt(0);
        SMPvBean sMPvBean = sMPvViewPnt.getBeanReference();
        if (sMPvBean.viewExists(sMPvViewPnt)) {
            return;
        }
        try {
            sMPvBean.postStatus(sMPvBean.getI18NString("pvCreatingViewPoint"));
            sMPvBean.startViewCreateThread(sMPvData, 0, sMPvBean.getCurrentViewPnt());
        }
        catch (Exception exception) {
            if (exception instanceof SMPvException) {
                sMPvBean.postStatus(sMPvBean.getI18NString("pvCreatingViewPointFailed") + exception.getMessage());
            }
            return;
        }
        sMPvBean.postStatus("");
    }

    public void postDetails(SMPvData sMPvData) {
        Vector vector = null;
        SMPvBean sMPvBean = this.nodeP.getPvViewPnt().getBeanReference();
        sMPvBean.postStatus("");
        if (!sMPvBean.isComponentDetailShowing()) {
            return;
        }
        SMPvImagePanelActive sMPvImagePanelActive = this;
        synchronized (sMPvImagePanelActive) {
            vector = sMPvBean.getComponentDetail(sMPvData);
        }
        if (vector == null) {
            sMPvBean.postStatus(sMPvBean.getI18NString("pvNoComponentDetails"));
        } else {
            sMPvBean.postStatus("");
        }
        sMPvBean.populateComponentDetails(vector);
    }

    public void postPath(String string) {
        SMPvViewPnt sMPvViewPnt = this.nodeP.getPvViewPnt();
        if (sMPvViewPnt != null) {
            sMPvViewPnt.getBeanReference().setPath(string);
        }
    }

    public void setRedCondition() {
        this.setCondition(2);
    }

    public void setYellowCondition() {
        this.setCondition(3);
    }

    public void setBlueCondition() {
        this.setCondition(4);
    }

    public void setNormalCondition() {
        this.setCondition(1);
    }
}

