/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.process.console;

import com.sun.symon.apps.process.console.ProbeRunnable;
import com.sun.symon.apps.process.console.ProcessModuleStatusThread;
import com.sun.symon.apps.process.console.ProcessTableUpdateThread;
import com.sun.symon.apps.process.console.SymonProcessTableModel;
import com.sun.symon.apps.process.console.TableSorter;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.alarm.SMAlarmStatusRequest;
import com.sun.symon.base.client.alarm.SMAlarmStatusResponse;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class SymonProcessPanel
extends JPanel {
    final int PROCESS_PANEL_WIDTH = 300;
    final int PROCESS_PANEL_HEIGHT = 300;
    final int TEXT_SCROLLER_HEIGHT = 150;
    SymonProcessTableModel tableModel;
    JTable table;
    DefaultTableCellRenderer defaultCellRenderer;
    boolean processRowSelected = false;
    int selectedRowNumber = 1;
    int selectedPID = -1;
    TableSorter sorterModel;
    JSplitPane splitPane;
    JScrollPane scrollPane;
    JPanel topPanel;
    JPanel menuPanel;
    JPanel buttonPanel;
    JMenuBar topMenuBar;
    JMenu columnsMenu;
    JComboBox commandBox;
    JLabel textAreaLabel;
    JTextField pidField;
    JTextArea processTextArea;
    JScrollPane textScroller;
    JTextArea summaryArea;
    boolean destroyed;
    StringBuffer sb;
    boolean processing = false;
    boolean setSortCol = false;
    Object processUpdateThread = null;
    Object moduleStatusThread = null;
    ProcessTableUpdateThread updateBean = null;
    ProbeRunnable probeRunnable = new ProbeRunnable(this);
    int panelWidth = 300;
    int panelHeight = 300;
    boolean viewColumnClicked = false;
    SMRawDataRequest reqHandle;
    SMModuleRequest mReq;
    JLabel statusMsg;
    String agentHost;
    int agentPort;
    String[] snmpURLArray;
    Container rootContainer;
    String[] attrNames = new String[]{"psProcessID", "psParentProcessID", "psUserID", "psUserName", "psEUserID", "psGroupID", "psEGroupID", "psSessionID", "psProcessGroupID", "psTTY", "psStartTime", "psTime", "psState", "psWaitChannel", "psSchClass", "psAddress", "psSize", "psPriority", "psNice", "psPercentCPUTime", "psPercentMemory", "psCommand", "psCommandLine"};
    final int PID_COLUMN_ID = 0;
    final int PPID_COLUMN_ID = 1;
    final int UID_COLUMN_ID = 2;
    final int User_COLUMN_ID = 3;
    final int EffUser_COLUMN_ID = 4;
    final int GroupID_COLUMN_ID = 5;
    final int EffGroup_COLUMN_ID = 6;
    final int SessionID_COLUMN_ID = 7;
    final int PGroup_COLUMN_ID = 8;
    final int Tty_COLUMN_ID = 9;
    final int StartTime_COLUMN_ID = 10;
    final int Time_COLUMN_ID = 11;
    final int State_COLUMN_ID = 12;
    final int WaitChannel_COLUMN_ID = 13;
    final int Class_COLUMN_ID = 14;
    final int Address_COLUMN_ID = 15;
    final int Size_COLUMN_ID = 16;
    final int Priority_COLUMN_ID = 17;
    final int Nice_COLUMN_ID = 18;
    final int CPUPct_COLUMN_ID = 19;
    final int MemoryPct_COLUMN_ID = 20;
    final int Command_COLUMN_ID = 21;
    final int CommandLine_COLUMN_ID = 22;
    final int totalColumns = 23;
    String[] columnHeaders;
    boolean[] columnSelection;
    boolean[] defaultSelection = new boolean[]{true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true};
    int[] columnWidths;
    int[] columnPositions;
    boolean validTableData;
    boolean justUnloaded;
    Vector columnNames = new Vector();
    Vector tableData = new Vector();
    Vector hiddenColumns = new Vector(23);
    Object[][] tableArray = null;

    public void init() {
        JCheckBoxMenuItem jCheckBoxMenuItem;
        if (!this.isModuleLoaded()) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JTextArea jTextArea = new JTextArea(this.getI18NString("statusMsg_ProcessModuleNotLoaded"));
            jTextArea.setMargin(new Insets(20, 10, 10, 10));
            jTextArea.setEditable(false);
            jTextArea.setOpaque(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            this.add((Component)jScrollPane, gridBagConstraints);
            return;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.columnHeaders = new String[23];
        int n = 0;
        while (n < 23) {
            this.columnHeaders[n] = new String(this.getI18NString("columnHeaders" + n));
            ++n;
        }
        this.processRowSelected = false;
        this.selectedRowNumber = 0;
        this.columnWidths = new int[this.columnHeaders.length];
        this.columnPositions = new int[this.columnHeaders.length];
        this.validTableData = false;
        this.viewColumnClicked = false;
        this.destroyed = false;
        this.justUnloaded = false;
        this.topPanel = new JPanel(new GridLayout(1, 1));
        this.topPanel.setMinimumSize(new Dimension(this.getSize().width - 10, 50));
        this.menuPanel = new JPanel(new FlowLayout(0));
        this.topMenuBar = new JMenuBar();
        this.topMenuBar.getAccessibleContext().setAccessibleName(this.getI18NString("topMenuAccessibleName"));
        this.columnsMenu = new JMenu(this.getI18NString("viewColumnMenuTitle"));
        this.columnsMenu.getAccessibleContext().setAccessibleDescription(this.getI18NString("columnsMenuAccessibleName"));
        this.columnsMenu.setMnemonic(this.getI18NString("viewColumnMenuTitle.mnemonic").charAt(0));
        this.columnSelection = new boolean[this.defaultSelection.length];
        int n2 = 0;
        while (n2 < this.columnHeaders.length) {
            this.columnSelection[n2] = this.defaultSelection[n2];
            this.columnNames.addElement(this.columnHeaders[n2]);
            jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnHeaders[n2], this.columnSelection[n2]);
            jCheckBoxMenuItem.addItemListener(new ViewColumnItemListener());
            this.columnsMenu.add(jCheckBoxMenuItem);
            ++n2;
        }
        this.columnsMenu.add(new JSeparator());
        jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getI18NString("columnsMenuAll"), false);
        jCheckBoxMenuItem.addItemListener(new ViewColumnItemListener());
        this.columnsMenu.add(jCheckBoxMenuItem);
        this.topMenuBar.add(this.columnsMenu);
        this.menuPanel.add(this.topMenuBar);
        this.topPanel.add(this.menuPanel);
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.02;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.topPanel, gridBagConstraints);
        this.add(this.topPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(this.getI18NString("commandOutputLabel"));
        jLabel.setDisplayedMnemonic(this.getI18NString("commandOutputLabel.mnemonic").charAt(0));
        jPanel2.add(jLabel);
        JComboBox jComboBox = this.createCommandBox();
        jPanel2.add(jComboBox);
        jLabel.setLabelFor(jComboBox);
        jPanel2.add(new JLabel(this.getI18NString("commandProcessLabel")));
        this.pidField = new JTextField("None", 7);
        this.pidField.setEditable(false);
        jPanel2.add(this.pidField);
        jPanel.add("North", jPanel2);
        this.processTextArea = new JTextArea();
        this.processTextArea.setText(this.getI18NString("processTextAreaDefaultMessage"));
        this.processTextArea.setEditable(false);
        this.processTextArea.setOpaque(false);
        this.processTextArea.getAccessibleContext().setAccessibleName(this.getI18NString("processTextAreaAccessibleName"));
        this.textScroller = new JScrollPane();
        this.textScroller.getViewport().add(this.processTextArea);
        jPanel.add((Component)this.textScroller, "Center");
        jPanel.setMinimumSize(new Dimension(this.getSize().width - 10, 50));
        jPanel.setPreferredSize(new Dimension(this.getSize().width - 10, 200));
        this.tableModel = new SymonProcessTableModel();
        this.sorterModel = new TableSorter(this.tableModel);
        this.sorterModel.setAscending(false);
        this.sorterModel.setLastSortedColumn(19);
        this.table = new JTable(this.sorterModel);
        this.table.setBackground(UcCommon.getLightGrayColor());
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.sorterModel.addMouseListenerToHeaderInTable(this.table, this);
        this.table.addMouseListener(new TableMouseListener());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                SymonProcessPanel.this.table.setPreferredScrollableViewportSize(new Dimension(SymonProcessPanel.this.table.getColumnModel().getTotalColumnWidth(), 50 + (5 + SymonProcessPanel.this.table.getRowCount()) * SymonProcessPanel.this.table.getRowHeight()));
                SymonProcessPanel.this.table.revalidate();
                SymonProcessPanel.this.scrollPane.revalidate();
            }
        });
        this.defaultCellRenderer = new DefaultTableCellRenderer();
        this.defaultCellRenderer.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setColumnHeaderView(this.table.getTableHeader());
        this.scrollPane.getViewport().setBackingStoreEnabled(true);
        this.scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        this.scrollPane.setMinimumSize(new Dimension(this.getSize().width - 10, 50));
        this.scrollPane.setPreferredSize(new Dimension(this.getSize().width - 10, 200));
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(0);
        this.splitPane.setBottomComponent(jPanel);
        this.splitPane.validate();
        this.splitPane.setTopComponent(this.scrollPane);
        this.splitPane.validate();
        this.add(this.splitPane);
        gridBagLayout.setConstraints(this.splitPane, gridBagConstraints);
        this.splitPane.validate();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.05;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JLabel jLabel2 = new JLabel();
        Font font = this.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        jLabel2.setText(this.getI18NString("summaryAreaTitle"));
        jPanel3.add((Component)jLabel2, "North");
        this.summaryArea = new JTextArea(10, 20);
        jPanel3.add((Component)this.summaryArea, "Center");
        jPanel3.setMinimumSize(new Dimension(this.getSize().width - 10, 60));
        jPanel3.setPreferredSize(new Dimension(this.getSize().width - 10, 60));
        this.summaryArea.setText(this.getI18NString("processTextAreaNoOutputMessage"));
        this.summaryArea.setEditable(false);
        this.summaryArea.setOpaque(false);
        this.summaryArea.setBorder(BorderFactory.createBevelBorder(1));
        this.add(jPanel3);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.snmpURLArray = new String[this.columnNames.size()];
        int n3 = 0;
        while (n3 < this.columnNames.size()) {
            this.snmpURLArray[n3] = new String("snmp://" + this.agentHost + ":" + this.agentPort + "/mod/process-details/processTable/processTableEntry." + this.attrNames[n3]);
            ++n3;
        }
        this.updateBean = new ProcessTableUpdateThread("Process Update Thread", this);
        this.startRequest();
    }

    public void setSortColumn(int n) {
        this.sorterModel.setLastSortedColumn(n);
    }

    public void destructService() {
        this.destroyed = true;
        this.table = null;
        this.tableModel = null;
        this.defaultCellRenderer = null;
        this.sorterModel = null;
        this.splitPane = null;
        this.scrollPane = null;
        this.topPanel = null;
        this.menuPanel = null;
        this.buttonPanel = null;
        this.topMenuBar = null;
        this.columnsMenu = null;
        this.commandBox = null;
        this.textAreaLabel = null;
        this.pidField = null;
        this.processTextArea = null;
        this.textScroller = null;
        this.summaryArea = null;
        this.statusMsg = null;
        this.rootContainer = null;
        this.columnNames = null;
        this.tableData = null;
        this.hiddenColumns = null;
        this.tableArray = null;
        this.stopRequest();
    }

    public void beanActivated() {
        this.justUnloaded = false;
        if (this.validTableData) {
            if (!this.isModuleLoaded()) {
                this.postStatus(this.getI18NString("statusMsg_ProcessModuleUnloaded"));
                this.justUnloaded = true;
                return;
            }
            this.startRequest();
        }
    }

    public void startRequest() {
        if (this.processUpdateThread == null) {
            try {
                this.processUpdateThread = this.reqHandle.getURLValue(this.snmpURLArray, "90", (SMRawDataResponse)this.updateBean, (Object)"processDataUpdate");
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("Error creating process tab data request: " + (Object)((Object)sMAPIException)));
            }
        }
        if (this.moduleStatusThread == null) {
            SMAlarmStatusRequest sMAlarmStatusRequest = new SMAlarmStatusRequest(this.reqHandle);
            String string = new String("snmp://" + this.agentHost + ":" + this.agentPort + "/mod/process-details");
            try {
                this.moduleStatusThread = sMAlarmStatusRequest.getTopAlarmStatusRequest(string, "15", (SMAlarmStatusResponse)new ProcessModuleStatusThread(this), (Object)"moduleStatusUpdate");
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("Error creating process module status request: " + (Object)((Object)sMAPIException)));
            }
        }
    }

    public void stopRequest() {
        if (this.processUpdateThread != null) {
            try {
                this.reqHandle.removeURLRequest(this.processUpdateThread);
                this.processUpdateThread = null;
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("Error removing process tab data request: " + (Object)((Object)sMAPIException)));
            }
        }
        if (this.moduleStatusThread != null) {
            try {
                this.reqHandle.removeURLRequest(this.moduleStatusThread);
                this.moduleStatusThread = null;
            }
            catch (SMAPIException sMAPIException) {
                UcDDL.logErrorMessage((String)("Error removing process module status request: " + (Object)((Object)sMAPIException)));
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getSize();
        return new Dimension(dimension.width - 10, dimension.height - 10);
    }

    public boolean isJustUnloaded() {
        return this.justUnloaded;
    }

    public boolean isValidTableData() {
        return this.validTableData;
    }

    public boolean isModuleLoaded() {
        try {
            return this.mReq.isModuleLoaded(this.agentHost, this.agentPort, "process-details");
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)("client API exception for isModuleLoaded: " + exception));
            return false;
        }
    }

    JComboBox createCommandBox() {
        this.commandBox = new JComboBox();
        this.commandBox.addItem("pmap -x");
        this.commandBox.addItem("pstack");
        this.commandBox.addItem("pfiles");
        this.commandBox.addItem("pldd");
        this.commandBox.addItem(this.getI18NString("commandBoxItem_None"));
        this.commandBox.setSelectedItem("pmap -x");
        this.commandBox.setEditable(false);
        this.commandBox.addActionListener(new ProcCommandActionListener());
        return this.commandBox;
    }

    public void probeSyMONServer(int n) {
        String[] stringArray;
        String string = this.commandBox.getSelectedItem().toString();
        this.updatePIDField(n);
        if (string.equals(this.getI18NString("commandBoxItem_None"))) {
            this.processTextArea.setText(this.getI18NString("processTextAreaNoOutputMessage"));
            this.processTextArea.invalidate();
            this.processTextArea.getParent().invalidate();
            return;
        }
        if (string.equals("pmap -x")) {
            string = "pmap";
            stringArray = new String[]{"-x", Integer.toString(n)};
        } else {
            stringArray = new String[]{Integer.toString(n)};
        }
        String string2 = new String("snmp://" + this.agentHost + ":" + this.agentPort + "/mod/tools-adhocs/users?runadhoccommand." + string);
        Socket[] socketArray = null;
        try {
            socketArray = this.reqHandle.probeConnectWithStderr(string2, stringArray);
        }
        catch (Exception exception) {
            this.processTextArea.setText(this.getI18NString("processTextAreaTryAgainMessage") + exception.toString());
            this.processTextArea.invalidate();
            this.processTextArea.getParent().invalidate();
        }
        if (socketArray != null) {
            try {
                String string3;
                Object object;
                InputStreamReader inputStreamReader = new InputStreamReader(socketArray[0].getInputStream());
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer();
                while ((object = bufferedReader.readLine()) != null) {
                    stringBuffer.append((String)object).append("\n");
                }
                if (this.table.getColumnCount() != 0) {
                    this.processTextArea.invalidate();
                    this.processTextArea.setText(stringBuffer.toString());
                    this.processTextArea.getParent().invalidate();
                    this.processTextArea.getParent().doLayout();
                }
                object = new InputStreamReader(socketArray[1].getInputStream());
                BufferedReader bufferedReader2 = new BufferedReader((Reader)object);
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl = false;
                while ((string3 = bufferedReader2.readLine()) != null) {
                    stringBuffer2.append(string3).append("\n");
                    bl = true;
                }
                if (bl) {
                    this.processTextArea.invalidate();
                    this.processTextArea.setText(stringBuffer2.toString());
                    this.processTextArea.getParent().invalidate();
                    this.processTextArea.getParent().doLayout();
                }
                this.textScroller.getVerticalScrollBar().setValue(0);
                this.textScroller.validate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                socketArray[0].close();
                socketArray[1].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void listProcesses(StObject[][] var1_1) {
        block31: {
            block30: {
                var2_2 = 0;
                if (this.processing) {
                    return;
                }
                this.processing = true;
                if (this.validTableData) {
                    var4_3 = 0;
                    while (var4_3 < this.columnHeaders.length) {
                        if (this.columnSelection[var4_3]) {
                            var3_8 = this.table.getColumn(this.columnHeaders[var4_3]);
                            var5_11 = this.table.convertColumnIndexToView(var4_3);
                            this.columnPositions[var5_11] = var4_3;
                            ++var2_2;
                        } else {
                            var3_8 = (TableColumn)this.hiddenColumns.elementAt(var4_3);
                        }
                        this.columnWidths[var4_3] = var3_8.getWidth();
                        ++var4_3;
                    }
                }
                this.tableData.removeAllElements();
                this.hiddenColumns.removeAllElements();
                this.table.setAutoResizeMode(3);
                this.postStatus(this.getI18NString("statusMsg_Get"));
                if (var1_1 != null) break block30;
                this.postStatus(this.getI18NString("statusMsg_Failed"));
                var3_8 = new Vector<E>();
                var3_8.addElement(new String(this.getI18NString("statusMsg_Failed")));
                var4_4 = new Vector<String>();
                var4_4.addElement(new String(this.getI18NString("errorColumnHeader")));
                this.tableData.addElement(var3_8);
                this.tableModel.setDataVector(this.tableData, var4_4);
                this.processRowSelected = false;
                this.validTableData = false;
                this.disableMenus();
                this.clearTextAreas();
                break block31;
            }
            try {
                var3_9 = var1_1.length;
                if (var3_9 != this.columnHeaders.length) {
                    this.postStatus(this.getI18NString("statusMsg_Incomplete"));
                    var4_5 = new Vector<String>();
                    var4_5.addElement(new String(this.getI18NString("statusMsg_Incomplete")));
                    var5_12 = new Vector<String>();
                    var5_12.addElement(new String(this.getI18NString("errorColumnHeader")));
                    this.tableData.addElement(var4_5);
                    this.tableModel.setDataVector(this.tableData, var5_12);
                    this.table.setAutoResizeMode(3);
                    this.processRowSelected = false;
                    this.validTableData = false;
                    this.disableMenus();
                    this.clearTextAreas();
                    this.processing = false;
                    return;
                }
                this.postStatus(this.getI18NString("statusMsg_GetDone"));
                this.enableMenus();
                var4_6 = new Vector<E>();
                UcListUtil.decomposeList((String)var1_1[0][0].toString(), var4_6);
                var5_11 = var4_6.size();
                var6_14 = 0;
                var7_15 = 0;
                var8_16 = 0;
                var9_17 = 0;
                var10_18 = 0;
                var11_19 = 0;
                var12_20 = 0;
                this.tableArray = new Object[var5_11][var3_9];
                var13_21 = 0;
                while (var13_21 < var5_11) {
                    this.tableArray[var13_21][0] = Integer.valueOf(var4_6.elementAt(var13_21).toString());
                    ++var13_21;
                }
                var14_22 = 1;
                while (var14_22 < var3_9) {
                    UcListUtil.decomposeList((String)var1_1[var14_22][0].toString(), var4_6);
                    var15_23 = 0;
                    while (var15_23 < var5_11) {
                        switch (var14_22) {
                            case 1: 
                            case 5: 
                            case 16: 
                            case 17: 
                            case 18: {
                                this.tableArray[var15_23][var14_22] = Integer.valueOf(var4_6.elementAt(var15_23).toString());
                                break;
                            }
                            case 19: 
                            case 20: {
                                this.tableArray[var15_23][var14_22] = Double.valueOf(var4_6.elementAt(var15_23).toString());
                                break;
                            }
                            case 12: {
                                if (!"S".equals(var4_6.elementAt(var15_23).toString())) ** GOTO lbl89
                                ++var7_15;
                                ** GOTO lbl106
lbl89:
                                // 1 sources

                                if (!"O".equals(var4_6.elementAt(var15_23).toString())) ** GOTO lbl92
                                ++var6_14;
                                ** GOTO lbl106
lbl92:
                                // 1 sources

                                if (!"R".equals(var4_6.elementAt(var15_23).toString())) ** GOTO lbl95
                                ++var8_16;
                                ** GOTO lbl106
lbl95:
                                // 1 sources

                                if (!"I".equals(var4_6.elementAt(var15_23).toString())) ** GOTO lbl98
                                ++var9_17;
                                ** GOTO lbl106
lbl98:
                                // 1 sources

                                if (!"Z".equals(var4_6.elementAt(var15_23).toString())) ** GOTO lbl101
                                ++var10_18;
                                ** GOTO lbl106
lbl101:
                                // 1 sources

                                if (!"T".equals(var4_6.elementAt(var15_23).toString())) ** GOTO lbl104
                                ++var11_19;
                                ** GOTO lbl106
lbl104:
                                // 1 sources

                                if ("X".equals(var4_6.elementAt(var15_23).toString())) {
                                    ++var12_20;
                                }
                            }
lbl106:
                            // 10 sources

                            default: {
                                this.tableArray[var15_23][var14_22] = var4_6.elementAt(var15_23);
                            }
                        }
                        ++var15_23;
                    }
                    ++var14_22;
                }
                this.tableModel.setDataVector(this.tableArray, this.columnHeaders);
                var15_23 = 0;
                while (var15_23 < this.columnHeaders.length) {
                    var16_24 = this.table.getColumn(this.columnHeaders[var15_23]);
                    var16_24.setCellRenderer(this.defaultCellRenderer);
                    this.hiddenColumns.addElement(var16_24);
                    if (var15_23 == 22) {
                        var16_24.setWidth(350);
                        var16_24.setPreferredWidth(350);
                    } else {
                        var16_24.setWidth(100);
                        var16_24.setPreferredWidth(100);
                    }
                    ++var15_23;
                }
                if (this.validTableData) {
                    var16_25 = 0;
                    while (var16_25 < this.columnHeaders.length) {
                        var17_26 = this.table.getColumn(this.columnHeaders[var16_25]);
                        this.table.removeColumn(var17_26);
                        ++var16_25;
                    }
                    var17_27 = 0;
                    while (var17_27 < var2_2) {
                        this.table.addColumn((TableColumn)this.hiddenColumns.elementAt(this.columnPositions[var17_27]));
                        ++var17_27;
                    }
                } else {
                    var16_25 = 0;
                    while (var16_25 < this.columnHeaders.length) {
                        var17_28 = this.table.getColumn(this.columnHeaders[var16_25]);
                        if (!this.columnSelection[var16_25]) {
                            this.table.removeColumn(var17_28);
                        }
                        ++var16_25;
                    }
                }
                this.table.setAutoResizeMode(0);
                if (this.table.getColumnCount() == 0) {
                    this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), 0));
                } else {
                    this.table.setPreferredScrollableViewportSize(new Dimension(this.table.getColumnModel().getTotalColumnWidth(), 50 + (5 + this.table.getRowCount()) * this.table.getRowHeight()));
                }
                this.sorterModel.sortByLastSortedColumn();
                this.processRowSelected = true;
                this.selectedRowNumber = 0;
                var16_25 = 0;
                while (var16_25 < this.table.getRowCount()) {
                    if (this.selectedPID == Integer.parseInt(this.table.getModel().getValueAt(var16_25, 0).toString())) {
                        this.selectedRowNumber = var16_25;
                        break;
                    }
                    ++var16_25;
                }
                this.table.getSelectionModel().setSelectionInterval(this.selectedRowNumber, this.selectedRowNumber);
                this.validTableData = true;
                this.postStatus(this.getI18NString("statusMsg_TableDone"));
                this.updateProcessInfo();
                this.summaryArea.invalidate();
                this.sb = null;
                this.sb = new StringBuffer();
                this.sb.append(this.getI18NString("summaryTotal"));
                this.sb.append(Integer.toString(var5_11));
                this.sb.append("\t");
                this.sb.append(this.getI18NString("summaryRunning"));
                this.sb.append(Integer.toString(var6_14));
                this.sb.append("\t");
                this.sb.append(this.getI18NString("summarySleeping"));
                this.sb.append(Integer.toString(var7_15));
                this.sb.append("\t");
                this.sb.append(this.getI18NString("summaryRunnable"));
                this.sb.append(Integer.toString(var8_16));
                this.sb.append("\n");
                this.sb.append(this.getI18NString("summaryIdle"));
                this.sb.append(Integer.toString(var9_17));
                this.sb.append("\t");
                this.sb.append(this.getI18NString("summaryZombies"));
                this.sb.append(Integer.toString(var10_18));
                this.sb.append("\t");
                this.sb.append(this.getI18NString("summaryTraced"));
                this.sb.append(Integer.toString(var11_19));
                this.sb.append("\t");
                this.sb.append(this.getI18NString("summarySxbrk"));
                this.sb.append(Integer.toString(var12_20));
                this.sb.append("\n");
                this.updateSummaryInfo();
                this.postStatus("");
            }
            catch (Exception var3_10) {
                this.postStatus(this.getI18NString("statusMsg_ModuleLoaded"));
                var4_7 = new Vector<String>();
                var4_7.addElement(new String(this.getI18NString("statusMsg_ModuleLoaded")));
                var5_13 = new Vector<String>();
                var5_13.addElement(new String(this.getI18NString("errorColumnHeader")));
                this.tableData.addElement(var4_7);
                this.table.setAutoResizeMode(3);
                this.tableModel.setDataVector(this.tableData, var5_13);
                this.table.setPreferredScrollableViewportSize(new Dimension(this.panelWidth, this.panelHeight));
                this.processRowSelected = false;
                this.validTableData = false;
                this.disableMenus();
                this.clearTextAreas();
            }
        }
        this.processing = false;
    }

    public void updatePIDField(int n) {
        if (this.table.getColumnCount() != 0) {
            this.pidField.setText(Integer.toString(n));
            this.pidField.invalidate();
            this.pidField.getParent().validate();
        }
    }

    public void updateSummaryInfo() {
        if (this.table.getColumnCount() != 0) {
            this.summaryArea.setText(this.sb.toString());
            this.summaryArea.invalidate();
            this.summaryArea.getParent().validate();
        }
    }

    public void updateProcessInfo() {
        if (!this.validTableData) {
            return;
        }
        int n = Integer.parseInt(this.table.getModel().getValueAt(this.selectedRowNumber, 0).toString());
        try {
            int n2 = Integer.parseInt(this.pidField.getText());
            if (n2 == n) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.probeSyMONServer(n);
    }

    public String getI18NString(String string) {
        try {
            return UcInternationalizer.translateKey((String)("com.sun.symon.apps.process.console.SymonProcessBundle:" + string));
        }
        catch (Exception exception) {
            return string;
        }
    }

    public void postStatus(String string) {
        if (this.statusMsg != null) {
            this.statusMsg.setText(string);
            this.statusMsg.invalidate();
            this.statusMsg.getParent().validate();
        }
    }

    public void clearTextAreas() {
        this.pidField.setText("None");
        this.processTextArea.setText(this.getI18NString("processTextAreaDefaultMessage"));
        this.processTextArea.validate();
        this.summaryArea.setText(this.getI18NString("processTextAreaNoOutputMessage"));
        this.summaryArea.validate();
    }

    public void disableMenus() {
        this.commandBox.setEnabled(false);
        this.topMenuBar.setEnabled(false);
        this.columnsMenu.setEnabled(false);
    }

    public void enableMenus() {
        this.commandBox.setEnabled(true);
        this.topMenuBar.setEnabled(true);
        this.columnsMenu.setEnabled(true);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.reqHandle = sMRawDataRequest;
        this.mReq = new SMModuleRequest(this.reqHandle);
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public JFrame getParentFrame() {
        return (JFrame)this.rootContainer;
    }

    public void setParentFrame(JFrame jFrame) {
        this.rootContainer = jFrame;
    }

    public void setPanelWidth(int n) {
        this.panelWidth = n;
    }

    public int getPanelWidth() {
        return this.panelWidth;
    }

    public void setPanelHeight(int n) {
        this.panelHeight = n;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public boolean isViewColumnClicked() {
        return this.viewColumnClicked;
    }

    public void setViewColumnClicked(boolean bl) {
        this.viewColumnClicked = bl;
    }

    public void setSortCol(boolean bl) {
        this.setSortCol = bl;
    }

    public boolean getSortCol() {
        return this.setSortCol;
    }

    class SummaryArea
    extends JTextArea {
        Vector stringVector;
        int lines = 0;

        public SummaryArea(int n, int n2) {
            super(n, n2);
        }

        public void paint(Graphics graphics) {
            Font font = this.getFont();
            Font font2 = new Font(font.getName(), 1, font.getSize());
            FontMetrics fontMetrics = graphics.getFontMetrics(font2);
            FontMetrics fontMetrics2 = graphics.getFontMetrics(font);
            this.setBackground(Color.white);
            graphics.setFont(font2);
            int n = 5 + fontMetrics.getAscent();
            graphics.drawString(SymonProcessPanel.this.getI18NString("summaryAreaTitle"), 5, n);
            n += fontMetrics2.getAscent();
            graphics.setFont(font);
            int n2 = 0;
            while (n2 < this.lines) {
                graphics.drawString((String)this.stringVector.elementAt(n2), 5, n);
                n += fontMetrics2.getAscent();
                ++n2;
            }
        }

        public void setText(String string) {
            if (this.stringVector != null) {
                this.stringVector.removeAllElements();
            }
            this.stringVector = new Vector(5);
            this.stringVector.addElement(string);
            this.lines = 1;
            this.repaint();
        }

        public void append(String string) {
            this.stringVector.addElement(string);
            ++this.lines;
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        TableMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SymonProcessPanel.this.isValidTableData()) {
                return;
            }
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n = SymonProcessPanel.this.table.rowAtPoint(point);
            if (n != -1 && SymonProcessPanel.this.table.getColumnCount() != 0) {
                SymonProcessPanel.this.processRowSelected = true;
                SymonProcessPanel.this.selectedRowNumber = n;
                SymonProcessPanel.this.selectedPID = Integer.parseInt(SymonProcessPanel.this.table.getModel().getValueAt(n, 0).toString());
                SymonProcessPanel.this.probeRunnable.setPID(SymonProcessPanel.this.selectedPID);
                Thread thread = new Thread((Runnable)SymonProcessPanel.this.probeRunnable, "processProbeThread");
                thread.start();
            }
        }
    }

    class ProcCommandActionListener
    implements ActionListener {
        ProcCommandActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            SymonProcessPanel.this.viewColumnClicked = true;
            if (SymonProcessPanel.this.processRowSelected && (n = Integer.parseInt(SymonProcessPanel.this.table.getModel().getValueAt(SymonProcessPanel.this.selectedRowNumber, 0).toString())) != -1) {
                SymonProcessPanel.this.probeSyMONServer(n);
            }
        }
    }

    class ViewColumnItemListener
    implements ItemListener {
        ViewColumnItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (SymonProcessPanel.this.hiddenColumns.size() == 0) {
                return;
            }
            SymonProcessPanel.this.viewColumnClicked = true;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)itemEvent.getSource();
            String string = jCheckBoxMenuItem.getText();
            if (string.equals(SymonProcessPanel.this.getI18NString("columnsMenuAll"))) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        boolean bl = false;
                        if (SymonProcessPanel.this.table.getColumnCount() == 0) {
                            bl = true;
                        }
                        int n = 0;
                        while (n < SymonProcessPanel.this.columnHeaders.length) {
                            if (!SymonProcessPanel.this.columnSelection[n]) {
                                SymonProcessPanel.this.table.addColumn((TableColumn)SymonProcessPanel.this.hiddenColumns.elementAt(n));
                                SymonProcessPanel.this.columnSelection[n] = true;
                                jCheckBoxMenuItem = (JCheckBoxMenuItem)SymonProcessPanel.this.columnsMenu.getItem(n);
                                jCheckBoxMenuItem.setState(true);
                            }
                            ++n;
                        }
                        SymonProcessPanel.this.table.setPreferredScrollableViewportSize(new Dimension(SymonProcessPanel.this.table.getColumnModel().getTotalColumnWidth(), 50 + (5 + SymonProcessPanel.this.table.getRowCount()) * SymonProcessPanel.this.table.getRowHeight()));
                        SymonProcessPanel.this.table.getParent().invalidate();
                        SymonProcessPanel.this.table.getParent().validate();
                        if (bl) {
                            SymonProcessPanel.this.updateProcessInfo();
                            SymonProcessPanel.this.updateSummaryInfo();
                        }
                        return;
                    }
                    case 2: {
                        int n = 0;
                        while (n < SymonProcessPanel.this.columnHeaders.length) {
                            if (SymonProcessPanel.this.columnSelection[n]) {
                                TableColumn tableColumn = SymonProcessPanel.this.table.getColumn(SymonProcessPanel.this.columnHeaders[n]);
                                SymonProcessPanel.this.hiddenColumns.setElementAt(tableColumn, n);
                                SymonProcessPanel.this.table.removeColumn(tableColumn);
                                SymonProcessPanel.this.columnSelection[n] = false;
                                jCheckBoxMenuItem = (JCheckBoxMenuItem)SymonProcessPanel.this.columnsMenu.getItem(n);
                                jCheckBoxMenuItem.setState(false);
                            }
                            ++n;
                        }
                        int n2 = 0;
                        while (n2 < SymonProcessPanel.this.columnHeaders.length) {
                            if (SymonProcessPanel.this.defaultSelection[n2]) {
                                SymonProcessPanel.this.table.addColumn((TableColumn)SymonProcessPanel.this.hiddenColumns.elementAt(n2));
                                SymonProcessPanel.this.columnSelection[n2] = SymonProcessPanel.this.defaultSelection[n2];
                                jCheckBoxMenuItem = (JCheckBoxMenuItem)SymonProcessPanel.this.columnsMenu.getItem(n2);
                                jCheckBoxMenuItem.setState(true);
                            }
                            ++n2;
                        }
                        SymonProcessPanel.this.table.setPreferredScrollableViewportSize(new Dimension(SymonProcessPanel.this.table.getColumnModel().getTotalColumnWidth(), 50 + (5 + SymonProcessPanel.this.table.getRowCount()) * SymonProcessPanel.this.table.getRowHeight()));
                        SymonProcessPanel.this.getParent().invalidate();
                        SymonProcessPanel.this.getParent().validate();
                        return;
                    }
                }
            } else {
                int n = 0;
                while (n < SymonProcessPanel.this.columnHeaders.length) {
                    if (string.equals(SymonProcessPanel.this.columnHeaders[n])) {
                        switch (itemEvent.getStateChange()) {
                            case 1: {
                                if (SymonProcessPanel.this.columnSelection[n]) {
                                    return;
                                }
                                TableColumn tableColumn = (TableColumn)SymonProcessPanel.this.hiddenColumns.elementAt(n);
                                SymonProcessPanel.this.table.addColumn(tableColumn);
                                SymonProcessPanel.this.columnSelection[n] = true;
                                SymonProcessPanel.this.columnPositions[SymonProcessPanel.this.table.getColumnCount() - 1] = n;
                                SymonProcessPanel.this.table.setPreferredScrollableViewportSize(new Dimension(SymonProcessPanel.this.table.getColumnModel().getTotalColumnWidth(), 50 + (5 + SymonProcessPanel.this.table.getRowCount()) * SymonProcessPanel.this.table.getRowHeight()));
                                SymonProcessPanel.this.getParent().invalidate();
                                SymonProcessPanel.this.getParent().validate();
                                if (SymonProcessPanel.this.table.getColumnCount() == 1) {
                                    SymonProcessPanel.this.updateProcessInfo();
                                    SymonProcessPanel.this.updateSummaryInfo();
                                }
                                return;
                            }
                            case 2: {
                                if (!SymonProcessPanel.this.columnSelection[n]) {
                                    return;
                                }
                                TableColumn tableColumn = SymonProcessPanel.this.table.getColumn(string);
                                SymonProcessPanel.this.hiddenColumns.setElementAt(tableColumn, n);
                                SymonProcessPanel.this.table.removeColumn(tableColumn);
                                SymonProcessPanel.this.columnSelection[n] = false;
                                if (SymonProcessPanel.this.table.getColumnCount() != 0) {
                                    SymonProcessPanel.this.table.setPreferredScrollableViewportSize(new Dimension(SymonProcessPanel.this.table.getColumnModel().getTotalColumnWidth(), 50 + (5 + SymonProcessPanel.this.table.getRowCount()) * SymonProcessPanel.this.table.getRowHeight()));
                                } else {
                                    SymonProcessPanel.this.table.setPreferredScrollableViewportSize(new Dimension(SymonProcessPanel.this.table.getColumnModel().getTotalColumnWidth(), 0));
                                }
                                SymonProcessPanel.this.getParent().invalidate();
                                SymonProcessPanel.this.getParent().validate();
                                if (SymonProcessPanel.this.table.getColumnCount() == 0) {
                                    SymonProcessPanel.this.clearTextAreas();
                                }
                                return;
                            }
                        }
                    }
                    ++n;
                }
            }
        }
    }
}

