/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.session;

import com.sun.management.services.common.Debug;
import com.sun.management.services.session.SessionManager;
import java.util.Iterator;
import java.util.TreeMap;

public class SessionTimeoutManager {
    private final TreeMap sessionManagers = new TreeMap();
    private TimeoutThread timeoutThread = null;
    private long timeToNextTimeout = Long.MAX_VALUE;

    public SessionTimeoutManager() {
    }

    public SessionTimeoutManager(SessionManager sessionManager) {
        this.updateTimeout(sessionManager);
    }

    public synchronized void updateTimeout(SessionManager sessionManager) {
        Entry entry = this.findEntryDo(sessionManager);
        if (entry != null) {
            entry.recalcTimeout();
            this.calctimeToNextTimeout();
        } else {
            this.addEntry(new Entry(sessionManager));
        }
    }

    private void addEntry(Entry entry) {
        this.sessionManagers.put(entry, entry);
        this.calctimeToNextTimeout();
    }

    public synchronized void removeEntry(Entry entry) {
        if (entry == null) {
            return;
        }
        this.sessionManagers.remove(entry);
        entry.sessionManager.cleanUpSession();
        this.calctimeToNextTimeout();
    }

    public synchronized void removeSessionManager(SessionManager sessionManager) {
        Entry entry = this.findEntryDo(sessionManager);
        if (entry != null) {
            this.removeEntry(entry);
        }
    }

    private void calctimeToNextTimeout() {
        this.timeToNextTimeout = Long.MAX_VALUE;
        long l = System.currentTimeMillis();
        while (this.sessionManagers.size() > 0) {
            Entry entry = (Entry)this.sessionManagers.lastKey();
            if (l >= entry.timeOutTime) {
                this.removeEntry(entry);
                continue;
            }
            this.timeToNextTimeout = entry.timeOutTime;
            break;
        }
        if (this.timeoutThread == null && this.timeToNextTimeout < Long.MAX_VALUE) {
            this.createTimeoutThread();
        }
    }

    private Entry findEntryDo(SessionManager sessionManager) {
        Iterator iterator = this.sessionManagers.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!entry.sessionManager.equals(sessionManager)) continue;
            return entry;
        }
        return null;
    }

    private void createTimeoutThread() {
        this.timeoutThread = new TimeoutThread();
        this.timeoutThread.start();
    }

    private class TimeoutThread
    extends Thread {
        public TimeoutThread() {
            super("SessionManager timeout");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    SessionTimeoutManager sessionTimeoutManager = SessionTimeoutManager.this;
                    synchronized (sessionTimeoutManager) {
                        long l = System.currentTimeMillis();
                        while (true) {
                            if (SessionTimeoutManager.this.timeToNextTimeout <= l) {
                                try {
                                    Entry entry = (Entry)SessionTimeoutManager.this.sessionManagers.lastKey();
                                    if (entry.timeOutTime > l) break;
                                    SessionTimeoutManager.this.removeEntry(entry);
                                }
                                catch (Exception exception) {
                                    Debug.trace1((String)"no keys");
                                }
                                break;
                            }
                            if (SessionTimeoutManager.this.timeToNextTimeout == Long.MAX_VALUE) {
                                SessionTimeoutManager.this.timeoutThread = null;
                                return;
                            }
                            SessionTimeoutManager.this.wait(SessionTimeoutManager.this.timeToNextTimeout - l);
                            l = System.currentTimeMillis();
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class Entry
    implements Comparable {
        private long timeOutTime = Long.MAX_VALUE;
        public SessionManager sessionManager;

        public Entry(SessionManager sessionManager) {
            this.sessionManager = sessionManager;
            this.recalcTimeout();
        }

        public void recalcTimeout() {
            this.timeOutTime = this.sessionManager.getTimeoutTime();
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            Entry entry = (Entry)object;
            if (this.timeOutTime < entry.timeOutTime) {
                return 1;
            }
            return -1;
        }
    }
}

