/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.session;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.management.services.authentication.SessionRepository;
import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.WebXmlParser;
import com.sun.management.services.session.CoreSessionManagerFilter;
import com.sun.management.services.session.SessionTimeoutManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionManager
extends Hashtable {
    private HttpSession consoleSession = null;
    private static int SESSIONTIMEOUT = 600000;
    private long timeoutTime = 0L;
    private static SessionTimeoutManager sessionTimeoutManager = new SessionTimeoutManager();

    public SessionManager() {
    }

    public SessionManager(HttpSession httpSession) {
        this.setConsoleSession(httpSession);
    }

    public void setConsoleSession(HttpSession httpSession) {
        this.consoleSession = httpSession;
        this.consoleSession.setAttribute("com.sun.web.console.constant.session_manager", (Object)this);
    }

    public HttpSession getConsoleSession() {
        return this.consoleSession;
    }

    public void cleanUpSession() {
        HttpSession httpSession = this.getConsoleSession();
        if (httpSession == null) {
            Debug.trace1((String)"SessionManager:cleanupSession aborting");
            return;
        }
        SessionRepository.removeSession(httpSession);
        this.cleanUpSSO();
        try {
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                HttpSession httpSession2 = (HttpSession)enumeration.nextElement();
                httpSession2.invalidate();
            }
            this.clear();
            httpSession.invalidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.trace1((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void cleanUpSSO() {
        try {
            SessionHttpRequest sessionHttpRequest = new SessionHttpRequest(this.getConsoleSession());
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken((HttpServletRequest)sessionHttpRequest);
            LoginContext loginContext = new LoginContext("ConsoleLogin", sSOToken.getSubject());
            loginContext.logout();
            loginContext = null;
            sSOTokenManager.destroyToken(sSOToken);
            sSOToken = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.trace1((String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void add(HttpSession httpSession) {
        this.put(httpSession.getId(), httpSession);
        httpSession.setAttribute("com.sun.web.console.constant.newAppSession", (Object)this.consoleSession);
    }

    public static SessionManager getSessionManager(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        HttpSession httpSession2 = CoreSessionManagerFilter.mRegService.getConsoleSession(httpSession);
        HttpSession httpSession3 = httpSession2 == null ? httpSession : httpSession2;
        SessionManager sessionManager = (SessionManager)httpSession3.getAttribute("com.sun.web.console.constant.session_manager");
        if (sessionManager == null) {
            sessionManager = new SessionManager(httpSession3);
        }
        return sessionManager;
    }

    public static void setSessionManager(HttpSession httpSession, SessionManager sessionManager) {
        if (sessionManager != null) {
            sessionManager.setConsoleSession(httpSession);
        }
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public void accessed() {
        long l = System.currentTimeMillis();
        long l2 = WebXmlParser.getSessionTimeout() * 60000;
        long l3 = l2 > 0L ? l2 : (long)SESSIONTIMEOUT;
        this.timeoutTime = l + l3;
        sessionTimeoutManager.updateTimeout(this);
    }

    public void logOut() {
        sessionTimeoutManager.removeSessionManager(this);
    }

    public class SessionHttpRequest
    implements HttpServletRequest {
        private HttpSession theSession;

        public SessionHttpRequest(HttpSession httpSession) {
            this.setSession(httpSession);
        }

        public String getAuthType() {
            return null;
        }

        public Object getAttribute(String string) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String string) {
            return 0L;
        }

        public String getHeader(String string) {
            return null;
        }

        public Enumeration getHeaderNames() {
            return null;
        }

        public Enumeration getHeaders(String string) {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public int getIntHeader(String string) {
            return 0;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public String getMethod() {
            return null;
        }

        public String getParameter(String string) {
            return null;
        }

        public Map getParameterMap() {
            return null;
        }

        public Enumeration getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String string) {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public String getRemoteUser() {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String string) {
            return null;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public String getServletPath() {
            return null;
        }

        public void setSession(HttpSession httpSession) {
            this.theSession = httpSession;
        }

        public HttpSession getSession() {
            return this.theSession;
        }

        public HttpSession getSession(boolean bl) {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public boolean isUserInRole(String string) {
            return false;
        }

        public void removeAttribute(String string) {
        }

        public void setAttribute(String string, Object object) {
        }

        public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        }

        public String getRealPath(String string) {
            return null;
        }
    }
}

