/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.common.Debug;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class WebXmlParser
extends DefaultHandler {
    private static int sessionTimeout = 15;
    private String timeoutValue = null;
    private static final String SESSION_TIMEOUT = "session-timeout";
    private CharArrayWriter contents = new CharArrayWriter();
    private Hashtable resDTDs = new Hashtable();
    private String publicId = null;

    public void parse(InputSource inputSource) throws IOException, SAXException {
        SAXParser sAXParser;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(false);
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Could not create parser!");
        }
        ParserAdapter parserAdapter = new ParserAdapter(sAXParser.getParser());
        parserAdapter.setContentHandler(this);
        try {
            parserAdapter.parse(inputSource);
            sessionTimeout = Integer.parseInt(this.timeoutValue);
        }
        catch (Exception exception) {
            Debug.trace1((String)"web.xml parsing error", (Throwable)exception);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase(SESSION_TIMEOUT)) {
            this.contents.reset();
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase(SESSION_TIMEOUT)) {
            this.timeoutValue = this.contents.toString();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contents.write(cArray, n, n2);
    }

    public static int getSessionTimeout() {
        return sessionTimeout;
    }

    public static void setSessionTimeout(int n) {
        sessionTimeout = n;
    }
}

