/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.registration.AuthType;
import com.sun.management.services.registration.AuthTypes;
import com.sun.management.services.registration.Description;
import com.sun.management.services.registration.Help;
import com.sun.management.services.registration.Icon;
import com.sun.management.services.registration.LocalizableElement;
import com.sun.management.services.registration.ManagementApp;
import com.sun.management.services.registration.Masthead;
import com.sun.management.services.registration.Name;
import com.sun.management.services.registration.Parameter;
import com.sun.management.services.registration.PermissionParam;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.ShortDescription;
import com.sun.management.services.registration.UrlDesc;
import java.io.CharArrayWriter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class AppDescriptorParser
extends DefaultHandler {
    private RegistrationInfo app = new RegistrationInfo();
    private ManagementApp mgmtApp = new ManagementApp();
    private UrlDesc urlDesc = new UrlDesc();
    private AuthType authType;
    private PermissionParam permissionParam;
    private Parameter parameter;
    private CharArrayWriter contents = new CharArrayWriter();

    public RegistrationInfo parse(InputSource inputSource) throws IOException, SAXException, RegistrationException {
        SAXParser sAXParser;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RegistrationException("Could not create parser!");
        }
        ParserAdapter parserAdapter = new ParserAdapter(sAXParser.getParser());
        parserAdapter.setContentHandler(this);
        try {
            parserAdapter.parse(inputSource);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        this.app.setManagementApp(this.mgmtApp);
        try {
            this.app.validate();
        }
        catch (RegistrationException registrationException) {
            StringBuffer stringBuffer = new StringBuffer("The application descriptor ").append("file is invalid for the following reason:\n\n").append(registrationException.getLocalizedMessage());
            throw new RegistrationException(stringBuffer.toString());
        }
        return this.app;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("registrationInfo")) {
            this.app.setVersion(attributes.getValue("version"));
        } else if (string2.equalsIgnoreCase("managementApp")) {
            this.mgmtApp.setVersion(attributes.getValue("version"));
            this.mgmtApp.setCategory(attributes.getValue("category"));
            this.mgmtApp.setPackage(attributes.getValue("package"));
            this.mgmtApp.setBundle(attributes.getValue("bundle"));
            this.mgmtApp.setBundleJar(attributes.getValue("bundleJar"));
            this.mgmtApp.setNativeDir(attributes.getValue("nativeDir"));
        } else if (string2.equalsIgnoreCase("name")) {
            this.contents.reset();
            Name name = new Name();
            this.setLocalizable((LocalizableElement)name, attributes);
            this.mgmtApp.setName(name);
        } else if (string2.equalsIgnoreCase("pluginName")) {
            this.contents.reset();
        } else if (string2.equalsIgnoreCase("icon")) {
            this.contents.reset();
            Icon icon = new Icon();
            this.setLocalizable((LocalizableElement)icon, attributes);
            this.mgmtApp.setIcon(icon);
        } else if (string2.equalsIgnoreCase("shortDescription")) {
            this.contents.reset();
            ShortDescription shortDescription = new ShortDescription();
            this.setLocalizable((LocalizableElement)shortDescription, attributes);
            this.mgmtApp.setShortDescription(shortDescription);
        } else if (string2.equalsIgnoreCase("description")) {
            this.contents.reset();
            Description description = new Description();
            this.setLocalizable((LocalizableElement)description, attributes);
            this.mgmtApp.setDescription(description);
        } else if (string2.equalsIgnoreCase("masthead")) {
            Masthead masthead = new Masthead();
            masthead.setBundle(attributes.getValue("bundle"));
            masthead.setBundleJar(attributes.getValue("bundleJar"));
            masthead.setLogo(attributes.getValue("logo"));
            masthead.setLogoAltText(attributes.getValue("logoAltText"));
            masthead.setLogoBorder(attributes.getValue("logoBorder"));
            masthead.setLogoHeight(attributes.getValue("logoHeight"));
            masthead.setLogoWidth(attributes.getValue("logoWidth"));
            String string4 = "showUserRole";
            masthead.setShowUserRole(Boolean.valueOf(attributes.getValue(string4)).booleanValue());
            string4 = "showServer";
            masthead.setShowServer(Boolean.valueOf(attributes.getValue(string4)).booleanValue());
            string4 = "showClose";
            masthead.setShowClose(Boolean.valueOf(attributes.getValue(string4)).booleanValue());
            string4 = "showHelp";
            masthead.setShowHelp(Boolean.valueOf(attributes.getValue(string4)).booleanValue());
            this.mgmtApp.setMasthead(masthead);
        } else if (string2.equalsIgnoreCase("help")) {
            Help help = new Help();
            help.setBundle(attributes.getValue("bundle"));
            help.setBundleJar(attributes.getValue("bundleJar"));
            help.setAnchor(attributes.getValue("anchor"));
            help.setPathPrefix(attributes.getValue("pathPrefix"));
            help.setHelpFileName(attributes.getValue("helpFileName"));
            help.setVersionFileName(attributes.getValue("versionFileName"));
            help.setStatus(attributes.getValue("status"));
            help.setHelpTooltip(attributes.getValue("helpTooltip"));
            help.setVersionTooltip(attributes.getValue("versionTooltip"));
            help.setMastheadTitle(attributes.getValue("mastheadTitle"));
            help.setWindowTitle(attributes.getValue("windowTitle"));
            help.setHeight(attributes.getValue("height"));
            help.setWidth(attributes.getValue("width"));
            this.mgmtApp.setHelp(help);
        } else if (string2.equalsIgnoreCase("authTypes")) {
            this.app.setAuthTypes(new AuthTypes());
        } else if (string2.equalsIgnoreCase("authType")) {
            this.authType = new AuthType();
            this.authType.setName(attributes.getValue("name"));
        } else if (string2.equalsIgnoreCase("classType")) {
            this.contents.reset();
        } else if (string2.equalsIgnoreCase("permissionParam")) {
            this.contents.reset();
            this.permissionParam = new PermissionParam();
            this.permissionParam.setName(attributes.getValue("name"));
        } else if (string2.equalsIgnoreCase("urlDesc")) {
            this.urlDesc = new UrlDesc();
        } else if (string2.equalsIgnoreCase("url")) {
            this.contents.reset();
        } else if (string2.equalsIgnoreCase("parameter")) {
            this.parameter = new Parameter();
            this.parameter.setName(attributes.getValue("name"));
            this.parameter.setValue(attributes.getValue("value"));
            this.urlDesc.addParameter(this.parameter);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase("name")) {
            this.mgmtApp.getName().setNameContent(this.contents.toString());
        } else if (string2.equalsIgnoreCase("pluginName")) {
            StringBuffer stringBuffer = new StringBuffer(this.contents.toString()).append("_").append(this.mgmtApp.getVersion());
            this.mgmtApp.setPluginName(stringBuffer.toString());
        } else if (string2.equalsIgnoreCase("icon")) {
            this.mgmtApp.getIcon().setIconContent(this.contents.toString());
        } else if (string2.equalsIgnoreCase("shortDescription")) {
            this.mgmtApp.getShortDescription().setShortDescriptionContent(this.contents.toString());
        } else if (string2.equalsIgnoreCase("description")) {
            this.mgmtApp.getDescription().setDescriptionContent(this.contents.toString());
        } else if (string2.equalsIgnoreCase("authType")) {
            this.app.getAuthTypes().addAuthType(this.authType);
        } else if (string2.equalsIgnoreCase("classType")) {
            this.authType.setClassType(this.contents.toString());
        } else if (string2.equalsIgnoreCase("urlDesc")) {
            this.app.setUrlDesc(this.urlDesc);
        } else if (string2.equalsIgnoreCase("url")) {
            this.urlDesc.setUrl(this.contents.toString());
        } else if (string2.equalsIgnoreCase("permissionParam")) {
            this.permissionParam.setPermissionParamContent(this.contents.toString());
            this.authType.addPermissionParam(this.permissionParam);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contents.write(cArray, n, n2);
    }

    public void setLocalizable(LocalizableElement localizableElement, Attributes attributes) {
        localizableElement.setLocalizable(Boolean.valueOf(attributes.getValue("localizable")).booleanValue());
    }
}

