/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication.sso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.management.services.authentication.sso.ConsoleSSOProvider;
import com.sun.management.services.authentication.sso.ConsoleSSOTokenID;
import com.sun.management.services.common.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Calendar;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class ConsoleSSOToken
implements SSOToken {
    HttpServletRequest request = null;
    HttpSession session = null;
    Subject subject = null;
    ConsoleSSOTokenID tokenID = null;
    long activationTime = 0L;
    long maxIdleTime = 10000L;
    long maxSessionTime = 500000L;
    Vector listeners = null;

    public ConsoleSSOToken(HttpServletRequest httpServletRequest, Subject subject, ConsoleSSOTokenID consoleSSOTokenID) {
        this.request = httpServletRequest;
        this.session = ConsoleSSOProvider.getConsoleSession(httpServletRequest);
        this.tokenID = consoleSSOTokenID;
        this.subject = subject;
        this.setLastUseTime();
        this.listeners = new Vector();
    }

    public Subject getSubject() throws SSOException {
        if (this.subject != null) {
            this.setLastUseTime();
            return this.subject;
        }
        Debug.trace2((String)"No subject found");
        throw new SSOException("no_subject_found");
    }

    public Principal getPrincipal() throws SSOException {
        if (this.subject == null) {
            throw new SSOException("no_subject_found");
        }
        this.setLastUseTime();
        Principal principal = null;
        Object[] objectArray = this.subject.getPrincipals().toArray();
        if (objectArray != null && objectArray.length != 0) {
            principal = (Principal)objectArray[0];
            return principal;
        }
        Debug.trace2((String)"No principal found");
        throw new SSOException("no_principal_found");
    }

    public String getAuthType() throws SSOException {
        this.setLastUseTime();
        return null;
    }

    public int getAuthLevel() throws SSOException {
        this.setLastUseTime();
        return 0;
    }

    public InetAddress getIPAddress() throws SSOException {
        this.setLastUseTime();
        try {
            return InetAddress.getByName(this.request.getRemoteHost());
        }
        catch (UnknownHostException unknownHostException) {
            throw new SSOException(unknownHostException.getMessage());
        }
    }

    public String getHostName() throws SSOException {
        this.setLastUseTime();
        return "localhost";
    }

    public long getMaxSessionTime() throws SSOException {
        this.setLastUseTime();
        return this.maxSessionTime;
    }

    public long getIdleTime() throws SSOException {
        Calendar calendar = Calendar.getInstance();
        long l = calendar.getTimeInMillis();
        long l2 = l - this.activationTime;
        return l2;
    }

    public long getMaxIdleTime() throws SSOException {
        this.setLastUseTime();
        return this.maxIdleTime;
    }

    public SSOTokenID getTokenID() {
        this.setLastUseTime();
        return this.tokenID;
    }

    public void setProperty(String string, String string2) throws SSOException {
    }

    public String getProperty(String string) throws SSOException {
        throw new SSOException("not_supported");
    }

    public void addSSOTokenListener(SSOTokenListener sSOTokenListener) throws SSOException {
        this.listeners.add(sSOTokenListener);
        this.setLastUseTime();
    }

    private void setLastUseTime() {
        Calendar calendar = Calendar.getInstance();
        this.activationTime = calendar.getTimeInMillis();
    }
}

