/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication.sso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.sun.management.services.authentication.SubjectRepository;
import com.sun.management.services.authentication.sso.ConsoleSSOToken;
import com.sun.management.services.authentication.sso.ConsoleSSOTokenID;
import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public final class ConsoleSSOProvider
implements SSOProvider {
    HttpSession session = null;
    static final MgmtAppRegistrationService mRegService = MgmtAppRegistrationServiceFactory.getRegistrationService();

    static HttpSession getConsoleSession(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        HttpSession httpSession2 = mRegService.getConsoleSession(httpSession);
        if (httpSession2 != null) {
            return httpSession2;
        }
        return httpSession;
    }

    public SSOToken createSSOToken(HttpServletRequest httpServletRequest) throws UnsupportedOperationException, SSOException {
        this.session = ConsoleSSOProvider.getConsoleSession(httpServletRequest);
        String string = (String)this.session.getAttribute("tokenID");
        if (string != null && string.length() != 0) {
            ConsoleSSOToken consoleSSOToken = (ConsoleSSOToken)this.session.getAttribute(string);
            if (consoleSSOToken != null) {
                return consoleSSOToken;
            }
            SubjectRepository subjectRepository = SubjectRepository.getInstance();
            ConsoleSSOTokenID consoleSSOTokenID = new ConsoleSSOTokenID(string);
            Subject subject = subjectRepository.getSubject(consoleSSOTokenID);
            ConsoleSSOToken consoleSSOToken2 = new ConsoleSSOToken(httpServletRequest, subject, consoleSSOTokenID);
            this.session.setAttribute(string, (Object)consoleSSOToken2);
            Debug.trace1((String)("new SSOToken created, token ID : " + string));
            return consoleSSOToken2;
        }
        throw new SSOException("token_id_not_found");
    }

    public SSOToken createSSOToken(String string) throws SSOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void destroyToken(SSOToken sSOToken) throws SSOException {
        ConsoleSSOTokenID consoleSSOTokenID = (ConsoleSSOTokenID)sSOToken.getTokenID();
        SubjectRepository subjectRepository = SubjectRepository.getInstance();
        subjectRepository.removeSubject(consoleSSOTokenID);
        if (this.session != null) {
            this.session.removeAttribute(consoleSSOTokenID.toString());
        }
        Debug.trace1((String)("SSOToken destroyed, token ID : " + consoleSSOTokenID.toString()));
    }

    public boolean isValidToken(SSOToken sSOToken) {
        try {
            return sSOToken.getIdleTime() <= sSOToken.getMaxIdleTime();
        }
        catch (SSOException sSOException) {
            return false;
        }
    }

    public void validateToken(SSOToken sSOToken) throws SSOException {
        if (sSOToken.getIdleTime() > sSOToken.getMaxIdleTime()) {
            throw new SSOException("session_timed_out");
        }
    }
}

