/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.sso.ConsoleSSOTokenID;
import com.sun.management.services.common.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Random;
import javax.security.auth.Subject;

public class SubjectRepository {
    private static SubjectRepository sr = null;
    private static Hashtable subjectCache = null;
    private static SecureRandom random;
    private static final int RANDOM_KEYSIZE = 20;
    private static final char[] hex;

    public SubjectRepository() {
        subjectCache = new Hashtable();
    }

    public static SubjectRepository getInstance() {
        if (sr == null) {
            sr = new SubjectRepository();
        }
        return sr;
    }

    public String addSubject(Subject subject) throws Exception {
        ConsoleSSOTokenID consoleSSOTokenID = this.getNewToken();
        if (subject == null) {
            throw new Exception("subject is null");
        }
        Debug.trace1((String)"new subject containing principles of type: ");
        Object[] objectArray = subject.getPrincipals().toArray();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                Debug.trace1((String)objectArray[n].getClass().getName());
                ++n;
            }
        }
        subjectCache.put(consoleSSOTokenID, subject);
        Debug.trace1((String)("SubjectRepository: added subject with token ID# " + consoleSSOTokenID.toString()));
        return consoleSSOTokenID.toString();
    }

    public void removeSubject(ConsoleSSOTokenID consoleSSOTokenID) {
        Subject subject = (Subject)subjectCache.remove(consoleSSOTokenID);
        consoleSSOTokenID = null;
        subject = null;
    }

    public Subject getSubject(ConsoleSSOTokenID consoleSSOTokenID) {
        return (Subject)subjectCache.get(consoleSSOTokenID);
    }

    private ConsoleSSOTokenID getNewToken() throws Exception {
        byte[] byArray;
        try {
            byArray = SubjectRepository.getSeed();
            random = new SecureRandom(byArray);
        }
        catch (Exception exception) {
            throw new Exception("random_number_generation_problem");
        }
        byArray = new byte[10];
        random.nextBytes(byArray);
        String string = SubjectRepository.toHex(byArray);
        String string2 = "localhost";
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        string = string + string2;
        string = string.trim();
        ConsoleSSOTokenID consoleSSOTokenID = new ConsoleSSOTokenID(string);
        Debug.trace1((String)("created new token ID : " + consoleSSOTokenID.toString()));
        return consoleSSOTokenID;
    }

    private static synchronized byte[] getSeed() {
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        long l = System.currentTimeMillis();
        Random random = new Random(l);
        random.nextBytes(byArray);
        random.nextBytes(byArray2);
        l = System.currentTimeMillis();
        long l2 = 1L;
        long l3 = 0L;
        int n = 0;
        while (n < 20) {
            l3 = l & l2;
            byArray3[n] = l3 > 0L ? byArray[n] : byArray2[n];
            l2 <<= 1;
            ++n;
        }
        return byArray3;
    }

    private static synchronized String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

