/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.authentication;

import com.sun.management.services.authentication.ConsoleCallback;
import com.sun.management.services.authentication.ExecProcess;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.RbacRoleCallback;
import com.sun.management.services.authentication.UserRoleCredential;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.common.Debug;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RbacRoleLoginModule
implements LoginModule {
    private Subject subject;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private CallbackHandler ccbh;
    private UserRolePrincipal up = null;
    private UserRoleCredential pc = null;
    private boolean authenticated = false;
    String host = null;
    String user = null;
    String role = null;
    PasswordCredential roleCredential = null;
    private String commandPath = null;
    private static final String NO_ROLE_CONST = "no_role";

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.ccbh = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.commandPath = (String)map2.get("commandPath");
        if (this.commandPath == null) {
            this.commandPath = "/usr/sadm/lib/webconsole/bin";
        }
    }

    public boolean login() throws LoginException {
        Serializable serializable;
        Debug.trace1((String)"INSIDE THE login() METHOD OF LOGINROLES");
        int n = -1;
        String[] stringArray = (String[])this.sharedState.get("roleList");
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        Callback[] callbackArray = new Callback[1];
        try {
            callbackArray[0] = new RbacRoleCallback();
            ((RbacRoleCallback)callbackArray[0]).setRolelist(stringArray);
            this.ccbh.handle(callbackArray);
            serializable = (RbacRoleCallback)callbackArray[0];
            this.role = ((RbacRoleCallback)serializable).getRole();
            if (this.role.equals(NO_ROLE_CONST)) {
                return true;
            }
            this.host = ((ConsoleCallback)serializable).getHost();
            this.user = ((ConsoleCallback)serializable).getUser();
            this.roleCredential = ((RbacRoleCallback)serializable).getRoleCredential();
        }
        catch (Exception exception) {
            Debug.trace2((String)exception.getMessage(), (Throwable)exception);
            LoginException loginException = new LoginException("call_back_failure");
            loginException.fillInStackTrace();
            throw loginException;
        }
        try {
            Object object;
            serializable = new Vector();
            String string = this.commandPath + "/pamverifier";
            String[] stringArray2 = new String[]{string, "authrole", this.role, this.user, this.roleCredential.getUserPassword()};
            ExecProcess execProcess = new ExecProcess(stringArray2);
            try {
                serializable = execProcess.exec();
            }
            catch (Exception exception) {
                LoginException loginException = new LoginException("exec_proc_failure");
                Debug.trace2((String)"ExecProcess Failure", (Throwable)loginException);
                loginException.fillInStackTrace();
                throw loginException;
            }
            if (serializable != null) {
                object = (String[])((Vector)serializable).elementAt(0);
                n = Integer.parseInt(object[0].trim());
            }
            if (n == 0) {
                this.succeeded = true;
                Debug.trace1((String)"ROLE VALIDATION SUCCESSFUL");
                Debug.trace1((String)"RbacRoleLoginModule::Role validated..");
                return true;
            }
            object = new FailedLoginException("login_failed_invalid_role_or_cred");
            Debug.trace2((String)"invalid role or credential", (Throwable)object);
            ((Throwable)object).fillInStackTrace();
            throw object;
        }
        catch (Exception exception) {
            FailedLoginException failedLoginException = new FailedLoginException("login_failed_see_log");
            Debug.trace2((String)"login failed", (Throwable)failedLoginException);
            failedLoginException.fillInStackTrace();
            throw failedLoginException;
        }
    }

    public boolean commit() throws LoginException {
        if (this.subject == null) {
            throw new LoginException("login_failed_see_log");
        }
        Object[] objectArray = this.subject.getPrincipals().toArray();
        Object[] objectArray2 = this.subject.getPrivateCredentials().toArray();
        if (this.role != null && !this.role.equals(NO_ROLE_CONST)) {
            int n = 0;
            while (n < objectArray.length) {
                UserRolePrincipal userRolePrincipal = (UserRolePrincipal)objectArray[n];
                UserRoleCredential userRoleCredential = (UserRoleCredential)objectArray2[n];
                if (userRolePrincipal.getHostName().equals(userRoleCredential.getHostName())) {
                    userRolePrincipal.setRoleName(this.role);
                    userRoleCredential.setRolePassword(this.roleCredential.getUserPassword());
                    break;
                }
                ++n;
            }
        }
        this.commitSucceeded = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.up = null;
            if (this.pc != null) {
                this.pc = null;
            }
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }
}

