/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.sso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOProvider;
import com.iplanet.sso.SSOToken;
import com.sun.management.services.common.Debug;
import javax.servlet.http.HttpServletRequest;

public final class SSOTokenManager {
    static final String DPRO_PROVIDER_CONFIG_FILE = "SSOConfig";
    static final String DPRO_PROVIDER_CLASSNAME_KEY = "com.iplanet.sso.providerimplclass";
    static final String DPRO_PROVIDER_CLASSNAME_KEY_OLD = "providerimplclass";
    static SSOProvider dProProvider = null;
    static final String CONSOLE_PROVIDER_CLASSNAME = "com.sun.management.services.authentication.sso.ConsoleSSOProvider";
    static final String CONSOLE_PROVIDER_PACKAGE = "com.sun.management.services.authentication.sso";
    static SSOProvider consoleProvider = null;
    private static SSOTokenManager instance = null;
    static /* synthetic */ Class class$com$iplanet$sso$SSOTokenManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSOTokenManager getInstance() throws SSOException {
        if (instance == null) {
            Class clazz = class$com$iplanet$sso$SSOTokenManager == null ? (class$com$iplanet$sso$SSOTokenManager = SSOTokenManager.class$("com.iplanet.sso.SSOTokenManager")) : class$com$iplanet$sso$SSOTokenManager;
            synchronized (clazz) {
                if (instance == null) {
                    Debug.trace1("Constructing a new instance of SSOTokenManager");
                    instance = new SSOTokenManager();
                }
            }
        }
        return instance;
    }

    private SSOTokenManager() throws SSOException {
        try {
            Class<?> clazz = Class.forName(CONSOLE_PROVIDER_CLASSNAME);
            consoleProvider = (SSOProvider)clazz.newInstance();
        }
        catch (Exception exception) {
            Debug.trace2("Unable to obtain Console SSO provider", exception);
        }
        if (dProProvider == null && consoleProvider == null) {
            Debug.trace2("Unable to obtain either Console or DPRO SSO providers");
            throw new SSOException("no providers can be found");
        }
    }

    protected static SSOProvider getProvider(SSOToken sSOToken) throws SSOException {
        String string = sSOToken.getClass().getName();
        if (string.startsWith(CONSOLE_PROVIDER_PACKAGE)) {
            if (consoleProvider == null) {
                throw new SSOException("no provider class");
            }
            return consoleProvider;
        }
        return dProProvider;
    }

    public SSOToken createSSOToken(HttpServletRequest httpServletRequest) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(httpServletRequest);
        }
        return consoleProvider.createSSOToken(httpServletRequest);
    }

    public SSOToken createSSOToken(String string) throws UnsupportedOperationException, SSOException {
        if (dProProvider != null) {
            return dProProvider.createSSOToken(string);
        }
        return consoleProvider.createSSOToken(string);
    }

    public boolean isValidToken(SSOToken sSOToken) {
        try {
            return SSOTokenManager.getProvider(sSOToken).isValidToken(sSOToken);
        }
        catch (SSOException sSOException) {
            return false;
        }
    }

    public void validateToken(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).validateToken(sSOToken);
    }

    public void destroyToken(SSOToken sSOToken) throws SSOException {
        SSOTokenManager.getProvider(sSOToken).destroyToken(sSOToken);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

