#
# ident "@(#)ichange-d.x	1.8 02/12/03 SMI"
#
# Copyright 2002 Sun Microsystems, Inc.  All rights reserved.
#

[ use MANAGED-MODULE ]
[ load ichange-m.x ]
[ requires template ichange-models-d ]


_services = { [ use SERVICE ]
        sh = {
                command = "pipe://localhost//bin/sh;transport=shell"
                max = 3
        }
}


software_info = { [ use templates.ichange-models-d.software_info ]
	initInterval	= 0
	Hostname = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/uname -n
		refreshInterval	= 0
	}
	OS_name = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/uname -s
		refreshInterval	= 0
	}


	OS_release = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/uname -r
		refreshInterval	= 0
	}

	OS_version = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/uname -v
		refreshInterval	= 0
	}
} # software_info

hardware_info = { [ use templates.ichange-models-d.hardware_info ]
	prcessor_type = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/uname -p
		refreshInterval	= 0
	}
	platform_type = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/uname -i
		refreshInterval	= 0
	}
} # hardware_info

boot_environment = { [ use templates.ichange-models-d.boot_environment ]
	initInterval	= 0
	name = {
		type		= active
		refreshService 	= _services.sh
		refreshCommand 	= /sbin/lucurr 2> /dev/null
		refreshInterval	= 0
	}
	
	status = {
		type 		= active
		refreshService 	= _services.sh
		refreshCommand	= echo ""
		refreshInterval	= 0
	}

	software_stack = {
		type 		= active
		refreshService 	= _services.sh
		refreshCommand	= echo ""
		refreshInterval	= 0
	}

} # boot_environment

refreshService = _internal
BE_list = { [ use templates.ichange-models-d.BE_list ]
	initInterval	= 0
	type 		= active
	refreshService 	= _services.sh

	# XXX this should be a configurable base path...
	refreshCommand	= ichange_lustatus
	refreshInterval	= 0
}


#
# Our probe command.  It should be named "probe" but why break anything.
#
adhocCommand(update) = probeserver -u root -c "ichange_probe"


#
# Only those with write access to this MIB may use the probe.
#
shadowMIBAccessMode(runadhoccommand) = useMIBAccess
