/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.session;

import com.sun.management.services.authentication.SessionRepository;
import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.AppFilter;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.MgmtAppRegistrationServiceFactory;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.session.SessionManager;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class CoreSessionManagerFilter
implements Filter {
    private FilterConfig filterConfig = null;
    protected static final MgmtAppRegistrationService mRegService = MgmtAppRegistrationServiceFactory.getRegistrationService();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.setFilterConfig(filterConfig);
    }

    public void destroy() {
        this.setFilterConfig(null);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            Debug.trace1((String)"CoreSessionManagementFilter.doFilter(): filterConfig = null");
            return;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        ServletContext servletContext = this.getConsoleServletContext();
        try {
            Cookie cookie;
            String string = httpServletRequest.getRequestURI();
            if (string.endsWith("/") && !string.equals("/")) {
                String string2 = string.substring(0, string.length() - 1);
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string2));
            }
            if (this.skippingSessionFilterAllowed(string)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            boolean bl = false;
            HttpSession httpSession = httpServletRequest.getSession();
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray == null) {
                this.sendRedirect(httpServletRequest, httpServletResponse, false);
                return;
            }
            if (httpSession != null) {
                httpSession.setMaxInactiveInterval(-1);
            }
            if ((cookie = this.getConsoleCookie(cookieArray)) == null) {
                this.sendRedirect(httpServletRequest, httpServletResponse, false);
            } else {
                HttpSession httpSession2 = this.findConsoleSession(cookie);
                if (httpSession2 != null) {
                    this.manageSessions(httpSession2, httpSession);
                    this.handleRequest(httpServletRequest, httpServletResponse, filterChain);
                } else {
                    Cookie cookie2 = new Cookie("com.sun.management.services.session.cookie", "com.sun.management.services.session.cookie");
                    cookie2.setPath("/");
                    cookie2.setMaxAge(0);
                    httpServletResponse.addCookie(cookie2);
                    this.sendRedirect(httpServletRequest, httpServletResponse, true);
                }
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("CoreSessionManagerFilter.doFilter() exception: " + exception.getLocalizedMessage()));
        }
    }

    protected ServletContext getConsoleServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected void sendRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) {
        String string;
        boolean bl2 = false;
        String string2 = null;
        boolean bl3 = false;
        String string3 = httpServletRequest.getParameter("ConsoleLogout");
        String string4 = httpServletRequest.getRequestURI();
        if (string4.equals("/") || string4.equals("/console") || string4.equals("/console/")) {
            bl2 = true;
        } else {
            string2 = this.resolveAppURL(string4);
            this.checkAppAvail(string2, httpServletRequest, httpServletResponse, "/console/login/Login");
        }
        StringBuffer stringBuffer = new StringBuffer(string4.length() + 256);
        stringBuffer.append("/console/login/Login");
        if (string3 != null) {
            stringBuffer.append("?");
            stringBuffer.append("ConsoleLogout=true");
            stringBuffer.append("&");
            bl3 = true;
        } else if (bl) {
            if (!bl3) {
                stringBuffer.append("?");
                bl3 = true;
            }
            stringBuffer.append("ConsoleTimeout=true");
            stringBuffer.append("&");
        }
        if (!bl && !bl2) {
            if (!bl3) {
                stringBuffer.append("?");
                bl3 = true;
            }
            stringBuffer.append("redirect_url");
            stringBuffer.append("=");
            stringBuffer.append("\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        if ((string = httpServletRequest.getQueryString()) != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (string5.startsWith("jato.page")) continue;
                    if (!bl3) {
                        stringBuffer.append("?");
                        bl3 = true;
                    }
                    stringBuffer.append("&");
                    stringBuffer.append(string5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(stringBuffer.toString()));
        }
        catch (Exception exception) {
            Debug.trace1((String)("CoreSessionManagerFilter.sendRedirect() exception: " + exception.getLocalizedMessage()));
        }
    }

    protected void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected boolean skippingSessionFilterAllowed(String string) {
        return false;
    }

    protected Cookie getConsoleCookie(Cookie[] cookieArray) {
        int n = 0;
        while (n < cookieArray.length) {
            Cookie cookie = cookieArray[n];
            if (cookie.getName().equals("com.sun.management.services.session.cookie")) {
                return cookie;
            }
            ++n;
        }
        return null;
    }

    protected HttpSession findConsoleSession(Cookie cookie) {
        String string = cookie.getValue();
        HttpSession httpSession = SessionRepository.getSession(string);
        if (httpSession == null) {
            return null;
        }
        return httpSession;
    }

    private void manageSessions(HttpSession httpSession, HttpSession httpSession2) {
        if (httpSession2 == null || httpSession == null) {
            return;
        }
        SessionManager sessionManager = SessionManager.getSessionManager(httpSession);
        sessionManager.accessed();
        if (httpSession.getId().equals(httpSession2.getId())) {
            return;
        }
        HttpSession httpSession3 = mRegService.getConsoleSession(httpSession2);
        if (httpSession3 != null) {
            if (!httpSession3.getId().equals(httpSession.getId())) {
                Debug.trace1((String)"CoreSessionManagerFilter.addConsoleToCurrentSession console and stored console sessions are not equal");
            }
            return;
        }
        sessionManager.add(httpSession2);
    }

    protected void handleRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) {
        String string = httpServletRequest.getRequestURI();
        String string2 = null;
        if (string.equals("/") || string.equals("/console") || string.equals("/console/")) {
            string2 = "/console/login/Login";
        } else {
            string2 = this.resolveAppURL(string);
            this.checkAppAvail(string2, httpServletRequest, httpServletResponse, "/console/launch/Launch");
            this.checkUserAuth(string2, httpServletRequest, httpServletResponse);
        }
        if (string2 != null && !string2.equals(string)) {
            try {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string2));
            }
            catch (Exception exception) {
                Debug.trace1((String)("CoreSessionManagerFilter.sendRedirect exception: " + exception.getLocalizedMessage()));
            }
        } else {
            try {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception exception) {
                Debug.trace1((String)("CoreSessionManagerFilter:replaceSession-Error: " + exception.getLocalizedMessage()));
            }
        }
    }

    protected void checkAppAvail(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string2) {
        CharSequence charSequence;
        boolean bl = false;
        if (string != null) {
            charSequence = null;
            int n = string.indexOf("/", 1);
            if (n != -1) {
                charSequence = string.substring(0, n + 1);
            }
            if (charSequence != null && ((String)charSequence).equals("/console/")) {
                return;
            }
            String string3 = this.getAppURL((String)charSequence);
            if (string3 != null) {
                return;
            }
            bl = true;
        }
        if (string == null || bl) {
            charSequence = new StringBuffer(256);
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append("?");
            ((StringBuffer)charSequence).append("app_not_avail");
            ((StringBuffer)charSequence).append("=");
            ((StringBuffer)charSequence).append("true");
            try {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(((StringBuffer)charSequence).toString()));
            }
            catch (Exception exception) {
                Debug.trace1((String)("HttpServletResponse.sendRedirect() exception: " + exception.getLocalizedMessage()));
            }
        }
    }

    protected void checkUserAuth(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() < 1) {
            return;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = MgmtAppRegistrationServiceFactory.getPluginName((String)string2);
        RegistrationInfo registrationInfo = MgmtAppRegistrationServiceFactory.getRegistrationInfo((String)string3);
        boolean bl = false;
        try {
            object = new AppFilter();
            if (((AppFilter)object).checkUserPermission(httpServletRequest, registrationInfo)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            object = new StringBuffer(256);
            ((StringBuffer)object).append("/console/launch/Launch");
            ((StringBuffer)object).append("?");
            ((StringBuffer)object).append("user_not_auth");
            ((StringBuffer)object).append("=");
            ((StringBuffer)object).append("true");
            try {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(((StringBuffer)object).toString()));
            }
            catch (Exception exception) {
                Debug.trace1((String)("HttpServletResponse.sendRedirect() exception: " + exception.getLocalizedMessage()));
            }
        }
    }

    protected String resolveAppURL(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (stringTokenizer.countTokens() != 1) {
            return string;
        }
        String string2 = stringTokenizer.nextToken();
        string2 = "/" + string2 + "/";
        return this.getAppURL(string2);
    }

    protected String getAppURL(String string) {
        MgmtAppRegistrationService mgmtAppRegistrationService = MgmtAppRegistrationServiceFactory.getRegistrationService();
        return mgmtAppRegistrationService.getAppURL(string);
    }
}

