/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.AppDescriptorParser;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.xml.sax.InputSource;

public class MgmtAppRegistrationServiceImpl
implements MgmtAppRegistrationService {
    private HashMap consoleApps = new HashMap();
    private HashMap registeredApps = new HashMap();
    private HashMap registeredAppDirs = new HashMap();
    private HashMap registeredAppNames = new HashMap();
    private static Hashtable urlTable = new Hashtable();
    private String registrationURL = null;
    private long tmpFileCounter = 0L;

    public String[] getConsoleRegisteredApps() {
        String[] stringArray = new String[this.consoleApps.size()];
        Iterator iterator = this.consoleApps.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public String[] getAllRegisteredApps() {
        String[] stringArray = new String[this.registeredApps.size()];
        Iterator iterator = this.registeredApps.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = (String)iterator.next();
        }
        return stringArray;
    }

    public RegistrationInfo getRegistrationInfo(String string) {
        if (string == null) {
            return null;
        }
        RegistrationInfo registrationInfo = (RegistrationInfo)this.consoleApps.get(string);
        if (registrationInfo != null) {
            return registrationInfo;
        }
        return (RegistrationInfo)this.registeredApps.get(string);
    }

    public boolean isAppRegistered(String string) {
        if (string == null) {
            return false;
        }
        if (this.registeredApps.get(string) != null) {
            return true;
        }
        return this.consoleApps.get(string) != null;
    }

    public String getRegisteredAppDir(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return (String)this.registeredAppDirs.get(string);
    }

    public String getPluginName(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return (String)this.registeredAppNames.get(string);
    }

    public RegistrationInfo registerApp(String string) throws RegistrationException {
        return this.registerApp(new StringReader(string));
    }

    public RegistrationInfo registerApp(Reader reader) throws RegistrationException {
        RegistrationInfo registrationInfo = null;
        try {
            int n;
            InputSource inputSource = new InputSource(reader);
            AppDescriptorParser appDescriptorParser = new AppDescriptorParser();
            registrationInfo = appDescriptorParser.parse(inputSource);
            MgmtAppRegistrationServiceImpl.printDebug(registrationInfo);
            String string = registrationInfo.getManagementApp().getPluginName();
            String string2 = registrationInfo.getUrlDesc().getUrl();
            if (registrationInfo.getManagementApp().getCategory().equalsIgnoreCase("Console")) {
                this.consoleApps.put(string, registrationInfo);
            } else {
                this.registeredApps.put(string, registrationInfo);
                n = string2.indexOf("/", 1);
                if (n != -1) {
                    urlTable.put(string2.substring(0, n + 1), string2);
                }
            }
            n = string2.indexOf("/");
            if (n >= 0 && (n = (string2 = string2.substring(n + 1)).indexOf("/")) >= 0) {
                string2 = string2.substring(0, n);
            }
            this.registeredAppDirs.put(string, string2);
            this.registeredAppNames.put(string2, string);
        }
        catch (Exception exception) {
            throw new RegistrationException(exception.getMessage());
        }
        return registrationInfo;
    }

    public void unregisterApp(String string) {
        this.registeredApps.remove(string);
        String string2 = (String)this.registeredAppDirs.get(string);
        this.registeredAppDirs.remove(string);
        this.registeredAppNames.remove(string2);
    }

    public String getAppURL(String string) {
        if (string == null) {
            return null;
        }
        return (String)urlTable.get(string);
    }

    public HttpSession getConsoleSession(HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        HttpSession httpSession2 = null;
        try {
            httpSession2 = (HttpSession)httpSession.getAttribute("com.sun.web.console.constant.newAppSession");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpSession2;
    }

    public static void printDebug(RegistrationInfo registrationInfo) {
        if (registrationInfo == null) {
            return;
        }
        if (!Debug.isOn()) {
            return;
        }
        Debug.trace1((String)"\n---------------------------------------------");
        Debug.trace1((String)"---------- Registration Information ---------\n");
        Debug.trace1((String)registrationInfo.toString());
        Debug.trace1((String)"\n---------------------------------------------\n");
    }
}

