/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.common;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConsoleException
extends Exception {
    public static final String DEFAULT_BUNDLE = "com.sun.management.services.common.resources.ExceptionResources";
    protected String bundleName = null;
    protected ClassLoader resourceClassLoader = null;
    protected Vector subargs = null;
    protected Exception subexcept = null;

    public ConsoleException(String string) {
        super(string);
    }

    public ConsoleException(String string, String[] stringArray) {
        super(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addArg(stringArray[n]);
                ++n;
            }
        }
    }

    public ConsoleException(String string, Exception exception) {
        super(string);
        this.subexcept = exception;
    }

    public ConsoleException(String string, String[] stringArray, Exception exception) {
        super(string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.addArg(stringArray[n]);
                ++n;
            }
        }
        this.subexcept = exception;
    }

    public void addArg(Object object) {
        this.addNextArg(object);
    }

    public void addArg(String string) {
        this.addNextArg(string);
    }

    public void addArg(Integer n) {
        this.addNextArg(n);
    }

    public void addArg(Long l) {
        this.addNextArg(l);
    }

    public void addArg(Date date) {
        this.addNextArg(date);
    }

    public String getMessage() {
        Locale locale = new Locale("", "");
        return this.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage() {
        Locale locale = Locale.getDefault();
        return this.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(Locale locale) {
        String string = super.getMessage();
        int n = 0;
        if (this.subargs != null) {
            n = this.subargs.size();
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.subargs.elementAt(n2);
            ++n2;
        }
        try {
            string = MessageFormat.format(this.getPattern(string, locale), objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean isEmbeddedException() {
        return this.subexcept != null;
    }

    public Exception getEmbeddedException() {
        return this.subexcept;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        if (string2 != null) {
            string = string.concat(": ");
            string = string.concat(string2);
        }
        return string;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.subexcept != null) {
            this.subexcept.printStackTrace();
        }
    }

    public String formatForLogging() {
        String string = "";
        string = this.getBundleName();
        string = string + "&!$";
        string = string + super.getMessage();
        if (this.subargs != null) {
            int n = 0;
            while (n < this.subargs.size()) {
                string = string + "&!$";
                Object e = this.subargs.elementAt(n);
                string = string + e.toString();
                ++n;
            }
        }
        return string;
    }

    public static ConsoleException parseLogStr(String string) {
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, "&!$", false);
        }
        if (stringTokenizer != null) {
            String string2;
            String string3;
            try {
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
            ConsoleException consoleException = new ConsoleException(string2);
            consoleException.setBundleName(string3);
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    consoleException.addArg(stringTokenizer.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    return consoleException;
                }
            }
            return consoleException;
        }
        return null;
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public void setResourceClassLoader(ClassLoader classLoader) {
        this.resourceClassLoader = classLoader;
    }

    protected String getBundleName() {
        if (this.bundleName == null) {
            return DEFAULT_BUNDLE;
        }
        return this.bundleName;
    }

    protected ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    protected void addNextArg(Object object) {
        if (this.subargs == null) {
            this.subargs = new Vector();
        }
        if (this.subargs.size() < 10) {
            this.subargs.addElement(object);
        }
    }

    protected String getPattern(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string3 = this.getBundleName();
        try {
            resourceBundle = this.getResourceClassLoader() == null ? ResourceBundle.getBundle(string3, locale) : ResourceBundle.getBundle(string3, locale, this.getResourceClassLoader());
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }
}

