/*
 * Copyright 2004 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_AUXV_386_H
#define	_SYS_AUXV_386_H

#pragma ident	"@(#)auxv_386.h	1.1	04/02/13 SMI"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Flags used in AT_SUN_HWCAP elements to describe various userland
 * instruction set extensions available on different processors.
 * The basic assumption is that of the i386 ABI; that is, i386 plus i387
 * floating point.
 *
 * Note that if a given bit is set; the implication is that the kernel
 * provides all the underlying architectural support for the correct
 * functioning of the extended instruction(s).
 */
#define	AV_386_FPU		0x0001	/* x87-style floating point */
#define	AV_386_TSC		0x0002	/* rdtsc insn */
#define	AV_386_CX8		0x0004	/* cmpxchg8 insn */
#define	AV_386_SEP		0x0008	/* sysenter and sysexit */
#define	AV_386_AMD_SYSC		0x0010	/* AMD's syscall and sysret */
#define	AV_386_CMOV		0x0020	/* conditional move insns */
#define	AV_386_MMX		0x0040	/* MMX insns */
#define	AV_386_AMD_MMX		0x0080	/* AMD's MMX insns */
#define	AV_386_AMD_3DNow	0x0100	/* AMD's 3Dnow! insns */
#define	AV_386_AMD_3DNowx	0x0200	/* AMD's 3Dnow! extended insns */
#define	AV_386_FXSR		0x0400	/* fxsave and fxrstor */
#define	AV_386_SSE		0x0800	/* SSE insns and regs */
#define	AV_386_SSE2		0x1000	/* SSE2 insns and regs */
#define	AV_386_PAUSE		0x2000	/* use pause insn (in spin loops) */

#define	FMT_AV_386					\
	"\20"						\
	"\16pause\15sse2\14sse\13fxsr\12amd3dx\11amd3d"	\
	"\10amdmmx\7mmx\6cmov\5amdsysc\4sep\3cx8\2tsc\1fpu"

#ifdef __cplusplus
}
#endif

#endif	/* !_SYS_AUXV_386_H */
