/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTableTabbedPane;
import com.sun.wbem.apps.cimworkshop.ClassTreeActionPane;
import com.sun.wbem.apps.common.AboutDialog;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.NameSpaceDialog;
import com.sun.wbem.apps.common.ToolBarPanel;
import com.sun.wbem.apps.common.Util;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;

public class ObjectTreeFrame
extends JFrame
implements WindowListener,
ItemListener,
ActionListener,
TreeSelectionListener {
    private CIMObjectPath delivery;
    private ClassTreeActionPane treePane;
    private CIMTableTabbedPane tablePane;
    private JSplitPane desktop;
    private JSplitPane fullPanel;
    private JComboBox nameSpaceList;
    private String prevNameSpace = "";
    private NameSpaceDialog nsDlg;
    private DefaultComboBoxModel cbModel = null;
    private boolean repopulating = false;
    private JTextArea eventOutputArea;
    private JMenu mnuWorkshop;
    private JMenu mnuAction;
    private JMenu mnuNamespace;
    private JMenu mnuProperties;
    private JMenu mnuMethods;
    private JMenu mnuHelp;
    private JMenuItem mnuChangeHost;
    private JMenuItem mnuChangeNamespace;
    private JMenuItem mnuExit;
    private JMenuItem mnuAddClass;
    private JMenuItem mnuDeleteClass;
    private JMenuItem mnuExecQuery;
    private JMenuItem mnuFindClass;
    private JMenuItem mnuInstances;
    private JMenuItem mnuClassQualifiers;
    private JMenuItem mnuPropertyQualifiers;
    private JMenuItem mnuMethodQualifiers;
    private JMenuItem mnuQualifierType;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuHelpAbout;
    private JMenuItem mnuAssocTraversal;
    private JMenuItem mnuShowPropertyValue;
    private JButton btnInstances;
    private JButton btnQualifiers;
    private JButton btnAddClass;

    public ObjectTreeFrame() {
        this.setTitle(I18N.loadStringFormat("TTL_CIM_WORKSHOP", I18N.loadString("LBL_NOT_CONNECTED")));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.eventOutputArea = new JTextArea();
        this.eventOutputArea.setWrapStyleWord(true);
        this.eventOutputArea.setEditable(false);
        this.fullPanel = new JSplitPane(0, true);
        this.fullPanel.setOneTouchExpandable(true);
        this.desktop = new JSplitPane(1, true);
        this.tablePane = new CIMTableTabbedPane(){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.tablePane.addEventsTab();
        this.treePane = new ClassTreeActionPane(this, this.tablePane){

            public Insets getInsets() {
                return new Insets(5, 5, 5, 5);
            }
        };
        this.treePane.addTreeSelectionListener(this);
        this.desktop.setLeftComponent(this.treePane);
        this.desktop.setRightComponent(this.tablePane);
        this.createMenuBar();
        this.createToolBar(jPanel);
        this.fullPanel.setTopComponent(this.desktop);
        this.eventOutputArea.setBorder(BorderFactory.createBevelBorder(1));
        JScrollPane jScrollPane = new JScrollPane(this.eventOutputArea);
        ActionString actionString = new ActionString("LBL_EVENT_OUTPUT");
        JLabel jLabel = new JLabel(actionString.getString() + ":");
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        jScrollPane.setColumnHeaderView(jLabel);
        jLabel.setLabelFor(this.eventOutputArea);
        this.fullPanel.setBottomComponent(jScrollPane);
        jPanel.add("Center", this.fullPanel);
        this.setSize(750, 550);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        this.setLocation(point.x - this.getSize().width / 2, point.y - this.getSize().height / 2);
    }

    public boolean login() {
        boolean bl = false;
        Util.waitOn(this);
        if (this.treePane.getHostInfo()) {
            this.show();
            this.desktop.setDividerLocation(0.4);
            bl = true;
        }
        Util.waitOff(this);
        return bl;
    }

    public void initializeNewHost() {
        boolean bl = CIMClientObject.userHasWritePermission();
        this.enableWritableMenuItems(bl);
        this.setTitle(I18N.loadStringFormat("TTL_CONNECTED", CIMClientObject.getHostName()));
        this.populateNameSpaceComboBox();
        this.prevNameSpace = "";
        this.setSelectedNameSpace(Util.cleanNameSpaceString(CIMClientObject.getNameSpace()));
        this.initializeEventListener();
    }

    private void populateNameSpaceComboBox() {
        this.repopulating = true;
        Enumeration enumeration = NameSpaceDialog.getAllNameSpaces();
        this.cbModel.removeAllElements();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
            String string = Util.cleanNameSpaceString(cIMObjectPath.getNameSpace());
            this.cbModel.addElement(string);
        }
        this.repopulating = false;
    }

    public void enableWritableMenuItems(boolean bl) {
        this.mnuAddClass.setEnabled(bl);
        this.mnuDeleteClass.setEnabled(bl);
        this.btnAddClass.setEnabled(bl);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Util.setWaitCursor(this);
        String string = treeSelectionEvent.getPath().getLastPathComponent().toString();
        boolean bl = true;
        CIMClass cIMClass = null;
        if (this.treePane.isRootSelected()) {
            bl = false;
            this.treePane.populateTables(null);
        } else {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(string);
            try {
                CIMClient cIMClient = CIMClientObject.getClient();
                if (cIMClient == null) {
                    return;
                }
                cIMClass = cIMClient.getClass(cIMObjectPath, false, true, true, null);
                this.treePane.populateTables(cIMClass);
            }
            catch (CIMException cIMException) {
                CIMErrorDialog.display(this, cIMException);
            }
        }
        this.mnuAssocTraversal.setEnabled(bl);
        this.mnuClassQualifiers.setEnabled(bl);
        this.mnuDeleteClass.setEnabled(bl && CIMClientObject.userHasWritePermission());
        this.btnQualifiers.setEnabled(bl);
        this.mnuPropertyQualifiers.setEnabled(bl && this.tablePane.isPropertySelected());
        this.mnuShowPropertyValue.setEnabled(bl && this.tablePane.isPropertySelected());
        this.mnuMethodQualifiers.setEnabled(bl && this.tablePane.isMethodSelected());
        if (cIMClass != null) {
            bl = bl && cIMClass.isKeyed();
        }
        this.btnInstances.setEnabled(bl);
        this.mnuInstances.setEnabled(bl);
        this.treePane.enableInstanceMenuItem(bl);
        Util.setDefaultCursor(this);
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        ActionString actionString = new ActionString("MNU_WORKSHOP");
        ActionString actionString2 = new ActionString("MNU_ACTION", "com.sun.wbem.apps.common.common");
        ActionString actionString3 = new ActionString("MNU_NAMESPACE");
        ActionString actionString4 = new ActionString("MNU_PROPERTIES");
        ActionString actionString5 = new ActionString("MNU_METHODS");
        ActionString actionString6 = new ActionString("MNU_HELP", "com.sun.wbem.apps.common.common");
        ActionString actionString7 = new ActionString("MNU_REFRESH_CLASS");
        ActionString actionString8 = new ActionString("MNU_EXIT", "com.sun.wbem.apps.common.common");
        ActionString actionString9 = new ActionString("MNU_CHANGE_HOST");
        ActionString actionString10 = new ActionString("MNU_CHANGE_NAMESPACE");
        ActionString actionString11 = new ActionString("MNU_ADD_CLASS");
        ActionString actionString12 = new ActionString("MNU_DELETE_CLASS");
        ActionString actionString13 = new ActionString("MNU_FIND_CLASS");
        ActionString actionString14 = new ActionString("MNU_INSTANCES");
        ActionString actionString15 = new ActionString("MNU_CLASS_QUALIFIERS");
        ActionString actionString16 = new ActionString("MNU_QUALIFIERS");
        ActionString actionString17 = new ActionString("MNU_ADD_QUALIFIER_TYPE");
        ActionString actionString18 = new ActionString("MNU_ASSOC_TRAVERSAL");
        ActionString actionString19 = new ActionString("MNU_EXEC_QUERY");
        ActionString actionString20 = new ActionString("MNU_ABOUT_CIMWORKSHOP");
        ActionString actionString21 = new ActionString("MNU_CLEAR_EVENT_OUTPUT");
        ActionString actionString22 = new ActionString("MNU_SHOW_VALUE");
        this.mnuWorkshop = new JMenu(actionString.getString());
        this.mnuWorkshop.setMnemonic(actionString.getMnemonic());
        this.mnuAction = new JMenu(actionString2.getString());
        this.mnuAction.setMnemonic(actionString2.getMnemonic());
        this.mnuNamespace = new JMenu(actionString3.getString());
        this.mnuNamespace.setMnemonic(actionString3.getMnemonic());
        this.mnuProperties = new JMenu(actionString4.getString());
        this.mnuProperties.setMnemonic(actionString4.getMnemonic());
        this.mnuMethods = new JMenu(actionString5.getString());
        this.mnuMethods.setMnemonic(actionString5.getMnemonic());
        this.mnuHelp = new JMenu(actionString6.getString());
        this.mnuHelp.setMnemonic(actionString6.getMnemonic());
        jMenuBar.add(this.mnuWorkshop);
        jMenuBar.add(this.mnuAction);
        jMenuBar.add(this.mnuHelp);
        this.mnuChangeHost = new JMenuItem(actionString9.getString());
        this.mnuChangeHost.setMnemonic(actionString9.getMnemonic());
        this.mnuChangeHost.addActionListener(this.treePane);
        this.mnuChangeHost.setActionCommand("hostDialog");
        this.mnuChangeNamespace = new JMenuItem(actionString10.getString());
        this.mnuChangeNamespace.setMnemonic(actionString10.getMnemonic());
        this.mnuChangeNamespace.addActionListener(this);
        this.mnuChangeNamespace.setActionCommand("CHANGE_NAMESPACE");
        this.mnuExit = new JMenuItem(actionString8.getString());
        this.mnuExit.setMnemonic(actionString8.getMnemonic());
        this.mnuExit.setActionCommand("EXIT");
        this.mnuExit.addActionListener(this);
        this.mnuAddClass = new JMenuItem(actionString11.getString());
        this.mnuAddClass.setMnemonic(actionString11.getMnemonic());
        this.mnuAddClass.setActionCommand("ADD_CLASS");
        this.mnuAddClass.addActionListener(this.treePane);
        this.mnuDeleteClass = new JMenuItem(actionString12.getString());
        this.mnuDeleteClass.setMnemonic(actionString12.getMnemonic());
        this.mnuDeleteClass.setActionCommand("DELETE_CLASS");
        this.mnuDeleteClass.addActionListener(this.treePane);
        this.mnuFindClass = new JMenuItem(actionString13.getString());
        this.mnuFindClass.setMnemonic(actionString13.getMnemonic());
        this.mnuFindClass.setActionCommand("FIND_CLASS");
        this.mnuFindClass.addActionListener(this.treePane);
        this.mnuInstances = new JMenuItem(actionString14.getString());
        this.mnuInstances.setMnemonic(actionString14.getMnemonic());
        this.mnuInstances.setActionCommand("INSTANCES");
        this.mnuInstances.addActionListener(this.treePane);
        this.mnuClassQualifiers = new JMenuItem(actionString15.getString());
        this.mnuClassQualifiers.setMnemonic(actionString15.getMnemonic());
        this.mnuClassQualifiers.setActionCommand("QUALIFIERS");
        this.mnuClassQualifiers.addActionListener(this.treePane);
        this.mnuPropertyQualifiers = new JMenuItem(actionString16.getString());
        this.mnuPropertyQualifiers.setMnemonic(actionString16.getMnemonic());
        this.mnuPropertyQualifiers.setActionCommand("QUALIFIERS");
        this.mnuPropertyQualifiers.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuShowPropertyValue = new JMenuItem(actionString22.getString());
        this.mnuShowPropertyValue.setMnemonic(actionString22.getMnemonic());
        this.mnuShowPropertyValue.setActionCommand("SHOW_VALUE");
        this.mnuShowPropertyValue.addActionListener(this.tablePane.getPropertiesTable());
        this.mnuMethodQualifiers = new JMenuItem(actionString16.getString());
        this.mnuMethodQualifiers.setMnemonic(actionString16.getMnemonic());
        this.mnuMethodQualifiers.setActionCommand("QUALIFIERS");
        this.mnuMethodQualifiers.addActionListener(this.tablePane.getMethodsTable());
        this.mnuQualifierType = new JMenuItem(actionString17.getString());
        this.mnuQualifierType.setMnemonic(actionString17.getMnemonic());
        this.mnuQualifierType.setActionCommand("ADD_QUALIFIER_TYPE");
        this.mnuQualifierType.addActionListener(this.treePane);
        this.mnuAssocTraversal = new JMenuItem(actionString18.getString());
        this.mnuAssocTraversal.setMnemonic(actionString18.getMnemonic());
        this.mnuAssocTraversal.setActionCommand("ASSOC_TRAVERSAL");
        this.mnuAssocTraversal.addActionListener(this.treePane);
        this.mnuExecQuery = new JMenuItem(actionString19.getString());
        this.mnuExecQuery.setMnemonic(actionString19.getMnemonic());
        this.mnuExecQuery.setActionCommand("EXEC_QUERY");
        this.mnuExecQuery.addActionListener(this.treePane);
        this.mnuRefresh = new JMenuItem(actionString7.getString());
        this.mnuRefresh.setMnemonic(actionString7.getMnemonic());
        this.mnuRefresh.setActionCommand("REFRESH");
        this.mnuRefresh.addActionListener(this.treePane);
        JMenuItem jMenuItem = new JMenuItem(actionString21.getString());
        jMenuItem.setMnemonic(actionString21.getMnemonic());
        jMenuItem.setActionCommand("CLEAR_EVENT_OUTPUT");
        jMenuItem.addActionListener(this);
        this.mnuHelpAbout = new JMenuItem(actionString20.getString());
        this.mnuHelpAbout.setMnemonic(actionString20.getMnemonic());
        this.mnuHelpAbout.setActionCommand("ABOUT_CIMWORKSHOP");
        this.mnuHelpAbout.addActionListener(this);
        this.mnuNamespace.add(this.mnuQualifierType);
        this.mnuProperties.add(this.mnuPropertyQualifiers);
        this.mnuProperties.add(this.mnuShowPropertyValue);
        this.mnuMethods.add(this.mnuMethodQualifiers);
        this.mnuWorkshop.add(this.mnuChangeHost);
        this.mnuWorkshop.addSeparator();
        this.mnuWorkshop.add(this.mnuChangeNamespace);
        this.mnuWorkshop.addSeparator();
        this.mnuWorkshop.add(this.mnuExit);
        this.mnuAction.add(this.mnuAddClass);
        this.mnuAction.add(this.mnuDeleteClass);
        this.mnuAction.add(this.mnuFindClass);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuInstances);
        this.mnuAction.add(this.mnuClassQualifiers);
        this.mnuAction.add(this.mnuAssocTraversal);
        this.mnuAction.add(this.mnuExecQuery);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuNamespace);
        this.mnuAction.add(this.mnuProperties);
        this.mnuAction.add(this.mnuMethods);
        this.mnuAction.addSeparator();
        this.mnuAction.add(this.mnuRefresh);
        this.mnuAction.add(jMenuItem);
        this.mnuHelp.add(this.mnuHelpAbout);
    }

    private void createToolBar(JPanel jPanel) {
        ToolBarPanel toolBarPanel = new ToolBarPanel();
        toolBarPanel.createButton(Util.loadImageIcon("new_host.gif"), I18N.loadString("TIP_HOSTNAME"), "hostDialog", this.treePane);
        this.cbModel = new DefaultComboBoxModel();
        this.nameSpaceList = new JComboBox(this.cbModel);
        this.nameSpaceList.addItemListener(this);
        this.nameSpaceList.setEditable(false);
        toolBarPanel.addComponent(this.nameSpaceList);
        toolBarPanel.createButton(Util.loadImageIcon("chng_namespace.gif"), I18N.loadString("TIP_NAMESPACE"), "CHANGE_NAMESPACE", this);
        toolBarPanel.createButton(Util.loadImageIcon("find_class.gif"), I18N.loadString("TIP_FIND_CLASS"), "FIND_CLASS", this.treePane);
        this.btnAddClass = toolBarPanel.createButton(Util.loadImageIcon("addclass.gif"), I18N.loadString("TIP_ADD_CLASS"), "ADD_CLASS", this.treePane);
        this.btnInstances = toolBarPanel.createButton(Util.loadImageIcon("instances.gif"), I18N.loadString("TIP_INSTANCES"), "INSTANCES", this.treePane);
        this.btnQualifiers = toolBarPanel.createButton(Util.loadImageIcon("qualifiers.gif"), I18N.loadString("TIP_CLASS_QUALIFIERS"), "QUALIFIERS", this.treePane);
        toolBarPanel.createButton(Util.loadImageIcon("refresh.gif"), I18N.loadString("TIP_REFRESH_CLASS"), "REFRESH", this.treePane);
        jPanel.add("North", toolBarPanel);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() == "select name space") {
            this.populateNameSpaceComboBox();
            this.nsDlg.setVisible(false);
            this.setSelectedNameSpace(this.nsDlg.getSelectedNameSpace());
            this.nsDlg.dispose();
            Util.waitOff(this);
        } else if (itemEvent.getItem().equals("dialog cancel")) {
            this.populateNameSpaceComboBox();
            Util.waitOff(this);
        } else if (itemEvent.getStateChange() == 1) {
            this.setSelectedNameSpace((String)itemEvent.getItem());
        }
    }

    public void setSelectedNameSpace(String string) {
        if (this.repopulating) {
            return;
        }
        CIMClient cIMClient = CIMClientObject.changeNameSpace("");
        try {
            cIMClient.enumQualifierTypes(new CIMObjectPath("", string));
        }
        catch (CIMException cIMException) {
            if (cIMException.getID().equals("CIM_ERR_INVALID_NAMESPACE")) {
                JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_NAMESPACE", string), I18N.loadString("TTL_CIM_ERROR"), 0);
            }
            this.populateNameSpaceComboBox();
            string = this.prevNameSpace;
        }
        if (!this.prevNameSpace.equals(string) && CIMClientObject.initialize(string)) {
            this.treePane.initializeClassTree();
        }
        this.prevNameSpace = string;
        this.cbModel.setSelectedItem(string);
    }

    public void initializeEventListener() {
        this.tablePane.deleteEventSubscriptions();
        CIMClient cIMClient = CIMClientObject.getClient();
        try {
            CIMClass cIMClass = cIMClient.getClass(new CIMObjectPath("CIM_IndicationFilter"), true, true, true, null);
            cIMClient.addCIMListener(new CIMListener(){

                public void indicationOccured(CIMEvent cIMEvent) {
                    String string = cIMEvent.getIndication().toString();
                    ObjectTreeFrame.this.eventOutputArea.append(string + "\n");
                }
            });
            CIMInstance cIMInstance = cIMClient.getIndicationHandler(null);
            CIMObjectPath cIMObjectPath = cIMClient.createInstance(new CIMObjectPath(), cIMInstance);
            this.tablePane.initializeEvents(cIMObjectPath, cIMClient);
        }
        catch (CIMException cIMException) {
            this.tablePane.initializeEvents(null, cIMClient);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("CHANGE_NAMESPACE")) {
            Util.waitOn(this);
            this.nsDlg = new NameSpaceDialog(this);
            this.nsDlg.addItemListener(this);
            this.nsDlg.setVisible(true);
        } else if (string.equals("ABOUT_CIMWORKSHOP")) {
            Util.setWaitCursor(this);
            String string2 = "2.5.0 09/09/04:18:45";
            AboutDialog aboutDialog = new AboutDialog(this, "CIM Workshop", string2, "Copyright 2001 Sun Microsystems, Inc.\nAll rights reserved.", null);
            Util.setDefaultCursor(this);
        } else if (string.equals("CLEAR_EVENT_OUTPUT")) {
            this.eventOutputArea.setText("");
        } else if (string.equals("EXIT")) {
            this.exitCIMWorkshop();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitCIMWorkshop();
    }

    private void exitCIMWorkshop() {
        if (this.nsDlg != null) {
            this.nsDlg.dispose();
        }
        this.tablePane.deleteEventSubscriptions();
        this.dispose();
        System.exit(0);
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.fullPanel.setDividerLocation(0.8);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

