/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTypes;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.AdminDialog;
import com.sun.wbem.apps.common.CancelObject;
import com.sun.wbem.apps.common.ColumnLayout;
import com.sun.wbem.apps.common.ContextHelpListener;
import com.sun.wbem.apps.common.GenInfoPanel;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.LAYOUT_ALIGNMENT;
import com.sun.wbem.apps.common.TextFieldFocusListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;

public class CIMEditDialog
extends AdminDialog
implements DocumentListener {
    private JButton okBtn;
    private JButton cancelBtn;
    private GenInfoPanel infoPanel = super.getInfoPanel();
    protected JTextField nameField;
    protected JTextField valueField;
    protected String returnString = null;
    protected String nameString = null;
    protected Object returnObject = null;
    protected String dataType;
    protected int cimType;
    protected CIMTypes cimTypes;
    protected boolean isEditable = true;
    private JPanel mainPanel;

    public CIMEditDialog(Frame frame) {
        this(frame, "", "", true);
    }

    public CIMEditDialog(Frame frame, String string, String string2) {
        this(frame, string, string2, true);
    }

    public CIMEditDialog(Frame frame, String string, String string2, boolean bl) {
        super(frame, I18N.loadString("TTL_DLG_CIM_WORKSHOP"), false);
        Object object;
        Object object2;
        this.isEditable = bl;
        this.cancelBtn = this.getCancelBtn();
        this.cancelBtn.addActionListener(new OKCancelButtonListener());
        this.okBtn = this.getOKBtn();
        if (this.isEditable) {
            this.okBtn.addActionListener(new OKCancelButtonListener());
            this.setTitle(I18N.loadStringFormat("TTL_SET_VALUE", string));
        } else {
            object2 = this.getbuttonPanel();
            ((Container)object2).remove(this.okBtn);
            object = new ActionString("LBL_CLOSE", "com.sun.wbem.apps.common.common");
            this.cancelBtn.setText(((ActionString)object).getString());
            this.cancelBtn.setMnemonic(((ActionString)object).getMnemonic());
            this.setTitle(I18N.loadStringFormat("TTL_SHOW_VALUE", string));
        }
        this.mainPanel = this.getRightPanel();
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(25, 15, 15, 15));
        this.mainPanel.setLayout(new ColumnLayout(LAYOUT_ALIGNMENT.EXPAND));
        this.dataType = string2;
        this.cimTypes = new CIMTypes();
        this.cimType = this.cimTypes.getCIMType(string2);
        object2 = new ActionString("LBL_TYPE");
        object = new JLabel(((ActionString)object2).getString() + ":  " + string2);
        if (string == null) {
            this.nameField = new JTextField();
            if (this.isEditable) {
                this.nameField.getDocument().addDocumentListener(this);
                this.nameField.addFocusListener(new TextFieldFocusListener());
            } else {
                this.nameField.setEnabled(false);
            }
            this.mainPanel.add(this.nameField);
        } else {
            ActionString actionString = new ActionString("LBL_NAME", "com.sun.wbem.apps.common.common");
            JLabel jLabel = new JLabel(actionString.getString() + ":  " + string);
            this.mainPanel.add(jLabel);
            this.nameString = string;
        }
        this.mainPanel.add((Component)object);
        this.setOKEnabled();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    protected void setDefaultHelp(String string) {
        GenInfoPanel genInfoPanel = this.getInfoPanel();
        this.setDefaultFocusListener(new ContextHelpListener(genInfoPanel, "cimworkshop", string), true);
        if (this.okBtn != null) {
            this.okBtn.addFocusListener(new ContextHelpListener(genInfoPanel, "cimworkshop", string));
        }
        if (this.cancelBtn != null) {
            this.cancelBtn.addFocusListener(new ContextHelpListener(genInfoPanel, "cimworkshop", string));
        }
    }

    public GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public void okClicked() {
        if (this.valueField != null) {
            this.returnString = this.valueField.getText().trim();
        }
        if (this.nameField != null) {
            this.nameString = this.nameField.getText().trim();
        }
        if (this.setReturnObject()) {
            this.dispose();
        }
    }

    public void cancelClicked() {
        this.returnString = null;
        this.returnObject = new CancelObject();
        this.nameString = null;
        this.dispose();
    }

    public Object getValueObject() {
        return this.returnObject;
    }

    public String getValueString() {
        return this.returnString;
    }

    public String getNameString() {
        return this.nameString;
    }

    public void windowOpened(WindowEvent windowEvent) {
        if (!this.isEditable) {
            this.cancelBtn.requestFocus();
        } else if (this.nameField != null) {
            this.nameField.requestFocus();
        } else if (this.valueField != null) {
            this.valueField.requestFocus();
        } else {
            this.okBtn.requestFocus();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setOKEnabled();
    }

    public void setOKEnabled() {
        boolean bl = true;
        if (!this.isEditable) {
            return;
        }
        if (this.nameField != null) {
            bl = this.nameField.getText().trim().length() != 0;
        }
        this.okBtn.setEnabled(bl);
    }

    public void setOKEnabled(boolean bl) {
        this.okBtn.setEnabled(bl);
    }

    public boolean setReturnObject() {
        if (this.returnString == null) {
            this.returnObject = null;
            return false;
        }
        if (this.returnString.length() == 0) {
            this.returnObject = null;
            return true;
        }
        try {
            switch (this.cimType) {
                case 1: {
                    this.returnObject = new Byte(this.returnString);
                    break;
                }
                case 3: {
                    this.returnObject = new Short(this.returnString);
                    break;
                }
                case 5: {
                    this.returnObject = new Integer(this.returnString);
                    break;
                }
                case 7: {
                    this.returnObject = new Long(this.returnString);
                    break;
                }
                case 0: {
                    this.returnObject = new UnsignedInt8(this.returnString);
                    break;
                }
                case 2: {
                    this.returnObject = new UnsignedInt16(this.returnString);
                    break;
                }
                case 4: {
                    this.returnObject = new UnsignedInt32(this.returnString);
                    break;
                }
                case 6: {
                    this.returnObject = new UnsignedInt64(this.returnString);
                    break;
                }
                case 8: {
                    this.returnObject = this.returnString;
                    break;
                }
                case 9: {
                    ActionString actionString = new ActionString("LBL_TRUE", "com.sun.wbem.apps.common.common");
                    boolean bl = this.returnString.equals(actionString.getString());
                    this.returnObject = new Boolean(bl);
                    break;
                }
                case 10: {
                    this.returnObject = new Float(this.returnString);
                    break;
                }
                case 11: {
                    this.returnObject = new Double(this.returnString);
                    break;
                }
                case 12: {
                    this.returnObject = new CIMDateTime(this.returnString);
                    break;
                }
                case 13: {
                    this.returnObject = new Character(this.returnString.charAt(0));
                    break;
                }
                default: {
                    this.returnObject = this.returnString;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, I18N.loadStringFormat("ERR_INVALID_VALUE_TYPE", this.returnString, (Object)this.dataType), I18N.loadString("TTL_CIM_ERROR"), 0);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, I18N.loadString("ERR_INVALID_DATETIME_STRING"), I18N.loadString("TTL_CIM_ERROR"), 0);
            return false;
        }
        return true;
    }

    class OKCancelButtonListener
    implements ActionListener {
        OKCancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == CIMEditDialog.this.cancelBtn) {
                CIMEditDialog.this.cancelClicked();
            } else if (actionEvent.getSource() == CIMEditDialog.this.okBtn) {
                CIMEditDialog.this.okClicked();
            }
        }
    }
}

