/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.AdminSecurityUtil;
import com.sun.wbem.solarisprovider.usermgr.common.SolAccountAttr;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class SolarisShadowTable {
    private static String tableName = "shadow";
    private String emptyString = new String("");
    private String fileType = new String("File");
    private long secondsInaDay = 86400L;
    private String GMT_TIMEZONE = "GMT";
    private String nullPassword = "";
    private String accountLockedValue = "*LK*";
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String lastchngCol = "lastchg";
    private String minCol = "min";
    private String maxCol = "max";
    private String warnCol = "warn";
    private String inactiveCol = "inactive";
    private String exCol = "expire";
    private String flagCol = "flag";
    private int nameColNum = 0;
    private int passwdColNum = 0;
    private int lastchngColNum = 0;
    private int minColNum = 0;
    private int maxColNum = 0;
    private int warnColNum = 0;
    private int inactiveColNum = 0;
    private int exColNum = 0;
    private int flagColNum = 0;
    private String scope;

    public SolarisShadowTable(String string) throws Exception {
        this.scope = string;
    }

    private String setUpExpirationDate(String string) {
        Date date;
        String string2 = "";
        if (string == null || string.equals("")) {
            return string2;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            return string2;
        }
        long l = date.getTime();
        l /= 1000L;
        string2 = String.valueOf(l /= this.secondsInaDay);
        return string2;
    }

    private String getExpirationDate(String string) {
        String string2 = "";
        long l = Long.parseLong(string);
        long l2 = l * this.secondsInaDay + 1L;
        Date date = new Date(l2 *= 1000L);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        simpleDateFormat.setLenient(false);
        String string3 = simpleDateFormat.format(date);
        return string3;
    }

    private boolean isCredProcessingNecessary() {
        String string = "on";
        return true;
    }

    private void modifyCredUserName(String string, String string2, ProviderUtility providerUtility) throws DirectoryTableException {
        Vector vector;
        String string3;
        String string4 = providerUtility.getScopeType(this.scope);
        if (!string4.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string5 = providerUtility.getScopeDomainName(this.scope);
        String string6 = new String(string2 + "." + string5);
        if (!string6.endsWith(".")) {
            string6 = string6.concat(".");
        }
        if (!(string3 = new String(string + "." + string5)).endsWith(".")) {
            string3 = string3.concat(".");
        }
        String string7 = new String("/usr/bin/nistbladm -E cname=" + string3 + " [cname=" + string6 + ",auth_type=LOCAL],cred.org_dir");
        try {
            vector = AdminCommonTools.CMN_exec(string7, true);
        }
        catch (Exception exception) {
            throw new DirectoryTableException("change principal in cred table failed", exception);
        }
        string7 = new String("/usr/bin/nistbladm -E cname=" + string3 + " [cname=" + string6 + ",auth_type=DES],cred.org_dir");
        try {
            vector = AdminCommonTools.CMN_exec(string7, true);
        }
        catch (Exception exception) {
            throw new DirectoryTableException("nistbladm to change principal name in cred table failed", exception);
        }
    }

    private void removeCredTableEntry(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws DirectoryTableException {
        String string = providerUtility.getScopeType(this.scope);
        if (!string.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string2 = providerUtility.getScopeDomainName(this.scope);
        String string3 = flatUserObj.getUserName();
        if (string3 == null || string3.trim().length() == 0) {
            return;
        }
        String string4 = new String(string3 + "." + string2);
        if (!string4.endsWith(".")) {
            string4 = string4.concat(".");
        }
        String string5 = new String("nisaddcred -r " + string4);
        try {
            Vector vector = AdminCommonTools.CMN_exec(string5, true);
        }
        catch (Exception exception) {
            throw new DirectoryTableException("nisaddcred failed to remove credentials", exception);
        }
    }

    private void setupCredTableEntry(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws DirectoryTableException, Exception {
        Object object;
        String string = providerUtility.getScopeType(this.scope);
        if (!string.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String string2 = null;
        if (flatUserObj.getCurPassword() != null && flatUserObj.getCurPassword().trim().length() != 0) {
            string2 = providerUtility.decryptPassword(flatUserObj.getCurPassword());
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new Exception("Password is null. Unable to setup credentials");
        }
        String string3 = providerUtility.getScopeDomainName(this.scope);
        String string4 = flatUserObj.getUserUID();
        if (string4 == null || string4.trim().length() == 0) {
            return;
        }
        String string5 = flatUserObj.getUserName();
        if (string5 == null || string5.trim().length() == 0) {
            return;
        }
        String string6 = new String(string5 + "." + string3);
        if (!string6.endsWith(".")) {
            string6 = string6.concat(".");
        }
        String string7 = new String("nisaddcred -p " + string4 + " -P " + string6 + " local");
        try {
            object = AdminCommonTools.CMN_exec(string7, true);
        }
        catch (Exception exception) {
            throw new DirectoryTableException("nisaddcred failed to add LOCAL credentials", exception);
        }
        object = new String("unix." + string4 + "@" + string3);
        string7 = new String("nisaddcred -p " + (String)object + " -P " + string6 + " -l " + string2 + " des");
        string2 = "";
        try {
            try {
                Vector vector = AdminCommonTools.CMN_exec(string7, true);
            }
            catch (Exception exception) {
                throw new DirectoryTableException("nisaddcred failed to add DES credentials", exception);
            }
            Object var13_14 = null;
            string7 = "";
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            string7 = "";
            throw throwable;
        }
        string7 = "";
        string2 = "";
    }

    private DirectoryTable openShadowTable() throws DirectoryTableException {
        try {
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            directoryTable.open(tableName);
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            this.nameColNum = tableDefinitions.getColumnNumber(this.nameCol);
            this.passwdColNum = tableDefinitions.getColumnNumber(this.passwdCol);
            this.lastchngColNum = tableDefinitions.getColumnNumber(this.lastchngCol);
            this.minColNum = tableDefinitions.getColumnNumber(this.minCol);
            this.maxColNum = tableDefinitions.getColumnNumber(this.maxCol);
            this.warnColNum = tableDefinitions.getColumnNumber(this.warnCol);
            this.inactiveColNum = tableDefinitions.getColumnNumber(this.inactiveCol);
            this.exColNum = tableDefinitions.getColumnNumber(this.exCol);
            this.flagColNum = tableDefinitions.getColumnNumber(this.flagCol);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            throw directoryTableDoesNotExistException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
        catch (DirectoryTableException directoryTableException) {
            throw directoryTableException;
        }
    }

    private void closeShadowTable(DirectoryTable directoryTable) {
        directoryTable.close();
        this.nameColNum = 0;
        this.passwdColNum = 0;
        this.lastchngColNum = 0;
        this.minColNum = 0;
        this.maxColNum = 0;
        this.warnColNum = 0;
        this.inactiveColNum = 0;
        this.exColNum = 0;
        this.flagColNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteShadowRow(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    this.removeCredTableEntry(flatUserObj, providerUtility);
                    Object var10_7 = null;
                    if (directoryTable == null) return;
                    this.closeShadowTable(directoryTable);
                    return;
                }
                this.removeCredTableEntry(flatUserObj, providerUtility);
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var10_9 = null;
                if (directoryTable == null) return;
                this.closeShadowTable(directoryTable);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (directoryTable == null) throw throwable;
            this.closeShadowTable(directoryTable);
            throw throwable;
        }
        Object var10_8 = null;
        if (directoryTable == null) return;
        this.closeShadowTable(directoryTable);
    }

    public void addShadowRow(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws Exception {
        String string = this.nullPassword;
        String string2 = this.nullPassword;
        if (flatUserObj.getCurPassword() != null && flatUserObj.getCurPassword().trim().length() != 0) {
            string2 = providerUtility.decryptPassword(flatUserObj.getCurPassword());
            string = AdminSecurityUtil.createUnixPassword(string2);
            string2 = "";
        }
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        try {
            try {
                String string3;
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                if (flatUserObj.getUserName() != null) {
                    directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                }
                if (string != null) {
                    directoryRow.putColumn(this.passwdColNum, string);
                    string3 = this.computeLastChangeCol();
                    directoryRow.putColumn(this.lastchngColNum, string3);
                }
                if (flatUserObj.getMustChangePasswdInDays() != null) {
                    directoryRow.putColumn(this.minColNum, flatUserObj.getMustChangePasswdInDays());
                }
                if (flatUserObj.getDoNotReUsePwdForDays() != null) {
                    directoryRow.putColumn(this.maxColNum, flatUserObj.getDoNotReUsePwdForDays());
                }
                if (flatUserObj.getWarnBeforePwdExpiresDays() != null) {
                    directoryRow.putColumn(this.warnColNum, flatUserObj.getWarnBeforePwdExpiresDays());
                }
                if (flatUserObj.getPwdInactiveDays() != null) {
                    directoryRow.putColumn(this.inactiveColNum, flatUserObj.getPwdInactiveDays());
                }
                string3 = "";
                if (flatUserObj.getAccountExpireDate() != null) {
                    string3 = this.setUpExpirationDate(flatUserObj.getAccountExpireDate());
                }
                if (string3 != null) {
                    directoryRow.putColumn(this.exColNum, string3);
                }
                directoryTable.addRow(directoryRow);
                String string4 = providerUtility.getScopeType(this.scope);
                if (string4.equals("nisplus")) {
                    this.setupCredTableEntry(flatUserObj, providerUtility);
                    flatUserObj.setCurPassword("");
                }
                Object var12_15 = null;
                if (directoryTable != null) {
                    this.closeShadowTable(directoryTable);
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                directoryTableInvalidParameterException.printStackTrace();
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                directoryTableAccessException.printStackTrace();
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                directoryTableConnectionException.printStackTrace();
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                directoryTableException.printStackTrace();
                throw directoryTableException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (directoryTable != null) {
                this.closeShadowTable(directoryTable);
            }
            throw throwable;
        }
    }

    public FlatUserObj getShadowRow(FlatUserObj flatUserObj) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        flatUserObj.setChangePasswd(false);
        flatUserObj.setCurPassword(null);
        flatUserObj.setAccountExpireDate(null);
        String string = flatUserObj.getUserName();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    // empty if block
                }
                flatUserObj.setMustChangePasswdInDays(directoryRow.getColumn(this.minColNum));
                flatUserObj.setDoNotReUsePwdForDays(directoryRow.getColumn(this.maxColNum));
                flatUserObj.setWarnBeforePwdExpiresDays(directoryRow.getColumn(this.warnColNum));
                flatUserObj.setPwdInactiveDays(directoryRow.getColumn(this.inactiveColNum));
                String string2 = directoryRow.getColumn(this.passwdColNum);
                if (string2.equals(this.accountLockedValue)) {
                    flatUserObj.setIsAccountLocked(true);
                } else {
                    flatUserObj.setIsAccountLocked(false);
                }
                String string3 = directoryRow.getColumn(this.exColNum);
                if (string3 != null && !string3.equals("")) {
                    flatUserObj.setAccountExpireDate(this.getExpirationDate(string3));
                } else {
                    flatUserObj.setAccountExpireDate("");
                }
                if (string2.length() != 0) {
                    flatUserObj.setHasPasswd(true);
                } else {
                    flatUserObj.setHasPasswd(false);
                }
                flatUserObj.setChangePasswd(false);
                flatUserObj.setCurPassword(null);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
            Object var10_11 = null;
            if (directoryTable != null) {
                this.closeShadowTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (directoryTable != null) {
                this.closeShadowTable(directoryTable);
            }
            throw throwable;
        }
        return flatUserObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyShadowRow(FlatUserObj flatUserObj, ProviderUtility providerUtility) throws Exception {
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        String string = "";
        try {
            try {
                String string2;
                DirectoryRow directoryRow;
                DirectoryRow directoryRow2;
                block28: {
                    directoryRow2 = directoryTable.getRowInstance();
                    directoryRow2.putColumn(this.nameColNum, flatUserObj.getUserName());
                    directoryRow2 = directoryTable.getFirstRow((SearchTemplate)directoryRow2);
                    if (directoryRow2 == null) {
                        this.addShadowRow(flatUserObj, providerUtility);
                        Object var11_8 = null;
                        if (directoryTable == null) return;
                        this.closeShadowTable(directoryTable);
                        return;
                    }
                    directoryRow = directoryRow2.extractRows(1, 1);
                    directoryRow.putColumn(this.nameColNum, flatUserObj.getUserName());
                    string2 = directoryRow2.getColumn(this.passwdColNum);
                    if (!flatUserObj.getChangePasswd()) break block28;
                    string2 = this.nullPassword;
                    try {
                        if (flatUserObj.getCurPassword() != null && flatUserObj.getCurPassword().trim().length() != 0) {
                            string = providerUtility.decryptPassword(flatUserObj.getCurPassword());
                            string2 = AdminSecurityUtil.createUnixPassword(string);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Shadow Entry " + flatUserObj.getUserName() + " could not decrypt password");
                        throw exception;
                    }
                }
                String string3 = this.setUpExpirationDate(flatUserObj.getAccountExpireDate());
                if (flatUserObj.getIsAccountLocked()) {
                    string2 = this.accountLockedValue;
                } else if (string2.equals(this.accountLockedValue)) {
                    string2 = this.nullPassword;
                }
                directoryRow.putColumn(this.passwdColNum, string2);
                String string4 = "";
                string4 = !string2.equals(directoryRow2.getColumn(this.passwdColNum)) ? this.computeLastChangeCol() : directoryRow2.getColumn(this.lastchngColNum);
                directoryRow.putColumn(this.lastchngColNum, string4);
                if (flatUserObj.getMustChangePasswdInDays() != null) {
                    directoryRow.putColumn(this.minColNum, flatUserObj.getMustChangePasswdInDays());
                }
                if (flatUserObj.getDoNotReUsePwdForDays() != null) {
                    directoryRow.putColumn(this.maxColNum, flatUserObj.getDoNotReUsePwdForDays());
                }
                if (flatUserObj.getWarnBeforePwdExpiresDays() != null) {
                    directoryRow.putColumn(this.warnColNum, flatUserObj.getWarnBeforePwdExpiresDays());
                }
                if (flatUserObj.getPwdInactiveDays() != null) {
                    directoryRow.putColumn(this.inactiveColNum, flatUserObj.getPwdInactiveDays());
                }
                if (string3 != null) {
                    directoryRow.putColumn(this.exColNum, string3);
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
                if (string.trim().length() != 0) {
                    this.setupCredTableEntry(flatUserObj, providerUtility);
                    string = "";
                }
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (directoryTable != null) {
                this.closeShadowTable(directoryTable);
            }
            string = "";
            throw throwable;
        }
        Object var11_9 = null;
        if (directoryTable == null) return;
        this.closeShadowTable(directoryTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyShadowUsername(String string, String string2, ProviderUtility providerUtility) throws DirectoryTableException {
        if (string2 == null) return;
        if (string2.trim().length() == 0) {
            return;
        }
        DirectoryTable directoryTable = null;
        directoryTable = this.openShadowTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.nameColNum, string2);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    try {
                        this.modifyCredUserName(string, string2, providerUtility);
                    }
                    catch (Exception exception) {
                    }
                    Object var11_11 = null;
                    if (directoryTable == null) return;
                    this.closeShadowTable(directoryTable);
                    return;
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                directoryRow2.putColumn(this.nameColNum, string2);
                directoryRow.putColumn(this.nameColNum, string);
                directoryTable.modifyRow(directoryRow2, directoryRow);
                this.modifyCredUserName(string, string2, providerUtility);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            catch (Exception exception) {
                Object var11_13 = null;
                if (directoryTable == null) return;
                this.closeShadowTable(directoryTable);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (directoryTable == null) throw throwable;
            this.closeShadowTable(directoryTable);
            throw throwable;
        }
        Object var11_12 = null;
        if (directoryTable == null) return;
        this.closeShadowTable(directoryTable);
    }

    private String computeLastChangeCol() {
        long l = System.currentTimeMillis();
        l /= 1000L;
        String string = String.valueOf(l /= this.secondsInaDay);
        return string;
    }
}

