/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.Solaris_SerialNative;
import com.sun.wbem.solarisprovider.serialport.TokenString;
import com.sun.wbem.utility.log.LogUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class SerialPortInfo {
    public static final String DEFAULT_PMADM_PATH = "/usr/sbin/pmadm";
    public static final String DEFAULT_SACADM_PATH = "/usr/sbin/sacadm";
    public static final String DEFAULT_TTYADM_PATH = "/usr/sbin/ttyadm";
    public static final String DEFAULT_DEVTERM_DIR = "/dev/term";
    public static final String DEFAULT_ARCHITECTURE = "sparc";
    public static final String DEFAULT_TTYDEFS_FILE = "/etc/ttydefs";
    public static final String PROVIDER_NAME = "SerialPort";
    private static final int PM_NOTEXIST = 0;
    private static final int PM_ENABLED = 1;
    private static final int PM_DISABLED = 2;
    private static final int PM_STARTING = 3;
    private static final int PM_FAILED = 4;
    private String pmadm_path = "/usr/sbin/pmadm";
    private String sacadm_path = "/usr/sbin/sacadm";
    private String ttyadm_path = "/usr/sbin/ttyadm";
    private String devterm_dir = "/dev/term";
    private String alternate_device_dirs = null;
    private String architecture = "sparc";
    private String ttydefs_file = "/etc/ttydefs";
    Hashtable allPortData = new Hashtable();
    Vector dataObjectVector = new Vector();
    LogUtil logUtil = null;

    public SerialPortInfo(LogUtil logUtil) {
        this.logUtil = logUtil;
    }

    private void fillData(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.allPortData.put(((SerialPortData)vector.elementAt(n)).getPortName(), (SerialPortData)vector.elementAt(n));
            ++n;
        }
    }

    public String getPortName(int n) {
        if (this.dataObjectVector.size() > 0) {
            SerialPortData serialPortData = (SerialPortData)this.dataObjectVector.elementAt(n);
            return serialPortData.getPortName();
        }
        return null;
    }

    public String getPortMonTag(String string) {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        return serialPortData.getPortMonTag();
    }

    public String getServiceTag(String string) {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        return serialPortData.getServiceTag();
    }

    public String getDescription(String string) {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        return serialPortData.getComment();
    }

    public int getnumPorts() {
        return this.dataObjectVector.size();
    }

    public int initData() throws SerialPortException {
        Vector vector = null;
        Vector vector2 = null;
        if (this.dataObjectVector.size() > 0) {
            this.dataObjectVector.removeAllElements();
        }
        if (!this.allPortData.isEmpty()) {
            this.allPortData.clear();
        }
        if ((vector = this.readDirs()) == null) {
            try {
                String string = this.logUtil.getMessage("LM_LABEL_SERIAL_DEV_DIR");
                String string2 = string + ": " + this.devterm_dir + "\n" + this.logUtil.getMessage("LM_LABEL_SERIAL_ALT_DEV_DIR") + ": " + this.alternate_device_dirs;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5002", "LM_5003", null, string2, false, 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_NODEV_SRV");
        }
        vector2 = this.listSerialDevices();
        this.constructData(vector, vector2);
        return this.dataObjectVector.size();
    }

    private Vector readDirs() throws SerialPortException {
        Object object;
        int n = 0;
        Vector vector = this.parseDirString(this.alternate_device_dirs);
        Vector<Object> vector2 = new Vector<Object>();
        boolean bl = false;
        File file = null;
        try {
            file = new File(this.devterm_dir);
        }
        catch (SecurityException securityException) {
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = true;
        }
        try {
            String[] stringArray;
            if (file.exists() && file.isDirectory() && (stringArray = file.list()) != null && stringArray.length > 0) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    object = this.devterm_dir + File.separator + stringArray[n2];
                    vector2.addElement(object);
                    ++n;
                    ++n2;
                }
            }
        }
        catch (SecurityException securityException) {
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] stringArray = new String[]{this.devterm_dir};
            bl = true;
        }
        if (vector != null && vector.size() > 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                try {
                    String[] stringArray;
                    String string = (String)vector.elementAt(n3);
                    object = new File(string);
                    if (((File)object).exists() && ((File)object).isDirectory() && (stringArray = ((File)object).list()) != null && stringArray.length > 0) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            String string2 = string + File.separator + stringArray[n3];
                            vector2.addElement(string2);
                            ++n;
                            ++n4;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    try {
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5012", null, "", false, 0, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bl = true;
                }
                ++n3;
            }
        }
        if (n == 0 && bl) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        if (n == 0) {
            return null;
        }
        return vector2;
    }

    private Vector parseDirString(String string) {
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        int n = 0;
        if (string == null || string.length() == 0) {
            return null;
        }
        string2 = TokenString.getToken(string, ":");
        while (string2 != null) {
            vector.addElement(string2);
            ++n;
            string2 = TokenString.getToken(null, ":");
        }
        if (n == 0) {
            return null;
        }
        return vector;
    }

    private Vector listSerialDevices() throws SerialPortException {
        String string;
        String string2 = this.pmadm_path + " -L -t ttymon";
        Vector<String> vector = new Vector<String>();
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(string2);
        }
        catch (IOException iOException) {
            try {
                String string3 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String string4 = string3 + ": " + string2;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5023", "LM_5024", null, string4, true, 0, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_IO_SRV");
        }
        catch (SecurityException securityException) {
            try {
                String string5 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String string6 = string5 + ": " + string2;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5006", "LM_5007", null, string6, true, 0, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n2 == 0) {
            InputStream inputStream2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                inputStream2 = process.getErrorStream();
                while ((n = inputStream.read()) > 0) {
                    stringBuffer2.append((char)n);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n2 == 0) {
                try {
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5008", "LM_5009", null, "", false, 0, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            String string7 = new String(stringBuffer2);
            return null;
        }
        String string8 = new String(stringBuffer);
        n2 = string8.indexOf("\n");
        int n3 = 0;
        int n4 = 0;
        while (n2 != -1) {
            n4 = n2;
            string = string8.substring(n3, n4);
            if (string.length() > 0) {
                vector.addElement(string);
            }
            if ((n3 = n4 + 1) >= string8.length()) break;
            n2 = string8.indexOf("\n", n3);
        }
        if (n3 < string8.length() && (string = string8.substring(n3)).length() > 0) {
            vector.addElement(string);
        }
        return vector;
    }

    private void constructData(Vector vector, Vector vector2) {
        String string = null;
        File file = null;
        int n = 0;
        while (n < vector.size()) {
            int n2 = 0;
            String string2 = (String)vector.elementAt(n);
            if (string2 != null && string2.length() > 0) {
                String[] stringArray;
                int n3 = 0;
                while (vector2 != null && n3 < vector2.size()) {
                    String string3 = (String)vector2.elementAt(n3);
                    if (string3 != null && string3.length() > 0) {
                        block15: {
                            String[] stringArray2;
                            try {
                                file = new File(string2);
                            }
                            catch (Exception exception) {
                                try {
                                    stringArray2 = new String[]{string2};
                                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", stringArray2, "", false, 0, 1);
                                }
                                catch (Exception exception2) {
                                    // empty catch block
                                }
                                n2 = -1;
                                break;
                            }
                            try {
                                if (file != null && file.exists()) break block15;
                                try {
                                    stringArray = new String[]{string2};
                                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", stringArray, "", false, 0, 1);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                n2 = -1;
                            }
                            catch (Exception exception) {
                                try {
                                    stringArray2 = new String[]{string2};
                                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5004", "LM_5005", stringArray2, "", false, 0, 1);
                                }
                                catch (Exception exception3) {
                                    // empty catch block
                                }
                                n2 = -1;
                            }
                            break;
                        }
                        n2 = this.parseAdmString(string2, string3);
                        if (n2 > 0) break;
                    }
                    ++n3;
                }
                if (n2 != -1 && n2 == 0) {
                    int n4 = string2.lastIndexOf("/");
                    string = n4 >= 0 ? string2.substring(n4 + 1) : string2;
                    stringArray = new SerialPortData(string);
                    stringArray.setDefaults(string);
                    stringArray.setDeleted();
                    stringArray.setDeviceName(string2);
                    this.dataObjectVector.addElement(stringArray);
                    this.allPortData.put(string, stringArray);
                }
            }
            ++n;
        }
    }

    private int parseAdmString(String string, String string2) {
        Object object;
        String string3;
        String[] stringArray;
        block10: {
            if (string2.indexOf(string + ":") < 0) {
                return 0;
            }
            stringArray = new String[20];
            int n = 0;
            while (n < 20) {
                stringArray[n] = "";
                ++n;
            }
            int n2 = string.lastIndexOf("/");
            string3 = n2 >= 0 ? string.substring(n2 + 1) : string;
            int n3 = 0;
            String string4 = TokenString.getToken(string2, ":");
            while (string4 != null && n3 < 19) {
                int n4;
                stringArray[n3] = string4;
                string4 = TokenString.getToken(null, ":");
                if (string4 != null && (n4 = stringArray[n3].lastIndexOf("\\")) > 0 && n4 == stringArray[n3].length() - 1) {
                    object = stringArray[n3].substring(0, n4);
                    stringArray[n3] = object = ((String)object).concat(":");
                    int n5 = n3;
                    stringArray[n5] = stringArray[n5] + string4;
                    string4 = TokenString.getToken(null, ":");
                }
                ++n3;
            }
            stringArray[19] = string4;
            String string5 = TokenString.getWhatRemains();
            if (string5 != null) {
                stringArray[19] = stringArray[19] + ":" + string5;
            }
            if (stringArray[8] != null && stringArray[8].length() != 0) {
                try {
                    if (Solaris_SerialNative.doStat(stringArray[8]) >= 0) break block10;
                    try {
                        object = new String[]{stringArray[8]};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5013", "LM_5014", (String[])object, "", true, 0, 2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        stringArray[19] = stringArray[19] != null && stringArray[19].length() > 1 ? (object = stringArray[19].substring(1)) : "";
        object = new SerialPortData(string3);
        ((SerialPortData)object).fillData(stringArray);
        this.dataObjectVector.addElement(object);
        this.allPortData.put(string3, object);
        return 1;
    }

    public SerialPortData getPortData(String string) throws SerialPortException {
        SerialPortData serialPortData = null;
        serialPortData = (SerialPortData)this.allPortData.get(string);
        if (serialPortData == null) {
            throw new SerialPortException("Null data");
        }
        return serialPortData;
    }

    public SerialPortData getPortData(int n) throws SerialPortException {
        SerialPortData serialPortData = null;
        serialPortData = (SerialPortData)this.dataObjectVector.elementAt(n);
        if (serialPortData == null) {
            throw new SerialPortException("Null data");
        }
        return serialPortData;
    }

    public synchronized void synchronizedSetPortInfo(String string, SerialPortData serialPortData, boolean bl) throws SerialPortException {
        Object object;
        Object object2;
        String[] stringArray;
        String string2;
        String[] stringArray2;
        boolean bl2;
        block68: {
            if (serialPortData == null) {
                throw new SerialPortException("EXM_NULL_DATA_SRV");
            }
            bl2 = false;
            stringArray2 = "";
            string2 = serialPortData.getDeviceName();
            try {
                if (Solaris_SerialNative.isConsole(string2) <= 0) break block68;
                try {
                    String[] stringArray3 = new String[]{string2};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5028", "LM_5029", stringArray3, "", false, 0, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CONSOLE_SRV", string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!serialPortData.isEnableSet() && !bl) {
            String[] stringArray4 = new String[6];
            String string3 = this.pmadm_path + " -d -p " + serialPortData.getPortMonTag() + "  -s " + serialPortData.getServiceTag();
            stringArray4[0] = this.pmadm_path;
            stringArray4[1] = "-d";
            stringArray4[2] = "-p";
            stringArray4[3] = serialPortData.getPortMonTag();
            stringArray4[4] = "-s";
            stringArray4[5] = serialPortData.getServiceTag();
            Vector vector = null;
            try {
                vector = this.runCommand(stringArray4);
            }
            catch (Exception exception) {
                try {
                    String[] stringArray5 = new String[]{serialPortData.getPortName()};
                    String string4 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5056", "LM_5057", stringArray5, string4 + ": " + string3, true, 0, 2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", string3);
            }
            if (vector != null && vector.size() > 0) {
                String string5 = (String)vector.elementAt(0);
                if (string5.compareTo("Error") == 0) {
                    try {
                        String[] stringArray6 = new String[]{serialPortData.getPortName()};
                        String string6 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        String string7 = string6 + ": " + string3;
                        int n = 1;
                        while (n < vector.size()) {
                            string7 = string7 + " " + (String)vector.elementAt(n);
                            ++n;
                        }
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5056", "LM_5057", stringArray6, string7, true, 0, 2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string3);
                }
                try {
                    String[] stringArray7 = new String[]{serialPortData.getPortName()};
                    String string8 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String string9 = string8 + ": " + string3;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5058", "LM_5059", stringArray7, string9, false, 0, 0);
                }
                catch (Exception exception) {}
            } else {
                try {
                    String[] stringArray8 = new String[]{serialPortData.getPortName()};
                    String string10 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5056", "LM_5057", stringArray8, string10 + ": " + string3, true, 0, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", string3);
            }
            return;
        }
        try {
            switch (this.checkForPortmon(serialPortData.getPortMonTag())) {
                case -1: {
                    String string11 = "1";
                    try {
                        stringArray = new String[]{this.ttyadm_path, "-V"};
                        object2 = this.runCommand(stringArray);
                        if (object2 != null && ((Vector)object2).size() > 0 && ((String)(object = (String)((Vector)object2).elementAt(0))).compareTo("Success") == 0) {
                            int n = 1;
                            while (n < ((Vector)object2).size()) {
                                string11 = (String)((Vector)object2).elementAt(n);
                                ++n;
                            }
                        }
                    }
                    catch (SerialPortException serialPortException) {
                        // empty catch block
                    }
                    stringArray = this.sacadm_path + " -a -n 2 -p " + serialPortData.getPortMonTag() + "\t-t ttymon -c /usr/lib/saf/ttymon -v " + string11 + " -y \"Serial Ports\"";
                    try {
                        object2 = new String[]{this.sacadm_path, "-a", "-n", "2", "-p", serialPortData.getPortMonTag(), "-t", "ttymon", "-c", "/usr/lib/saf/ttymon", "-v", string11, "-y", "\"Serial Ports\""};
                        object = this.runCommand((String[])object2);
                        if (object == null || ((Vector)object).size() <= 0) break;
                        String string12 = (String)((Vector)object).elementAt(0);
                        if (string12.compareTo("Error") == 0) {
                            String[] stringArray9 = new String[]{string};
                            try {
                                String string13 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                String string14 = string13 + ": " + (String)stringArray;
                                int n = 1;
                                while (n < ((Vector)object).size()) {
                                    string14 = string14 + " " + (String)((Vector)object).elementAt(n);
                                    ++n;
                                }
                                this.logUtil.writeLog(PROVIDER_NAME, "LM_5030", "LM_5031", stringArray9, string14, true, 0, 2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            bl2 = true;
                            stringArray2 = stringArray;
                            break;
                        }
                        String[] stringArray10 = new String[]{string};
                        try {
                            String string15 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            String string16 = string15 + ": " + (String)stringArray;
                            int n = 1;
                            while (n < ((Vector)object).size()) {
                                string16 = string16 + " " + (String)((Vector)object).elementAt(n);
                                ++n;
                            }
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5032", "LM_5033", stringArray10, string16, false, 0, 0);
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (SerialPortException serialPortException) {
                        bl2 = true;
                        stringArray2 = stringArray;
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    object2 = this.sacadm_path + " -e -p " + serialPortData.getPortMonTag();
                    try {
                        object = new String[]{this.sacadm_path, "-e", "-p", serialPortData.getPortMonTag()};
                        Vector vector = this.runCommand((String[])object);
                        if (vector == null || vector.size() <= 0) break;
                        String string17 = (String)vector.elementAt(0);
                        if (string17.compareTo("Error") == 0) {
                            String[] stringArray11 = new String[]{string};
                            try {
                                String string18 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                String string19 = string18 + ": " + (String)object2;
                                int n = 1;
                                while (n < vector.size()) {
                                    string19 = string19 + " " + (String)vector.elementAt(n);
                                    ++n;
                                }
                                this.logUtil.writeLog(PROVIDER_NAME, "LM_5034", "LM_5035", stringArray11, string19, true, 0, 2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            bl2 = true;
                            break;
                        }
                        String[] stringArray12 = new String[]{string};
                        try {
                            String string20 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            String string21 = string20 + ": " + (String)object2;
                            int n = 1;
                            while (n < vector.size()) {
                                string21 = string21 + " " + (String)vector.elementAt(n);
                                ++n;
                            }
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5036", "LM_5037", stringArray12, string21, false, 0, 0);
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (SerialPortException serialPortException) {
                        bl2 = true;
                        stringArray2 = object2;
                    }
                    break;
                }
                case 4: {
                    object = this.sacadm_path + " -s -p " + serialPortData.getPortMonTag();
                    try {
                        String[] stringArray13 = new String[]{this.sacadm_path, "-s", "-p", serialPortData.getPortMonTag()};
                        Vector vector = this.runCommand(stringArray13);
                        if (vector == null || vector.size() <= 0) break;
                        String string22 = (String)vector.elementAt(0);
                        if (string22.compareTo("Error") == 0) {
                            String[] stringArray14 = new String[]{string};
                            try {
                                String string23 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                                String string24 = string23 + ": " + (String)object;
                                int n = 1;
                                while (n < vector.size()) {
                                    string24 = string24 + " " + (String)vector.elementAt(n);
                                    ++n;
                                }
                                this.logUtil.writeLog(PROVIDER_NAME, "LM_5038", "LM_5039", stringArray14, string24, true, 0, 2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            bl2 = true;
                            break;
                        }
                        String[] stringArray15 = new String[]{string};
                        try {
                            String string25 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                            String string26 = string25 + ": " + (String)object;
                            int n = 1;
                            while (n < vector.size()) {
                                string26 = string26 + " " + (String)vector.elementAt(n);
                                ++n;
                            }
                            this.logUtil.writeLog(PROVIDER_NAME, "LM_5040", "LM_5041", stringArray15, string26, false, 0, 0);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    catch (SerialPortException serialPortException) {
                        bl2 = true;
                        stringArray2 = object;
                    }
                }
            }
        }
        catch (SerialPortException serialPortException) {
            stringArray = new String[]{string};
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5042", "LM_5043", stringArray, "", true, 0, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2) {
            throw new SerialPortException("EXM_SACADM_ERR_SRV", stringArray2);
        }
        this.turn_on_port(serialPortData, bl);
        int n = -1;
        n = Solaris_SerialNative.eepromSet(string2);
        if (n < 0) {
            stringArray = new String[]{serialPortData.getDeviceName()};
            try {
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5060", "LM_5061", stringArray, "", true, 0, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_EEPROM_SRV");
        }
        stringArray = new String[]{string};
        try {
            object2 = this.logUtil.getMessage("LM_LABEL_SERIAL_OLD_DATA");
            object = (SerialPortData)this.allPortData.get(string);
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5062", "LM_5063", stringArray, (String)object2 + ": " + ((SerialPortData)object).toString(), false, 0, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Vector runCommand(String[] stringArray) throws SerialPortException {
        String string;
        Vector<String> vector = new Vector<String>();
        Process process = null;
        Runtime runtime = null;
        InputStream inputStream = null;
        runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(stringArray);
        }
        catch (IOException iOException) {
            throw new SerialPortException("");
        }
        catch (SecurityException securityException) {
            throw new SerialPortException("EXM_SEC_SRV");
        }
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            inputStream = process.getInputStream();
            while ((n = inputStream.read()) > 0) {
                stringBuffer.append((char)n);
                ++n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n2 == 0) {
            String string2;
            InputStream inputStream2 = null;
            StringBuffer stringBuffer2 = new StringBuffer();
            try {
                inputStream2 = process.getErrorStream();
                while ((n = inputStream2.read()) > 0) {
                    stringBuffer2.append((char)n);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new SerialPortException("");
            }
            if (n2 == 0) {
                vector.addElement("Success");
                return vector;
            }
            String string3 = new String(stringBuffer2);
            n2 = string3.indexOf("\n");
            int n3 = 0;
            int n4 = 0;
            vector.addElement("Error");
            while (n2 != -1) {
                n4 = n2;
                string2 = string3.substring(n3, n4);
                if (string2.length() > 0) {
                    vector.addElement(string2);
                }
                if ((n3 = n4 + 1) >= string3.length()) break;
                n2 = string3.indexOf("\n", n3);
            }
            if (n3 < string3.length() && (string2 = string3.substring(n3)).length() > 0) {
                vector.addElement(string2);
            }
            return vector;
        }
        String string4 = new String(stringBuffer);
        vector.addElement("Success");
        n2 = string4.indexOf("\n");
        int n5 = 0;
        int n6 = 0;
        while (n2 != -1) {
            n6 = n2;
            string = string4.substring(n5, n6);
            if (string.length() > 0) {
                vector.addElement(string);
            }
            if ((n5 = n6 + 1) >= string4.length()) break;
            n2 = string4.indexOf("\n", n5);
        }
        if (n5 < string4.length() && (string = string4.substring(n5)).length() > 0) {
            vector.addElement(string);
        }
        return vector;
    }

    private int checkForPortmon(String string) throws SerialPortException {
        String string2 = this.sacadm_path + " -l -t ttymon";
        Vector vector = null;
        String[] stringArray = new String[4];
        try {
            stringArray[0] = this.sacadm_path;
            stringArray[1] = "-l";
            stringArray[2] = "-t";
            stringArray[3] = "ttymon";
            vector = this.runCommand(stringArray);
        }
        catch (Exception exception) {
            try {
                String string3 = stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
                String[] stringArray2 = new String[]{string3, "ttymon"};
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5064", "LM_5065", stringArray2, "", false, 0, 2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SerialPortException("EXM_PORTMONERR_SRV");
        }
        if (vector == null || vector.size() == 0) {
            return -1;
        }
        String string4 = (String)vector.elementAt(0);
        if (string4.compareTo("Error") == 0) {
            return -1;
        }
        int n = 1;
        while (n < vector.size()) {
            String string5 = (String)vector.elementAt(n);
            int n2 = string5.indexOf(string);
            if (n2 >= 0) {
                n2 = string5.indexOf("ENABLED");
                if (n2 > 0) {
                    return 1;
                }
                n2 = string5.indexOf("DISABLED");
                if (n2 > 0) {
                    return 2;
                }
                n2 = string5.indexOf("STARTING");
                if (n2 > 0) {
                    return 3;
                }
                n2 = string5.indexOf("FAILED");
                if (n2 > 0) {
                    return 4;
                }
                return -1;
            }
            ++n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void turn_on_port(SerialPortData serialPortData, boolean bl) throws SerialPortException {
        void var12_36;
        String[] stringArray;
        Object object;
        String string;
        String string2;
        Vector vector;
        Object[] objectArray;
        String string3;
        Vector<Object> vector2;
        String string4;
        block55: {
            if (serialPortData.isEnableSet() && !bl) {
                Object object2;
                String string5 = this.pmadm_path + "  -e -p " + serialPortData.getPortMonTag() + " -s " + serialPortData.getServiceTag();
                Vector vector3 = null;
                try {
                    object2 = new String[]{this.pmadm_path, "-e", "-p", serialPortData.getPortMonTag(), "-s", serialPortData.getServiceTag()};
                    vector3 = this.runCommand((String[])object2);
                }
                catch (Exception exception) {
                    try {
                        String string6 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        String[] stringArray2 = new String[]{serialPortData.getPortName()};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", stringArray2, string6 + ": " + string5, true, 0, 2);
                        throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                }
                if (vector3 != null && vector3.size() > 0) {
                    object2 = (String)vector3.elementAt(0);
                    if (((String)object2).compareTo("Error") != 0) return;
                    try {
                        String string7 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                        String[] stringArray3 = new String[]{serialPortData.getPortName()};
                        this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", stringArray3, string7 + ": " + string5, true, 0, 2);
                        throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                }
                try {
                    object2 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray4 = new String[]{serialPortData.getPortName()};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5044", "LM_5045", stringArray4, (String)object2 + ": " + string5, true, 0, 2);
                    throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_CMD_FAIL_SRV", string5);
            }
            if (serialPortData.isEnableSet() && bl) {
                serialPortData.tweakPortFlags();
            }
            if (!serialPortData.isEnableSet() && bl) {
                serialPortData.setDisableFlag();
            }
            int n = -1;
            n = Solaris_SerialNative.checkTTYLabel(serialPortData.getTTYLabel(), this.ttydefs_file);
            if (n < 0) {
                try {
                    String[] stringArray5 = new String[]{serialPortData.getPortName(), serialPortData.getTTYLabel(), this.ttydefs_file};
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5050", "LM_5051", stringArray5, "", true, 0, 1);
                    throw new SerialPortException("EXM_NO_TTYLABEL_SRV", (Object)this.ttydefs_file, serialPortData.getTTYLabel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_NO_TTYLABEL_SRV", (Object)this.ttydefs_file, serialPortData.getTTYLabel());
            }
            string4 = this.ttyadm_path + " -d " + serialPortData.getDeviceName() + " -l " + serialPortData.getTTYLabel() + " -s " + serialPortData.getServiceCmdLine();
            vector2 = new Vector<Object>();
            vector2.addElement(this.ttyadm_path);
            vector2.addElement("-d");
            vector2.addElement(serialPortData.getDeviceName());
            vector2.addElement("-l");
            vector2.addElement(serialPortData.getTTYLabel());
            vector2.addElement("-s");
            vector2.addElement(serialPortData.getServiceCmdLine());
            String string8 = serialPortData.getTTYFlags();
            if (string8 != null && string8.length() > 0) {
                if (string8.indexOf("b") >= 0) {
                    string4 = string4 + " -b ";
                    vector2.addElement("-b");
                }
                if (string8.indexOf("c") >= 0) {
                    string4 = string4 + " -c ";
                    vector2.addElement("-c");
                }
                if (string8.indexOf("I") >= 0) {
                    string4 = string4 + " -I ";
                    vector2.addElement("-I");
                }
            }
            if ((string3 = serialPortData.getModules()) != null && string3.length() > 0) {
                string4 = string4 + " -m " + string3;
                vector2.addElement("-m");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getPrompt()) != null && string3.length() > 0) {
                string4 = string4 + " -p " + string3;
                vector2.addElement("-p");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getTimeoutVal()) != null && string3.length() > 0) {
                string4 = string4 + " -t " + string3;
                vector2.addElement("-t");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getSoftwareCarrier()) != null && string3.length() > 0) {
                string4 = string4 + " -S " + string3;
                vector2.addElement("-S");
                vector2.addElement(string3);
            }
            if ((string3 = serialPortData.getTerminalType()) != null && string3.length() > 0) {
                string4 = string4 + " -T " + string3;
                vector2.addElement("-T");
                vector2.addElement(string3);
            }
            objectArray = new String[vector2.size()];
            vector2.copyInto(objectArray);
            vector = null;
            string2 = "";
            try {
                vector = this.runCommand((String[])objectArray);
                break block55;
            }
            catch (SerialPortException serialPortException) {
                try {
                    String string9 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray6 = new String[]{serialPortData.getPortName()};
                    String string10 = string9 + ": " + string4;
                    int n2 = 1;
                    while (n2 < vector.size()) {
                        string10 = string10 + " " + (String)vector.elementAt(n2);
                        ++n2;
                    }
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", stringArray6, string10, true, 0, 2);
                    throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
        }
        if (vector != null && vector.size() > 0) {
            string = (String)vector.elementAt(0);
            if (string.compareTo("Error") == 0) {
                try {
                    String string11 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray7 = new String[]{serialPortData.getPortName()};
                    String string12 = string11 + ": " + string4;
                    int n = 1;
                    while (n < vector.size()) {
                        string12 = string12 + " " + (String)vector.elementAt(n);
                        ++n;
                    }
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", stringArray7, string12, true, 0, 2);
                    throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
            }
            if (vector.size() > 1) {
                string2 = (String)vector.elementAt(1);
            }
        } else {
            try {
                String string13 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] stringArray8 = new String[]{serialPortData.getPortName()};
                String string14 = string13 + ": " + string4;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5052", "LM_5053", stringArray8, string14, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string4);
        }
        string3 = serialPortData.getOldPortMonTag();
        if (string3 != null && string3.length() > 0 && (string = serialPortData.getOldServiceTag()) != null && string.length() > 0) {
            String[] stringArray9 = new String[]{this.pmadm_path, "-r", "-p", string3, "-s", string};
            this.runCommand(stringArray9);
        }
        string = this.pmadm_path + " -a " + " -p " + serialPortData.getPortMonTag() + " -s " + serialPortData.getServiceTag() + " -i " + serialPortData.getIdentity();
        vector2 = new Vector();
        vector2.addElement(this.pmadm_path);
        vector2.addElement("-a");
        vector2.addElement("-p");
        vector2.addElement(serialPortData.getPortMonTag());
        vector2.addElement("-s");
        vector2.addElement(serialPortData.getServiceTag());
        vector2.addElement("-i");
        vector2.addElement(serialPortData.getIdentity());
        String string15 = "1";
        try {
            object = new String[]{this.ttyadm_path, "-V"};
            vector = this.runCommand((String[])object);
            if (vector != null && vector.size() > 0 && (stringArray = (String[])vector.elementAt(0)).compareTo("Success") == 0) {
                int n = 1;
                while (n < vector.size()) {
                    String string16 = (String)vector.elementAt(n);
                    ++n;
                }
            }
        }
        catch (SerialPortException serialPortException) {
            // empty catch block
        }
        string = string + " -v " + (String)var12_36;
        vector2.addElement("-v");
        vector2.addElement(var12_36);
        string3 = serialPortData.getPortFlags();
        if (string3 != null && string3.length() > 0) {
            string = string + " -f " + string3;
            vector2.addElement("-f");
            vector2.addElement(string3);
        }
        string = string + " -m \"" + string2 + "\"";
        vector2.addElement("-m");
        vector2.addElement(string2);
        string3 = serialPortData.getComment();
        if (string3 != null && string3.length() > 0) {
            string = string + " -y " + string3;
            vector2.addElement("-y");
            vector2.addElement(string3);
        }
        objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        try {
            vector = this.runCommand((String[])objectArray);
        }
        catch (SerialPortException serialPortException) {
            try {
                stringArray = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] stringArray10 = new String[]{serialPortData.getPortName()};
                String string17 = (String)stringArray + ": " + string;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", stringArray10, string17, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        if (vector != null && vector.size() > 0) {
            object = (String)vector.elementAt(0);
            if (((String)object).compareTo("Error") != 0) return;
            try {
                stringArray = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                String[] stringArray11 = new String[]{serialPortData.getPortName()};
                String string18 = (String)stringArray + ": " + string;
                int n = 1;
                while (n < vector.size()) {
                    string18 = string18 + " " + (String)vector.elementAt(n);
                    ++n;
                }
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", stringArray11, string18, true, 0, 2);
                throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        try {
            object = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
            stringArray = new String[]{serialPortData.getPortName()};
            String string19 = (String)object + ": " + string;
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5054", "LM_5055", stringArray, string19, true, 0, 2);
            throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SerialPortException("EXM_SACADM_ERR_SRV", string);
    }

    public synchronized Vector synchronizedDeletePort(String string) throws SerialPortException {
        SerialPortData serialPortData = (SerialPortData)this.allPortData.get(string);
        String string2 = serialPortData.getPortMonTag();
        String string3 = serialPortData.getServiceTag();
        Vector vector = null;
        if (string2 != null && string3 != null) {
            String[] stringArray;
            String string4;
            Object object;
            String string5 = this.pmadm_path + " -r -p " + string2 + " -s " + string3;
            try {
                object = new String[]{this.pmadm_path, "-r", "-p", string2, "-s", string3};
                vector = this.runCommand((String[])object);
            }
            catch (Exception exception) {
                try {
                    String string6 = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray2 = new String[]{string};
                    String string7 = string6 + ": " + string5;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5016", stringArray2, string7, false, 0, 2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_DEL_SRV", string);
            }
            if (vector != null && vector.size() > 1) {
                try {
                    object = this.logUtil.getMessage("LM_LABEL_SERIAL_SEC_CMD");
                    String[] stringArray3 = new String[]{string, (String)vector.elementAt(1)};
                    String string8 = (String)object + ": " + string5;
                    this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5017", stringArray3, string8, false, 0, 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SerialPortException("EXM_DEL_SRV", string);
            }
            serialPortData.setDefaults(string);
            int n = 0;
            while (n < this.dataObjectVector.size()) {
                string4 = null;
                stringArray = (String[])this.dataObjectVector.elementAt(n);
                string4 = stringArray.getPortName();
                if (string4 != null && string4.compareTo(string) == 0) {
                    stringArray.setDefaults(string);
                    stringArray.setDeviceName(serialPortData.getDeviceName());
                    stringArray.setNoService();
                    stringArray.setDeleted();
                    this.dataObjectVector.setElementAt(stringArray, n);
                    this.allPortData.put(string, stringArray);
                    break;
                }
                ++n;
            }
            try {
                string4 = this.logUtil.getMessage("LM_LABEL_SERIAL_PORTMONTAG");
                stringArray = new String[]{string};
                String string9 = string4 + ": " + string2 + "\n" + this.logUtil.getMessage("LM_LABEL_SERIAL_SERVICETAG") + ": " + string3;
                this.logUtil.writeLog(PROVIDER_NAME, "LM_5019", "LM_5020", stringArray, string9, false, 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.dataObjectVector;
        }
        try {
            String[] stringArray = new String[]{string};
            this.logUtil.writeLog(PROVIDER_NAME, "LM_5015", "LM_5018", stringArray, "", false, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new SerialPortException("EXM_DELNODATA_SRV", string);
    }

    public String toString(int n) {
        SerialPortData serialPortData = (SerialPortData)this.dataObjectVector.elementAt(n);
        return serialPortData.toString();
    }
}

