/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CommonServerSecurityContext;
import com.sun.wbem.cimom.security.UserPasswordProvider;
import com.sun.wbem.client.adapter.rmi.RemoteCIMListener;
import java.io.File;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;

public final class ServerSecurity
implements CommonServerSecurityContext {
    public static final long AUDIT_NO_SUCH_USER = -1L;
    public static final long AUDIT_BAD_PASSWD = -2L;
    public static final long AUDIT_SUCCESS = 1L;
    private static final String WBEM_LOCAL_TYPE = "__LOCAL";
    private static final String WBEM_LOCAL_DIR = "/var/sadm/wbem/security";
    private static final int WBEM_LOCAL_NONCE_SIZE = 16;
    private static ThreadLocal requestSession = new ThreadLocal();
    protected static byte[] adminCred = null;
    private static boolean initialized = false;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey sprivkey;
    private static PublicKey spubkey;
    private MessageDigest md = null;
    private PublicKey cpubkey;
    private String userName = null;
    private String roleName = null;
    private String authName = null;
    private String localFile = null;
    private String clientHost = null;
    private String initialKey = "InitialKey";
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] decryptKey = null;
    private byte[] auditKey = null;
    private byte[] cf;
    private byte[] sf;
    private byte[] nameSpace;
    private String cp = null;
    private String cversion;
    private String cap = "none";
    private String capNameSpace = "__junk__";
    private boolean bLocalMode = false;
    private static UserPasswordProvider upp;
    private RemoteCIMListener rl = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    static UserPasswordProvider getUserPasswordProvider() throws Exception {
        if (upp == null) {
            try {
                Class<?> clazz = Class.forName(System.getProperty("com.sun.wbem.cimom.pswdprov"));
                upp = (UserPasswordProvider)clazz.newInstance();
            }
            catch (Exception exception) {
                Debug.trace1((String)"Sundigest: Error getting password provider", (Throwable)exception);
                throw exception;
            }
        }
        return upp;
    }

    public ServerSecurity() throws Exception {
        if (!initialized) {
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            sprivkey = keypair.getPrivate();
            spubkey = keypair.getPublic();
            initialized = true;
        }
        upp = ServerSecurity.getUserPasswordProvider();
        this.md = MessageDigest.getInstance("MD5");
    }

    public ServerSecurity(String string, String string2, String string3, byte[] byArray) {
        this.userName = string;
        this.roleName = string2;
        this.setClientHostName(string3);
        ServerSecurity.setRequestSession(this);
        this.auditKey = byArray;
    }

    public String getClientVersion() {
        return this.cversion;
    }

    public String getCapability() {
        return this.cap;
    }

    public String getCapabilityNS() {
        return this.capNameSpace;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getPasswd() {
        return this.cp;
    }

    public byte[] getNameSpace() {
        return this.nameSpace;
    }

    public byte[] getShadow() {
        return this.sf;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return spubkey;
    }

    public PublicKey getClientPublicKey() {
        return this.cpubkey;
    }

    public PrivateKey getPrivateKey() {
        return sprivkey;
    }

    public MessageDigest getMD() {
        return this.md;
    }

    public Signature getSigner() {
        return signer;
    }

    public RemoteCIMListener getListener() {
        return this.rl;
    }

    public void setCapability(String string) {
        this.cap = string;
    }

    public void setCapabilityNS(String string) {
        this.capNameSpace = string;
    }

    public void setClientHostName(String string) {
        this.clientHost = string;
    }

    public void setListener(RemoteCIMListener remoteCIMListener) {
        this.rl = remoteCIMListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SecurityMessage generateChallenge(String string, SecurityMessage securityMessage, byte[] byArray) throws CIMException {
        Object object;
        byte[] byArray2;
        int n;
        byte[] byArray3;
        block15: {
            if (!securityMessage.isHello()) {
                throw new CIMSecurityException("NOT_HELLO");
            }
            this.cversion = string;
            this.sessionId = byArray;
            byArray3 = securityMessage.getChallenge();
            this.md.reset();
            this.md.update(byArray3);
            byte[] byArray4 = this.md.digest(this.initialKey.getBytes());
            this.md.reset();
            this.md.update(byArray3);
            this.md.update(this.initialKey.getBytes());
            this.md.update(securityMessage.getUserDigest());
            this.md.update(securityMessage.getNameSpace());
            if (!MessageDigest.isEqual(this.md.digest(), securityMessage.getChecksum())) {
                Debug.trace1((String)"Sundigest: user authentication; request checksum error");
                throw new CIMSecurityException("CHECKSUM_ERROR");
            }
            byte[] byArray5 = SecurityUtil.extractHashedData((byte[])securityMessage.getUserDigest(), (byte[])byArray4);
            this.nameSpace = SecurityUtil.extractHashedData((byte[])securityMessage.getNameSpace(), (byte[])byArray4);
            this.userName = new String(byArray5);
            if (byArray5 == null) {
                Debug.trace1((String)"Sundigest: user authentication; no user name");
                upp.auditLogin(this.clientHost, this.userName, -1L);
                throw new CIMSecurityException("NO_SUCH_PRINCIPAL", null);
            }
            this.authName = new String(byArray5);
            Debug.trace3((String)("Sundigest: user = " + this.authName));
            n = this.authName.indexOf(58);
            if (n > 0) {
                this.userName = this.authName.substring(0, n);
                if (this.authName.length() > n && this.authName.substring(n + 1).equals(WBEM_LOCAL_TYPE)) {
                    this.bLocalMode = true;
                    break block15;
                } else {
                    Debug.trace1((String)("Sundigest: invalid user type: " + this.authName));
                    throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)"INVALID_TYPE");
                }
            }
            this.userName = this.authName;
            this.bLocalMode = false;
        }
        String string2 = upp.getEncryptedPassword(this.userName, 1);
        if (string2 == null || string2.length() == 0) {
            Debug.trace1((String)("Sundigest: user authentication; bad user name: " + this.userName));
            upp.auditLogin(this.clientHost, this.userName, -1L);
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)this.userName);
        }
        byte[] byArray6 = null;
        if (this.bLocalMode) {
            this.sf = new byte[16];
            SecurityUtil.secrand.nextBytes(this.sf);
            Debug.trace3((String)("Sundigest: shared secret: " + this.toHex(this.sf)));
            byArray2 = SecurityUtil.hashData((byte[])this.sf, (byte[])byArray3);
            object = this.toHex(byArray2);
            this.localFile = null;
            try {
                this.localFile = upp.writeLocalAuthenticator(this.userName, WBEM_LOCAL_DIR, (String)object);
                n = this.localFile.lastIndexOf(File.separatorChar);
                if (n > 0) {
                    this.localFile = this.localFile.substring(n + 1);
                }
                String string3 = "$__LOCAL$" + this.localFile;
                byArray6 = string3.getBytes("UTF-8");
            }
            catch (Exception exception) {
                Debug.trace1((String)("Sundigest: error writing local auth file: " + exception.getMessage()));
                throw new CIMSecurityException("CIM_ERR_FAILED", (Object)"WRITE_LOCAL_AUTHENTICATOR");
            }
        }
        if (string2.charAt(0) != '$') {
            this.sf = string2.getBytes();
            byArray6 = new byte[]{this.sf[0], this.sf[1]};
        } else {
            n = string2.lastIndexOf(36);
            try {
                this.sf = string2.substring(n + 1).getBytes();
                byArray6 = string2.substring(0, n).getBytes();
            }
            catch (Exception exception) {
                Debug.trace1((String)("Sundigest: bad password encryption: " + string2));
                throw new CIMSecurityException("INVALID_CREDENTIAL");
            }
        }
        Debug.trace3((String)("Sundigest: shared secret: " + new String(this.sf)));
        Debug.trace3((String)("Sundigest: salt = " + new String(byArray6)));
        Debug.trace3((String)("Sundigest: request valid: " + this.userName));
        this.schallenge1 = new byte[16];
        SecurityUtil.secrand.nextBytes(this.schallenge1);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        byArray2 = this.md.digest();
        object = SecurityUtil.hashData((byte[])byArray6, (byte[])byArray2);
        this.md.reset();
        this.md.update(this.schallenge1);
        this.md.update(this.initialKey.getBytes());
        this.md.update((byte[])object);
        return SecurityMessage.challenge((byte[])this.schallenge1, (byte[])object, (byte[])byArray, (byte[])this.md.digest(byArray));
    }

    public SecurityMessage validateResponse(byte[] byArray, byte[] byArray2, PublicKey publicKey, byte[] byArray3, SecurityMessage securityMessage) throws CIMException {
        if (this.bLocalMode) {
            this.removeLocalFile();
        }
        if (!securityMessage.isResponse()) {
            throw new CIMSecurityException("NOT_RESPONSE");
        }
        this.sessionKey = byArray3;
        this.cpubkey = securityMessage.getPublicKey();
        this.md.reset();
        this.md.update(byArray);
        this.md.update(this.initialKey.getBytes());
        byte[] byArray4 = this.md.digest(byArray2);
        this.md.reset();
        this.md.update(byArray);
        this.md.update(this.initialKey.getBytes());
        this.md.update(byArray2);
        this.md.update(securityMessage.getResponse());
        this.md.update(securityMessage.getPublicKey().getEncoded());
        this.md.update(securityMessage.getSessionId());
        if (!MessageDigest.isEqual(this.md.digest(), securityMessage.getChecksum())) {
            Debug.trace1((String)("Sundigest: invalid credentials: " + this.userName));
            upp.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        byte[] byArray5 = SecurityUtil.extractHashedData((byte[])securityMessage.getResponse(), (byte[])byArray4);
        if (byArray5 == null) {
            upp.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        boolean bl = false;
        if (this.bLocalMode) {
            if (Arrays.equals(byArray5, byArray2)) {
                bl = true;
            }
        } else {
            try {
                bl = upp.authenticateUser(this.userName, new String(byArray5, "UTF-8"));
            }
            catch (Exception exception) {
                Debug.trace1((String)("Sundigest: error creating password string with UTF-8 converter: " + exception.getMessage()));
            }
        }
        if (!bl) {
            Debug.trace1((String)("Sundigest: invalid credentials: " + this.userName));
            upp.auditLogin(this.clientHost, this.userName, -2L);
            throw new CIMSecurityException("INVALID_CREDENTIAL");
        }
        Debug.trace1((String)("Sundigest: client authenticated: " + this.userName));
        this.decryptKey = new byte[byArray3.length];
        System.arraycopy(byArray3, 0, this.decryptKey, 0, this.decryptKey.length);
        this.auditKey = new byte[4];
        System.arraycopy(byArray3, 0, this.auditKey, 0, 4);
        this.md.reset();
        this.md.update(byArray);
        byArray4 = this.md.digest(byArray5);
        byte[] byArray6 = SecurityUtil.hashData((byte[])byArray3, (byte[])byArray4);
        this.md.reset();
        this.md.update(byArray);
        this.md.update(byArray5);
        this.md.update(securityMessage.getSessionId());
        this.md.update(publicKey.getEncoded());
        upp.auditLogin(this.clientHost, this.userName, 1L);
        return SecurityMessage.result((byte[])securityMessage.getSessionId(), (PublicKey)publicKey, (byte[])byArray6, (byte[])this.md.digest(byArray6));
    }

    public void assumeRole(String string, String string2) throws CIMException {
        String string3 = this.trans51Unformat(string2);
        if (!upp.authenticateRole(string, string3, this.userName)) {
            Debug.trace1((String)("Solarisdigest: role assumption; : Could not assume role " + string + " for user " + this.userName));
            upp.auditLogin(this.clientHost, string, -2L);
            throw new CIMSecurityException("CANNOT_ASSUME_ROLE", (Object)this.userName, (Object)string);
        }
        this.roleName = string;
        Debug.trace1((String)("Solarisdigest: role assumed: " + this.roleName));
        upp.auditLogin(this.clientHost, string, 1L);
    }

    public void authenticateRequest(String[] stringArray, SecurityToken securityToken) throws CIMException {
        ServerSecurity.setRequestSession(this);
        MessageDigest messageDigest = this.getMD();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = string + stringArray[n];
            ++n;
        }
        byte[] byArray = string.getBytes();
        messageDigest.reset();
        messageDigest.update(this.getSessionKey());
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        if (!MessageDigest.isEqual(byArray2, securityToken.getChecksum())) {
            Debug.trace1((String)"Sundigest: method authentication; invalid digest");
            throw new CIMSecurityException("CHECKSUM_ERROR");
        }
    }

    public void incSessionKey() {
        SecurityUtil.incByteArray((byte[])this.sessionKey);
    }

    public String trans51Unformat(String string) {
        byte[] byArray = this.fromHex(string);
        if (byArray == null) {
            return null;
        }
        if (this.decryptKey == null) {
            return null;
        }
        int n = this.decryptKey.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.decryptKey, 0, byArray2, 0, n);
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        while (n2 < n4) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray[n2]);
            if (bl && byArray2[n2] == 0) {
                bl = false;
                n3 = n2;
            }
            ++n2;
        }
        if (n3 < 1 || n3 > 15) {
            return null;
        }
        String string2 = new String(byArray2, 0, n3);
        return string2;
    }

    public static void setRequestSession(CommonServerSecurityContext commonServerSecurityContext) {
        requestSession.set(commonServerSecurityContext);
    }

    static CommonServerSecurityContext getRequestSession() {
        return (CommonServerSecurityContext)requestSession.get();
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getClientHostName() {
        return this.clientHost;
    }

    public int getAuditId() {
        int n = 0;
        if (this.auditKey != null) {
            n = (this.auditKey[0] & 0xFF) << 24;
            n |= (this.auditKey[1] & 0xFF) << 16;
            n |= (this.auditKey[2] & 0xFF) << 8;
            n |= this.auditKey[3] & 0xFF;
        }
        return n;
    }

    private void removeLocalFile() {
        if (this.localFile != null && this.localFile.length() > 0) {
            try {
                File file = new File(WBEM_LOCAL_DIR + File.separator + this.localFile);
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length() / 2 * 2;
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = 0;
            boolean bl = false;
            char c = string.charAt(n2);
            int n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(n4 << 4 & 0xF0);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            bl = false;
            c = string.charAt(++n2);
            n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(byArray[n3] | (byte)(n4 & 0xF));
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            ++n3;
            ++n2;
        }
        return byArray;
    }

    static {
        upp = null;
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

