/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.MOFFormatter;
import com.sun.wbem.cim.XmlInstance;
import java.util.Enumeration;
import java.util.Vector;

public class CIMProperty
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private String originClass = "";
    private CIMDataType type = null;
    private int size = 0;
    private Vector qualifiers = new Vector();
    private String op = null;
    private CIMValue value = null;

    public CIMProperty() {
        this("");
    }

    public CIMProperty(String string) {
        super(string);
    }

    public CIMProperty(String string, CIMValue cIMValue) {
        this(string);
        this.value = cIMValue;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void setQualifiers(Vector vector) {
        this.qualifiers = vector;
    }

    public String getOriginClass() {
        return this.originClass;
    }

    public void setOriginClass(String string) {
        this.originClass = string == null ? "" : string;
    }

    public void setValue(CIMValue cIMValue) {
        this.value = cIMValue;
    }

    public CIMValue getValue() {
        return this.value;
    }

    public void setType(CIMDataType cIMDataType) {
        this.type = cIMDataType;
    }

    public CIMDataType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value != null) {
            return this.value.getType();
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void setOverridingProperty(String string) {
        this.op = string;
    }

    public String getOverridingProperty() {
        return this.op;
    }

    public boolean isReference() {
        if (this.type == null) {
            return false;
        }
        return this.type.getType() == 28;
    }

    public CIMQualifier getQualifier(String string) {
        if (string == null) {
            return null;
        }
        int n = this.qualifiers.indexOf(new CIMQualifier(string));
        CIMQualifier cIMQualifier = n >= 0 ? (CIMQualifier)this.qualifiers.elementAt(n) : null;
        return cIMQualifier;
    }

    public CIMQualifier setQualifier(CIMQualifier cIMQualifier) throws CIMException {
        CIMQualifier cIMQualifier2 = this.getQualifier(cIMQualifier.getName());
        if (cIMQualifier2 == null) {
            throw new CIMException("Property " + this.getName() + " does not have qualifier " + cIMQualifier.getName());
        }
        cIMQualifier2.setValue(cIMQualifier.getValue());
        return cIMQualifier2;
    }

    public void addQualifier(CIMQualifier cIMQualifier) throws CIMException {
        CIMQualifier cIMQualifier2 = this.getQualifier(cIMQualifier.getName());
        if (cIMQualifier2 != null) {
            throw new CIMException("Property " + this.getName() + " already has qualifier " + cIMQualifier.getName());
        }
        this.qualifiers.addElement(cIMQualifier);
    }

    public boolean removeQualifier(String string) {
        return this.qualifiers.removeElement(new CIMQualifier(string));
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public synchronized Object clone() {
        return this.clone(true, true);
    }

    public synchronized Object clone(boolean bl, boolean bl2) {
        CIMProperty cIMProperty = new CIMProperty();
        cIMProperty.name = this.name;
        cIMProperty.identifier = this.identifier;
        cIMProperty.type = this.type;
        if (bl2) {
            cIMProperty.originClass = this.originClass;
        }
        cIMProperty.size = this.size;
        cIMProperty.value = this.value;
        cIMProperty.op = this.op;
        if (this.qualifiers == null || !bl) {
            cIMProperty.qualifiers = new Vector();
        } else {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.qualifiers.elements();
            while (enumeration.hasMoreElements()) {
                CIMQualifier cIMQualifier = (CIMQualifier)enumeration.nextElement();
                vector.addElement(cIMQualifier.clone());
            }
            cIMProperty.qualifiers = vector;
        }
        return cIMProperty;
    }

    public boolean isKey() {
        if (this.getOverridingProperty() != null) {
            return false;
        }
        if (this.isReference()) {
            return true;
        }
        CIMQualifier cIMQualifier = this.getQualifier("key");
        if (cIMQualifier == null) {
            return false;
        }
        return cIMQualifier.getValue() == null || cIMQualifier.getValue().equals(CIMValue.TRUE);
    }

    public String toXml() {
        XmlInstance xmlInstance = new XmlInstance();
        return xmlInstance.toXml(this);
    }
}

