/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMElement;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlInstance;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CIMObjectPath
implements Serializable {
    static final long serialVersionUID = 200L;
    private String nameSpace = "";
    private String objectName = "";
    private Vector keys = new Vector();
    private String host = "";

    private String validateNameSpace(String string) {
        int n;
        if (string == null || string.length() == 0) {
            return "";
        }
        boolean bl = false;
        string = string.replace('/', '\\');
        string = string.toLowerCase();
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n = string.charAt(n3);
            stringBuffer.append((char)n);
            if (n == 92) {
                try {
                    while (string.charAt(n3 + 1) == '\\') {
                        ++n3;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
            }
            ++n3;
        }
        string = stringBuffer.toString();
        n = string.length();
        if (n > 1 && string.endsWith("\\")) {
            --n;
        }
        return string.substring(0, n).toLowerCase();
    }

    public CIMObjectPath() {
    }

    public CIMObjectPath(String string) {
        this();
        this.objectName = string;
    }

    public CIMObjectPath(String string, String string2) {
        this(string);
        this.nameSpace = this.validateNameSpace(string2);
    }

    public CIMObjectPath(String string, Vector vector) {
        this(string);
        this.keys = vector;
    }

    public void addKey(String string, CIMValue cIMValue) {
        CIMProperty cIMProperty = new CIMProperty(string, cIMValue);
        try {
            cIMProperty.addQualifier(new CIMQualifier("key"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cIMValue != null) {
            cIMProperty.setType(cIMValue.getType());
        }
        this.keys.addElement(cIMProperty);
    }

    public Vector getKeys() {
        return this.keys;
    }

    public void setKeys(Vector vector) {
        this.keys = vector;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getHost() {
        return this.host;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void parse(String string) {
        string = string.replace('/', '\\');
        this.nameSpace = this.validateNameSpace(string.substring(0, string.lastIndexOf("\\")));
        this.objectName = string.substring(string.lastIndexOf("\\") + 1, string.length());
    }

    public void setHost(String string) {
        this.host = string == null ? "" : string;
    }

    public void setNameSpace(String string) {
        this.nameSpace = this.validateNameSpace(string);
    }

    public void setObjectName(String string) {
        this.objectName = string;
    }

    private String escaped(char c, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n2 = (1 << n) - 1;
        while (n3 > 0) {
            stringBuffer.append('\\');
            --n3;
        }
        stringBuffer.append(c);
        return stringBuffer.toString();
    }

    private String escapedns(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            if (c != '\\' && c != '/') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append(this.escaped('\\', n));
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String escapedString(String string, int n) {
        int n2 = n + 1;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.escaped('\"', n);
        stringBuffer.append(string2);
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            char c = string.charAt(n4);
            switch (c) {
                case '\n': {
                    stringBuffer.append(this.escaped('n', n2));
                    break;
                }
                case '\t': {
                    stringBuffer.append(this.escaped('t', n2));
                    break;
                }
                case '\b': {
                    stringBuffer.append(this.escaped('b', n2));
                    break;
                }
                case '\r': {
                    stringBuffer.append(this.escaped('r', n2));
                    break;
                }
                case '\f': {
                    stringBuffer.append(this.escaped('f', n2));
                    break;
                }
                case '\\': {
                    stringBuffer.append(this.escaped('\\', n2));
                    break;
                }
                case '\"': {
                    stringBuffer.append(this.escaped('\"', n2));
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n4;
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    private String toString(int n) {
        Object object;
        int n2 = n - 1;
        String string = this.escaped('\"', n2);
        if (this.keys == null || this.keys.size() == 0) {
            if (this.objectName != null && this.objectName.length() != 0) {
                return string + this.escapedns(this.nameSpace, n) + ":" + this.objectName + string;
            }
            return string + this.escapedns(this.nameSpace, n) + string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        Enumeration enumeration = this.keys.elements();
        while (enumeration.hasMoreElements()) {
            object = (CIMProperty)enumeration.nextElement();
            if (object == null) continue;
            stringBuffer.append(((CIMElement)object).getName() + "=");
            Object object2 = null;
            CIMValue cIMValue = null;
            try {
                cIMValue = ((CIMProperty)object).getValue();
                object2 = cIMValue.getValue();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (object2 instanceof String) {
                stringBuffer.append(this.escapedString((String)object2, n));
            } else if (object2 instanceof CIMObjectPath) {
                stringBuffer.append(((CIMObjectPath)object2).toString(n + 1));
            } else if (object2 instanceof CIMDateTime) {
                String string2 = this.escaped('\"', n);
                stringBuffer.append(string2 + object2.toString() + string2);
            } else {
                stringBuffer.append("" + cIMValue);
            }
            stringBuffer.append(",");
            ++n3;
        }
        if (n3 > 0) {
            object = stringBuffer.toString();
            return string + this.escapedns(this.nameSpace, n) + ":" + this.objectName + "." + ((String)object).substring(0, ((String)object).lastIndexOf(",")) + string;
        }
        return string + this.escapedns(this.nameSpace, n) + ":" + this.objectName + string;
    }

    public String toString() {
        return this.toString(1);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof CIMObjectPath) || object == null) {
            return false;
        }
        CIMObjectPath cIMObjectPath = (CIMObjectPath)object;
        if (cIMObjectPath.nameSpace == null ? this.nameSpace != null && this.nameSpace.length() != 0 : !cIMObjectPath.nameSpace.equalsIgnoreCase(this.nameSpace)) {
            return false;
        }
        if (cIMObjectPath.objectName == null ? this.objectName != null && this.objectName.length() != 0 : !cIMObjectPath.objectName.equalsIgnoreCase(this.objectName)) {
            return false;
        }
        if (cIMObjectPath.keys == null) {
            if (this.keys != null) {
                return false;
            }
        } else {
            CIMProperty cIMProperty;
            if (this.keys == null) {
                return false;
            }
            if (cIMObjectPath.keys.size() != this.keys.size()) {
                return false;
            }
            Hashtable<String, CIMProperty> hashtable = new Hashtable<String, CIMProperty>();
            int n = 0;
            while (n < this.keys.size()) {
                cIMProperty = (CIMProperty)this.keys.elementAt(n);
                if (bl) {
                    hashtable.put(cIMProperty.getName().toLowerCase(), cIMProperty);
                } else {
                    hashtable.put(cIMProperty.getOriginClass().toLowerCase() + "." + cIMProperty.getName().toLowerCase(), cIMProperty);
                }
                ++n;
            }
            n = 0;
            while (n < this.keys.size()) {
                CIMProperty cIMProperty2 = (CIMProperty)cIMObjectPath.keys.elementAt(n);
                cIMProperty = bl ? (CIMProperty)hashtable.get(cIMProperty2.getName().toLowerCase()) : (CIMProperty)hashtable.get(cIMProperty2.getOriginClass().toLowerCase() + "." + cIMProperty2.getName().toLowerCase());
                CIMValue cIMValue = cIMProperty.getValue();
                CIMValue cIMValue2 = cIMProperty2.getValue();
                if (cIMValue2 == null ? cIMValue != null : !cIMValue2.equals(cIMValue)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public String toXml() throws CIMException {
        XmlInstance xmlInstance = new XmlInstance();
        return xmlInstance.toXml(this);
    }
}

