/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryFilter;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableSetup;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryTableFactory {
    public static DirectoryTable getDirectoryTableInstance(String string) throws DirectoryTableException {
        int n = 0;
        n = string.indexOf(":/");
        if (n == -1 || n < 2) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1, n).toLowerCase();
        String string3 = string.length() > n + 2 ? string.substring(n + 2) : "";
        String string4 = "com.sun.wbem.utility.directorytable." + string2 + "DirectoryTable";
        try {
            DirectoryTable directoryTable = (DirectoryTable)Class.forName(string4).newInstance();
            if (directoryTable != null) {
                directoryTable.setContext(string3);
            }
            return directoryTable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", string2);
        }
        catch (InstantiationException instantiationException) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", string2);
        }
    }

    public static DirectoryTable getDirectoryTableInstance(String string, String string2, String string3) {
        try {
            return DirectoryTableFactory.getDirectoryTableInstance(string + ":/" + string3 + "/" + string2);
        }
        catch (DirectoryTableException directoryTableException) {
            return null;
        }
    }

    public static DirectoryTable getDirectoryTableInstance(String string, String string2, String string3, String string4, String string5) {
        try {
            return DirectoryTableFactory.getDirectoryTableInstance(string + ":/" + string3 + "/" + string2 + "/authName = " + string4 + ", authPassword = " + string5);
        }
        catch (DirectoryTableException directoryTableException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            System.out.println("Instantiate a table for a given nameservice");
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance("File", "", "");
            System.out.println("Open the hosts table");
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("hosts");
            try {
                directoryTable.open(tableDefinitions);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                directoryTable.create(tableDefinitions);
            }
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(tableDefinitions.getColumnNumber("addr"), "128.99.99.99");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("cname"), "testhost");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("aliases"), "testalias");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("comment"), "test entry");
            System.out.println("Add the new row we built");
            directoryTable.addRow(directoryRow);
            System.out.println("Now delete the row we added before");
            directoryTable.deleteRow(directoryRow);
            System.out.println("Build a different new row to add");
            directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(tableDefinitions.getColumnNumber("addr"), "128.98.98.98");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("cname"), "testhost2");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("aliases"), "testalias2");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("comment"), "test entry2");
            System.out.println("Add the new row we built");
            directoryTable.addRow(directoryRow);
            System.out.println("Build a modify template");
            DirectoryRow directoryRow2 = directoryRow.extractRows(1, 1);
            directoryRow2.putColumn(tableDefinitions.getColumnNumber("cname"), "testhost3");
            System.out.println("Modify the last row we added");
            directoryTable.modifyRow(directoryRow, directoryRow2);
            System.out.println("Now enumerate the filtered rows with first/next");
            DirectoryFilter directoryFilter = new DirectoryFilter(1);
            directoryFilter.add(tableDefinitions.getColumnNumber("cname"), 1, 5, "testhost3");
            DirectoryRow directoryRow3 = directoryTable.getFirstRow(directoryFilter);
            int n2 = 0;
            while (directoryRow3 != null) {
                System.out.print("Row " + n2 + ": ");
                n = 1;
                while (n <= directoryRow3.getNumberOfColumns()) {
                    System.out.print(tableDefinitions.getColumnName(n) + " = " + directoryRow3.getColumn(n) + " ");
                    ++n;
                }
                System.out.println("");
                directoryRow3 = directoryTable.getNextRow(directoryFilter);
                ++n2;
            }
            System.out.println("Now delete the row we modified");
            directoryTable.deleteRow(directoryRow2);
            System.out.println("Now enumerate the rows sorted by cname");
            directoryRow3 = directoryTable.getAll();
            if (directoryRow3 != null) {
                directoryRow3.sortByColumn(tableDefinitions.getColumnNumber("cname"), tableDefinitions);
                n = 1;
                while (n <= directoryRow3.getNumberOfRows()) {
                    System.out.print("Row " + n + ": ");
                    int n3 = 1;
                    while (n3 <= directoryRow3.getNumberOfColumns()) {
                        System.out.print(tableDefinitions.getColumnName(n3) + " = " + directoryRow3.getColumn(n3, n) + " ");
                        ++n3;
                    }
                    System.out.println("");
                    ++n;
                }
            }
            System.out.println("Close the table");
            directoryTable.close();
        }
        catch (DirectoryTableException directoryTableException) {
            System.out.println(directoryTableException.getMessage());
        }
    }

    static {
        DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
        directoryTableSetup.setup();
    }
}

