/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.logsvc;

import com.sun.wbem.cimom.ReadersWriter;
import com.sun.wbem.solarisprovider.common.PropertyUtil;
import com.sun.wbem.solarisprovider.common.PropertyUtilException;
import com.sun.wbem.solarisprovider.logsvc.AdminLogException;
import com.sun.wbem.solarisprovider.logsvc.Buffer;
import com.sun.wbem.solarisprovider.logsvc.CorruptDataException;
import com.sun.wbem.solarisprovider.logsvc.DataRecord;
import com.sun.wbem.solarisprovider.logsvc.DataStore;
import com.sun.wbem.solarisprovider.logsvc.FilterThread;
import com.sun.wbem.solarisprovider.logsvc.Filterable;
import com.sun.wbem.solarisprovider.logsvc.InvalidRecordException;
import com.sun.wbem.solarisprovider.logsvc.LogFileNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogRecord;
import com.sun.wbem.solarisprovider.logsvc.LogRecordNotFoundException;
import com.sun.wbem.solarisprovider.logsvc.LogServiceInterface;
import com.sun.wbem.solarisprovider.logsvc.LogSvcNative;
import com.sun.wbem.solarisprovider.logsvc.ReadThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LogService
implements LogServiceInterface {
    public static final String LOG_SERVICE_FILE_DIR = "wbem.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "wbem.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "wbem.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "wbem.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "wbem.logging.syslog";
    public static final String LOG_FILE_DIR = "/var/sadm/wbem/log";
    public static final String LOG_FILE_NAME = "wbem_log";
    public static final int LOG_FILE_SIZE = 5;
    public static final int LOG_FILE_NUM = 5;
    public static final String SYSLOG_SWITCH = "on";
    public static final String TYPE_SYSLOG = "Syslog";
    public static final String TYPE_WBEMLOG = "WBEM Log";
    public static final String IDENTITY = "WBEM_Logging_Service";
    public static final String LOGSVC_APPNAME = "Log Viewer";
    public static final int MEG = 0x100000;
    public static final int EIGHT_K = 8192;
    private static final String CONF = "/etc/syslog.conf";
    private static final String DEV = "/dev";
    private static ReadersWriter lock = null;
    private Map logFilesHash = Collections.synchronizedMap(new HashMap());
    private Map syslogFilesHash = Collections.synchronizedMap(new HashMap());
    private DataStore storage;
    private long fileSize = 0L;
    private int numOfLogFiles = 0;
    private String dirName = null;
    private String fileName = null;
    private String logFileName = null;
    private long currentFileSize = 0L;
    private String currentViewerFileName = null;
    private boolean serverSyslogSwitch = true;
    private boolean syslogEx = false;
    private PropertyUtil props = null;
    public static LogService theOnlyService = null;

    public static LogService getInstance() throws AdminLogException {
        if (theOnlyService == null) {
            theOnlyService = new LogService();
        }
        return theOnlyService;
    }

    private LogService() throws AdminLogException {
        String string = null;
        String string2 = null;
        String string3 = null;
        try {
            this.props = new PropertyUtil("propdir", "WbemServices.properties", 1);
            this.fileName = this.props.getProp(LOG_SERVICE_FILE_NAME);
            this.dirName = this.props.getProp(LOG_SERVICE_FILE_DIR);
            string = this.props.getProp(LOG_SERVICE_FILE_SIZE);
            string2 = this.props.getProp(LOG_SERVICE_FILE_NUM);
            string3 = this.props.getProp(LOG_SERVICE_SYSLOG);
        }
        catch (PropertyUtilException propertyUtilException) {
            throw new AdminLogException(propertyUtilException.getMessage());
        }
        if (this.fileName == null) {
            this.fileName = LOG_FILE_NAME;
        }
        if (this.dirName == null) {
            this.dirName = LOG_FILE_DIR;
        }
        this.fileSize = string == null ? 5L : Long.parseLong(string);
        this.fileSize *= 0x100000L;
        this.numOfLogFiles = string2 == null ? 5 : Integer.parseInt(string2);
        if (string3 == null) {
            string3 = SYSLOG_SWITCH;
        }
        this.serverSyslogSwitch = string3.equalsIgnoreCase(SYSLOG_SWITCH);
        File file = new File(this.dirName);
        if (!file.exists() && !file.mkdirs()) {
            throw new AdminLogException("EXLOG_DIR", this.dirName);
        }
        this.logFileName = this.dirName + File.separator + this.fileName;
        this.initHash();
        this.fillSyslogHash();
        if (lock == null) {
            lock = new ReadersWriter();
        }
    }

    public void writeRecord(LogRecord logRecord, boolean bl) throws AdminLogException {
        this.writeRecord(logRecord, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRecord(LogRecord logRecord, boolean bl, String string) throws AdminLogException {
        try {
            lock.writeLock();
            try {
                this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
            }
            catch (CorruptDataException corruptDataException) {
                File file = new File(this.logFileName);
                try {
                    if (file.exists()) {
                        file.renameTo(new File(this.logFileName + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception exception) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                this.initHash();
                throw new AdminLogException("EXLOG_COR", this.logFileName);
            }
            catch (InvalidRecordException invalidRecordException) {
            }
            catch (IOException iOException) {
                File file = new File(this.logFileName);
                try {
                    if (file.exists()) {
                        file.renameTo(new File(this.logFileName + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception exception) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
                this.initHash();
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
            if (this.currentFileSize < 0L) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException adminLogException) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
                try {
                    this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
                }
                catch (InvalidRecordException invalidRecordException) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
                catch (IOException iOException) {
                    throw new AdminLogException("EXLOG_IO", this.logFileName);
                }
            }
            if (this.currentFileSize == this.fileSize) {
                try {
                    this.synchronizedClearLog(this.currentViewerFileName);
                }
                catch (AdminLogException adminLogException) {
                    throw new AdminLogException("EXLOG_WR", this.logFileName);
                }
            }
            if (bl && this.serverSyslogSwitch) {
                int n;
                String string2 = logRecord.getDetailedMesg(true);
                if (string2 == null) {
                    string2 = logRecord.getSummaryMesg(true);
                }
                if ((n = logRecord.getSeverity()) == -1) {
                    n = 0;
                }
                try {
                    LogSvcNative.writeToSyslog(string2, IDENTITY, n);
                }
                catch (AdminLogException adminLogException) {
                }
            }
            Object var10_18 = null;
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            lock.writeUnlock();
            throw throwable;
        }
        lock.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord readRecord(long l, int n, String string) throws AdminLogException {
        LogRecord logRecord;
        try {
            lock.readLock();
            logRecord = this.synchronizedReadRecord(l, n, string);
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return logRecord;
    }

    public long getNumRecords(String string) throws AdminLogException {
        return this.synchronizedGetNumRecords(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getStartDate(String string) throws AdminLogException {
        long l;
        block10: {
            long l2;
            block9: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = -1L;
                        Object var9_7 = null;
                        break block9;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    String string2 = (String)vector.elementAt(0);
                    if (string2 == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    File file = new File(string2);
                    try {
                        if (!file.exists()) {
                            throw new LogFileNotFoundException("EXLOG_DEL", string);
                        }
                    }
                    catch (Exception exception) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    l = dataStore.getFileDate();
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var9_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getList(int n, Filterable filterable, long l, String string) throws LogFileNotFoundException, AdminLogException {
        Vector vector;
        try {
            lock.readLock();
            vector = this.synchronizedGetList(n, filterable, l, string);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        try {
            lock.writeLock();
            this.synchronizedClearLog(string);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.writeUnlock();
            throw throwable;
        }
        lock.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listLogFiles() throws AdminLogException {
        String[] stringArray;
        try {
            lock.readLock();
            stringArray = this.synchronizedListLogFiles();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentLogFileName() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetCurrentLogFileName();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLogFiles() {
        int n;
        try {
            lock.readLock();
            n = this.synchronizedGetNumLogFiles();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLogFileSize(String string) throws AdminLogException {
        long l;
        try {
            lock.readLock();
            l = this.synchronizedGetLogFileSize(string);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSyslogSwitch() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetSyslogSwitch();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogStorageName() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetLogStorageName();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogFileDir() {
        String string;
        try {
            lock.readLock();
            string = this.synchronizedGetLogFileDir();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(int n, int n2, String string, String string2) throws AdminLogException {
        try {
            lock.writeLock();
            this.synchronizedSetProperties(n, n2, string, string2);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.writeUnlock();
            throw throwable;
        }
        lock.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listSyslogFiles() throws AdminLogException {
        String[] stringArray;
        try {
            lock.readLock();
            this.fillSyslogHash();
            if (this.syslogEx && this.syslogFilesHash.size() == 0) {
                throw new AdminLogException("EXLOG_SYSLOGEX");
            }
            String[] stringArray2 = new String[this.syslogFilesHash.size()];
            Set set = this.syslogFilesHash.keySet();
            Map map = this.syslogFilesHash;
            synchronized (map) {
                set.toArray(stringArray2);
            }
            stringArray = stringArray2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            lock.readUnlock();
            throw throwable;
        }
        lock.readUnlock();
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSyslogRecords(String string) throws AdminLogException {
        block8: {
            String[] stringArray;
            try {
                String[] stringArray2;
                lock.readLock();
                this.fillSyslogHash();
                if (this.syslogEx && this.syslogFilesHash.size() == 0) {
                    throw new AdminLogException("EXLOG_SYSLOGEX");
                }
                if (string == null) break block8;
                File file = (File)this.syslogFilesHash.get(string);
                if (file == null || !file.exists()) {
                    throw new AdminLogException("EXLOG_FNF", string);
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    stringArray2 = new FileInputStream(file);
                    stringArray = new InputStreamReader((InputStream)stringArray2);
                    BufferedReader bufferedReader = new BufferedReader((Reader)stringArray);
                    while (bufferedReader.ready()) {
                        String string2 = bufferedReader.readLine();
                        arrayList.add(string2);
                    }
                    stringArray2.close();
                }
                catch (Exception exception) {
                    throw new AdminLogException(exception.getMessage());
                }
                stringArray2 = new String[arrayList.size()];
                arrayList.toArray(stringArray2);
                stringArray = stringArray2;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                lock.readUnlock();
                throw throwable;
            }
            lock.readUnlock();
            return stringArray;
        }
        String[] stringArray = null;
        Object var9_11 = null;
        lock.readUnlock();
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getLogPercentageFull(String string) throws AdminLogException {
        int n;
        block8: {
            int n2;
            block7: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        n2 = 0;
                        Object var9_8 = null;
                        break block7;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    try {
                        double d = dataStore.getFileSize();
                        Double d2 = new Double(d / (double)this.fileSize * 100.0);
                        n = d2.intValue();
                        break block8;
                    }
                    catch (IOException iOException) {
                        throw new AdminLogException("EXLOG_IO", string);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return n2;
        }
        Object var9_9 = null;
        lock.readUnlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getTimeOfLastChange(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var7_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = dataStore.getTimeOfLastChange();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var7_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogHeaderFormat(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = "";
                        Object var6_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = dataStore.getLogHeaderFormat();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var6_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLogHeaderSize(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var7_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = dataStore.getLogHeaderSize();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var7_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRecordHeaderFormat(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = null;
                        Object var6_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = dataStore.getRecordHeaderFormat();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var6_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getRecordHeaderSize(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var7_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = dataStore.getRecordHeaderSize();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var7_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogType(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        if (!file.exists()) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = TYPE_SYSLOG;
                        Object var6_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = TYPE_WBEMLOG;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var6_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxLogFileSize(String string) throws AdminLogException {
        long l;
        block6: {
            long l2;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        l2 = 0L;
                        Object var7_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    l = this.fileSize;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return l2;
        }
        Object var7_8 = null;
        lock.readUnlock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogVersion(String string) throws AdminLogException {
        String string2;
        block6: {
            String string3;
            block5: {
                try {
                    Vector vector;
                    lock.readLock();
                    if (string == null) {
                        string = this.currentViewerFileName;
                    }
                    if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
                        File file = (File)this.syslogFilesHash.get(string);
                        if (file == null) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        if (!file.exists()) throw new LogFileNotFoundException("EXLOG_FNF", string);
                        string3 = "N/A";
                        Object var6_7 = null;
                        break block5;
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    string2 = dataStore.getVersion();
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    lock.readUnlock();
                    throw throwable;
                }
            }
            lock.readUnlock();
            return string3;
        }
        Object var6_8 = null;
        lock.readUnlock();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogFileName(String string) {
        Iterator iterator;
        block8: {
            String string2;
            block9: {
                String string3;
                block7: {
                    try {
                        lock.readLock();
                        if (this.syslogFilesHash.get(string) != null) {
                            string3 = string;
                            Object var11_4 = null;
                            break block7;
                        }
                        Set set = this.logFilesHash.entrySet();
                        Map map = this.logFilesHash;
                        synchronized (map) {
                            Map.Entry entry;
                            Vector vector;
                            String string4;
                            iterator = set.iterator();
                            do {
                                if (iterator.hasNext()) continue;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var3_8
                                iterator = null;
                                break block8;
                            } while (!(string4 = (String)(vector = (Vector)(entry = (Map.Entry)iterator.next()).getValue()).elementAt(0)).equalsIgnoreCase(string));
                            string2 = (String)entry.getKey();
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var11_7 = null;
                        lock.readUnlock();
                        throw throwable;
                    }
                }
                lock.readUnlock();
                return string3;
            }
            Object var11_5 = null;
            lock.readUnlock();
            return string2;
        }
        Object var11_6 = null;
        lock.readUnlock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogStorageName(String string) {
        Iterator iterator;
        block8: {
            String string2;
            block9: {
                String string3;
                block7: {
                    try {
                        lock.readLock();
                        if (this.syslogFilesHash.get(string) != null) {
                            string3 = string;
                            Object var12_4 = null;
                            break block7;
                        }
                        Set set = this.logFilesHash.entrySet();
                        Map map = this.logFilesHash;
                        synchronized (map) {
                            String string4;
                            Map.Entry entry;
                            String string5;
                            iterator = set.iterator();
                            do {
                                if (iterator.hasNext()) continue;
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var3_8
                                iterator = null;
                                break block8;
                            } while (!(string5 = (String)(entry = (Map.Entry)iterator.next()).getKey()).equalsIgnoreCase(string));
                            Vector vector = (Vector)entry.getValue();
                            string2 = string4 = (String)vector.elementAt(0);
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var12_7 = null;
                        lock.readUnlock();
                        throw throwable;
                    }
                }
                lock.readUnlock();
                return string3;
            }
            Object var12_5 = null;
            lock.readUnlock();
            return string2;
        }
        Object var12_6 = null;
        lock.readUnlock();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_cascaded_backup() throws AdminLogException {
        File file;
        Object object;
        int n = 0;
        boolean bl = false;
        Collection collection = this.logFilesHash.values();
        Map map = this.logFilesHash;
        synchronized (map) {
            object = collection.toArray();
            n = 0;
            while (n < ((Object[])object).length) {
                DataStore dataStore;
                Vector vector = (Vector)object[n];
                if (vector != null && (dataStore = (DataStore)vector.elementAt(1)) != null) {
                    dataStore.close();
                }
                ++n;
            }
        }
        n = this.numOfLogFiles;
        while (n > 1) {
            object = new File(this.logFileName + "." + String.valueOf(n));
            file = new File(this.logFileName + "." + String.valueOf(n - 1));
            try {
                if (file.exists()) {
                    file.renameTo((File)object);
                }
            }
            catch (SecurityException securityException) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            --n;
        }
        object = new File(this.logFileName);
        file = new File(this.logFileName + ".1");
        try {
            if (((File)object).exists()) {
                ((File)object).renameTo(file);
            }
        }
        catch (SecurityException securityException) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        this.initHash();
        this.fillSyslogHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHash() throws AdminLogException {
        Vector<Object> vector = new Vector<Object>();
        Map map = this.logFilesHash;
        synchronized (map) {
            Serializable serializable;
            this.logFilesHash.clear();
            try {
                this.storage = new DataStore(this.logFileName);
            }
            catch (EOFException eOFException) {
                serializable = new File(this.logFileName);
                try {
                    if (((File)serializable).exists()) {
                        ((File)serializable).renameTo(new File(this.logFileName + ".corrupted"));
                    }
                    this.storage = new DataStore(this.logFileName);
                }
                catch (Exception exception) {
                    throw new AdminLogException("EXLOG_FPM", this.dirName);
                }
            }
            catch (IOException iOException) {
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
            long l = this.storage.getFileDate();
            if (l <= 0L) {
                throw new AdminLogException("EXLOG_COR", this.logFileName);
            }
            Date date = new Date(l);
            serializable = (SimpleDateFormat)DateFormat.getDateInstance(1);
            ((SimpleDateFormat)serializable).applyPattern("MM/dd/yyyy.HH:mm:ss");
            String string = ((DateFormat)serializable).format(date);
            if (string == null) {
                string = String.valueOf(l);
            }
            vector.addElement(this.logFileName);
            vector.addElement(this.storage);
            this.currentViewerFileName = "Log." + string;
            this.logFilesHash.put(this.currentViewerFileName, vector.clone());
            vector.removeAllElements();
            int n = 0;
            DataStore dataStore = null;
            n = 1;
            while (n <= this.numOfLogFiles) {
                block24: {
                    block23: {
                        File file = new File(this.logFileName + "." + String.valueOf(n));
                        try {
                            if (file.exists()) {
                                try {
                                    dataStore = new DataStore(this.logFileName + "." + String.valueOf(n));
                                }
                                catch (EOFException eOFException) {
                                }
                                catch (IOException iOException) {}
                            }
                        }
                        catch (Exception exception) {
                            throw new AdminLogException("EXLOG_FPM", this.dirName);
                        }
                        if (dataStore == null) break block23;
                        l = dataStore.getFileDate();
                        if (l <= 0L) break block24;
                        date = new Date(l);
                        ((SimpleDateFormat)serializable).applyPattern("MM/dd/yyyy.HH:mm:ss");
                        string = ((DateFormat)serializable).format(date);
                        if (string == null) {
                            string = String.valueOf(l);
                        }
                        vector.addElement(this.logFileName + "." + String.valueOf(n));
                        vector.addElement(dataStore);
                        this.logFilesHash.put("Log." + string, vector.clone());
                    }
                    dataStore = null;
                    vector.removeAllElements();
                }
                ++n;
            }
        }
    }

    private LogRecord synchronizedReadRecord(long l, int n, String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        DataRecord dataRecord = null;
        Vector vector = (Vector)this.logFilesHash.get(string);
        if (vector == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        try {
            dataRecord = dataStore.readSpecificRecordAsStr(l, n);
        }
        catch (CorruptDataException corruptDataException) {
            String string3 = dataStore.getFileName();
            File file2 = new File(string3);
            try {
                if (file2.exists()) {
                    file2.renameTo(new File(dataStore.getFileName() + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_COR", string);
        }
        catch (InvalidRecordException invalidRecordException) {
            throw new LogRecordNotFoundException(invalidRecordException.getMessage());
        }
        catch (EOFException eOFException) {
            String string4 = dataStore.getFileName();
            File file3 = new File(string4);
            try {
                if (file3.exists()) {
                    file3.renameTo(new File(dataStore.getFileName() + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_IO", string);
        }
        catch (IOException iOException) {
            String string5 = dataStore.getFileName();
            File file4 = new File(string5);
            try {
                if (file4.exists()) {
                    file4.renameTo(new File(dataStore.getFileName() + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_IO", string);
        }
        if (dataRecord == null) {
            String string6 = dataStore.getFileName();
            File file5 = new File(string6);
            try {
                if (file5.exists()) {
                    file5.renameTo(new File(dataStore.getFileName() + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            throw new AdminLogException("EXLOG_COR", string);
        }
        LogRecord logRecord = (LogRecord)dataRecord.getRecord();
        logRecord.setRecordId(dataRecord.getOffset());
        logRecord.setHashCode(dataRecord.getHash());
        return logRecord;
    }

    private Vector synchronizedGetList(int n, Filterable filterable, long l, String string) throws LogFileNotFoundException, AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        Buffer buffer = new Buffer();
        FilterThread filterThread = new FilterThread(buffer, filterable, n);
        ReadThread readThread = new ReadThread(buffer, l, n, filterable.getSortDirection(), dataStore);
        Thread thread = new Thread(filterThread);
        Thread thread2 = new Thread(readThread);
        thread2.start();
        thread.start();
        try {
            thread2.join();
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AdminLogException adminLogException = buffer.getException();
        if (adminLogException != null && (adminLogException instanceof CorruptDataException || adminLogException instanceof InvalidRecordException)) {
            String string3 = dataStore.getFileName();
            File file2 = new File(string3);
            try {
                if (file2.exists()) {
                    file2.renameTo(new File(dataStore.getFileName() + ".corrupted"));
                }
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            this.initHash();
            this.fillSyslogHash();
            throw new AdminLogException("EXLOG_COR", string);
        }
        return buffer.getVect();
    }

    private synchronized long synchronizedGetNumRecords(String string) throws AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            File file = (File)this.syslogFilesHash.get(string);
            if (file != null) {
                try {
                    String[] stringArray = this.getSyslogRecords(string);
                    if (stringArray != null) {
                        return stringArray.length;
                    }
                    return 0L;
                }
                catch (Exception exception) {
                    return 0L;
                }
            }
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        return dataStore.getNumRecords();
    }

    private void synchronizedClearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if (!this.logFilesHash.containsKey(string)) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        Vector vector = (Vector)this.logFilesHash.get(string);
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new AdminLogException("EXLOG_ACT", (Object)string2, string);
        }
        if (string2.compareTo(this.logFileName) == 0) {
            this.do_cascaded_backup();
        } else {
            try {
                File file = new File(string2);
                if (file.exists()) {
                    vector = (Vector)this.logFilesHash.get(string);
                    if (vector == null) {
                        throw new LogFileNotFoundException("EXLOG_FNF", string);
                    }
                    DataStore dataStore = (DataStore)vector.elementAt(1);
                    if (dataStore != null) {
                        dataStore.close();
                    }
                    this.logFilesHash.remove(string);
                    file.delete();
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] synchronizedListLogFiles() {
        String[] stringArray = new String[this.logFilesHash.size()];
        Set set = this.logFilesHash.keySet();
        Map map = this.logFilesHash;
        synchronized (map) {
            Object[] objectArray = set.toArray();
            int n = 0;
            while (n < objectArray.length) {
                stringArray[n] = (String)objectArray[n];
                ++n;
            }
        }
        return stringArray;
    }

    private String synchronizedGetCurrentLogFileName() {
        return this.currentViewerFileName;
    }

    private int synchronizedGetNumLogFiles() {
        return this.numOfLogFiles;
    }

    private long synchronizedGetLogFileSize(String string) throws AdminLogException {
        Vector vector;
        if (this.fileName == null) {
            this.fileName = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            File file = (File)this.syslogFilesHash.get(string);
            if (file != null) {
                return file.length();
            }
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        try {
            return dataStore.getFileSize();
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", string);
        }
    }

    private String synchronizedGetSyslogSwitch() {
        if (this.serverSyslogSwitch) {
            return SYSLOG_SWITCH;
        }
        return "off";
    }

    private String synchronizedGetLogStorageName() {
        return this.fileName;
    }

    private String synchronizedGetLogFileDir() {
        return this.dirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void synchronizedSetProperties(int var1_1, int var2_2, String var3_3, String var4_4) throws AdminLogException {
        var5_5 = false;
        if (var3_3 == null) {
            var3_3 = "on";
        } else if (var3_3.equalsIgnoreCase("on")) {
            this.serverSyslogSwitch = true;
        } else if (var3_3.equalsIgnoreCase("off")) {
            this.serverSyslogSwitch = false;
        } else {
            var3_3 = "on";
        }
        if (var4_4 != null) {
            var6_6 = new File(var4_4);
            if (!var6_6.exists() && !var6_6.mkdirs()) {
                var5_5 = true;
            }
            if (var6_6.isDirectory()) {
                var10_8 = this.logFilesHash.values();
                var11_9 = this.logFilesHash;
                synchronized (var11_9) {
                    var12_10 = var10_8.toArray();
                    var13_12 = 0;
                    while (var13_12 < var12_10.length) {
                        var7_15 = (Vector)var12_10[var13_12];
                        if (var7_15 != null && (var8_16 = (DataStore)var7_15.elementAt(1)) != null) {
                            var8_16.close();
                        }
                        ++var13_12;
                    }
                }
                var12_11 = 1;
                while (var12_11 <= this.numOfLogFiles) {
                    var13_13 = var4_4 + File.separator + this.fileName;
                    var14_18 = this.logFileName;
                    var15_19 = new File(var13_13 + "." + String.valueOf(var12_11));
                    var16_20 = new File(var14_18 + "." + String.valueOf(var12_11));
                    try {
                        if (var16_20.exists() && !var16_20.renameTo(var15_19) && !this.do_copy(var16_20, var15_19)) {
                            this.flush_dir(var13_13, var12_11);
                            var5_5 = true;
                        }
                    }
                    catch (SecurityException var17_22) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    ++var12_11;
                }
                if (!var5_5) {
                    var13_14 = new File(this.logFileName);
                    var14_18 = var4_4 + File.separator + this.fileName;
                    var15_19 = new File(var14_18);
                    try {
                        if (!var13_14.exists()) ** GOTO lbl69
                        if (!var13_14.renameTo(var15_19)) {
                            if (!this.do_copy(var13_14, var15_19)) {
                                this.flush_dir(var14_18, 0);
                                var5_5 = true;
                            }
                            this.flush_dir(this.logFileName, -1);
                            this.logFileName = var4_4 + File.separator + this.fileName;
                            this.dirName = var4_4;
                        }
                        this.logFileName = var4_4 + File.separator + this.fileName;
                        this.dirName = var4_4;
                    }
                    catch (SecurityException var16_21) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                }
            } else {
                var5_5 = true;
            }
        }
lbl69:
        // 8 sources

        if (var1_1 > 0) {
            this.fileSize = var1_1 * 0x100000;
        }
        if (var2_2 > 0) {
            this.numOfLogFiles = var2_2;
        }
        if (var4_4 != null) {
            this.initHash();
            this.fillSyslogHash();
        }
        if (var5_5) {
            throw new AdminLogException("EXLOG_PROP_DIR", (Object)this.dirName, var4_4);
        }
        try {
            this.props.putProp("wbem.logging.file.size", String.valueOf(var1_1));
            this.props.putProp("wbem.logging.file.num", String.valueOf(var2_2));
            this.props.putProp("wbem.logging.file.dir", var4_4);
            this.props.putProp("wbem.logging.syslog", var3_3);
            this.props.saveProps("Wbem Services properties file");
        }
        catch (PropertyUtilException var6_7) {
            throw new AdminLogException(var6_7.getMessage());
        }
    }

    private boolean do_copy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 8192);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (Exception exception) {
            return false;
        }
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void flush_dir(String string, int n) {
        File file = null;
        int n2 = 0;
        int n3 = this.numOfLogFiles;
        if (n == -1) {
            file = new File(string);
        } else if (n == 0) {
            file = new File(string + "." + String.valueOf(1));
        } else {
            file = new File(string + "." + String.valueOf(1));
            n3 = n - 1;
        }
        while (n2 <= n3) {
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            file = new File(string + "." + String.valueOf(++n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSyslogHash() {
        boolean bl = false;
        Map map = this.syslogFilesHash;
        synchronized (map) {
            this.syslogFilesHash.clear();
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(CONF, "r");
            }
            catch (Exception exception) {
                this.syslogEx = true;
                bl = true;
                return;
            }
            String string = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                string = randomAccessFile.readLine();
                if (string == null) {
                    System.out.println("Empty conf file");
                }
                int n = 0;
                while (randomAccessFile.getFilePointer() < randomAccessFile.length()) {
                    String string2;
                    if (string == null || string.trim().length() == 0 || string.startsWith("#")) {
                        string = randomAccessFile.readLine();
                        continue;
                    }
                    int n2 = string.indexOf("/");
                    if (n2 == -1) {
                        string = randomAccessFile.readLine();
                        continue;
                    }
                    int n3 = string.indexOf(", ", n2);
                    if (n3 == -1) {
                        n3 = string.indexOf(" ", n2);
                    }
                    if (n3 == -1) {
                        n3 = string.indexOf("\n", n2);
                    }
                    if (n3 == -1) {
                        n3 = string.length();
                    }
                    if (!hashMap.containsValue(string2 = string.substring(n2, n3))) {
                        hashMap.put(String.valueOf(n), string2);
                        ++n;
                    }
                    string = randomAccessFile.readLine();
                }
                randomAccessFile.close();
            }
            catch (Exception exception) {
                bl = true;
            }
            int n = 0;
            while (n < hashMap.size()) {
                block23: {
                    int n4;
                    String string3;
                    String string4 = (String)hashMap.get(String.valueOf(n));
                    File file = null;
                    try {
                        file = new File(string4);
                    }
                    catch (Exception exception) {
                        bl = true;
                        break block23;
                    }
                    if (!(file.isDirectory() || !file.isFile() || (string3 = string4.substring(0, n4 = string4.lastIndexOf("/"))) != null && string3.equalsIgnoreCase(DEV))) {
                        try {
                            file = new File(string3);
                        }
                        catch (Exception exception) {
                            bl = true;
                            break block23;
                        }
                        n4 = string4.lastIndexOf("/");
                        string3 = string4.substring(n4 + 1);
                        File[] fileArray = file.listFiles();
                        int n5 = 0;
                        while (fileArray != null && n5 < fileArray.length) {
                            String string5 = fileArray[n5].getName();
                            if (!fileArray[n5].isDirectory() && string5.startsWith(string3)) {
                                this.syslogFilesHash.put(fileArray[n5].toString(), fileArray[n5]);
                            }
                            ++n5;
                        }
                    }
                }
                ++n;
            }
            this.syslogEx = bl && this.syslogFilesHash.size() == 0;
        }
    }
}

