/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.NamedConf;
import com.sun.wbem.utility.directorytable.NamedConfSection;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;
import java.util.Vector;

public class DnsTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 8;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int NUMBER_OF_COLUMNS = 8;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"hosts", "%DBFILE%", " \t", ";", "0", "3", Integer.toString(273), Integer.toString(132), "7", "cname", "owner", "", Integer.toString(9), "ttl", "ttl", "", Integer.toString(20), "class", "class", "IN", Integer.toString(9), "type", "type", "A", Integer.toString(9), "addr", "data", "", Integer.toString(3), "aliases", "aliases", "CNAME", Integer.toString(9), "comment", "comment", "", Integer.toString(8)}, {"user_attr", "/etc/user_attr", ":", "; ", "0", "3", Integer.toString(287), Integer.toString(42), "5", "name", "", "", Integer.toString(9), "qualifier", "", "", Integer.toString(9), "res1", "", "", Integer.toString(8), "res2", "", "", Integer.toString(8), "attr", "", "", Integer.toString(8)}, {"auth_attr", "/etc/security/auth_attr", ":", "; ", "0", "3", Integer.toString(287), Integer.toString(42), "6", "name", "", "", Integer.toString(9), "res1", "", "", Integer.toString(8), "res2", "", "", Integer.toString(8), "short_descr", "", "", Integer.toString(8), "long_descr", "", "", Integer.toString(8), "attr", "", "", Integer.toString(8)}, {"RR_REVIP", "%DBFILE%", " \t", ";", "0", "3", Integer.toString(287), Integer.toString(132), "6", "addr", "owner", "", Integer.toString(9), "ttl", "ttl", "", Integer.toString(25), "class", "class", "IN", Integer.toString(9), "type", "type", "PTR", Integer.toString(9), "cname", "data", "", Integer.toString(9), "comment", "comment", "", Integer.toString(8)}, {"ethers", "/etc/ethers", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(4), "5", "addr", "", "", Integer.toString(3), "name", "", "", Integer.toString(9), "class", "class", "", Integer.toString(9), "type", "type", "", Integer.toString(9), "comment", "", "", Integer.toString(8)}, {"bootparams", "/etc/bootparams", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(36), "5", "clientname", "", "", Integer.toString(9), "identifiers", "", "", Integer.toString(72), "class", "class", "", Integer.toString(9), "type", "type", "", Integer.toString(9), "comment", "", "", Integer.toString(8)}, {"timezone", "/etc/timezone", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "5", "timezone", "", "", Integer.toString(8), "domain", "", "", Integer.toString(9), "class", "class", "", Integer.toString(9), "type", "type", "", Integer.toString(9), "comment", "", "", Integer.toString(8)}, {"RR", "%DBFILE%", " \t", ";", "0", "3", Integer.toString(287), Integer.toString(132), "5", "owner", "", "", Integer.toString(9), "ttl", "", "", Integer.toString(25), "class", "", "", Integer.toString(9), "type", "", "", Integer.toString(9), "data", "", "", Integer.toString(9)}};
    int tableIndex = USER_DEFINED;
    String tableName = "";
    String tableType = "";
    String mappedTableName = "";
    String columnSeparators = " \t";
    String commentSeparators = "; ";
    int numberOfColumns;
    int tableAttributes = 0;
    int[] columnAttributes = null;
    String[] columnNames = null;
    String[] mappedColumnNames = null;
    String[] secondaryMappedColumnNames = null;
    int userId = 0;
    int groupId = 3;
    int access = 273;
    String serverName;
    String domainName;
    String db_file;

    public DnsTableDefinitions(String string, String string2) {
        this.domainName = string2;
        this.serverName = string;
        this.db_file = this.getDbFileName();
    }

    public void loadTableDefinitions(String string) throws DirectoryTableInvalidParameterException {
        this.tableName = string;
        int n = 0;
        while (n < NUMBER_OF_TABLES) {
            if (string.equalsIgnoreCase(definitions[n][TABLE_NAME])) {
                this.tableIndex = n;
                this.tableName = definitions[n][TABLE_NAME];
                this.tableType = this.tableName + "_tbl";
                this.mappedTableName = definitions[n][MAPPED_TABLE_NAME];
                this.columnSeparators = definitions[n][COLUMN_SEPARATORS];
                this.commentSeparators = definitions[n][COMMENT_SEPARATORS];
                this.userId = Integer.valueOf(definitions[n][USERID]);
                this.groupId = Integer.valueOf(definitions[n][GROUPID]);
                this.access = Integer.valueOf(definitions[n][ACCESS]);
                this.tableAttributes = Integer.valueOf(definitions[n][TABLE_ATTRIBUTES]);
                this.numberOfColumns = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS]);
                this.columnNames = new String[this.numberOfColumns];
                this.mappedColumnNames = new String[this.numberOfColumns];
                this.secondaryMappedColumnNames = new String[this.numberOfColumns];
                this.columnAttributes = new int[this.numberOfColumns];
                int n2 = 0;
                while (n2 < this.numberOfColumns) {
                    this.columnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 1];
                    this.mappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 2];
                    this.secondaryMappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 3];
                    this.columnAttributes[n2] = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS + n2 * 4 + 4]);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (n == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[n - 1];
    }

    public String getMappedColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[n - 1];
    }

    public String getAuxilliaryColumnData(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[n - 1];
    }

    public int getColumnNumber(String string) throws DirectoryTableInvalidParameterException {
        int n = 0;
        while (n < this.numberOfColumns) {
            if (this.columnNames[n].equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int n) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            return this.columnAttributes[n - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = n;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[n - 1] = string;
    }

    public void setMappedColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[n - 1] = string;
    }

    public void setAuxilliaryColumnData(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[n - 1] = string;
    }

    public void setColumnAttributes(int n, int n2) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[n - 1] = n2;
    }

    public void setTableAttributes(int n) {
        this.tableAttributes = n;
    }

    public void setMappedTableName(String string) {
        this.mappedTableName = string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableType(String string) {
        this.tableType = string;
    }

    public void setCommentSeparators(String string) {
        this.commentSeparators = string;
    }

    public void setColumnSeparators(String string) {
        this.columnSeparators = string;
    }

    public void setUser(int n) {
        this.userId = n;
    }

    public void setGroup(int n) {
        this.groupId = n;
    }

    public void setAccess(int n) {
        this.access = n;
    }

    private String expandMacros(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DBFILE") == 0 ? string2 + this.db_file : string2 + string3;
        }
        return string2;
    }

    private String getDbFileName() {
        Vector vector = null;
        Vector vector2 = null;
        String string = "";
        String string2 = "";
        try {
            NamedConfSection namedConfSection;
            int n;
            NamedConf namedConf = new NamedConf();
            namedConf.load();
            Vector vector3 = namedConf.getSections("options");
            if (vector3 != null) {
                n = 0;
                while (n < vector3.size()) {
                    namedConfSection = (NamedConfSection)vector3.get(n);
                    vector = namedConfSection.getAttributeValue("directory");
                    if (vector != null) {
                        string = (String)vector.get(0);
                    }
                    ++n;
                }
            }
            if ((vector3 = namedConf.getSections("zone")) != null) {
                n = 0;
                while (n < vector3.size()) {
                    namedConfSection = (NamedConfSection)vector3.get(n);
                    vector2 = namedConfSection.getSectionModifiers();
                    if (vector2 != null && vector2.get(0).equals(this.domainName) && (vector = namedConfSection.getAttributeValue("type")) != null && vector.get(0).equals("master")) {
                        string2 = (String)namedConfSection.getAttributeValue("file").get(0);
                    }
                    ++n;
                }
            }
            return string + "/" + string2;
        }
        catch (DirectoryTableException directoryTableException) {
            return "";
        }
    }
}

