/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.http;

import com.sun.wbem.cimom.CIMOMServer;
import com.sun.wbem.cimom.DeliveryHandler;
import com.sun.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.client.http.CIMRequestHandler;
import com.sun.wbem.cimom.adapters.client.http.HttpIndicationHandler;
import java.net.InetAddress;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.HttpServerEndpoint;
import javax.wbem.client.adapter.http.transport.RequestHandler;

public class HttpService
implements ClientProtocolAdapterIF {
    private static final String PORT = "PortNumber";
    private final String XMLHTTPDELIVERYCLASS = "CIM_IndicationHandlerCIMXML";
    private final String CIMXMLCOMMUNICATIONMECHANISM = "CIM_CIMXMLCommunicationMechanism";
    private final String DEFAULTNS = "/root/cimv2";
    private final String SYSCREATIONCLASSNAME = "SystemCreationClassName";
    private final String SYSNAME = "SystemName";
    private final String CREATIONCLASSNAME = "CreationClassName";
    private final String COMMUNICATIONMECHANISM = "CommunicationMechanism";
    private final String NAME = "Name";
    private final String WBEMSERVICES_OBJECTMANAGER = "WBEMServices_ObjectManager";
    private final String PROFILESSUPPORTED = "ProfilesSupported";
    private final String MULTIPLEOPERATIONSSUPPORTED = "MultipleOperationsSupported";
    private final String QUERYLANGUAGESSUPPORTED = "QueryLanguagesSupported";
    private final String AUTHMECHANISMSSUPPORTED = "AuthenticationMechanismsSupported";
    private final String XMLPROTOCOLVERSION = "CIMXMLProtocolVersion";
    private final String VALIDATED = "CIMValidated";
    private final String WQL1 = "WBEMSQL1";
    private String servername;
    private CIMOMServer cimom = null;
    private CIMOMHandle ch = null;
    private int port;
    private HttpServerEndpoint serverEndPoint;
    private CIMObjectPath commMechOp;

    public HttpService() throws Exception {
        try {
            this.servername = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.servername = "??";
        }
    }

    public HttpService(CIMOMServer cIMOMServer) throws Exception {
        this();
        this.cimom = cIMOMServer;
    }

    public void initialize(CIMOMServer cIMOMServer, CIMOMHandle cIMOMHandle) {
        this.cimom = cIMOMServer;
        this.ch = cIMOMHandle;
        DeliveryHandler.registerIndicationHandler("CIM_IndicationHandlerCIMXML", new HttpIndicationHandler());
    }

    public int startService(CIMInstance cIMInstance) {
        Object object;
        try {
            object = new CIMObjectPath("WBEMServices_ObjectManager", "/root/cimv2");
            CIMInstance cIMInstance2 = (CIMInstance)this.ch.enumerateInstances(object, true, false, true, true, null).nextElement();
            CIMObjectPath cIMObjectPath = new CIMObjectPath("CIM_CIMXMLCommunicationMechanism", "/root/cimv2");
            CIMClass cIMClass = this.ch.getClass(cIMObjectPath, false, true, true, null);
            CIMInstance cIMInstance3 = cIMClass.newInstance();
            cIMInstance3.setProperty("SystemCreationClassName", cIMInstance2.getProperty("SystemCreationClassName").getValue());
            cIMInstance3.setProperty("SystemName", cIMInstance2.getProperty("SystemName").getValue());
            cIMInstance3.setProperty("CreationClassName", new CIMValue((Object)cIMObjectPath.getObjectName()));
            cIMInstance3.setProperty("Name", new CIMValue((Object)"cim-xml"));
            cIMInstance3.setProperty("CommunicationMechanism", new CIMValue((Object)new UnsignedInt16(2)));
            Vector<UnsignedInt16> vector = new Vector<UnsignedInt16>(8);
            vector.addElement(new UnsignedInt16(2));
            vector.addElement(new UnsignedInt16(3));
            vector.addElement(new UnsignedInt16(4));
            vector.addElement(new UnsignedInt16(5));
            vector.addElement(new UnsignedInt16(6));
            vector.addElement(new UnsignedInt16(7));
            vector.addElement(new UnsignedInt16(8));
            vector.addElement(new UnsignedInt16(9));
            CIMValue cIMValue = new CIMValue(vector);
            cIMInstance3.setProperty("ProfilesSupported", cIMValue);
            cIMInstance3.setProperty("MultipleOperationsSupported", CIMValue.TRUE);
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement(new String("WBEMSQL1"));
            CIMValue cIMValue2 = new CIMValue(vector2);
            cIMInstance3.setProperty("QueryLanguagesSupported", cIMValue2);
            Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>(1);
            vector3.addElement(new UnsignedInt16(3));
            CIMValue cIMValue3 = new CIMValue(vector3);
            cIMInstance3.setProperty("AuthenticationMechanismsSupported", cIMValue3);
            cIMInstance3.setProperty("CIMXMLProtocolVersion", new CIMValue((Object)new UnsignedInt16(1)));
            cIMInstance3.setProperty("CIMValidated", CIMValue.FALSE);
            this.ch.createInstance(cIMObjectPath, cIMInstance3);
            this.commMechOp = cIMInstance3.getObjectPath();
            this.commMechOp.setNameSpace(cIMObjectPath.getNameSpace());
        }
        catch (CIMException cIMException) {
            Debug.trace2((String)"Got exception creating XML communication mechanism", (Throwable)cIMException);
        }
        try {
            object = cIMInstance.getProperty(PORT).getValue();
            this.port = ((UnsignedInt32)object.getValue()).intValue();
        }
        catch (NullPointerException nullPointerException) {
            Debug.trace2((String)"Got exception getting the HTTP port number", (Throwable)nullPointerException);
        }
        try {
            object = new CIMRequestHandler(this.cimom, this.servername);
            this.serverEndPoint = new HttpServerEndpoint(this.servername, this.port);
            this.serverEndPoint.listen((RequestHandler)object);
        }
        catch (Exception exception) {
            Debug.trace2((String)"Got exception when starting Http service", (Throwable)exception);
            return -1;
        }
        return 0;
    }

    public int stopService() {
        try {
            this.ch.deleteInstance(this.commMechOp);
        }
        catch (CIMException cIMException) {
            Debug.trace2((String)"Got exception deleting comm mech instance", (Throwable)cIMException);
        }
        return 0;
    }
}

