/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.http;

import com.sun.wbem.cimom.CommonServerSecurityContext;
import com.sun.wbem.cimom.EventService;
import com.sun.xml.parser.Parser;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlDocumentBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMExport;
import javax.wbem.client.CIMExportIndication;
import javax.wbem.client.adapter.http.transport.HttpClientConnection;
import javax.wbem.client.adapter.http.transport.HttpClientSocketFactory;
import javax.wbem.client.adapter.http.transport.HttpSocketFactory;
import javax.wbem.client.adapter.http.transport.OutboundRequest;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class HttpIndicationHandler
implements EventService.IndicationHandler {
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private static boolean useMPost = true;
    private Map connMap = new HashMap();
    private CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();
    private boolean debug = false;
    private String prefix = "";

    public CommonServerSecurityContext getSecurityContext(CIMInstance cIMInstance) {
        return null;
    }

    public void deliverEvent(CIMEvent cIMEvent, CIMInstance cIMInstance) throws CIMException {
        URL uRL = null;
        try {
            XmlDocument xmlDocument = this.xmlImpl.getXmlRequest((CIMExport)new CIMExportIndication(cIMEvent.getIndication()));
            uRL = new URL((String)cIMInstance.getProperty("Destination").getValue().getValue());
            this.deliverEventRequest(xmlDocument, uRL);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    private synchronized void deliverEventRequest(XmlDocument xmlDocument, URL uRL) throws CIMException, IOException {
        OutputStreamWriter outputStreamWriter = null;
        String string = uRL.getHost();
        int n = uRL.getPort();
        HttpSocketFactory httpSocketFactory = new HttpSocketFactory(uRL.getProtocol());
        OutboundRequest outboundRequest = null;
        String string2 = string + ":" + n;
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.connMap.get(string2);
        int n2 = 0;
        while (n2 < 2) {
            try {
                if (httpClientConnection == null) {
                    httpClientConnection = new HttpClientConnection(string, n, (HttpClientSocketFactory)httpSocketFactory, useMPost);
                    this.connMap.put(string2, httpClientConnection);
                }
                outboundRequest = httpClientConnection.newRequest(uRL.getPath());
                outputStreamWriter = new OutputStreamWriter(outboundRequest.getRequestOutputStream(), "UTF8");
                this.setRequestHeaders(outboundRequest, this.xmlImpl.getXmlRequestHeaders(xmlDocument));
                outboundRequest.endWriteHeader();
                xmlDocument.write((Writer)outputStreamWriter);
                ((Writer)outputStreamWriter).flush();
                ((Writer)outputStreamWriter).close();
                break;
            }
            catch (IOException iOException) {
                httpClientConnection.shutdown(true);
                httpClientConnection = null;
                this.connMap.put(string2, httpClientConnection);
                if (n2 == 1) {
                    throw iOException;
                }
                ++n2;
            }
        }
        try {
            if (this.debug) {
                this.dumpRequest(xmlDocument, outboundRequest);
            }
            XmlDocument xmlDocument2 = this.getResponse(outboundRequest);
            if (this.debug) {
                this.dumpResponse(xmlDocument2, outboundRequest);
            }
        }
        catch (SAXException sAXException) {
            if (useMPost) {
                if (httpClientConnection != null) {
                    httpClientConnection.shutdown(true);
                    httpClientConnection = null;
                    this.connMap.put(string2, httpClientConnection);
                }
                useMPost = false;
                this.deliverEventRequest(xmlDocument, uRL);
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)sAXException);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public void ping(CIMInstance cIMInstance) throws CIMException {
    }

    private void dumpRequest(XmlDocument xmlDocument, OutboundRequest outboundRequest) throws IOException {
        System.out.println("****************************************");
        outboundRequest.dumpOutHeader();
        if (xmlDocument != null) {
            xmlDocument.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF REQUEST  =-=-=-=-=-=-=-=-=-=-=-=");
    }

    private void dumpResponse(XmlDocument xmlDocument, OutboundRequest outboundRequest) throws IOException {
        System.out.println("++++++++++++++++++++++++++++++++++++++++");
        outboundRequest.dumpInHeader();
        System.out.println("\n");
        if (xmlDocument != null) {
            xmlDocument.write((OutputStream)System.out);
        }
        System.out.println("=-=-=-=-=-=-=-=-=-=-=-= END OF RESPONSE =-=-=-=-=-=-=-=-=-=-=-=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument getResponse(OutboundRequest outboundRequest) throws IOException, SAXException {
        XmlDocument xmlDocument;
        InputStream inputStream = outboundRequest.getResponseInputStream();
        try {
            XmlDocument xmlDocument2;
            Parser parser = new Parser();
            XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
            InputSource inputSource = new InputSource();
            xmlDocumentBuilder.setDisableNamespaces(false);
            parser.setDocumentHandler((DocumentHandler)xmlDocumentBuilder);
            inputSource.setByteStream(inputStream);
            parser.parse(inputSource);
            if (outboundRequest.getResponseCode() >= 400) {
                throw new IOException();
            }
            xmlDocument = xmlDocument2 = xmlDocumentBuilder.getDocument();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return xmlDocument;
    }

    private void setRequestHeaders(OutboundRequest outboundRequest, Map map) throws CIMException {
        if (useMPost) {
            this.setPrefix();
            outboundRequest.addHeaderField("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        } else {
            this.prefix = "";
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            outboundRequest.addHeaderField(this.prefix + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setPrefix() {
        Random random = new Random();
        int n = Math.abs(random.nextInt() % 100);
        this.prefix = Integer.toString(n);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }
}

