/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.snmp;

import com.sun.wbem.cimom.CIMOMServer;
import com.sun.wbem.cimom.ServerSecurity;
import com.sun.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpCache;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpMapEntry;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.snmp.SnmpMessage;
import javax.management.snmp.SnmpNull;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpPduPacket;
import javax.management.snmp.SnmpPduRequest;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpTooBigException;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.Debug;

public class SnmpImpl
implements ClientProtocolAdapterIF {
    private static final byte CTXTCONSFLAG = -96;
    private static final byte TAG_SEQ = 48;
    private static final byte SECURITY_TAG_USER = 16;
    private static final byte MGMT_REQ_REREAD_CACHE = 1;
    private static final byte SEQ_TAG_LONG2_CNT_FIELD = -126;
    private static final int SEQ_TAG_LONG2_MINUS_SHORT = 2;
    private static final int SEQ_TAG_LONG2_MINUS_LONG1 = 1;
    private static final int REQUEST_TYPE_FIELD_LEN = 2;
    private static final int HEADER_ERR_STAT_OFFSET_FROM_VARBINDLIST_CNT = -5;
    private static final int HEADER_ERR_INDEX_OFFSET_FROM_VARBINDLIST_CNT = -2;
    private static final int HEADER_CNT_FIELD_INDEX_VARBINDLIST = 2;
    private static final int MAX_PDU_BYTE_LEN = 1500;
    private static final int MILLISECS_IN_HOUR = 3600000;
    private static final int MILLISECS_IN_MINUTE = 60000;
    private static final String ROOT_NAMESPACE = "root/cimv2";
    private static final String HARDCODED_USERNAME = "root";
    private static final String MAP_DIRECTORY = "/var/sadm/wbem/snmp/map/";
    private static final String MAP_TABLE_SUFFIX = ".map";
    private static final String SNMP_MAP_TABLE_VERSION = "1.0";
    private static final String MAP_TABLE_VERSION_LABEL = "Version";
    private static final String LOG_RESOURCE = "com.sun.wbem.utility.log.SnmpAdapterLogMessages";
    private static final String ADAPTERNAME = "SNMP Adapter";
    private boolean debugOn = false;
    private CIMOMServer cimomhandle = null;
    private SnmpCache mapCache = null;

    public void initialize(CIMOMServer cIMOMServer, CIMOMHandle cIMOMHandle) {
        this.cimomhandle = cIMOMServer;
        Debug.trace1((String)"Starting SNMP Adapter Impl...");
        String string = System.getProperty("wbem.debug.level");
        if (string != null && string.length() > 0) {
            this.debugOn = true;
        }
        this.mapCache = new SnmpCache(this, this.debugOn);
    }

    public int startService(CIMInstance cIMInstance) {
        try {
            new SnmpService(false, this).start();
        }
        catch (Exception exception) {
            Debug.trace1((String)"Snmp service error", (Throwable)exception);
        }
        return 0;
    }

    public int stopService() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkSecurity(byte[] byArray) throws CIMException {
        boolean bl = false;
        int n = 0;
        try {
            if (byArray == null) throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            if (byArray.length < 2) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            block3: while (true) {
                int n2;
                if (n >= byArray.length) {
                    if (bl) return;
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                byte by = byArray[n++];
                if ((n2 = byArray[n++] & 0x7F) != byArray.length - 2) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                StringBuffer stringBuffer = new StringBuffer(n2);
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        String string = stringBuffer.toString();
                        if (by != 16) throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                        if (!string.equals(HARDCODED_USERNAME)) throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                        bl = true;
                        continue block3;
                    }
                    stringBuffer.append((char)byArray[n++]);
                    ++n3;
                }
                break;
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{};
            String string = this.logError("SNMPA_100", "SNMPA_201", stringArray);
            return;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"checkSecurity"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] snmpRequest(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        block25: {
            SnmpPduRequest snmpPduRequest;
            SnmpPduRequest snmpPduRequest2;
            block23: {
                byte[] byArray4;
                byArray3 = null;
                snmpPduRequest2 = null;
                snmpPduRequest = null;
                try {
                    byArray4 = this.formatInputTags(byArray2);
                }
                catch (CIMException cIMException) {
                    throw cIMException;
                }
                catch (Exception exception) {
                    String[] stringArray = new String[]{"formatInputTags"};
                    String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                snmpPduRequest2 = this.decodePduRequest(byArray4);
                this.checkSecurity(byArray);
                switch (snmpPduRequest2.type) {
                    case 160: {
                        snmpPduRequest = this.snmpGetPdu(snmpPduRequest2);
                        break;
                    }
                    default: {
                        snmpPduRequest = this.snmpErrorResponse(snmpPduRequest2, 130);
                    }
                }
                this.tracePdu(snmpPduRequest);
                byArray3 = this.encodePduResponse(snmpPduRequest);
                this.traceHexBytes("response bytes", byArray3);
                Object var12_15 = null;
                if (snmpPduRequest2 == null || snmpPduRequest != null) break block23;
                try {
                    snmpPduRequest = this.snmpErrorResponse(snmpPduRequest2, 130);
                    byArray3 = this.encodePduResponse(snmpPduRequest);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (byArray3 == null) {
                byArray3 = this.snmpLastDitchError(byArray2);
            }
            break block25;
            {
                catch (CIMException cIMException) {
                    Object var12_16 = null;
                    if (snmpPduRequest2 != null && snmpPduRequest == null) {
                        try {
                            snmpPduRequest = this.snmpErrorResponse(snmpPduRequest2, 130);
                            byArray3 = this.encodePduResponse(snmpPduRequest);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (byArray3 == null) {
                        byArray3 = this.snmpLastDitchError(byArray2);
                    }
                    break block25;
                }
                catch (Exception exception) {
                    String[] stringArray = new String[]{"snmpRequest"};
                    String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
                    Object var12_17 = null;
                    if (snmpPduRequest2 != null && snmpPduRequest == null) {
                        try {
                            snmpPduRequest = this.snmpErrorResponse(snmpPduRequest2, 130);
                            byArray3 = this.encodePduResponse(snmpPduRequest);
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (byArray3 == null) {
                        byArray3 = this.snmpLastDitchError(byArray2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                if (snmpPduRequest2 != null && snmpPduRequest == null) {
                    try {
                        snmpPduRequest = this.snmpErrorResponse(snmpPduRequest2, 130);
                        byArray3 = this.encodePduResponse(snmpPduRequest);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (byArray3 == null) {
                    byArray3 = this.snmpLastDitchError(byArray2);
                }
                throw throwable;
            }
        }
        return byArray3;
    }

    public void mgmtRequest(byte[] byArray, byte[] byArray2) {
        try {
            this.checkSecurity(byArray);
            if (byArray2 == null || byArray2.length == 0) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            switch (byArray2[0]) {
                case 1: {
                    this.mapCache.write();
                    break;
                }
                default: {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{};
            String string = this.logError("SNMPA_102", "SNMPA_202", stringArray);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"mgmtRequest"};
            String string = this.logException("SNMPA_102", "SNMPA_200", stringArray, exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    private byte[] formatInputTags(byte[] var1_1) throws Exception, CIMException {
        var7_2 = 0;
        var10_3 = 0;
        var11_4 = 0;
        var12_5 = 0;
        var13_6 = new ArrayList<Integer>();
        var14_7 = new ArrayList<Integer>();
        if (var1_1 != null && var1_1.length != 0) ** GOTO lbl35
        var15_8 = new String[]{};
        var16_9 = this.logError("SNMPA_100", "SNMPA_210", var15_8);
        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
lbl-1000:
        // 1 sources

        {
            var3_11 = var1_1[var7_2];
            if (var3_11 == 48 || (var3_11 & -96) == -96) {
                var13_6.add(new Integer(var7_2++));
                if (var1_1[var7_2] < 0) {
                    var2_10 = (byte)(var1_1[var7_2] & 127);
                    if (var2_10 == 1) {
                        var14_7.add(new Integer(1));
                        ++var10_3;
                    } else {
                        var14_7.add(new Integer(0));
                    }
                    var7_2 += var2_10;
                } else {
                    var14_7.add(new Integer(2));
                    var10_3 += 2;
                }
                ++var7_2;
                continue;
            }
            v0 = ++var7_2;
            ++var7_2;
            var8_12 = var1_1[v0];
            var7_2 += var8_12;
lbl35:
            // 3 sources

            ** while (var7_2 < var1_1.length)
        }
lbl36:
        // 1 sources

        var5_13 = new byte[var1_1.length + var10_3];
        var7_2 = 0;
        var12_5 = 0;
        while (var7_2 < var1_1.length) {
            var3_11 = var1_1[var7_2];
            var5_13[var11_4++] = var1_1[var7_2++];
            var10_3 = 0;
            var6_15 = var12_5 + 1;
            while (var12_5 < 3 && var6_15 < var14_7.size()) {
                var9_16 = (Integer)var14_7.get(var6_15);
                var10_3 += var9_16.intValue();
                ++var6_15;
            }
            var4_14 = (var6_15 = (var9_16 = (Integer)var14_7.get(var12_5++)).intValue()) == 0 ? this.writeCountBytes(var1_1[var7_2 + 1], var1_1[var7_2 + 2], var10_3) : (var6_15 == 1 ? this.writeCountBytes((byte)0, var1_1[var7_2 + 1], var10_3) : this.writeCountBytes((byte)0, var1_1[var7_2], var10_3));
            var7_2 = var7_2 + 3 - var6_15;
            var6_15 = 0;
            while (var6_15 < var4_14.length) {
                var5_13[var11_4++] = var4_14[var6_15];
                ++var6_15;
            }
            if (var12_5 < var13_6.size()) {
                var9_16 = (Integer)var13_6.get(var12_5);
                var8_12 = var9_16;
            } else {
                var8_12 = var1_1.length;
            }
            var6_15 = var7_2;
            while (var6_15 < var8_12) {
                var5_13[var11_4++] = var1_1[var6_15];
                ++var6_15;
            }
            var7_2 = var8_12;
        }
        return var5_13;
    }

    private byte[] writeCountBytes(byte by, byte by2, int n) throws CIMException {
        byte[] byArray = null;
        try {
            if (by < 0) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            int n2 = by << 8;
            n2 = by2 < 0 ? n2 + (by2 & 0x7F) + 127 + 1 : (n2 += by2);
            by2 = (byte)((n2 += n) & 0xFF);
            by = (byte)(n2 >> 8);
            byArray = new byte[]{-126, by, by2};
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{this.byteToHex(by), this.byteToHex(by2)};
            String string = this.logError("SNMPA_100", "SNMPA_205", stringArray);
            throw cIMException;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"writeCount"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return byArray;
    }

    private SnmpPduRequest snmpGetPdu(SnmpPduRequest snmpPduRequest) {
        SnmpPduRequest snmpPduRequest2 = null;
        if (snmpPduRequest == null || snmpPduRequest.varBindList == null) {
            return snmpPduRequest2;
        }
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[snmpPduRequest.varBindList.length];
        snmpPduRequest2 = new SnmpPduRequest();
        snmpPduRequest2.requestId = snmpPduRequest.requestId;
        snmpPduRequest2.community = snmpPduRequest.community;
        snmpPduRequest2.version = snmpPduRequest.version;
        snmpPduRequest2.type = 162;
        try {
            int n = 0;
            while (n < snmpPduRequest.varBindList.length) {
                SnmpVarBind snmpVarBind;
                SnmpVarBind snmpVarBind2 = snmpPduRequest.varBindList[n];
                SnmpOid snmpOid = snmpVarBind2.oid;
                SnmpMapEntry snmpMapEntry = (SnmpMapEntry)this.mapCache.read(snmpOid.toString());
                snmpVarBindArray[n] = snmpVarBind = this.getVarBindRsp(snmpPduRequest2, snmpVarBind2, n + 1, snmpMapEntry);
                if (snmpPduRequest2.errorIndex > 0) break;
                ++n;
            }
            snmpPduRequest2.varBindList = snmpVarBindArray;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"snmpGetPdu"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
        }
        return snmpPduRequest2;
    }

    private CIMValue getCIMValue(SnmpMapEntry snmpMapEntry) throws Exception, CIMException {
        CIMValue cIMValue = null;
        String[] stringArray = new String[1];
        try {
            CIMProperty cIMProperty;
            CIMObjectPath cIMObjectPath = new CIMObjectPath(snmpMapEntry.className, ROOT_NAMESPACE);
            stringArray[0] = snmpMapEntry.propertyName;
            ServerSecurity serverSecurity = new ServerSecurity(HARDCODED_USERNAME, "", "snmpadapter", new byte[4]);
            Enumeration enumeration = this.cimomhandle.enumerateInstances("1", new CIMNameSpace("", ""), cIMObjectPath, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, stringArray, serverSecurity).elements();
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                if (cIMInstance == null) {
                    throw new CIMException("CIM_ERR_NOT_FOUND");
                }
                cIMProperty = cIMInstance.getProperty(snmpMapEntry.propertyName);
                if (cIMProperty == null) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
            } else {
                throw new CIMException("CIM_ERR_NOT_FOUND");
            }
            cIMValue = cIMProperty.getValue();
        }
        catch (CIMException cIMException) {
            Debug.trace2((String)cIMException.getMessage());
            throw cIMException;
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{"getCIMValue"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray2, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return cIMValue;
    }

    private SnmpVarBind createVarbindErrRsp(SnmpPduRequest snmpPduRequest, SnmpVarBind snmpVarBind, SnmpStatusException snmpStatusException) {
        SnmpVarBind snmpVarBind2;
        SnmpOid snmpOid = snmpVarBind.oid;
        if (snmpPduRequest.version == 0) {
            snmpVarBind2 = new SnmpVarBind((SnmpOid)snmpOid.clone(), (SnmpValue)new SnmpNull());
            snmpPduRequest.errorIndex = snmpStatusException.getErrorIndex();
            int n = snmpStatusException.getStatus();
            n = n == 129 ? 2 : 5;
            snmpPduRequest.errorStatus = n;
        } else {
            snmpVarBind2 = new SnmpVarBind((SnmpOid)snmpOid.clone(), (SnmpValue)new SnmpNull(snmpStatusException.getStatus()));
        }
        return snmpVarBind2;
    }

    private String extractCIMValueDateTime(CIMValue cIMValue) throws CIMException {
        String string = null;
        try {
            CIMDateTime cIMDateTime = (CIMDateTime)cIMValue.getValue();
            Calendar calendar = cIMDateTime.getCalendar();
            int n = calendar.get(1);
            string = "" + (char)(n >> 8);
            string = string + (char)(n & 0xFF);
            string = string + (char)(calendar.get(2) + 1);
            string = string + (char)calendar.get(5);
            string = string + (char)calendar.get(10);
            string = string + (char)calendar.get(12);
            string = string + (char)calendar.get(13);
            string = string + (char)(calendar.get(14) / 100);
            n = calendar.get(15);
            if (n > 0) {
                string = string + '+';
            } else {
                n *= -1;
                string = string + '-';
            }
            int n2 = n / 3600000;
            string = string + (char)n2;
            int n3 = (n - n2 * 3600000) / 60000;
            string = string + (char)n3;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"extractCIMValueDateTime"};
            String string2 = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return string;
    }

    private long extractCIMValueLong(CIMValue cIMValue, boolean bl) throws CIMException {
        long l;
        block6: {
            l = 0L;
            try {
                Object object = cIMValue.getValue();
                if (object instanceof Number) {
                    l = ((Number)object).longValue();
                    if (l < 0L & bl) {
                        l *= -1L;
                    }
                    break block6;
                }
                if (object instanceof String) {
                    Long l2 = new Long((String)object);
                    l = l2;
                    break block6;
                }
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException cIMException) {
                throw cIMException;
            }
            catch (Exception exception) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        return l;
    }

    private SnmpVarBind copyCIMValueToVarbind(SnmpMapEntry snmpMapEntry, CIMValue cIMValue) throws CIMException {
        SnmpVarBind snmpVarBind;
        block19: {
            SnmpOid snmpOid = new SnmpOid(snmpMapEntry.oid);
            if (cIMValue == null || cIMValue.getValue() == null) {
                SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpOid, (SnmpValue)new SnmpNull());
                return snmpVarBind2;
            }
            snmpVarBind = new SnmpVarBind(snmpOid);
            try {
                String string = snmpMapEntry.asn1Type;
                CIMDataType cIMDataType = cIMValue.getType();
                int n = cIMDataType.getType();
                if (string.equals("SnmpString")) {
                    Object object = cIMValue.getValue();
                    if (object instanceof String) {
                        snmpVarBind.setSnmpStringValue((String)cIMValue.getValue());
                        break block19;
                    }
                    if (object instanceof CIMDateTime) {
                        snmpVarBind.setSnmpStringValue(this.extractCIMValueDateTime(cIMValue));
                        break block19;
                    }
                    if (object instanceof Number) {
                        snmpVarBind.setSnmpStringValue(object.toString());
                        break block19;
                    }
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                if (string.equals("SnmpTimeticks")) {
                    CIMDateTime cIMDateTime = (CIMDateTime)cIMValue.getValue();
                    Calendar calendar = cIMDateTime.getCalendar();
                    Date date = calendar.getTime();
                    Calendar calendar2 = Calendar.getInstance();
                    Date date2 = calendar2.getTime();
                    long l = (date2.getTime() - date.getTime()) / 10L;
                    snmpVarBind.setSnmpTimeticksValue(l);
                    break block19;
                }
                if (string.equals("SnmpCounter")) {
                    long l = this.extractCIMValueLong(cIMValue, true);
                    snmpVarBind.setSnmpCounterValue(l);
                    break block19;
                }
                if (string.equals("SnmpInt")) {
                    long l = this.extractCIMValueLong(cIMValue, false);
                    snmpVarBind.setSnmpIntValue(l);
                    break block19;
                }
                if (string.equals("SnmpGauge")) {
                    long l = this.extractCIMValueLong(cIMValue, true);
                    snmpVarBind.setSnmpGaugeValue(l);
                    break block19;
                }
                if (string.equals("SnmpOid")) {
                    snmpVarBind.setSnmpOidValue((String)cIMValue.getValue());
                    break block19;
                }
                if (string.equals("SnmpIpAddress")) {
                    snmpVarBind.setSnmpIpAddressValue((String)cIMValue.getValue());
                    break block19;
                }
                if (string.equals("SnmpOpaque")) {
                    Object object = cIMValue.getValue();
                    if (!(object instanceof Vector)) {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                    }
                    Vector vector = (Vector)cIMValue.getValue();
                    byte[] byArray = new byte[vector.size()];
                    object = vector.elementAt(0);
                    if (!(object instanceof Byte)) {
                        throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                    }
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        Byte by = (Byte)vector.elementAt(n2);
                        byArray[n2] = by;
                        ++n2;
                    }
                    snmpVarBind.setSnmpOpaqueValue(byArray);
                    break block19;
                }
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (CIMException cIMException) {
                throw cIMException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] stringArray = new String[]{illegalArgumentException.getMessage()};
                String string = this.logError("SNMPA_101", "SNMPA_209", stringArray);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            catch (Exception exception) {
                String[] stringArray = new String[]{"copyCIMValueToVarbind"};
                String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
        }
        return snmpVarBind;
    }

    private SnmpVarBind getVarBindRsp(SnmpPduRequest snmpPduRequest, SnmpVarBind snmpVarBind, int n, SnmpMapEntry snmpMapEntry) {
        SnmpStatusException snmpStatusException = null;
        SnmpVarBind snmpVarBind2 = null;
        try {
            if (snmpMapEntry == null) {
                snmpStatusException = new SnmpStatusException(129, n);
            } else {
                CIMValue cIMValue = this.getCIMValue(snmpMapEntry);
                snmpVarBind2 = this.copyCIMValueToVarbind(snmpMapEntry, cIMValue);
            }
        }
        catch (CIMException cIMException) {
            snmpStatusException = new SnmpStatusException(129, n);
        }
        catch (Exception exception) {
            snmpStatusException = new SnmpStatusException(130, n);
        }
        if (snmpStatusException != null) {
            snmpVarBind2 = this.createVarbindErrRsp(snmpPduRequest, snmpVarBind, snmpStatusException);
        }
        return snmpVarBind2;
    }

    private SnmpPduRequest snmpErrorResponse(SnmpPduRequest snmpPduRequest, int n) throws CIMException {
        SnmpPduRequest snmpPduRequest2 = null;
        SnmpStatusException snmpStatusException = null;
        if (snmpPduRequest == null) {
            return snmpPduRequest2;
        }
        int n2 = snmpPduRequest.version == 0 ? 1 : snmpPduRequest.varBindList.length;
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n2];
        snmpPduRequest2 = new SnmpPduRequest();
        snmpPduRequest2.requestId = snmpPduRequest.requestId;
        snmpPduRequest2.community = snmpPduRequest.community;
        snmpPduRequest2.version = snmpPduRequest.version;
        snmpPduRequest2.type = 162;
        try {
            int n3 = 0;
            while (n3 < n2) {
                SnmpVarBind snmpVarBind;
                SnmpVarBind snmpVarBind2 = snmpPduRequest.varBindList[n3];
                snmpStatusException = new SnmpStatusException(n, n3 + 1);
                snmpVarBindArray[n3] = snmpVarBind = this.createVarbindErrRsp(snmpPduRequest2, snmpVarBind2, snmpStatusException);
                ++n3;
            }
            snmpPduRequest2.varBindList = snmpVarBindArray;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"snmpErrorResponse"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return snmpPduRequest2;
    }

    private byte[] snmpLastDitchError(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[100];
        int n2 = 0;
        int n3 = 4;
        int[] nArray = new int[n3];
        int n4 = 10;
        int n5 = 0;
        int n6 = 0;
        try {
            n = 0;
            while (n < n4) {
                byte by = byArray[n5++];
                byArray2[n6++] = by;
                if (by == 48 || (by & 0xFFFFFFA0) == -96) {
                    if (by != 48) {
                        byArray2[n6 - 1] = -94;
                    }
                    nArray[n2++] = n6;
                    byArray2[n6++] = 0;
                    if (byArray[n5] < 0) {
                        byte by2 = (byte)(byArray[n5] & 0x7F);
                        n5 += by2;
                    }
                    ++n5;
                } else {
                    int n7 = n6++;
                    int n8 = byArray[n5++];
                    byArray2[n7] = n8;
                    int n9 = n8;
                    int n10 = 0;
                    while (n10 < n9) {
                        byArray2[n6++] = byArray[n5++];
                        ++n10;
                    }
                }
                ++n;
            }
            byArray2[n6++] = 5;
            byArray2[n6++] = 0;
            n = 0;
            while (n < n3) {
                byArray2[nArray[n]] = (byte)(n6 - nArray[n] - 1);
                ++n;
            }
            byArray2[nArray[2] + -5] = 5;
            byArray2[nArray[2] + -2] = 1;
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"snmpLastDitchError"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
        }
        byte[] byArray3 = new byte[n6];
        n = 0;
        while (n < n6) {
            byArray3[n] = byArray2[n];
            ++n;
        }
        return byArray3;
    }

    private SnmpPduRequest decodePduRequest(byte[] byArray) throws Exception, CIMException {
        SnmpMessage snmpMessage = new SnmpMessage();
        SnmpPduRequest snmpPduRequest = null;
        try {
            snmpMessage.decodeMessage(byArray, byArray.length);
        }
        catch (SnmpStatusException snmpStatusException) {
            String[] stringArray = new String[]{snmpStatusException.getMessage()};
            String string = this.logError("SNMPA_100", "SNMPA_206", stringArray);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"decodePduRequest"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        try {
            snmpPduRequest = (SnmpPduRequest)snmpMessage.decodePdu();
        }
        catch (SnmpStatusException snmpStatusException) {
            String[] stringArray = new String[]{snmpStatusException.getMessage()};
            String string = this.logError("SNMPA_100", "SNMPA_207", stringArray);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"decodePduRequest"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return snmpPduRequest;
    }

    private byte[] encodePduResponse(SnmpPduRequest snmpPduRequest) throws Exception, CIMException {
        byte[] byArray = new byte[1500];
        byte[] byArray2 = null;
        SnmpMessage snmpMessage = new SnmpMessage();
        if (snmpPduRequest == null) {
            return null;
        }
        try {
            snmpMessage.encodePdu((SnmpPduPacket)snmpPduRequest, 1500);
            int n = snmpMessage.encodeMessage(byArray);
            byArray2 = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray2[n2] = byArray[n2];
                ++n2;
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            String[] stringArray = new String[]{snmpStatusException.getMessage()};
            String string = this.logError("SNMPA_100", "SNMPA_208", stringArray);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (SnmpTooBigException snmpTooBigException) {
            String[] stringArray = new String[]{snmpTooBigException.getMessage()};
            String string = this.logError("SNMPA_100", "SNMPA_208", stringArray);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"encodePduResponse"};
            String string = this.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return byArray2;
    }

    private String byteToHex(byte n) {
        int[] nArray = new int[2];
        String string = new String("0x");
        int n2 = n < 0 ? (n & 0x7F) + 127 + 1 : n;
        nArray[1] = n2 % 16;
        nArray[0] = n2 >> 4;
        int n3 = 0;
        while (n3 < nArray.length) {
            char c = Character.forDigit(nArray[n3], 16);
            string = string + c;
            ++n3;
        }
        return string;
    }

    protected String logError(String string, String string2, String[] stringArray) {
        String string3 = "";
        String string4 = "";
        return string4 + "\n" + string3;
    }

    protected String logException(String string, String string2, String[] stringArray, Exception exception) {
        String string3 = "";
        String string4 = "";
        return string4 + "\n" + string3;
    }

    private void tracePdu(SnmpPduRequest snmpPduRequest) {
        if (!this.debugOn) {
            return;
        }
        try {
            int n;
            String string;
            if (snmpPduRequest == null) {
                Debug.trace3((String)"tracePdu, pdu is null");
                return;
            }
            if (snmpPduRequest.community != null) {
                string = "community = ";
                n = 0;
                while (n < snmpPduRequest.community.length) {
                    string = string + (char)snmpPduRequest.community[n];
                    ++n;
                }
            } else {
                string = "no community string found";
            }
            Debug.trace3((String)string);
            Debug.trace3((String)("requestId = " + snmpPduRequest.requestId));
            string = "type = " + snmpPduRequest.type + ", ";
            string = snmpPduRequest.type == 160 ? string + "GetRequest" : (snmpPduRequest.type == 162 ? string + "GetResponse" : (snmpPduRequest.type == 165 ? string + "GetBulkRequest" : (snmpPduRequest.type == 161 ? string + "GetNextRequest" : (snmpPduRequest.type == 163 ? string + "SetRequest" : (snmpPduRequest.type == 253 ? string + "WalkRequest" : string + "Undefined Request")))));
            Debug.trace3((String)string);
            string = "version = " + snmpPduRequest.version + ", ";
            string = snmpPduRequest.version == 0 ? string + "SNMP V1" : string + "SNMP V2";
            Debug.trace3((String)string);
            Debug.trace3((String)("varBindList length = " + snmpPduRequest.varBindList.length));
            Debug.trace3((String)"varBindList = ");
            n = 0;
            while (n < snmpPduRequest.varBindList.length) {
                SnmpVarBind snmpVarBind = snmpPduRequest.varBindList[n];
                if (snmpVarBind == null) break;
                Debug.trace3((String)snmpVarBind.toString());
                ++n;
            }
            Debug.trace3((String)"");
            Debug.trace3((String)"***tracePdu complete***");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void traceHexBytes(String string, byte[] byArray) {
        if (!this.debugOn) {
            return;
        }
        String string2 = "";
        Debug.trace3((String)(string + ", len = " + byArray.length));
        int n = 0;
        while (n < byArray.length) {
            string2 = string2 + this.byteToHex(byArray[n]) + " ";
            ++n;
        }
        Debug.trace3((String)string2);
    }

    private void traceTags(ArrayList arrayList, ArrayList arrayList2) {
        if (!this.debugOn) {
            return;
        }
        int n = 0;
        while (n < arrayList.size()) {
            Integer n2 = (Integer)arrayList.get(n);
            Debug.trace3((String)("tag index = " + n2));
            n2 = (Integer)arrayList2.get(n);
            Debug.trace3((String)("tag offset adjustment = " + n2));
            ++n;
        }
    }

    private void traceHeaderFormats(String string, byte[] byArray, byte[] byArray2) {
        if (!this.debugOn) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Debug.trace3((String)"traceHeaderFormats");
        Debug.trace3((String)string);
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by == 48 || (by & 0xFFFFFFA0) == -96) {
                int n3;
                int n4;
                String string2 = this.byteToHex(byArray[n]);
                string2 = string2 + " " + this.byteToHex(byArray[++n]);
                if (byArray[n] < 0) {
                    n4 = byArray[n] & 0x7F;
                    n3 = 0;
                    while (n3 < n4) {
                        string2 = string2 + " " + this.byteToHex(byArray[n + n3 + 1]);
                        ++n3;
                    }
                    n += n4;
                }
                ++n;
                Debug.trace3((String)"***************");
                Debug.trace3((String)("inBytes header: " + string2));
                String string3 = this.byteToHex(byArray2[n2]);
                string3 = string3 + " " + this.byteToHex(byArray2[++n2]);
                if (byArray2[n2] < 0) {
                    n4 = (byte)(byArray2[n2] & 0x7F);
                    n3 = 0;
                    while (n3 < n4) {
                        string3 = string3 + " " + this.byteToHex(byArray2[n2 + n3 + 1]);
                        ++n3;
                    }
                    n2 += n4;
                }
                ++n2;
                Debug.trace3((String)("outBytes header: " + string3));
                continue;
            }
            if ((by & 0xFFFFFFA0) == -96) {
                n += 2;
                n2 += 2;
                continue;
            }
            int n5 = ++n;
            ++n;
            byte by2 = byArray[n5];
            n += by2;
            int n6 = ++n2;
            ++n2;
            by2 = byArray2[n6];
            n2 += by2;
        }
    }
}

