/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.client.WorkMod51;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;

public class CIMOMLibrary {
    public static final String CIMOM_LIBRARY = "cimom";
    private static boolean library_loaded = false;

    public static String getEncryptedPassword(String string, int n) throws CIMException {
        String string2 = null;
        if (library_loaded) {
            string2 = CIMOMLibrary.getPassword(string, n);
            if (string2 == null) {
                return null;
            }
            if (string2.trim().length() < 2) {
                return "";
            }
        } else {
            Debug.trace1((String)"Cannot find user password provider library");
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)string);
        }
        byte[] byArray = string2.getBytes();
        byte[] byArray2 = new byte[]{byArray[0], byArray[1]};
        byte[] byArray3 = new WorkMod51().mod51Format(new byte[20], byArray2);
        String string3 = new String(byArray3);
        if (string3.equals(string2)) {
            return "";
        }
        return string2;
    }

    public static boolean authenticateUser(String string, String string2) throws CIMException {
        if (string == null || string.trim().length() == 0 || string2 == null || string2.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUserOrRole(string, string2, null);
    }

    public static boolean authenticateRole(String string, String string2, String string3) throws CIMException {
        if (string2 == null || string2.trim().length() == 0 || string == null || string.trim().length() == 0 || string3 == null || string3.trim().length() == 0) {
            return false;
        }
        return CIMOMLibrary.authenticateUserOrRole(string, string2, string3);
    }

    private static boolean authenticateUserOrRole(String string, String string2, String string3) throws CIMException {
        if (library_loaded) {
            if (string2 == null) {
                return false;
            }
            if (string2.trim().length() == 0) {
                string2 = "";
            }
        } else {
            Debug.trace1((String)"Cannot find user password provider library");
            throw new CIMSecurityException("NO_SUCH_PRINCIPAL", (Object)string);
        }
        boolean bl = false;
        try {
            bl = CIMOMLibrary.doAuthenticate(string, string2, string3);
        }
        catch (Exception exception) {
            Debug.trace1((String)"Unexpected exception from native method doAuthenticate: ", (Throwable)exception);
        }
        if (!bl) {
            if (string3 != null) {
                Debug.trace1((String)("CIMOMLibrary.authenticateUserOrRole : failed to authenticate role " + string + " for user " + string3));
            } else {
                Debug.trace1((String)("CIMOMLibrary.authenticateUserOrRole : failed to authenticate user " + string));
            }
        }
        return bl;
    }

    public static String writeLocalAuthenticator(String string, String string2, String string3) throws CIMException {
        String string4 = null;
        if (!library_loaded) {
            Debug.trace1((String)"Cannot find passwd access library");
            throw new CIMSecurityException("CIM_ERR_FAILED");
        }
        string4 = CIMOMLibrary.writeLocalFile(string, string2, string3);
        return string4;
    }

    public static void writeToSyslog(String string, String string2, int n) throws CIMException {
        if (!library_loaded) {
            throw new CIMException("Cannot log");
        }
        CIMOMLibrary.doSyslog(string, string2, n);
    }

    public static synchronized void auditLogin(String string, String string2, long l) throws CIMException {
        if (string == null || string2 == null) {
            return;
        }
        if (library_loaded) {
            CIMOMLibrary.setupAuditLogin(string, string2);
            if (l == 1L) {
                CIMOMLibrary.auditLoginSuccess(string, string2, (int)l);
            } else {
                CIMOMLibrary.auditLoginFailure(string, string2, (int)l);
            }
        } else {
            throw new CIMException("Error loading library - cannot audit login");
        }
    }

    private static native String getPassword(String var0, int var1);

    private static native String writeLocalFile(String var0, String var1, String var2);

    private static native void doSyslog(String var0, String var1, int var2);

    private static native void setupAuditLogin(String var0, String var1);

    private static native void auditLoginSuccess(String var0, String var1, long var2);

    private static native void auditLoginFailure(String var0, String var1, int var2);

    private static native boolean doAuthenticate(String var0, String var1, String var2) throws Exception;

    static {
        try {
            System.loadLibrary(CIMOM_LIBRARY);
            library_loaded = true;
        }
        catch (SecurityException securityException) {
            Debug.trace1((String)"Unexpected SecurityException: ", (Throwable)securityException);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Debug.trace1((String)"Unexpected UnsatisfiedLinkError: ", (Throwable)unsatisfiedLinkError);
        }
    }
}

