/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Debug {
    private static final boolean ON = true;
    private static final String TRACE_DIR = "/var/tmp";
    private static final String TRACE_STDOUT_NAME = "stdout";
    private static final String TRACE_STDERR_NAME = "stderr";
    private static final int TRACE_OFF = 0;
    private static final int TRACE_STDOUT = 1;
    private static final int TRACE_STDERR = 2;
    private static final int TRACE_FILE = 3;
    private static final int TRACE_RETRY = 5;
    private static boolean trace_init = false;
    private static int trace_level = 0;
    private static boolean trace_time = false;
    private static boolean trace_method = false;
    private static boolean trace_thread = false;
    private static int trace_out = 2;
    private static FileWriter trace_fw;
    private static BufferedWriter trace_bw;
    private static PrintWriter trace_pw;

    public static final void traceOpen(String string, String string2) {
        Debug.openTrace(string, string2);
    }

    public static final boolean isOn() {
        return trace_level > 0;
    }

    public static final void trace1(String string) {
        if (trace_level > 0) {
            Debug.writeTrace(string);
        }
    }

    public static final void trace1(String string, Throwable throwable) {
        if (trace_level > 0) {
            Debug.writeTrace(string);
            if (throwable != null) {
                Debug.writeStackTrace(throwable);
            }
        }
    }

    public static final void trace2(String string) {
        if (trace_level > 1) {
            Debug.writeTrace(string);
        }
    }

    public static final void trace2(String string, Throwable throwable) {
        if (trace_level > 1) {
            Debug.writeTrace(string);
            if (throwable != null) {
                Debug.writeStackTrace(throwable);
            }
        }
    }

    public static final void trace3(String string) {
        if (trace_level > 2) {
            Debug.writeTrace(string);
        }
    }

    public static final void trace3(String string, Throwable throwable) {
        if (trace_level > 2) {
            Debug.writeTrace(string);
            if (throwable != null) {
                Debug.writeStackTrace(throwable);
            }
        }
    }

    private static void openTrace(String string, String string2) {
        Serializable serializable;
        String string3 = null;
        String string4 = null;
        if (trace_init) {
            return;
        }
        trace_level = 0;
        trace_time = false;
        trace_method = false;
        trace_thread = false;
        if (string != null) {
            try {
                serializable = new Integer(string.substring(0, 1));
            }
            catch (Exception exception) {
                serializable = new Integer(0);
            }
            trace_level = (Integer)serializable;
            if (string.indexOf(116) > 0) {
                trace_time = true;
            }
            if (string.indexOf(109) > 0) {
                trace_method = true;
            }
            if (string.indexOf(112) > 0) {
                trace_thread = true;
            }
        }
        if (trace_level == 0) {
            return;
        }
        if (string2 != null && string2.trim().length() != 0) {
            if (string2.equals(TRACE_STDOUT_NAME)) {
                trace_out = 1;
            } else if (string2.equals(TRACE_STDERR_NAME)) {
                trace_out = 2;
            } else {
                trace_out = 3;
                string3 = string2.trim();
            }
        } else {
            trace_level = 2;
        }
        if (trace_out == 3 && trace_level > 0) {
            if (string3.indexOf(File.separatorChar) < 0) {
                string3 = Debug.getLogDir() + File.separator + string3;
            }
            serializable = new SimpleDateFormat("MMdd_HHmm");
            string4 = "_" + ((DateFormat)serializable).format(new Date());
            String string5 = string3 = string3 + string4;
            int n = 1;
            while (n < 5) {
                try {
                    File file = new File(string5);
                    if (!file.exists()) break;
                    string5 = string3 + "_" + n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
            if (n < 5) {
                try {
                    trace_fw = new FileWriter(string5);
                    trace_bw = new BufferedWriter(trace_fw);
                    trace_pw = new PrintWriter((Writer)trace_bw, true);
                }
                catch (Exception exception) {
                    trace_level = 0;
                }
            } else {
                trace_level = 0;
            }
        }
        trace_init = true;
    }

    private static void writeStackTrace(Throwable throwable) {
        try {
            if (trace_out == 3) {
                throwable.printStackTrace(trace_pw);
            } else if (trace_out == 1) {
                throwable.printStackTrace(System.out);
            } else if (trace_out == 2) {
                throwable.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getLogDir() {
        return TRACE_DIR;
    }

    private static String getClassMethod() {
        String string = null;
        try {
            InputStream inputStream = Debug.getStackStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            string = Debug.getCaller(string2);
            bufferedReader.close();
        }
        catch (Exception exception) {
            string = "??:??";
        }
        return string;
    }

    private static synchronized void writeTrace(String string) {
        Object object;
        String string2 = "";
        if (trace_time) {
            object = new Time(System.currentTimeMillis());
            string2 = ((Time)object).toString() + " | ";
        }
        if (trace_thread) {
            object = Thread.currentThread();
            string2 = string2 + ((Thread)object).getName() + " | ";
        }
        if (trace_method) {
            string2 = string2 + Debug.getClassMethod() + " | ";
        }
        string2 = string2 + string;
        try {
            if (trace_out == 3) {
                trace_pw.println(string2);
            } else if (trace_out == 1) {
                System.out.println(string2);
            } else if (trace_out == 2) {
                System.err.println(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static InputStream getStackStream() {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            new Exception().printStackTrace(printWriter);
            printWriter.close();
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            byteArrayInputStream = null;
        }
        return byteArrayInputStream;
    }

    private static String getCaller(String string) {
        String string2 = string;
        int n = string.indexOf(40);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        if ((n = string2.indexOf("at")) > 0) {
            string2 = string2.substring(n + 3);
        }
        if ((n = string2.lastIndexOf(46)) > 0) {
            String string3 = string2.substring(n + 1);
            String string4 = (n = (string2 = string2.substring(0, n)).lastIndexOf(46)) > 0 ? string2.substring(n + 1) : string2;
            string2 = string4 + ":" + string3;
        }
        return string2;
    }
}

