/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.MOFFormatter;

public class CIMParameter
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMDataType type;
    private int size = 0;
    private Vector qualifiers = new Vector();

    public void setQualifiers(Vector vector) {
        this.qualifiers = vector;
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public void setType(CIMDataType cIMDataType) {
        this.type = cIMDataType;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public CIMParameter() {
        this("");
    }

    public CIMParameter(String string) {
        super(string);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public synchronized Object clone() {
        return this.clone(true);
    }

    synchronized Object clone(boolean bl) {
        CIMParameter cIMParameter = new CIMParameter();
        cIMParameter.name = this.name;
        cIMParameter.identifier = this.identifier;
        cIMParameter.type = this.type;
        cIMParameter.size = this.size;
        if (this.qualifiers == null || !bl) {
            cIMParameter.qualifiers = new Vector();
        } else {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.qualifiers.elements();
            while (enumeration.hasMoreElements()) {
                CIMQualifier cIMQualifier = (CIMQualifier)enumeration.nextElement();
                vector.addElement(cIMQualifier.clone());
            }
            cIMParameter.qualifiers = vector;
        }
        return cIMParameter;
    }

    public CIMQualifier getQualifier(String string) {
        if (string == null) {
            return null;
        }
        int n = this.qualifiers.indexOf(new CIMQualifier(string));
        CIMQualifier cIMQualifier = n >= 0 ? (CIMQualifier)this.qualifiers.elementAt(n) : null;
        return cIMQualifier;
    }
}

