/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.homedir;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.homedir.HomeDirObj;
import java.io.File;
import java.text.StringCharacterIterator;

public class UMgrWrapper {
    ProviderUtility provUtil = null;
    private String mvCommand = "/usr/bin/mv";
    private String chownCommand = "/usr/bin/chown";
    private String chmodCommand = "/usr/bin/chmod";
    private String chgrpCommand = "/usr/bin/chgrp";
    private String cpCommand = "/usr/bin/cp";
    private String mkdirCommand = "/usr/bin/mkdir";
    private String rmdirCommand = "/usr/bin/rm -r ";
    private String DEFAULT_SOURCE_DIRECTORY = "/etc/skel";
    private String ROOT = "/";
    private String ETC = "/etc";
    private String USR = "/usr";
    private String HOM = "/home";
    private String VAR = "/var";
    private String OPT = "/opt";
    private String TMP = "/tmp";
    private String PRC = "/proc";

    public UMgrWrapper(ProviderUtility providerUtility) throws UserException {
        this.provUtil = providerUtility;
    }

    public synchronized HomeDirObj getPermissions(HomeDirObj homeDirObj) throws UserException {
        String string = homeDirObj.getPathname();
        int n = 7;
        int n2 = 5;
        int n3 = 0;
        homeDirObj.setOwnerPerms(n);
        homeDirObj.setGroupPerms(n2);
        homeDirObj.setWorldPerms(n3);
        File file = new File(string);
        try {
            if (!file.exists()) {
                homeDirObj.setModifyServer(true);
                homeDirObj.setForceModify(true);
                return homeDirObj;
            }
        }
        catch (Exception exception) {
            return homeDirObj;
        }
        String[] stringArray = new String[]{"LC_ALL=C", "LC_MESSAGES=C", "LANG=C"};
        String string2 = "/bin/ls -ld ";
        string2 = string2.concat(string);
        String[] stringArray2 = AdminCommonTools.CMN_exec(string2, stringArray);
        if (stringArray2 == null) {
            AdminCommonTools.CMN_HandleOutput("ls command failed!");
            return homeDirObj;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(stringArray2[0]);
        n = 0;
        char c = stringCharacterIterator.first();
        c = stringCharacterIterator.next();
        if (c == 'r') {
            n = 5;
        }
        if ((c = stringCharacterIterator.next()) == 'w') {
            n = 7;
        }
        n2 = 0;
        c = stringCharacterIterator.next();
        c = stringCharacterIterator.next();
        if (c == 'r') {
            n2 = 5;
        }
        if ((c = stringCharacterIterator.next()) == 'w') {
            n2 = 7;
        }
        n3 = 0;
        c = stringCharacterIterator.next();
        c = stringCharacterIterator.next();
        if (c == 'r') {
            n3 = 5;
        }
        if ((c = stringCharacterIterator.next()) == 'w') {
            n3 = 7;
        }
        homeDirObj.setOwnerPerms(n);
        homeDirObj.setGroupPerms(n2);
        homeDirObj.setWorldPerms(n3);
        return homeDirObj;
    }

    public synchronized void deleteHomeDir(String string) throws UserException {
        String string2 = null;
        String string3 = null;
        string3 = string.trim();
        boolean bl = this.isStringOK(string3);
        if (!bl) {
            string2 = this.provUtil.writeLog(2, "LM_2047", "LM_2307", string3, null, null, null);
            throw new UserException(string2);
        }
        if (string3.equals(this.ROOT) || string3.equals(this.ETC) || string3.equals(this.USR) || string3.equals(this.HOM) || string3.equals(this.VAR) || string3.equals(this.OPT) || string3.equals(this.TMP) || string3.equals(this.PRC)) {
            string2 = this.provUtil.writeLog(2, "LM_2047", "LM_2232", string3, null, null, null);
            throw new UserException(string2);
        }
        String string4 = new String(this.rmdirCommand + string3);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(string4);
            process.getInputStream().close();
            process.getErrorStream().close();
            process.waitFor();
        }
        catch (Exception exception) {
            string2 = this.provUtil.writeLog(2, "LM_2047", "LM_2307", string3, null, null, null);
            throw new UserException(string2);
        }
        this.provUtil.writeLog(0, "LM_2044", "LM_2304", string3, null, null, null);
    }

    public synchronized void createHomeDir(HomeDirObj homeDirObj) throws UserException {
        String string = "";
        String string2 = homeDirObj.getUserName();
        if (homeDirObj != null) {
            string = homeDirObj.getPathname();
        }
        String string3 = null;
        File file = null;
        try {
            file = new File(string);
        }
        catch (Exception exception) {
            string3 = this.provUtil.writeLog(2, "LM_2043", "LM_2220", exception.getLocalizedMessage(), null, null, null);
            throw new UserException(string3);
        }
        if (file.exists()) {
            string3 = this.provUtil.writeLog(2, "LM_2043", "LM_2064", string, string2, homeDirObj.getServer(), null);
            throw new UserException(string3);
        }
        try {
            this.performCreateHomeDir(homeDirObj);
        }
        catch (Exception exception) {
            string3 = this.provUtil.writeLog(2, "LM_2043", "LM_2308", string, null, null, null);
            throw new UserException(string3);
        }
        this.provUtil.writeLog(0, "LM_2045", "LM_2076", string2, string, null, null);
    }

    public void modifyHomeDir(HomeDirObj homeDirObj, String string) throws UserException {
        Object object;
        Object object2;
        Object object3;
        String string2 = null;
        if (homeDirObj == null) {
            string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
            throw new UserException(string2);
        }
        String string3 = homeDirObj.getUserName();
        String string4 = string;
        String string5 = homeDirObj.getPathname();
        if (string4 == null) {
            string4 = "";
        }
        if (string4.trim().length() == 0) {
            string4 = string5;
        }
        if (string4.equals(string5)) {
            object3 = new File(string5);
            if (!((File)object3).exists()) {
                try {
                    this.performCreateHomeDir(homeDirObj);
                    string2 = this.provUtil.writeLog(0, "LM_2004", "LM_2076", string3, string4, null, null);
                    return;
                }
                catch (Exception exception) {
                    string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                    throw new UserException(string2);
                }
            }
        } else {
            Process process;
            Runtime runtime;
            String string6;
            object3 = new File(string4);
            if (((File)object3).exists()) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2065", string4, string3, homeDirObj.getServer(), null);
                throw new UserException(string2);
            }
            int n = string4.lastIndexOf("/");
            object2 = null;
            if (n == -1) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2313", string4, null, null, null);
                throw new UserException(string2);
            }
            object2 = string4.substring(0, n);
            object = new File((String)object2);
            if (!((File)object).exists()) {
                string6 = new String(this.mkdirCommand + " -m 750 -p " + (String)object2);
                runtime = Runtime.getRuntime();
                try {
                    process = runtime.exec(string6);
                    process.getInputStream().close();
                    process.getErrorStream().close();
                    process.waitFor();
                }
                catch (Exception exception) {
                    string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                    throw new UserException(string2);
                }
            }
            string6 = new String(this.mvCommand + " " + string5 + " " + string4);
            runtime = Runtime.getRuntime();
            try {
                process = runtime.exec(string6);
                process.getInputStream().close();
                process.getErrorStream().close();
                process.waitFor();
            }
            catch (Exception exception) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2221", null, null, null, null);
                throw new UserException(string2);
            }
        }
        object3 = homeDirObj.getOwnerPerms() + homeDirObj.getGroupPerms() + homeDirObj.getWorldPerms();
        String string7 = new String(this.chmodCommand + " " + (String)object3 + " " + string4);
        object2 = Runtime.getRuntime();
        try {
            object = ((Runtime)object2).exec(string7);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
        }
        catch (Exception exception) {
            string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2309", string4, null, null, null);
            throw new UserException(string2);
        }
        this.provUtil.writeLog(0, "LM_2004", "LM_2080", string3, string4, null, null);
    }

    private void performCreateHomeDir(HomeDirObj homeDirObj) throws SolServerException, UserException {
        Object object;
        Object object2;
        if (homeDirObj == null) {
            throw new SolServerException("?????");
        }
        String string = homeDirObj.getUID();
        String string2 = homeDirObj.getPathname();
        String string3 = homeDirObj.getOwnerPerms() + homeDirObj.getGroupPerms() + homeDirObj.getWorldPerms();
        String string4 = homeDirObj.getPrimaryGroup();
        String string5 = new String(this.mkdirCommand + " -m 750 -p " + string2);
        Runtime runtime = Runtime.getRuntime();
        try {
            object2 = runtime.exec(string5);
            ((Process)object2).getInputStream().close();
            ((Process)object2).getErrorStream().close();
            ((Process)object2).waitFor();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Exec'ing mkdir failed");
            exception.printStackTrace();
            throw new SolServerException("?????");
        }
        object2 = null;
        object2 = homeDirObj.getInitFilePath() != null && homeDirObj.getInitFilePath().trim().length() != 0 ? new String(homeDirObj.getInitFilePath()) : new String(this.DEFAULT_SOURCE_DIRECTORY);
        object2 = ((String)object2).endsWith("/") ? ((String)object2).concat(".") : ((String)object2).concat("/.");
        string5 = new String(this.cpCommand + " -r -p " + (String)object2 + " " + string2);
        try {
            object = AdminCommonTools.CMN_exec(string5);
            int n = 0;
            while (n < ((String[])object).length) {
                if (object[n] != null) {
                    AdminCommonTools.CMN_Trace1("cpOutput is " + object[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("Exec'ing cp failed");
            throw new SolServerException("?????");
        }
        string5 = new String(this.mvCommand + " " + string2 + "/" + "local.login " + string2 + "/" + ".login");
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
        }
        catch (Exception exception) {
            throw new SolServerException("?????");
        }
        string5 = new String(this.mvCommand + " " + string2 + "/" + "local.profile " + string2 + "/" + ".profile");
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
        }
        catch (Exception exception) {
            throw new SolServerException("?????");
        }
        string5 = new String(this.mvCommand + " " + string2 + "/" + "local.cshrc " + string2 + "/" + ".cshrc");
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
        }
        catch (Exception exception) {
            throw new SolServerException("?????");
        }
        string5 = new String(this.chmodCommand + " " + string3 + " " + string2);
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing chmod failed");
            throw new SolServerException("?????");
        }
        string5 = new String(this.chownCommand + " -fR " + string + " " + string2);
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing chown failed");
            throw new SolServerException("?????");
        }
        string5 = new String(this.chgrpCommand + " -fR " + string4 + " " + string2);
        try {
            object = runtime.exec(string5);
            ((Process)object).getInputStream().close();
            ((Process)object).getErrorStream().close();
            ((Process)object).waitFor();
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_Trace1("exec'ing chown failed");
            throw new SolServerException("?????");
        }
    }

    private boolean isStringOK(String string) {
        boolean bl = true;
        int n = string.length();
        if (n < 1) {
            bl = false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == ' ' || string.charAt(n2) == '.' || string.charAt(n2) == '*') {
                bl = false;
                break;
            }
            ++n2;
        }
        return bl;
    }
}

