/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPkgInfo;
import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import com.sun.wbem.solarisprovider.patch.SolarisPatchUtil;
import com.sun.wbem.solarisprovider.patch.SpooledPatchData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpooledPatchInfo {
    public static final String PKGINFO = "pkginfo";
    private static final String PKG = "PKG";
    private static final String DIPATCH_FILE = ".diPatch";
    private static final String PID_DELIM = "-";
    private static final int MAX_PID_TOKENS = 2;
    private static final int PATCH_BASE_LENGTH = 6;
    private static final int PATCH_REV_LENGTH = 2;
    private ProviderUtility provUtil;

    public SpooledPatchInfo(ProviderUtility providerUtility) {
        this.provUtil = providerUtility;
    }

    public Vector getSpooledPatchInfo(String string) throws PatchException {
        File file = new File(string);
        Vector<String> vector = new Vector<String>();
        try {
            if (file.exists() && file.isDirectory() && file.canRead()) {
                File[] fileArray = file.listFiles();
                SolarisPatchUtil solarisPatchUtil = new SolarisPatchUtil(this.provUtil);
                SpooledPatchData spooledPatchData = new SpooledPatchData();
                Vector vector2 = new Vector();
                Vector vector3 = new Vector();
                StringBuffer stringBuffer = new StringBuffer(50);
                StringBuffer stringBuffer2 = new StringBuffer(50);
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isDirectory()) {
                        String string2 = fileArray[n].getName();
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(string);
                        stringBuffer2.append("/");
                        stringBuffer2.append(string2);
                        stringBuffer2.append("/");
                        stringBuffer2.append(DIPATCH_FILE);
                        File file2 = new File(stringBuffer2.toString());
                        if (file2.exists()) {
                            stringBuffer.setLength(0);
                            stringBuffer.append(string);
                            stringBuffer.append("/");
                            stringBuffer.append(string2);
                            stringBuffer.append("/");
                            stringBuffer.append("README");
                            stringBuffer.append(".");
                            stringBuffer.append(string2);
                            File file3 = new File(stringBuffer.toString());
                            if (file3.exists() && file3.canRead() && file3.length() > 0L) {
                                vector2 = solarisPatchUtil.contentsOfReadmeFile(stringBuffer.toString());
                                spooledPatchData.setPatchId(string2);
                                String string3 = PatchPkgInfo.getInfoValue(vector2, "Relevant Architectures");
                                spooledPatchData.setArchitecture(string3);
                                String string4 = PatchPkgInfo.getInfoValue(vector2, "SunOS Release");
                                if (string4.equals("")) {
                                    string4 = PatchPkgInfo.getInfoValue(vector2, "SunOS release");
                                    spooledPatchData.setSunOsRelease(string4);
                                } else {
                                    spooledPatchData.setSunOsRelease(string4);
                                }
                                String string5 = PatchPkgInfo.getInfoValue(vector2, "Patches required with this patch");
                                string5 = this.patchIdFilter(string5);
                                spooledPatchData.setRequires(string5);
                                String string6 = PatchPkgInfo.getInfoValue(vector2, "Patches which conflict with this patch");
                                string6 = this.patchIdFilter(string6);
                                spooledPatchData.setConflicting(string6);
                                String string7 = PatchPkgInfo.getInfoValue(vector2, "Patches accumulated and obsoleted by this patch");
                                string7 = this.patchIdFilter(string7);
                                spooledPatchData.setObsoletes(string7);
                                vector3 = this.getPackagesToBePatched(string, string2);
                                String string8 = new String();
                                int n2 = 0;
                                while (n2 < vector3.size()) {
                                    string8 = string8 + (String)vector3.elementAt(n2) + " ";
                                    ++n2;
                                }
                                string8 = string8.trim();
                                spooledPatchData.setPackages(string8);
                                PatchPropertiesConfig patchPropertiesConfig = PatchPkgInfo.getPatchPropConfig(vector3, string + File.separatorChar + string2);
                                spooledPatchData.setPatchPropertiesConfig(patchPropertiesConfig);
                                vector.addElement(spooledPatchData.formatString());
                            }
                        }
                    }
                    ++n;
                }
                return vector;
            }
            this.provUtil.writeLog(2, "LM_8820", "LM_8824", string, null, null, null, null);
            throw new PatchException("EXM_SPOOL_PATCH_DIR_ACCESS", string);
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new PatchException("EXM_SPOOL_PATCH_DIR_ERR", string);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSpooledPatchReadme(String string, String string2) throws PatchException {
        String string3;
        InputStreamReader inputStreamReader;
        BufferedReader bufferedReader;
        block14: {
            Exception exception2;
            String string4;
            block15: {
                bufferedReader = null;
                inputStreamReader = null;
                string3 = string + "/" + string2 + "/" + "README" + "." + string2;
                File file = new File(string3);
                if (!file.exists() || !file.canRead()) break block14;
                inputStreamReader = new FileReader(file);
                bufferedReader = new BufferedReader(inputStreamReader);
                String string5 = bufferedReader.readLine();
                String string6 = new String();
                while (string5 != null) {
                    string6 = string6 + string5;
                    string6 = string6 + "\n";
                    string5 = bufferedReader.readLine();
                }
                inputStreamReader.close();
                bufferedReader.close();
                string4 = string6;
                Object var11_11 = null;
                if (inputStreamReader == null) break block15;
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (bufferedReader == null) return string4;
            try {
                bufferedReader.close();
                return string4;
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return string4;
        }
        try {
            this.provUtil.writeLog(2, "LM_8820", "LM_8825", string3, null, null, null, null);
            throw new PatchException("EXM_SPOOL_PATCH_README_ACCESS", string3);
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new PatchException("EXM_SPOOL_PATCH_README_ERR");
            {
                catch (Throwable throwable) {
                    Exception exception32;
                    Object var11_12 = null;
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception32) {
                            // empty catch block
                        }
                    }
                    if (bufferedReader == null) throw throwable;
                    try {
                        bufferedReader.close();
                        throw throwable;
                    }
                    catch (Exception exception32) {}
                    throw throwable;
                }
            }
        }
    }

    private Vector getPackagesToBePatched(String string, String string2) throws PatchException {
        Vector<String> vector = new Vector<String>();
        try {
            String string3 = string + "/" + string2;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            File file = new File(string3);
            if (file.exists() && file.isDirectory() && file.canRead()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    if (fileArray[n].isDirectory()) {
                        String string4;
                        boolean bl;
                        String string5 = fileArray[n].getName();
                        String string6 = string3 + "/" + string5 + "/" + PKGINFO;
                        File file2 = new File(string6);
                        if (file2.exists() && !(bl = hashtable.containsKey(string4 = this.getPackageName(string6)))) {
                            hashtable.put(string4, string4);
                        }
                    }
                    ++n;
                }
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((String)enumeration.nextElement());
                }
                return vector;
            }
            this.provUtil.writeLog(2, "LM_8820", "LM_8824", string, null, null, null, null);
            throw new PatchException("EXM_SPOOL_PATCH_DIR_ACCESS", string);
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new PatchException("EXM_SPOOL_PKGINFO_ERR");
        }
    }

    private String getPackageName(String string) {
        Vector vector = PatchPkgInfo.contentsOfPkginfoFile(string);
        String string2 = PatchPkgInfo.getInfoValue(vector, PKG);
        return string2;
    }

    private String patchIdFilter(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer(50);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!SpooledPatchInfo.isValidPatchID(string2)) continue;
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString().trim();
    }

    private static boolean isValidPatchID(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, PID_DELIM);
        int n = stringTokenizer.countTokens();
        if (n != 2) {
            return false;
        }
        try {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() != 6) {
                return false;
            }
            Integer.parseInt(string2);
            string2 = stringTokenizer.nextToken();
            if (string2.length() != 2) {
                return false;
            }
            Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }
}

