/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wbem.client.Debug;

public class PProUtil {
    public static final String SERIALIZED_HOST_NAME = "ppro_host.obj";
    public static final String DEF_DOWNLOAD_DIR = "/var/tmp/ppro-patches";
    public static final String DEF_TARGET_DIR = "/var/sadm/spool";
    public static final String VAR_TMP = "/var/tmp";
    private static final String HOST_STRING = "/var/tmp" + File.separatorChar + "ppro_host.obj";
    private static final String JAR_EXT = ".jar";
    private static final String[] EXECUTABLES = new String[]{"prepatch", "prePatch", "postpatch", "prebackout", "postbackout", "installpatch", "backoutpatch", "download32", "download64", "download", "install", "install_patch", "t3.sh", "t4.sh"};
    private static final String[] NONPRIV_READABLES = new String[]{"checkinstall", "request", "patch_checkinstall"};
    private static final String[] NOT_CONTENT = new String[]{"META-INF/", ".file_attributes.SunOS", ".file_attributes.linux"};

    protected static boolean isHostSerialized() {
        try {
            File file = new File(HOST_STRING);
            if (file.exists() && file.canRead()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected static ReadOnlyHost getSerializedHost() {
        ReadOnlyHost readOnlyHost = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(HOST_STRING);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            readOnlyHost = (ReadOnlyHost)objectInputStream.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return readOnlyHost;
    }

    protected static void setSerializedHost(ReadOnlyHost readOnlyHost) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(HOST_STRING);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(readOnlyHost);
            objectOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void extractSignedPatches(PatchList patchList, String string) throws PatchException {
        try {
            File file = new File(DEF_DOWNLOAD_DIR);
            if (file.exists()) {
                Patch patch = null;
                String string2 = "";
                int n = patchList != null ? patchList.size() : 0;
                int n2 = 0;
                while (n2 < n) {
                    patch = patchList.getPatchAt(n2);
                    string2 = patch.getPatchID().getPatchID();
                    PProUtil.unjarFiles(string, string2);
                    ++n2;
                }
            }
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, exception);
            }
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void copySignedPatches(PatchList patchList, String string) throws PatchException {
        try {
            File file = new File(DEF_DOWNLOAD_DIR);
            if (!file.exists()) return;
            Patch patch = null;
            String string2 = "";
            if (patchList == null) return;
            int n = patchList.size();
            int n2 = n;
            String string3 = null;
            String string4 = null;
            FileChannel fileChannel = null;
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            int n22 = 0;
            while (true) {
                IOException iOException2;
                Object var13_12;
                if (n22 >= n2) {
                    return;
                }
                patch = patchList.getPatchAt(n22);
                string2 = patch.getPatchID().getPatchID();
                string3 = DEF_DOWNLOAD_DIR + File.separatorChar + string2 + JAR_EXT;
                string4 = string + File.separatorChar + string2 + JAR_EXT;
                fileChannel = null;
                abstractInterruptibleChannel = null;
                try {
                    try {
                        fileChannel = new FileInputStream(string3).getChannel();
                        abstractInterruptibleChannel = new FileOutputStream(string4).getChannel();
                        ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, (int)fileChannel.size());
                    }
                    catch (Exception exception) {
                        throw new PatchException(exception.getLocalizedMessage());
                    }
                    var13_12 = null;
                    {
                    }
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    try {
                        if (fileChannel != null) {
                            fileChannel.close();
                        }
                        if (abstractInterruptibleChannel == null) throw throwable;
                        abstractInterruptibleChannel.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException iOException2) {}
                if (fileChannel != null) {
                    fileChannel.close();
                }
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                ++n22;
            }
        }
        catch (Exception exception) {
            if (PPro.provUtil == null) throw new PatchException(exception.getLocalizedMessage());
            PPro.provUtil.writeLog(2, exception);
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    /*
     * Loose catch block
     */
    private static void unjarFiles(String string, String string2) throws PatchException {
        block21: {
            Exception exception2222;
            InputStream inputStream;
            FileOutputStream fileOutputStream;
            block20: {
                StringBuffer stringBuffer = new StringBuffer(50);
                stringBuffer.append(DEF_DOWNLOAD_DIR);
                stringBuffer.append(File.separatorChar);
                stringBuffer.append(string2);
                stringBuffer.append(JAR_EXT);
                File file = new File(stringBuffer.toString());
                if (!file.exists()) {
                    return;
                }
                fileOutputStream = null;
                inputStream = null;
                byte[] byArray = new byte[8192];
                JarFile jarFile = new JarFile(file, false);
                StringBuffer stringBuffer2 = new StringBuffer(50);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!PProUtil.isContent(jarEntry.getName())) continue;
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(string.toString());
                    stringBuffer2.append(File.separatorChar);
                    stringBuffer2.append(jarEntry.getName());
                    String string3 = stringBuffer2.toString();
                    File file2 = new File(string3);
                    File file3 = file2.getParentFile();
                    if (file3 != null && !file3.exists()) {
                        file3.mkdirs();
                    }
                    if (!file2.exists()) {
                        file2.createNewFile();
                    }
                    fileOutputStream = new FileOutputStream(string3);
                    inputStream = jarFile.getInputStream(jarEntry);
                    int n = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    fileOutputStream.close();
                    if (PProUtil.isExecutable(jarEntry.getName())) {
                        PProUtil.setExecutable(string3);
                    }
                    if (PProUtil.isNonprivReadable(jarEntry.getName())) {
                        PProUtil.setReadable(string3);
                    }
                    file2 = null;
                    file3 = null;
                    inputStream = null;
                    fileOutputStream = null;
                }
                Object var16_16 = null;
                if (inputStream == null) break block20;
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2222) {}
            }
            break block21;
            {
                catch (IOException iOException) {
                    throw new PatchException("EXM_DL_PROCESSING", string2, string, iOException.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var16_17 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private static boolean isExecutable(String string) {
        boolean bl = false;
        String string2 = PProUtil.getFileName(string);
        if (string.indexOf("/") == string.lastIndexOf("/")) {
            int n = 0;
            while (n < EXECUTABLES.length) {
                if (string2.equals(EXECUTABLES[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private static boolean isNonprivReadable(String string) {
        boolean bl = false;
        String string2 = PProUtil.getFileName(string);
        int n = 0;
        while (n < NONPRIV_READABLES.length) {
            if (string2.equals(NONPRIV_READABLES[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static boolean isContent(String string) {
        boolean bl = true;
        int n = 0;
        while (n < NOT_CONTENT.length) {
            if (string.indexOf(NOT_CONTENT[n]) == 0) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static void setExecutable(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("/usr/bin/chmod a+x,ug+r " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void setReadable(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("/usr/bin/chmod a+r " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getFileName(String string) {
        int n = string.lastIndexOf("/") + 1;
        return string.substring(n);
    }

    protected static void removeDirectory(String string) throws PatchException {
        try {
            File file = new File(string);
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    fileArray[n].delete();
                    ++n;
                }
                file.delete();
            }
        }
        catch (Exception exception) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, exception);
            }
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    protected static Vector patchListToVector(PatchList patchList) throws PatchException {
        String string = null;
        Vector<String> vector = new Vector<String>();
        Debug.trace3((String)("Errors found: " + patchList.hasAnyErrors()));
        int n = patchList.size();
        Debug.trace3((String)("PatchList size: " + n));
        int n2 = 0;
        while (n2 < n) {
            PatchID patchID;
            Patch patch;
            try {
                patch = patchList.getPatchAt(n2);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                throw new PatchException(noSuchPatchException.getLocalizedMessage());
            }
            if (patch != null && (patchID = patch.getPatchID()) != null && ((string = patchID.getPatchID()) != null || string.length() > 0)) {
                vector.addElement(string);
            }
            ++n2;
        }
        return vector;
    }

    protected static void printPatchList(PatchList patchList) throws PatchException {
        if (patchList == null) {
            return;
        }
        System.out.println("Errors found: " + patchList.hasAnyErrors());
        System.out.println("PatchList size: " + patchList.size());
        try {
            int n = 0;
            while (n < patchList.size()) {
                System.out.println("Patch: " + patchList.getPatchAt(n).getPatchID().getPatchID());
                boolean bl = patchList.hasErrorAt(n);
                if (bl) {
                    System.out.println("Error: " + patchList.getErrorAt(n));
                }
                ++n;
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            throw new PatchException(noSuchPatchException.getLocalizedMessage());
        }
    }

    public static String getKeyBoard(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            return new String("");
        }
    }

    public static void dirAvailable(String string) throws PatchException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new PatchException("EXM_DL_DIR_ACCESS", file.toString());
            }
            if (!file.canWrite()) {
                throw new PatchException("EXM_DL_DIR_WRITE", file.toString());
            }
        }
        catch (Exception exception) {
            String string2 = exception.getLocalizedMessage();
            throw new PatchException(string2);
        }
    }
}

