/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.IPSubnetData;
import com.sun.wbem.solarisprovider.network.IPSubnetInfo;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_IPSubnet
implements InstanceProvider {
    private static final String SOLARIS_IP_SUBNET = "Solaris_IPSubnet";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String SUBNET_NUMBER = "SubnetNumber";
    private static final String SUBNET_MASK = "SubnetMask";
    private static final String ADDRESS_TYPE = "AddressType";
    private static final String NAME = "Name";
    private static final String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static final String providerName = "Solaris_IPSubnet";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        try {
            this.cimomhandle = cIMOMHandle;
            this.provUtil = new ProviderUtility(cIMOMHandle, "Solaris_IPSubnet");
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cIMException.toString());
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        try {
            CIMProperty cIMProperty;
            String string = null;
            IPSubnetData iPSubnetData = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                string = (String)cIMProperty.getValue().getValue();
            }
            if (string == null) {
                return null;
            }
            iPSubnetData = this.getIPSubnetData(string);
            cIMProperty = this.createNewInstance(cIMClass, iPSubnetData);
            if (bl) {
                cIMProperty = cIMProperty.localElements();
            }
            return cIMProperty.filterProperties(stringArray, bl2, bl3);
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        try {
            this.hash = this.getData();
            if (this.hash == null) {
                return null;
            }
            cIMInstanceArray = this.hash.elements();
            while (cIMInstanceArray.hasMoreElements()) {
                IPSubnetData iPSubnetData = (IPSubnetData)cIMInstanceArray.nextElement();
                CIMInstance cIMInstance = this.createNewInstance(cIMClass, iPSubnetData);
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath[] cIMObjectPathArray;
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            this.hash = this.getData();
            if (this.hash == null) {
                return null;
            }
            cIMObjectPathArray = this.hash.elements();
            while (cIMObjectPathArray.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                IPSubnetData iPSubnetData = (IPSubnetData)cIMObjectPathArray.nextElement();
                cIMObjectPath2.addKey(NAME, new CIMValue((Object)iPSubnetData.getSubnetNumber()));
                cIMObjectPath2.addKey(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPSubnet"));
                cIMObjectPath2.addKey(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
                try {
                    cIMObjectPath2.addKey(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                vector.addElement(cIMObjectPath2);
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return null;
    }

    private Hashtable getData() throws Exception {
        try {
            IPSubnetInfo iPSubnetInfo = new IPSubnetInfo();
            Hashtable hashtable = iPSubnetInfo.getNetmasksData();
            if (hashtable != null) {
                return hashtable;
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        return null;
    }

    private IPSubnetData getIPSubnetData(String string) throws Exception {
        Hashtable hashtable = null;
        IPSubnetData iPSubnetData = null;
        try {
            hashtable = this.getData();
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)exception.toString());
        }
        if (hashtable == null) {
            return null;
        }
        iPSubnetData = (IPSubnetData)hashtable.get(string);
        if (iPSubnetData == null) {
            return null;
        }
        return iPSubnetData;
    }

    private CIMInstance createNewInstance(CIMClass cIMClass, IPSubnetData iPSubnetData) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty(NAME, new CIMValue((Object)iPSubnetData.getSubnetNumber()));
        cIMInstance.setProperty(SUBNET_NUMBER, new CIMValue((Object)iPSubnetData.getSubnetNumber()));
        cIMInstance.setProperty(SUBNET_MASK, new CIMValue((Object)iPSubnetData.getSubnetMask()));
        cIMInstance.setProperty(ADDRESS_TYPE, new CIMValue((Object)new UnsignedInt16(iPSubnetData.getAddressType())));
        cIMInstance.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPSubnet"));
        cIMInstance.setProperty(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
        try {
            cIMInstance.setProperty(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cIMInstance;
    }
}

