/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.NetworkConfigData;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.client.CIMProviderException;

public class NetworkConfigInfo {
    private final String netconfig = "/usr/sbin/ifconfig ";
    private final int NUM_FIELDS = 8;
    Hashtable netConfigData = new Hashtable();
    private ProviderUtility provUtil = null;

    public NetworkConfigInfo(ProviderUtility providerUtility) {
        this.provUtil = providerUtility;
    }

    public Hashtable initData() throws Exception {
        block4: {
            try {
                int n;
                Process process = Runtime.getRuntime().exec("/usr/sbin/ifconfig -au");
                InputStream inputStream = process.getInputStream();
                StringBuffer stringBuffer = new StringBuffer();
                while ((n = inputStream.read()) != -1) {
                    stringBuffer.append((char)n);
                }
                Vector vector = this.GetNetworkInterfaces(stringBuffer.toString());
                if (vector != null) {
                    this.NetworkInterfaceData(vector);
                    break block4;
                }
                return null;
            }
            catch (IOException iOException) {
                this.provUtil.writeLog(2, (Exception)iOException);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)iOException.toString());
            }
        }
        return this.netConfigData;
    }

    private void NetworkInterfaceData(Vector vector) {
        try {
            int n = 0;
            Process process = null;
            Runtime runtime = null;
            InputStream inputStream = null;
            String[] stringArray = null;
            n = vector.size();
            if (n <= 0) {
                return;
            }
            stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                runtime = Runtime.getRuntime();
                process = runtime.exec("/usr/sbin/ifconfig " + vector.elementAt(n2).toString());
                inputStream = process.getInputStream();
                StringBuffer stringBuffer = new StringBuffer();
                while ((n3 = inputStream.read()) != -1) {
                    stringBuffer.append((char)n3);
                }
                stringArray[n2] = stringBuffer.toString();
                ++n2;
            }
            this.ParseInterfaceData(stringArray, n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ParseInterfaceData(String[] stringArray, int n) {
        try {
            String[] stringArray2 = new String[8];
            int n2 = 0;
            while (n2 < n) {
                String string;
                String string2 = stringArray[n2];
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ": ");
                stringArray2[0] = stringTokenizer.nextToken();
                stringTokenizer.nextToken("<");
                stringArray2[1] = stringTokenizer.nextToken(" ");
                while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken(" \t")) != null) {
                    if (string.equalsIgnoreCase("inet")) {
                        stringArray2[2] = stringTokenizer.nextToken(" \n");
                        continue;
                    }
                    if (string.equalsIgnoreCase("netmask")) {
                        stringArray2[3] = stringTokenizer.nextToken("   \n");
                        continue;
                    }
                    if (string.equalsIgnoreCase("broadcast")) {
                        stringArray2[4] = stringTokenizer.nextToken("   \n");
                        continue;
                    }
                    if (string.equalsIgnoreCase("index")) {
                        stringArray2[5] = stringTokenizer.nextToken("   \n");
                        continue;
                    }
                    if (!string.equalsIgnoreCase("mtu")) continue;
                    stringArray2[6] = stringTokenizer.nextToken(" \n");
                }
                stringArray2[7] = stringArray[n2];
                NetworkConfigData networkConfigData = new NetworkConfigData(stringArray2);
                this.netConfigData.put(stringArray2[0], networkConfigData);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Vector GetNetworkInterfaces(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = "index";
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string3 = stringTokenizer.nextToken();
            if (string3.indexOf(string2, 0) <= -1 || (n = string3.indexOf(58, 0)) <= 0) continue;
            vector.addElement(string3.substring(0, n));
        }
        return vector;
    }
}

